/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;

public class KeyCodeParser {
    private KeyCodeParser() {
    }

    public static String format(int n) {
        switch (n) {
            case 262144: {
                return GUI.i18n.getTranslation("LABEL_KEY_CONTROL");
            }
            case 131072: {
                return GUI.i18n.getTranslation("LABEL_KEY_SHIFT");
            }
            case 65536: {
                return GlobalSettings.isMac() ? "Opt" : "Alt";
            }
            case 0x400000: {
                return GUI.i18n.getTranslation("LABEL_KEY_COMMAND");
            }
            case 0x100000A: {
                return "F1";
            }
            case 0x100000B: {
                return "F2";
            }
            case 0x100000C: {
                return "F3";
            }
            case 0x100000D: {
                return "F4";
            }
            case 0x100000E: {
                return "F5";
            }
            case 0x100000F: {
                return "F6";
            }
            case 0x1000010: {
                return "F7";
            }
            case 0x1000011: {
                return "F8";
            }
            case 0x1000012: {
                return "F9";
            }
            case 0x1000013: {
                return "F10";
            }
            case 0x1000014: {
                return "F11";
            }
            case 0x1000015: {
                return "F12";
            }
            case 0x1000016: {
                return "F13";
            }
            case 0x1000017: {
                return "F14";
            }
            case 0x1000018: {
                return "F15";
            }
            case 9: {
                return "Tab";
            }
            case 27: {
                return "Esc";
            }
            case 0x1000002: {
                return GUI.i18n.getTranslation("LABEL_KEY_ARROW_DOWN");
            }
            case 0x1000001: {
                return GUI.i18n.getTranslation("LABEL_KEY_ARROW_UP");
            }
            case 0x1000003: {
                return GUI.i18n.getTranslation("LABEL_KEY_ARROW_LEFT");
            }
            case 0x1000004: {
                return GUI.i18n.getTranslation("LABEL_KEY_ARROW_RIGHT");
            }
            case 0x1000005: {
                return GUI.i18n.getTranslation("LABEL_KEY_PAGE_UP");
            }
            case 0x1000006: {
                return GUI.i18n.getTranslation("LABEL_KEY_PAGE_DOWN");
            }
            case 0x1000007: {
                return "Home";
            }
            case 0x1000008: {
                return "End";
            }
            case 0x1000009: {
                return GUI.i18n.getTranslation("LABEL_KEY_INSERT");
            }
            case 16777258: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Multiply";
            }
            case 16777259: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Add";
            }
            case 16777261: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Subtract";
            }
            case 16777262: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Decimal";
            }
            case 16777263: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Divide";
            }
            case 0x1000030: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_0";
            }
            case 0x1000031: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_1";
            }
            case 16777266: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_2";
            }
            case 0x1000033: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_3";
            }
            case 16777268: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_4";
            }
            case 16777269: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_5";
            }
            case 16777270: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_6";
            }
            case 16777271: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_7";
            }
            case 16777272: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_8";
            }
            case 16777273: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_9";
            }
            case 16777277: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Equal";
            }
            case 0x1000050: {
                return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Enter";
            }
            case 0x1000051: {
                return "Help";
            }
            case 0x1000055: {
                return GUI.i18n.getTranslation("LABEL_KEY_PAUSE");
            }
            case 16777302: {
                return "Break";
            }
            case 16777303: {
                return "PRINT_SCREEN";
            }
            case 13: {
                return "Enter";
            }
            case 32: {
                return GUI.i18n.getTranslation("LABEL_KEY_SPACE");
            }
            case 8: {
                return "DEL";
            }
        }
        String string = String.valueOf((char)n);
        if (string.toLowerCase().matches("[a-z\u00e4\u00fc\u00f6\u00df0-9]")) {
            return string.toUpperCase();
        }
        if (string.matches("\\p{Print}")) {
            return string;
        }
        return "";
    }
}

