/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.i18n;

import java.util.Hashtable;
import java.util.Locale;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.StringShop;

public class LanguageDetector {
    private static Hashtable countryMap = new Hashtable();

    private LanguageDetector() {
    }

    public static String parseLanguage(Locale locale) {
        String string = locale.getLanguage().toLowerCase();
        String string2 = locale.getCountry();
        if (StringShop.isset(string) && Dictionary.languages.contains(string)) {
            return string;
        }
        if (StringShop.isset(string2) && countryMap.containsKey(string2)) {
            return (String)countryMap.get(string2);
        }
        if (string != null && string.equals("zh")) {
            return "zhcn";
        }
        return "en";
    }

    static {
        countryMap.put("UK", "en");
        countryMap.put("US", "en");
        countryMap.put("DK", "da");
        countryMap.put("CH", "de");
        countryMap.put("AT", "de");
        countryMap.put("LI", "de");
        countryMap.put("GR", "el");
        countryMap.put("AR", "es");
        countryMap.put("BO", "es");
        countryMap.put("CL", "es");
        countryMap.put("CO", "es");
        countryMap.put("CU", "es");
        countryMap.put("MX", "es");
        countryMap.put("PA", "es");
        countryMap.put("PY", "es");
        countryMap.put("UY", "es");
        countryMap.put("VE", "es");
        countryMap.put("BJ", "fr");
        countryMap.put("BF", "fr");
        countryMap.put("CF", "fr");
        countryMap.put("GN", "fr");
        countryMap.put("ML", "fr");
        countryMap.put("MC", "fr");
        countryMap.put("SN", "fr");
        countryMap.put("LU", "fr");
        countryMap.put("VA", "it");
        countryMap.put("BE", "nl");
        countryMap.put("BR", "pt");
        countryMap.put("CV", "pt");
        countryMap.put("MZ", "pt");
        countryMap.put("AO", "pt");
        countryMap.put("BY", "ru");
        countryMap.put("UZ", "ru");
        countryMap.put("GE", "ru");
        countryMap.put("KZ", "ru");
        countryMap.put("TM", "ru");
        countryMap.put("CN", "zhcn");
        countryMap.put("TW", "zhtw");
        countryMap.put("JP", "ja");
        countryMap.put("KR", "ko");
        countryMap.put("KP", "ko");
        countryMap.put("BD", "bn");
        countryMap.put("SE", "sv");
        countryMap.put("UA", "uk");
        countryMap.put("CZ", "cs");
        countryMap.put("SI", "sl");
        countryMap.put("TR", "tr");
        countryMap.put("HU", "hu");
        countryMap.put("TH", "th");
        countryMap.put("CS", "sr");
        countryMap.put("MK", "sr");
        countryMap.put("BA", "sh");
        countryMap.put("YU", "sh");
        countryMap.put("CS@Latn", "sh");
    }
}

