/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.i18n;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.i18n.RSSOwlI18nEN;
import net.sourceforge.rssowl.util.i18n.Translation;

public class RSSOwlI18n
extends Dictionary {
    private static RSSOwlI18nEN defaultTranslation;
    private HashMap i18n;

    public RSSOwlI18n(Locale locale) {
        String string = locale.getLanguage();
        if (string != null && !string.equals("en") && translations.containsKey(string)) {
            try {
                String string2 = "";
                if (locales.containsKey(string)) {
                    string2 = ((Locale)locales.get(string)).getCountry();
                }
                Class<?> clazz = Class.forName((String)translations.get(string));
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                this.i18n = ((Translation)constructor.newInstance(string, string2)).getTranslation();
                Dictionary.selectedLanguage = string;
                selectedLocale = new Locale(string, string2);
            }
            catch (Exception exception) {
                GUI.logger.log("RSSOwlI18n()", exception);
                this.switchToDefaultTranslation();
            }
        } else {
            this.switchToDefaultTranslation();
        }
    }

    public static Translation getDefaultTranslation() {
        if (defaultTranslation == null) {
            defaultTranslation = new RSSOwlI18nEN("en", "EN");
        }
        return defaultTranslation;
    }

    @Override
    public String getTranslation(String string) {
        Object v = this.i18n.get(string);
        if (v != null) {
            return (String)v;
        }
        if (RSSOwlI18n.getDefaultTranslation().getTranslation().get(string) != null) {
            return (String)RSSOwlI18n.getDefaultTranslation().getTranslation().get(string);
        }
        return string;
    }

    private void switchToDefaultTranslation() {
        Dictionary.selectedLanguage = "en";
        this.i18n = RSSOwlI18n.getDefaultTranslation().getTranslation();
        selectedLocale = new Locale("en");
    }

    static {
        String string = "net.sourceforge.rssowl.util.i18n.";
        Dictionary.register("de", "DE", true, string + "RSSOwlI18nDE");
        Dictionary.register("en", "EN", false, string + "RSSOwlI18nEN");
        Dictionary.register("fr", "FR", true, string + "RSSOwlI18nFR");
        Dictionary.register("it", "IT", true, string + "RSSOwlI18nIT");
        Dictionary.register("da", "DK", true, string + "RSSOwlI18nDA");
        Dictionary.register("no", "NO", true, string + "RSSOwlI18nNO");
        Dictionary.register("nl", "NL", true, string + "RSSOwlI18nNL");
        Dictionary.register("sv", "SE", true, string + "RSSOwlI18nSV");
        Dictionary.register("fi", "FI", true, string + "RSSOwlI18nFI");
        Dictionary.register("es", "ES", true, string + "RSSOwlI18nES");
        Dictionary.register("gl", "GL", false, string + "RSSOwlI18nGL");
        Dictionary.register("pl", "PL", true, string + "RSSOwlI18nPL");
        Dictionary.register("el", "GR", true, string + "RSSOwlI18nEL");
        Dictionary.register("ru", "RU", true, string + "RSSOwlI18nRU");
        Dictionary.register("uk", "UA", false, string + "RSSOwlI18nUK");
        Dictionary.register("bn", "BD", false, string + "RSSOwlI18nBN");
        Dictionary.register("pt", "BR", false, string + "RSSOwlI18nPT");
        Dictionary.register("bg", "BG", false, string + "RSSOwlI18nBG");
        Dictionary.register("zhcn", "CN", false, string + "RSSOwlI18nZHcn");
        Dictionary.register("ja", "JP", true, string + "RSSOwlI18nJA");
        Dictionary.register("zhtw", "TW", false, string + "RSSOwlI18nZHtw");
        Dictionary.register("ko", "KR", false, string + "RSSOwlI18nKO");
        Dictionary.register("th", "TH", false, string + "RSSOwlI18nTH");
        Dictionary.register("tr", "TR", false, string + "RSSOwlI18nTR");
        Dictionary.register("hy", "AM", true, string + "RSSOwlI18nHY");
        Dictionary.register("cs", "CZ", false, string + "RSSOwlI18nCS");
        Dictionary.register("sr", "CS", false, string + "RSSOwlI18nSR");
        Dictionary.register("sh", "CS@Latn", false, string + "RSSOwlI18nSH");
        Dictionary.register("hr", "HR", true, string + "RSSOwlI18nHR");
        Dictionary.register("hu", "HU", false, string + "RSSOwlI18nHU");
        Dictionary.register("sk", "SK", true, string + "RSSOwlI18nSK");
        Dictionary.register("sl", "SI", false, string + "RSSOwlI18nSL");
    }
}

