/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.search;

import java.util.ArrayList;
import java.util.Hashtable;
import net.sourceforge.rssowl.util.search.SearchDefinition;
import net.sourceforge.rssowl.util.search.SearchPatternParser;
import net.sourceforge.rssowl.util.shop.RegExShop;

public class ParsedSearch {
    private ArrayList mustContain;
    private ArrayList mustNotContain;
    private SearchDefinition searchDefinition;

    private ParsedSearch(SearchDefinition searchDefinition) {
        this.searchDefinition = searchDefinition;
    }

    public static ParsedSearch parseFrom(SearchDefinition searchDefinition) {
        ParsedSearch parsedSearch = new ParsedSearch(searchDefinition);
        if (!searchDefinition.isPatternRegEx()) {
            String string = RegExShop.escapeRegEx(searchDefinition.getPattern());
            Hashtable hashtable = SearchPatternParser.parsePattern(string);
            ArrayList arrayList = SearchPatternParser.generateRegEx((ArrayList)hashtable.get("MUST_CONTAIN_KEY"), searchDefinition.isWholeWord());
            parsedSearch.setMustContain(arrayList);
            ArrayList arrayList2 = (ArrayList)hashtable.get("MUSTNOT_CONTAIN_KEY");
            parsedSearch.setMustNotContain(arrayList2);
        }
        return parsedSearch;
    }

    public ArrayList getMustContain() {
        return this.mustContain;
    }

    public ArrayList getMustNotContain() {
        return this.mustNotContain;
    }

    public SearchDefinition getSearchDefinition() {
        return this.searchDefinition;
    }

    public boolean isRegExSearch() {
        return this.searchDefinition.isPatternRegEx();
    }

    private void setMustContain(ArrayList arrayList) {
        this.mustContain = arrayList;
    }

    private void setMustNotContain(ArrayList arrayList) {
        this.mustNotContain = arrayList;
    }
}

