/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.dialog.PreferencesDialog;
import net.sourceforge.rssowl.controller.thread.StreamGobbler;
import net.sourceforge.rssowl.model.Category;
import net.sourceforge.rssowl.model.NewsItem;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.jdom.Text;

public class BlogShop {
    static String executable;

    private BlogShop() {
    }

    public static void blogNews(NewsItem newsItem) {
        String string;
        if (!BlogShop.isBloggerSet()) {
            return;
        }
        String string2 = newsItem.getLink();
        if (string2 == null && newsItem.getGuid() != null) {
            string2 = newsItem.getGuid();
        } else if (string2 == null) {
            string2 = "";
        }
        String string3 = newsItem.getNewsfeedXmlUrl();
        if (string3 == null) {
            string3 = "";
        }
        if (newsItem.isPartOfAggregation()) {
            string3 = newsItem.getNewsfeedTitle();
        }
        if (Category.getLinkForTitle(string3) != null) {
            string3 = Category.getLinkForTitle(string3);
        }
        if (!StringShop.isset(string = newsItem.getTitle())) {
            string = GUI.i18n.getTranslation("NO_TITLE");
        }
        String string4 = GlobalSettings.bloggerArguments;
        string4 = StringShop.replaceAll(string4, "[NEWSLINK]", string2);
        string4 = StringShop.replaceAll(string4, "[FEEDLINK]", string3);
        string4 = StringShop.replaceAll(string4, "[TITLE]", StringShop.replaceAll(string, "\"", "'"));
        if (StringShop.isset(newsItem.getAuthor())) {
            string4 = StringShop.replaceAll(string4, "[AUTHOR]", newsItem.getAuthor());
        }
        if (StringShop.isset(newsItem.getCategory())) {
            string4 = StringShop.replaceAll(string4, "[CATEGORY]", newsItem.getCategory());
        }
        string4 = StringShop.isset(newsItem.getDescription()) ? StringShop.replaceAll(string4, "[DESCRIPTION]", StringShop.replaceAll(newsItem.getDescription(), "\"", "'")) : StringShop.replaceAll(string4, "[DESCRIPTION]", GUI.i18n.getTranslation("NEWS_NO_DESCRIPTION"));
        if (StringShop.isset(newsItem.getPubDate())) {
            string4 = StringShop.replaceAll(string4, "[PUBDATE]", newsItem.getPubDate());
        }
        if (StringShop.isset(newsItem.getPublisher())) {
            string4 = StringShop.replaceAll(string4, "[PUBLISHER]", newsItem.getPublisher());
        }
        if (StringShop.isset(newsItem.getSource())) {
            string4 = StringShop.replaceAll(string4, "[SOURCE]", newsItem.getSource());
        }
        string4 = Text.normalizeString(string4);
        executable = GlobalSettings.bloggerPath + " " + string4;
        Thread thread = new Thread("Blogger Launcher"){

            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec(executable);
                    StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
                    StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
                    streamGobbler.start();
                    streamGobbler2.start();
                    process.waitFor();
                }
                catch (IOException iOException) {
                    GUI.logger.log("blogNews", iOException);
                }
                catch (InterruptedException interruptedException) {
                    GUI.logger.log("blogNews", interruptedException);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static boolean isBloggerSet() {
        if (GlobalSettings.bloggerPath.equals("")) {
            MessageBoxFactory.showMessage(GUI.shell, 8, GUI.i18n.getTranslation("POP_BLOG_NEWS"), GUI.i18n.getTranslation("DIALOG_BLOGGER_ATTENTION"));
            PreferencesDialog.lastOpenedPropertyPage = 8;
            new PreferencesDialog(GUI.shell, GUI.i18n.getTranslation("MENU_PREFERENCES"), GUI.rssOwlGui).open();
            return false;
        }
        return true;
    }
}

