/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.io.IOException;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.controller.dialog.PreferencesDialog;
import net.sourceforge.rssowl.controller.thread.StreamGobbler;
import net.sourceforge.rssowl.controller.thread.UpdateManager;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.program.Program;

public class BrowserShop {
    public static final String IE_MOTW = "<!-- saved from url=(0014)about:internet -->";
    static String executable;
    static String localHref;
    static String webBrowser;
    static boolean webBrowserSuccessfullyOpened;

    private BrowserShop() {
    }

    public static String createBrowserError(SWTError sWTError) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GUI.i18n.getTranslation("DIALOG_ERROR_INTERNALBROWSER")).append("\n");
        stringBuffer.append(sWTError.getLocalizedMessage()).append("\n").append("\n");
        stringBuffer.append("Please refer to the FAQ on how to setup your").append("\n");
        stringBuffer.append("system to use the Internal Browser in RSSOwl.");
        return stringBuffer.toString();
    }

    public static String getOwlAgent() {
        if (GlobalSettings.isWindows()) {
            return "RSSOwl/" + UpdateManager.getPublicVersion() + " (Windows; U; " + Dictionary.selectedLanguage + ")";
        }
        if (GlobalSettings.isLinux() || GlobalSettings.isSolaris()) {
            return "RSSOwl/" + UpdateManager.getPublicVersion() + " (X11; U; " + Dictionary.selectedLanguage + ")";
        }
        if (GlobalSettings.isMac()) {
            return "RSSOwl/" + UpdateManager.getPublicVersion() + " (Macintosh; U; " + Dictionary.selectedLanguage + ")";
        }
        return "RSSOwl/" + UpdateManager.getPublicVersion();
    }

    public static String getUserAgent() {
        if (GlobalSettings.isWindows()) {
            return "Mozilla/5.0 (compatible; MSIE 6.0; Windows XP)";
        }
        if (GlobalSettings.isLinux()) {
            return "Mozilla/5.0 (X11; U; Linux i686)";
        }
        if (GlobalSettings.isSolaris()) {
            return "Mozilla/5.0 (X11; U; Solaris i686)";
        }
        if (GlobalSettings.isMac()) {
            return "Mozilla/5.0 (Macintosh; U)";
        }
        return "Mozilla/5.0";
    }

    public static void openLink(String string) {
        if (string.startsWith("file:")) {
            string = string.substring(5);
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            string = "file:///" + string;
        }
        if ((localHref = string).indexOf(" ") >= 0) {
            localHref = "\"" + localHref + "\"";
        }
        if (!GlobalSettings.customBrowser.equals("")) {
            BrowserShop.useCustomBrowser();
        } else {
            BrowserShop.useDefaultBrowser();
        }
    }

    public static void openLinkInTab(String string) {
        if (GlobalSettings.openBrowserExtern || !GlobalSettings.useInternalBrowser()) {
            BrowserShop.openLink(string);
        } else {
            try {
                GUI.rssOwlGui.getRSSOwlNewsTabFolder().loadURLInTab(string);
            }
            catch (SWTError sWTError) {
                GUI.logger.log("openLinkInTab", sWTError);
                GlobalSettings.openBrowserExtern = true;
                MessageBoxFactory.showError(GUI.shell, BrowserShop.createBrowserError(sWTError));
                GUI.rssOwlGui.getEventManager().actionOpenFAQOnBrowser();
                BrowserShop.openLink(string);
            }
        }
    }

    private static void useCustomBrowser() {
        String string = GlobalSettings.customBrowser;
        String string2 = GlobalSettings.customBrowserArguments;
        executable = string2.equals("") ? string + " " + localHref : (string2.indexOf("[URL]") >= 0 ? string + " " + StringShop.replaceAll(string2, "[URL]", localHref) : string + " " + string2 + " " + localHref);
        Thread thread = new Thread("Browser Launcher"){

            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec(executable);
                    StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
                    StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
                    streamGobbler.start();
                    streamGobbler2.start();
                    process.waitFor();
                }
                catch (IOException iOException) {
                    GUI.logger.log("useCustomBrowser()", iOException);
                    BrowserShop.useDefaultBrowser();
                }
                catch (InterruptedException interruptedException) {
                    GUI.logger.log("useCustomBrowser()", interruptedException);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    static void errorMessage() {
        if (GUI.isAlive()) {
            GUI.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageBoxFactory.showMessage(GUI.shell, 1, GUI.i18n.getTranslation("MESSAGE_BOX_TITLE_ERROR"), GUI.i18n.getTranslation("DIALOG_BROWSERSTART_FAILED"));
                    PreferencesDialog.lastOpenedPropertyPage = 9;
                    new PreferencesDialog(GUI.shell, GUI.i18n.getTranslation("MENU_PREFERENCES"), GUI.rssOwlGui).open();
                }
            });
        }
    }

    static Process openWebBrowser(String string) {
        Process process = null;
        if (webBrowser == null) {
            try {
                webBrowser = "netscape";
                process = Runtime.getRuntime().exec(webBrowser + "  " + string);
            }
            catch (IOException iOException) {
                webBrowser = "mozilla";
            }
        }
        if (process == null) {
            try {
                process = Runtime.getRuntime().exec(webBrowser + " " + string);
            }
            catch (IOException iOException) {
                GUI.logger.log("openWebBrowser", iOException);
                BrowserShop.errorMessage();
            }
        }
        return process;
    }

    static void useDefaultBrowser() {
        if (GlobalSettings.isWindows()) {
            Program.launch(localHref);
        } else if (GlobalSettings.isMac()) {
            try {
                Process process = Runtime.getRuntime().exec("/usr/bin/open " + localHref);
                StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
                StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
                streamGobbler.start();
                streamGobbler2.start();
            }
            catch (IOException iOException) {
                GUI.logger.log("useDefaultBrowser", iOException);
                BrowserShop.errorMessage();
            }
        } else {
            Thread thread = new Thread("Browser Launcher"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            if (webBrowserSuccessfullyOpened) {
                                Process process = Runtime.getRuntime().exec(webBrowser + " -remote openURL(" + localHref + ")");
                                StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
                                StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
                                streamGobbler.start();
                                streamGobbler2.start();
                                break block10;
                            }
                            Process process = BrowserShop.openWebBrowser(localHref);
                            webBrowserSuccessfullyOpened = true;
                            if (process != null) {
                                StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
                                StreamGobbler streamGobbler3 = new StreamGobbler(process.getInputStream());
                                streamGobbler.start();
                                streamGobbler3.start();
                            }
                            try {
                                if (process != null) {
                                    process.waitFor();
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                GUI.logger.log("useDefaultBrowser", interruptedException);
                            }
                            finally {
                                webBrowserSuccessfullyOpened = false;
                            }
                        }
                        catch (IOException iOException) {
                            GUI.logger.log("useDefaultBrowser", iOException);
                            BrowserShop.errorMessage();
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }
}

