/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.MessageBoxFactory;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.model.Channel;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.SimpleFileShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import net.sourceforge.rssowl.util.shop.XMLShop;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.jdom.Document;

public class FileShop
extends SimpleFileShop {
    private FileShop() {
    }

    public static boolean exists(String string) {
        if (!StringShop.isset(string)) {
            return false;
        }
        return new File(string).exists();
    }

    public static void exportCategory(Shell shell, String string, String[] stringArray) throws IOException {
        String string2 = FileShop.getFilePath(shell, stringArray, string, 8192, null, null);
        if (string2 != null && (!new File(string2).exists() || FileShop.overwrite())) {
            SimpleFileShop.copy(GlobalSettings.TEMP_EXPORT_FILE, string2);
        }
    }

    public static void exportUserSettings(Shell shell) throws IOException {
        String string = FileShop.getFilePath(shell, new String[]{"*.xml", "*.*"}, "user.xml", 8192, null, GUI.i18n.getTranslation("MENU_EXPORT"));
        if (string != null && (!new File(string).exists() || FileShop.overwrite())) {
            SimpleFileShop.copy(GlobalSettings.RSSOWL_SETTINGS_FILE, string);
        }
    }

    public static String getContent(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        if (inputStream == null) {
            return "";
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            GUI.logger.log("getContent()", iOException);
            return "";
        }
        return stringBuffer.toString();
    }

    public static String getContent(URL uRL) throws IOException {
        ConnectionManager connectionManager = new ConnectionManager(uRL.toExternalForm());
        connectionManager.setShowLoginDialogIfRequired(false);
        connectionManager.connect();
        String string = FileShop.getContent(connectionManager.getInputStream());
        connectionManager.closeConnection();
        return string;
    }

    public static String getFilePath(Shell shell, String[] stringArray, String string, int n, String string2, String string3) {
        FileDialog fileDialog = new FileDialog(shell, n);
        if (stringArray != null) {
            fileDialog.setFilterExtensions(stringArray);
        }
        if (string2 != null) {
            fileDialog.setFilterPath(string2);
        }
        if (string != null) {
            fileDialog.setFileName(string);
        }
        if (StringShop.isset(string3)) {
            fileDialog.setText(string3);
        }
        return fileDialog.open();
    }

    public static String getFilePath(String[] stringArray, String string, int n, String string2, String string3) {
        return FileShop.getFilePath(GUI.shell, stringArray, string, n, string2, string3);
    }

    public static String getSavePath(String string, String string2, String string3) {
        String string4 = FileShop.getFilePath(new String[]{"*." + string2, "*.*"}, string, 8192, null, string3);
        if (string4 != null && (!new File(string4).exists() || FileShop.overwrite())) {
            return string4;
        }
        return null;
    }

    public static int importUserSettings(Shell shell) throws IOException {
        String string = FileShop.getFilePath(shell, new String[]{"*.xml", "*.*"}, null, 4096, null, GUI.i18n.getTranslation("MENU_IMPORT"));
        if (string == null) {
            return -1;
        }
        if (XMLShop.isValidUserXML(string)) {
            SimpleFileShop.copy(string, GlobalSettings.RSSOWL_SETTINGS_FILE);
            return 0;
        }
        return 1;
    }

    public static boolean isMediumWriteable(File file) {
        try {
            file.createNewFile();
            file.delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void saveRSSXML(String string, String string2) {
        String string3 = FileShop.getFilePath(new String[]{"*.xml", "*.*"}, string2, 8192, null, GUI.i18n.getTranslation("MENU_SAVE"));
        if (string3 != null && (!new File(string3).exists() || FileShop.overwrite())) {
            FileShop.copyXML(string, string3);
        }
    }

    public static boolean saveSelectedNewsFeed() {
        Channel channel = GUI.rssOwlGui.getRSSOwlNewsTabFolder().getSelectedChannel();
        if (channel == null) {
            return false;
        }
        Document document = channel.toDocument();
        XMLShop.writeXML(document, GlobalSettings.TEMP_FEED_FILE, true);
        String string = FileShop.suggestRSSFileName(GUI.rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().getSelection().getText());
        FileShop.saveRSSXML(GlobalSettings.TEMP_FEED_FILE, string);
        return true;
    }

    public static String suggestRSSFileName(String string) {
        String string2 = DateParser.dateToFileName(DateParser.formatDate());
        String string3 = string + "_rss_" + string2 + ".xml";
        string3 = StringShop.createFileName(string3);
        return string3;
    }

    private static boolean overwrite() {
        return MessageBoxFactory.showMessage(GUI.shell, 200, GUI.i18n.getTranslation("MESSAGEBOX_TITLE_ATTENTION"), GUI.i18n.getTranslation("MESSAGEBOX_FILE_EXISTS")) == 64;
    }

    static void copyXML(String string, String string2) {
        try {
            InputStream inputStream = XMLShop.getXMLStream(string);
            if (inputStream != null) {
                FileShop.copy(XMLShop.getXMLStream(string), new BufferedOutputStream(new FileOutputStream(string2)));
            }
        }
        catch (IOException iOException) {
            GUI.logger.log("copyRssXml", iOException);
        }
    }
}

