/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import java.util.Vector;
import net.sourceforge.rssowl.util.shop.RegExShop;

public class StringShop {
    public static final String AUTH_TOKENIZER = " =;;= ";
    public static final String CAT_TOKENIZER = "=;=";
    public static final String EMPTY_TEXT_DATA = " ";

    private StringShop() {
    }

    public static String createAnchor(String string) {
        return StringShop.createAnchor(string, string);
    }

    public static String createAnchor(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=\"").append(string).append("\">").append(string2).append("</a>");
        return stringBuffer.toString();
    }

    public static String createFileName(String string) {
        string = string.replaceAll(" \\| ", "_");
        string = string.replaceAll(">", "_");
        string = string.replaceAll(": ", "_");
        string = string.replaceAll(EMPTY_TEXT_DATA, "_");
        if ((string = string.replaceAll("\\?", "_")).matches("[_]+")) {
            string = "rssowl";
        }
        return string;
    }

    public static String escapeAmpersands(String string) {
        if (string.indexOf(38) >= 0) {
            return StringShop.replaceAll(string, "&", "&&");
        }
        return string;
    }

    public static String hrTrim(String string, int n) {
        if (string.indexOf(32) == -1 || string.length() < n) {
            return string;
        }
        string = string.substring(0, n);
        for (int i = n - 1; i >= 0; --i) {
            if (string.charAt(i) != ' ') continue;
            return string.substring(0, i) + "...";
        }
        return string;
    }

    public static boolean isset(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isTerminating(String string) {
        if (string == null) {
            return true;
        }
        return string.equals(EMPTY_TEXT_DATA) || string.equals("\n") || string.equals(System.getProperty("line.separator")) || string.equals("\t") || string.equals("\"") || string.equals("'");
    }

    public static boolean isWhiteSpaceOrEmpty(String string) {
        return !StringShop.isset(string) || RegExShop.WHITESPACE_PATTERN.matcher(string).matches();
    }

    public static String pointTrim(String string, int n, boolean bl) {
        if (bl) {
            string = StringShop.escapeAmpersands(string);
        }
        return string.length() >= n ? string.substring(0, n) + "..." : string;
    }

    public static String printf(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            string = StringShop.replaceAll(string, stringArray[i], stringArray2[i]);
        }
        return string;
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String stripTags(String string) {
        if (string == null || string.indexOf(60) == -1 || string.indexOf(62) == -1) {
            return string;
        }
        string = RegExShop.HTML_TAG_REGEX_PATTERN.matcher(string).replaceAll("");
        return string;
    }

    public static Vector toVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector;
    }

    public static String unicodeToEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c >= ' ' && c <= '~' || Character.isWhitespace(c))) {
                stringBuffer.append("&#x");
                String string2 = Integer.toHexString(c & 0xFFFF);
                if (string2.length() == 2) {
                    stringBuffer.append("00");
                }
                stringBuffer.append(string2).append(";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

