/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.rssowl.util.shop;

import com.lowagie.text.html.HtmlEncoder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Vector;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.UpdateManager;
import net.sourceforge.rssowl.dao.ConnectionManager;
import net.sourceforge.rssowl.util.DateParser;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.BrowserShop;
import net.sourceforge.rssowl.util.shop.FileShop;
import net.sourceforge.rssowl.util.shop.RegExShop;
import net.sourceforge.rssowl.util.shop.StringShop;
import org.apache.commons.httpclient.HttpException;
import org.eclipse.swt.SWT;

public class URLShop {
    public static final String ABOUT_BLANK = "about:blank";
    public static String AMPHETARATE_REGISTRATION_URL;
    public static final String FEED_PROTOCOL_LONG = "feed://";
    public static final String FEED_PROTOCOL_SHORT = "feed:";
    public static final String FEED_VALIDATOR_URL = "http://validator.w3.org/feed/check.cgi?url=";
    public static String RSSOWL_CHANGELOG_URL;
    public static String RSSOWL_CONTACT;
    public static String RSSOWL_DONATE;
    public static String RSSOWL_DOWNLOAD;
    public static String RSSOWL_FAQ;
    public static String RSSOWL_FEED;
    public static String RSSOWL_FORUM;
    public static String RSSOWL_LIST;
    public static String RSSOWL_PROMOTION;
    public static String RSSOWL_TUTORIAL;
    public static String RSSOWL_UPDATE_URL;
    public static String RSSOWL_WEBPAGE;
    private static final String[] BINARY_EXTENSIONS;
    private static final String ERROR_MAIL = "error-report@rssowl.org";
    private static final String[] FEED_EXTENSIONS;
    private static final String[] FEED_EXTENSIONS_DOTTED;

    private URLShop() {
    }

    public static String canonicalize(String string) {
        String string2 = string;
        if (string.startsWith("ftp.")) {
            string2 = "ftp://" + string;
        } else if (string.startsWith("gopher.")) {
            string2 = "gopher://" + string;
        } else if (string.charAt(0) == '/') {
            string2 = "file:" + string;
        } else if (!URLShop.hasProtocolName(string)) {
            if (URLShop.isSimpleHostName(string)) {
                string = "www." + string;
            }
            string2 = "http://" + string;
        }
        return string2;
    }

    public static Vector crawlUrls(String string) throws HttpException, IOException {
        ConnectionManager connectionManager = new ConnectionManager(string);
        connectionManager.setUserAgent(BrowserShop.getUserAgent());
        connectionManager.connect();
        String string2 = FileShop.getContent(connectionManager.getInputStream());
        connectionManager.closeConnection();
        Vector vector = new Vector();
        RegExShop.extractLinksFromHTML(string2, vector);
        RegExShop.extractLinksFromText(string2, vector);
        return vector;
    }

    public static String createErrorReport() {
        String string = "mailto:error-report@rssowl.org";
        String string2 = "RSSOwl Error Report (OS: " + SWT.getPlatform() + " RSSOwl " + UpdateManager.getPublicVersion() + " " + DateParser.formatDate() + ")";
        String string3 = GUI.i18n.getTranslation("MAIL_ERROR_BODY") + "\nPS: Please use English or German if possible, thanks.";
        string = string + "?body=" + URLShop.mailToUrllEncode(string3) + "&subject=" + URLShop.mailToUrllEncode(string2);
        return string;
    }

    public static String createTellMyFriends() {
        String string = "mailto:";
        String string2 = "RSSOwl - RSS / RDF / Atom Newsreader";
        String string3 = GUI.i18n.getTranslation("RSSOWL_TEASER");
        string = string + "?body=" + URLShop.mailToUrllEncode(string3) + "&subject=" + URLShop.mailToUrllEncode(string2);
        return string;
    }

    public static String getFile(URL uRL) {
        String[] stringArray;
        String string = uRL.getPath();
        if (StringShop.isset(string) && (stringArray = string.split("/")).length > 0 && StringShop.isset(stringArray[stringArray.length - 1])) {
            return URLShop.urlDecode(stringArray[stringArray.length - 1]);
        }
        return uRL.toExternalForm();
    }

    public static boolean hasProtocolName(String string) {
        int n = string.indexOf(58);
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean isSimpleHostName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean looksLikeBinary(String string) {
        for (int i = 0; i < BINARY_EXTENSIONS.length; ++i) {
            if (string.indexOf(BINARY_EXTENSIONS[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean looksLikeNewsfeed(String string, boolean bl) {
        for (int i = 0; i < (bl ? FEED_EXTENSIONS_DOTTED.length : FEED_EXTENSIONS.length); ++i) {
            if (string.indexOf(bl ? FEED_EXTENSIONS_DOTTED[i] : FEED_EXTENSIONS[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean looksLikeNewsfeed(URL uRL, boolean bl) {
        return URLShop.looksLikeNewsfeed(uRL.getFile(), bl);
    }

    public static boolean looksLikeURL(String string) {
        if (!StringShop.isset(string)) {
            return false;
        }
        if (string.indexOf(32) >= 0) {
            return false;
        }
        if (RegExShop.isValidURL(string)) {
            return true;
        }
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static String mailToUrllEncode(String string) {
        if (GlobalSettings.htmlFormatMail) {
            return HtmlEncoder.encode(URLShop.urlEncode(string.replaceAll("\\n", "<br />")).replaceAll("\\+", "%20"));
        }
        return URLShop.urlEncode(string).replaceAll("\\+", "%20");
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, GlobalSettings.charEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return URLDecoder.decode(string, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return URLDecoder.decode(string);
            }
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, GlobalSettings.charEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return URLEncoder.encode(string, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return URLEncoder.encode(string);
            }
        }
    }

    public static boolean isScriptAllowed(String string) {
        return !ABOUT_BLANK.equals(string);
    }

    static {
        BINARY_EXTENSIONS = new String[]{".jpg", ".gif", ".png", ".bmp", ".pdf", ".doc", ".zip", ".tar", ".gz", ".rar", ".bz", ".ps", ".xls", ".ppt", ".rtf", ".midi", ".wav", ".mp3", ".mov", ".rm", ".swf", ".exe", ".dmg"};
        FEED_EXTENSIONS = new String[]{"rss", "rdf", "xml", "atom", "feed"};
        FEED_EXTENSIONS_DOTTED = new String[]{".rss", ".rdf", ".xml", ".atom", ".feed"};
        AMPHETARATE_REGISTRATION_URL = "http://amphetarate.sourceforge.net/dinka-create-uid.php?appname=RSSOwl";
        RSSOWL_WEBPAGE = "http://www.rssowl.org";
        RSSOWL_FORUM = "http://sourceforge.net/forum/?group_id=86683";
        RSSOWL_PROMOTION = "http://www.rssowl.org/contribute";
        RSSOWL_FEED = "http://www.rssowl.org/newsfeed";
        RSSOWL_DOWNLOAD = "http://www.rssowl.org/download";
        RSSOWL_LIST = "http://lists.sourceforge.net/mailman/listinfo/rssowl-users";
        RSSOWL_DONATE = "http://sourceforge.net/donate/index.php?group_id=86683";
        RSSOWL_FAQ = "http://www.rssowl.org/faq.xml";
        RSSOWL_TUTORIAL = "http://tutorial.rssowl.org";
        RSSOWL_CHANGELOG_URL = "http://www.rssowl.org/update/rssowl.release";
        RSSOWL_UPDATE_URL = "http://www.rssowl.org/update/rssowl.version";
        RSSOWL_CONTACT = "mailto:contact@rssowl.org";
    }
}

