/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     IBM Corporation - initial API and implementation                     **
 **     RSSOwl.org      - Copied to avoid dependancy to ui.forms             ** 
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.forms;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

/**
 * Utility methods to access shared form-specific resources.
 * <p>
 * All methods declared on this class are static. This class cannot be
 * instantiated.
 * </p>
 */
public class FormsResources {
  private static Cursor busyCursor;
  private static Cursor handCursor;
  private static Cursor textCursor;

  /**
   * @return Cursor
   */
  public static Cursor getBusyCursor() {
    if (busyCursor == null)
      busyCursor = new Cursor(Display.getCurrent(), SWT.CURSOR_WAIT);
    return busyCursor;
  }

  /**
   * @return Cursor
   */
  public static Cursor getHandCursor() {
    if (handCursor == null)
      handCursor = new Cursor(Display.getCurrent(), SWT.CURSOR_HAND);
    return handCursor;
  }

  /**
   * @return Cursor
   */
  public static Cursor getTextCursor() {
    if (textCursor == null)
      textCursor = new Cursor(Display.getCurrent(), SWT.CURSOR_IBEAM);
    return textCursor;
  }

  /** Shutdown */
  public static void shutdown() {
    if (busyCursor != null)
      busyCursor.dispose();
    if (handCursor != null)
      handCursor.dispose();
    if (textCursor != null)
      textCursor.dispose();
    busyCursor = null;
    handCursor = null;
    textCursor = null;
  }
}