/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     IBM Corporation - initial API and implementation                     **
 **     RSSOwl.org      - Copied to avoid dependancy to ui.forms             ** 
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.forms;

/**
 * This adapter class provides default implementations for the methods described
 * by the <code>HyperlinkListener</code> interface.
 * <p>
 * Classes that wish to deal with <code>HyperlinkEvent</code> s can extend
 * this class and override only the methods which they are interested in.
 * </p>
 * 
 * @see IHyperlinkListener
 * @see HyperlinkEvent
 * @since 3.0
 */
public class HyperlinkAdapter implements IHyperlinkListener {
  /**
   * Sent when the link is entered. The default behaviour is to do nothing.
   * 
   * @param e the event
   */
  public void linkEntered(HyperlinkEvent e) {
  // Do nothing by default
  }

  /**
   * Sent when the link is exited. The default behaviour is to do nothing.
   * 
   * @param e the event
   */
  public void linkExited(HyperlinkEvent e) {
  // Do nothing by default
  }

  /**
   * Sent when the link is activated. The default behaviour is to do nothing.
   * 
   * @param e the event
   */
  public void linkActivated(HyperlinkEvent e) {
  // Do nothing by default
  }
}