/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     IBM Corporation - initial API and implementation                     **
 **     RSSOwl.org      - Copied to avoid dependancy to ui.forms             ** 
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.forms;

import org.eclipse.swt.widgets.Composite;

/**
 * Classes that extend abstract class Layout and implement this interface can
 * take part in layout computation of the TableWrapLayout manager. This layout
 * uses alternative algorithm that computes columns before rows. It allows it to
 * 'flow' wrapped text proportionally (similar to the way web browser renders
 * tables). Custom layout managers that implement this interface will allow
 * TableWrapLayout to properly compute width hint to pass.
 * 
 * @see TableWrapLayout
 * @see ColumnLayout
 * @since 3.0
 */
public interface ILayoutExtension {
  /**
   * Computes the minimum width of the parent. All widgets capable of word
   * wrapping should return the width of the longest word that cannot be broken
   * any further.
   * 
   * @param parent the parent composite
   * @param changed <code>true</code> if the cached information should be
   * flushed, <code>false</code> otherwise.
   * @return the minimum width of the parent composite
   */
  public int computeMinimumWidth(Composite parent, boolean changed);

  /**
   * Computes the maximum width of the parent. All widgets capable of word
   * wrapping should return the length of the entire text with wrapping turned
   * off.
   * 
   * @param parent the parent composite
   * @param changed <code>true</code> if the cached information should be
   * flushed, <code>false</code> otherwise.
   * @return the maximum width of the parent composite
   */
  public int computeMaximumWidth(Composite parent, boolean changed);
}