/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * The blogroll-favorite popup appears when right-clicking on any favorite that
 * is part of a blogroll in the tree.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class BlogrollFavoritePopup {
  private Menu popUpMenu;
  private Shell shell;
  EventManager eventManager;

  /**
   * Instantiate a new BlogrollFavoritePopup
   * 
   * @param shell The shell
   * @param popUpMenu The menu to add this menu to
   * @param eventManager The event manager
   */
  public BlogrollFavoritePopup(Shell shell, Menu popUpMenu, EventManager eventManager) {
    this.shell = shell;
    this.popUpMenu = popUpMenu;
    this.eventManager = eventManager;

    /** Init the Popup */
    initBlogrollFavoriteMenu();
  }

  /** Init the popup menuStructure for a blogroll favorite */
  private void initBlogrollFavoriteMenu() {

    /** Open selected favorite */
    MenuItem open = new MenuItem(popUpMenu, SWT.PUSH);
    open.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
    open.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionHandleTreeItemSelect();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Mark selected favorite read */
    MenuItem markRead = new MenuItem(popUpMenu, SWT.PUSH);
    markRead.setText(GUI.i18n.getTranslation("POP_MARK_FAVORITE_READ"));
    markRead.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionMarkFavoriteRead();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Reload favorite */
    MenuItem reload = new MenuItem(popUpMenu, SWT.PUSH);
    reload.setText(GUI.i18n.getTranslation("BUTTON_RELOAD"));
    if (!GlobalSettings.isMac())
      reload.setImage(PaintShop.iconReload);
    reload.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionReloadFeed();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Search in favorite */
    MenuItem search = new MenuItem(popUpMenu, SWT.PUSH);
    search.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE") + "...");
    if (!GlobalSettings.isMac())
      search.setImage(PaintShop.iconFind);
    search.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionSearchInFeed();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Synchronize */
    MenuItem synchronize = new MenuItem(popUpMenu, SWT.PUSH);
    synchronize.setText(GUI.i18n.getTranslation("POP_SYNCHRONIZE"));
    synchronize.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionSynchronizeBlogroll();
      }
    });

    /** Unsubscribe */
    MenuItem remove = new MenuItem(popUpMenu, SWT.PUSH);
    remove.setText(GUI.i18n.getTranslation("POP_UNSUBSCRIBE"));
    if (!GlobalSettings.isMac())
      remove.setImage(PaintShop.iconDelete);
    remove.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionDeleteBlogroll();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Copy favorite's URL */
    MenuItem copyXmlLocation = new MenuItem(popUpMenu, SWT.PUSH);
    copyXmlLocation.setText(GUI.i18n.getTranslation("POP_COPY_NEWS_URL"));
    copyXmlLocation.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionCopyFavoritesXmlLocation();
      }
    });

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Import OPML files */
    MenuItem importMenu = new MenuItem(popUpMenu, SWT.CASCADE);
    importMenu.setText(GUI.i18n.getTranslation("POP_IMPORT"));
    if (!GlobalSettings.isMac())
      importMenu.setImage(PaintShop.iconImport);

    Menu selectImport = new Menu(shell, SWT.DROP_DOWN);
    importMenu.setMenu(selectImport);

    /** Import OPML */
    MenuItem cascadeItemImportOPML = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportOPML.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportOPML.setImage(PaintShop.iconImportOpml);
    cascadeItemImportOPML.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportOPML();
      }
    });

    /** Import Synchronized Blogroll */
    MenuItem cascadeItemImportBlogroll = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportBlogroll.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportBlogroll.setImage(PaintShop.iconAddBlogroll);
    cascadeItemImportBlogroll.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportBlogroll();
      }
    });

    /** Export favorite into OPML file */
    MenuItem export = new MenuItem(popUpMenu, SWT.CASCADE);
    export.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
    if (!GlobalSettings.isMac())
      export.setImage(PaintShop.iconExport);

    Menu selectexport = new Menu(shell, SWT.DROP_DOWN);
    export.setMenu(selectexport);

    MenuItem cascadeItemCreateOPML = new MenuItem(selectexport, SWT.PUSH);
    cascadeItemCreateOPML.setText(GUI.i18n.getTranslation("POP_EXPORT_OPML") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemCreateOPML.setImage(PaintShop.iconExportOpml);
    cascadeItemCreateOPML.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionFavoriteToOPML();
      }
    });
  }
}