/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.popup;

import net.sourceforge.rssowl.controller.EventManager;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * The empty tree popup shows, when the tree holding the favorites is empty.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class EmptyTreePopup {
  private Menu popUpMenu;
  private Shell shell;
  EventManager eventManager;

  /**
   * Instantiate a new EmptyTreePopup
   * 
   * @param shell The shell
   * @param popUpMenu The menu to add this menu to
   * @param eventManager The event manager
   */
  public EmptyTreePopup(Shell shell, Menu popUpMenu, EventManager eventManager) {
    this.shell = shell;
    this.popUpMenu = popUpMenu;
    this.eventManager = eventManager;

    /** Init the Popup */
    initEmptyTreeMenu();
  }

  /** Menu when the tree is empty */
  private void initEmptyTreeMenu() {

    /** Aggregate */
    MenuItem open = new MenuItem(popUpMenu, SWT.PUSH);
    open.setText(GUI.i18n.getTranslation("POP_AGGREGATE_FAV"));
    open.setEnabled(false);

    /** Open selected categorie's direct Favorites */
    if (!GlobalSettings.displaySingleTab) {
      MenuItem openCategory = new MenuItem(popUpMenu, SWT.PUSH);
      openCategory.setText(GUI.i18n.getTranslation("BUTTON_OPEN"));
      openCategory.setEnabled(false);
    }

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Mark selected category read */
    MenuItem markRead = new MenuItem(popUpMenu, SWT.PUSH);
    markRead.setText(GUI.i18n.getTranslation("POP_MARK_CATEGORY_READ"));
    markRead.setEnabled(false);

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    MenuItem reload = new MenuItem(popUpMenu, SWT.PUSH);
    reload.setText(GUI.i18n.getTranslation("BUTTON_RELOAD_CAT"));
    if (!GlobalSettings.isMac())
      reload.setImage(PaintShop.iconReload);
    reload.setEnabled(false);

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    MenuItem search = new MenuItem(popUpMenu, SWT.PUSH);
    search.setText(GUI.i18n.getTranslation("SEARCH_DIALOG_TITLE") + "...");
    if (!GlobalSettings.isMac())
      search.setImage(PaintShop.iconFind);
    search.setEnabled(false);

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** New Menu */
    MenuItem newCatOrFav = new MenuItem(popUpMenu, SWT.CASCADE);
    newCatOrFav.setText(GUI.i18n.getTranslation("POP_NEW"));
    if (!GlobalSettings.isMac())
      newCatOrFav.setImage(PaintShop.iconNew);

    Menu selectNewCatOrFav = new Menu(shell, SWT.DROP_DOWN);
    newCatOrFav.setMenu(selectNewCatOrFav);

    /** Create a new favorite */
    MenuItem cascadeItemNewFav = new MenuItem(selectNewCatOrFav, SWT.PUSH);
    cascadeItemNewFav.setText(GUI.i18n.getTranslation("LABEL_FAVORITE") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemNewFav.setImage(PaintShop.iconAddToFavorites);
    cascadeItemNewFav.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionNewFavorite();
      }
    });

    /** Separator */
    new MenuItem(selectNewCatOrFav, SWT.SEPARATOR);

    /** Create a new category */
    MenuItem cascadeItemNewCat = new MenuItem(selectNewCatOrFav, SWT.PUSH);
    cascadeItemNewCat.setText(GUI.i18n.getTranslation("LABEL_CATEGORY") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemNewCat.setImage(PaintShop.iconAddCategory);
    cascadeItemNewCat.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionNewCategory(false);
      }
    });

    /** Rename */
    MenuItem rename = new MenuItem(popUpMenu, SWT.PUSH);
    rename.setText(GUI.i18n.getTranslation("MENU_EDIT_RENAME"));
    rename.setEnabled(false);

    /** Delete */
    MenuItem delete = new MenuItem(popUpMenu, SWT.PUSH);
    delete.setText(GUI.i18n.getTranslation("MENU_EDIT_DELETE"));
    if (!GlobalSettings.isMac())
      delete.setImage(PaintShop.iconDelete);
    delete.setEnabled(false);

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Import OPML files */
    MenuItem importMenu = new MenuItem(popUpMenu, SWT.CASCADE);
    importMenu.setText(GUI.i18n.getTranslation("POP_IMPORT"));
    if (!GlobalSettings.isMac())
      importMenu.setImage(PaintShop.iconImport);

    Menu selectImport = new Menu(shell, SWT.DROP_DOWN);
    importMenu.setMenu(selectImport);

    /** Import OPML into Root category */
    MenuItem cascadeItemImportOPML = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportOPML.setText(GUI.i18n.getTranslation("POP_FROM_OPML") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportOPML.setImage(PaintShop.iconImportOpml);
    cascadeItemImportOPML.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportOPML();
      }
    });

    /** Import Synchronized Blogroll */
    MenuItem cascadeItemImportBlogroll = new MenuItem(selectImport, SWT.PUSH);
    cascadeItemImportBlogroll.setText(GUI.i18n.getTranslation("POP_IMPORT_BLOGROLL") + "...");
    if (!GlobalSettings.isMac())
      cascadeItemImportBlogroll.setImage(PaintShop.iconAddBlogroll);
    cascadeItemImportBlogroll.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        eventManager.actionImportBlogroll();
      }
    });

    /** Export */
    MenuItem export = new MenuItem(popUpMenu, SWT.CASCADE);
    export.setText(GUI.i18n.getTranslation("BUTTON_EXPORT"));
    if (!GlobalSettings.isMac())
      export.setImage(PaintShop.iconExport);
    export.setEnabled(false);

    /** In case Proxy is activated */
    if (ProxyShop.isUseProxy()) {

      /** Separator */
      new MenuItem(popUpMenu, SWT.SEPARATOR);

      /** Enable / Disable use of proxy for the favorites in this category */
      MenuItem proxy = new MenuItem(popUpMenu, SWT.PUSH);
      proxy.setText(GUI.i18n.getTranslation("MENU_PROXY"));
      proxy.setEnabled(false);
    }

    /** Separator */
    new MenuItem(popUpMenu, SWT.SEPARATOR);

    /** Properties */
    MenuItem properties = new MenuItem(popUpMenu, SWT.PUSH);
    properties.setText(GUI.i18n.getTranslation("POP_PROPERTIES"));
    properties.setEnabled(false);
  }
}