/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.DisposeListenerImpl;
import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

/**
 * Class displays a PropertyPage to configure Colors in RSSOwl
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class ColorProperties extends PropertyPage {
  Button linkColorChooser;
  Button syntaxHighlightcolorChooser;

  /**
   * Instatiate a new ColorProperties PropertyPage
   * 
   * @param parent Composite's parent
   * @param rssOwlGui The MainController
   */
  public ColorProperties(Composite parent, GUI rssOwlGui) {
    super(parent, rssOwlGui);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#applyButtonPressed()
   */
  public void applyButtonPressed() {

    /** Update link color if changed */
    if (!propertyChangeManager.getLinkColor().equals(GlobalSettings.linkColor)) {
      GlobalSettings.linkColor = propertyChangeManager.getLinkColor();
      PaintShop.initLinkColor(GUI.display);
      rssOwlGui.getRSSOwlNewsText().updateLinkColor();
    }

    /** Update syntaxhighlight color if changed */
    if (!propertyChangeManager.getSyntaxHighlightColor().equals(GlobalSettings.syntaxHighlightColor)) {
      GlobalSettings.syntaxHighlightColor = propertyChangeManager.getSyntaxHighlightColor();
      PaintShop.initSyntaxHighlightColor(GUI.display);
    }
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#updatePropertiesChangeManager()
   */
  public void updatePropertiesChangeManager() {
  /** Nothing to do */
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Color chooser for the Link Color */
    Group linkColorChooserGroup = new Group(composite, SWT.NONE);
    linkColorChooserGroup.setText(GUI.i18n.getTranslation("GROUP_LINK_COLOR"));
    linkColorChooserGroup.setLayout(new GridLayout(2, false));
    linkColorChooserGroup.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    linkColorChooserGroup.setFont(FontShop.dialogFont);

    /** Label */
    Label curLinkColor = new Label(linkColorChooserGroup, SWT.NONE);
    curLinkColor.setText(GUI.i18n.getTranslation("LABEL_CURRENT_COLOR") + ": ");
    curLinkColor.setFont(dialogFont);

    /** Color Chooser */
    linkColorChooser = new Button(linkColorChooserGroup, SWT.NONE);
    linkColorChooser.setFont(dialogFont);
    linkColorChooser.addDisposeListener(DisposeListenerImpl.getInstance());
    linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getLinkColor(), 30, 15));
    linkColorChooser.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        ColorDialog colorDialog = new ColorDialog(composite.getShell());
        colorDialog.setRGB(propertyChangeManager.getLinkColor());
        RGB selectedColor = colorDialog.open();

        if (selectedColor != null) {
          propertyChangeManager.setLinkColor(selectedColor);
          linkColorChooser.getImage().dispose();
          linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, selectedColor, 30, 15));
        }
      }
    });

    /** Color chooser for the Syntaxhighlight Color */
    Group syntaxHighlightColorChooserGroup = new Group(composite, SWT.NONE);
    syntaxHighlightColorChooserGroup.setText(GUI.i18n.getTranslation("GROUP_SYNTAXHIGHLIGHT_COLOR"));
    syntaxHighlightColorChooserGroup.setLayout(new GridLayout(2, false));
    syntaxHighlightColorChooserGroup.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    syntaxHighlightColorChooserGroup.setFont(FontShop.dialogFont);

    /** Label */
    Label curSyntaxHighlightColor = new Label(syntaxHighlightColorChooserGroup, SWT.NONE);
    curSyntaxHighlightColor.setText(GUI.i18n.getTranslation("LABEL_CURRENT_COLOR") + ": ");
    curSyntaxHighlightColor.setFont(dialogFont);

    /** Color Chooser */
    syntaxHighlightcolorChooser = new Button(syntaxHighlightColorChooserGroup, SWT.NONE);
    syntaxHighlightcolorChooser.setFont(dialogFont);
    syntaxHighlightcolorChooser.addDisposeListener(DisposeListenerImpl.getInstance());
    syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getSyntaxHighlightColor(), 30, 15));
    syntaxHighlightcolorChooser.addSelectionListener(new SelectionAdapter() {
      public void widgetSelected(SelectionEvent e) {
        ColorDialog colorDialog = new ColorDialog(composite.getShell());
        colorDialog.setRGB(propertyChangeManager.getSyntaxHighlightColor());
        RGB selectedColor = colorDialog.open();

        if (selectedColor != null) {
          propertyChangeManager.setSyntaxHighlightColor(selectedColor);
          syntaxHighlightcolorChooser.getImage().dispose();
          syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, selectedColor, 30, 15));
        }
      }
    });

    /** Set Mnemonics to Buttons */
    WidgetShop.initMnemonics(new Button[] { linkColorChooser, syntaxHighlightcolorChooser });

    /** Add Spacer */
    LayoutShop.setDialogSpacer(composite, 2, 6);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#restoreButtonPressed()
   */
  protected void restoreButtonPressed() {
    propertyChangeManager.setLinkColor(new RGB(0, 0, 255));
    propertyChangeManager.setSyntaxHighlightColor(new RGB(255, 255, 0));
    linkColorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getLinkColor(), 30, 15));
    syntaxHighlightcolorChooser.setImage(PaintShop.getFilledImage(GUI.display, propertyChangeManager.getSyntaxHighlightColor(), 30, 15));
  }
}