/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.controller.thread.FeedAutoUpdater;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

/**
 * Class displays a PropertyPage to set default values for new favorites
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class FavoritesProperties extends PropertyPage {
  private Combo autoReloadCombo;
  private Button openOnStartupCheck;
  private Button reloadOnStartupCheck;

  /**
   * Instatiate a new Favorites PropertyPage
   * 
   * @param parent Composite's parent
   */
  public FavoritesProperties(Composite parent) {
    super(parent);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#applyButtonPressed()
   */
  public void applyButtonPressed() {
    GlobalSettings.favDefaultOpenOnStartup = openOnStartupCheck.getSelection();
    GlobalSettings.favDefaultReloadOnStartup = reloadOnStartupCheck.getSelection();
    GlobalSettings.favDefaultAutoReloadInterval = FeedAutoUpdater.updateInterval[autoReloadCombo.getSelectionIndex()];

    updatePropertiesChangeManager();
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#updatePropertiesChangeManager()
   */
  public void updatePropertiesChangeManager() {
    propertyChangeManager.setFavDefaultOpenOnStartup(openOnStartupCheck.getSelection());
    propertyChangeManager.setFavDefaultReloadOnStartup(reloadOnStartupCheck.getSelection());
    propertyChangeManager.setFavDefaultAutoReloadInterval(FeedAutoUpdater.updateInterval[autoReloadCombo.getSelectionIndex()]);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Group for the mail body */
    Group explanationGroup = new Group(composite, SWT.NONE);
    explanationGroup.setText(GUI.i18n.getTranslation("LABEL_DESCRIPTION"));
    explanationGroup.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    explanationGroup.setLayout(new GridLayout(1, false));
    explanationGroup.setFont(FontShop.dialogFont);

    /** Explanation label */
    Label explanation = new Label(explanationGroup, SWT.WRAP);
    explanation.setText(GUI.i18n.getTranslation("LABEL_TEMPLATE_EXPLANATION"));
    explanation.setFont(dialogFont);
    explanation.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

    /** Group for the auto-reload components */
    Group autoReloadGroup = new Group(composite, SWT.NONE);
    autoReloadGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    autoReloadGroup.setText(GUI.i18n.getTranslation("POP_AUTO_UPDATE"));
    autoReloadGroup.setLayout(new GridLayout(2, false));
    autoReloadGroup.setFont(FontShop.dialogFont);

    /** Combo to select an auto-update interval */
    autoReloadCombo = new Combo(autoReloadGroup, SWT.READ_ONLY);
    autoReloadCombo.setVisibleItemCount(FeedAutoUpdater.updateInterval.length);
    autoReloadCombo.setFont(FontShop.dialogFont);

    /** For each supported auto update interval */
    int selectIndex = 0;
    for (int a = 0; a < FeedAutoUpdater.updateInterval.length; a++) {

      /** Add supported interval into Combo */
      autoReloadCombo.add(GUI.i18n.getTranslation(FeedAutoUpdater.updateIntervalNames[a]));

      /** Remember update-interval of current favorite */
      if (FeedAutoUpdater.updateInterval[a] == propertyChangeManager.getFavDefaultAutoReloadInterval())
        selectIndex = a;
    }

    /** Select the interval of the current favorite */
    autoReloadCombo.select(selectIndex);

    /** Update on startup checkbutton */
    reloadOnStartupCheck = new Button(autoReloadGroup, SWT.CHECK);
    reloadOnStartupCheck.setText(GUI.i18n.getTranslation("POP_UPDATE_ONSTARTUP"));
    reloadOnStartupCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    reloadOnStartupCheck.setFont(dialogFont);
    reloadOnStartupCheck.setSelection(propertyChangeManager.isFavDefaultReloadOnStartup());

    /** Group holding the misc. settings */
    Group settingsGroup = new Group(composite, SWT.NONE);
    settingsGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    settingsGroup.setText(GUI.i18n.getTranslation("MENU_MISC"));
    settingsGroup.setLayout(new GridLayout(2, false));
    settingsGroup.setFont(FontShop.dialogFont);

    /** Open on startup checkbutton */
    openOnStartupCheck = new Button(settingsGroup, SWT.CHECK);
    openOnStartupCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    openOnStartupCheck.setSelection(propertyChangeManager.isFavDefaultOpenOnStartup());
    openOnStartupCheck.setText(GUI.i18n.getTranslation("POP_OPEN_STARTUP"));
    openOnStartupCheck.setFont(dialogFont);

    /** Fill with some spacer */
    LayoutShop.setDialogSpacer(composite, 2, 3);

    /** Set Mnemonics to Buttons */
    WidgetShop.initMnemonics(new Button[] { reloadOnStartupCheck, openOnStartupCheck });
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#restoreButtonPressed()
   */
  protected void restoreButtonPressed() {
    openOnStartupCheck.setSelection(false);
    reloadOnStartupCheck.setSelection(false);
    autoReloadCombo.select(5);
  }
}