/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Class displays a PropertyPage to format the news recommendation mail
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class MailProperties extends PropertyPage {
  private Button htmlFormatMailCheck;
  Text bodyText;
  Text subjectText;

  /**
   * Instatiate a new MailProperties PropertyPage
   * 
   * @param parent Composite's parent
   */
  public MailProperties(Composite parent) {
    super(parent);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#applyButtonPressed()
   */
  public void applyButtonPressed() {
    GlobalSettings.mailBody = bodyText.getText();
    GlobalSettings.mailSubject = subjectText.getText();
    GlobalSettings.htmlFormatMail = htmlFormatMailCheck.getSelection();

    updatePropertiesChangeManager();
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#updatePropertiesChangeManager()
   */
  public void updatePropertiesChangeManager() {
    propertyChangeManager.setMailBody(bodyText.getText());
    propertyChangeManager.setMailSubject(subjectText.getText());
    propertyChangeManager.setHtmlFormatMail(htmlFormatMailCheck.getSelection());
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Group for the mail subject */
    Group mailFormatSubjectGroup = new Group(composite, SWT.NONE);
    mailFormatSubjectGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    mailFormatSubjectGroup.setText(GUI.i18n.getTranslation("LABEL_MAIL_SUBJECT"));
    mailFormatSubjectGroup.setLayout(new GridLayout(2, false));
    mailFormatSubjectGroup.setFont(FontShop.dialogFont);

    /** Mail Subject */
    subjectText = new Text(mailFormatSubjectGroup, SWT.BORDER | SWT.SINGLE);
    subjectText.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    subjectText.setFont(dialogFont);
    subjectText.setText(propertyChangeManager.getMailSubject());

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(subjectText);

    /** Menu to insert the wildcards */
    WidgetShop.createWildCardMenu(subjectText, new String[] { "[TITLE]", "[LINK]", "[DESCRIPTION]", "[AUTHOR]", "[CATEGORY]", "[PUBDATE]", "[PUBLISHER]", "[SOURCE]" });

    /** Group for the mail body */
    Group mailFormatBodyGroup = new Group(composite, SWT.NONE);
    mailFormatBodyGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    mailFormatBodyGroup.setText(GUI.i18n.getTranslation("LABEL_MAIL_BODY"));
    mailFormatBodyGroup.setLayout(new GridLayout(2, false));
    mailFormatBodyGroup.setFont(FontShop.dialogFont);

    /** Mail Body */
    bodyText = new Text(mailFormatBodyGroup, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.WRAP);
    bodyText.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2, SWT.DEFAULT, 100));
    bodyText.setFont(dialogFont);
    bodyText.setText(propertyChangeManager.getMailBody());

    /** Tweak Text Widget */
    WidgetShop.tweakTextWidget(bodyText);

    /** Menu to insert the wildcards */
    WidgetShop.createWildCardMenu(bodyText, new String[] { "[TITLE]", "[LINK]", "[DESCRIPTION]", "[AUTHOR]", "[CATEGORY]", "[PUBDATE]", "[PUBLISHER]", "[SOURCE]" });

    /** Describe usage */
    Label usage = new Label(mailFormatBodyGroup, SWT.WRAP);
    usage.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    usage.setFont(dialogFont);
    usage.setText(GUI.i18n.getTranslation("LABEL_MAIL_USAGE"));

    /** Group holding the misc. settings */
    Group settingsGroup = new Group(composite, SWT.NONE);
    settingsGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    settingsGroup.setText(GUI.i18n.getTranslation("MENU_MISC"));
    settingsGroup.setLayout(new GridLayout(2, false));
    settingsGroup.setFont(FontShop.dialogFont);

    /** HTML Format mail */
    htmlFormatMailCheck = new Button(settingsGroup, SWT.CHECK);
    htmlFormatMailCheck.setFont(dialogFont);
    htmlFormatMailCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    htmlFormatMailCheck.setText(GUI.i18n.getTranslation("LABEL_HTML_FORMAT_MAIL"));
    htmlFormatMailCheck.setSelection(propertyChangeManager.isHtmlFormatMail());

    /** Set Mnemonics to Buttons */
    WidgetShop.initMnemonics(new Button[] { htmlFormatMailCheck });
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#restoreButtonPressed()
   */
  protected void restoreButtonPressed() {
    subjectText.setText("[TITLE]");
    bodyText.setText("[TITLE]\n[LINK]\n\n[DESCRIPTION]");
    htmlFormatMailCheck.setSelection(true);
  }
}