/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.i18n.Dictionary;
import net.sourceforge.rssowl.util.i18n.RSSOwlI18n;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.HotkeyShop;
import net.sourceforge.rssowl.util.shop.PaintShop;
import net.sourceforge.rssowl.util.shop.ProxyShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

/**
 * The PropertyChangeManager watches all settings the user has made in the
 * PreferencesDialog and saves the settings after exit with click on "OK"
 * Button. If the user leaves without pressing "OK", the settings are no longer
 * used and removed.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class PropertyChangeManager {
  private String amphetaRateId;
  private String amphetaRatePassword;
  private String amphetaRateUsername;
  private boolean animateNewsPopup;
  private boolean autoCloseNewsPopup;
  private boolean autoOpenEachNews;
  private boolean autoOpenEmptyNews;
  private boolean autoSortNews;
  private boolean blockPopups;
  private String bloggerArguments;
  private String bloggerPath;
  private boolean checkForUpdate;
  private boolean confirmBlogrollDeletion;
  private boolean confirmCategoryDeletion;
  private boolean confirmFavoriteDeletion;
  private int connectionTimeout;
  private String customBrowserArguments;
  private String customBrowserPath;
  private Font dialogFont;
  private boolean displaySingleTab;
  private int favDefaultAutoReloadInterval;
  private boolean favDefaultOpenOnStartup;
  private boolean favDefaultReloadOnStartup;
  private boolean focusNewTabs;
  private Font headerFont;
  private Hashtable hotkeys;
  private boolean htmlFormatMail;
  private boolean isDoubleClickOpen;
  private boolean isThreeColumnGUI;
  private RGB linkColor;
  private boolean localCacheFeeds;
  private String mailBody;
  private String mailSubject;
  private boolean markAllReadOnMinimize;
  private boolean markFeedReadOnTabClose;
  private int maxConnectionCount;
  private boolean openBrowserExtern;
  private boolean openBrowserInNewTab;
  private Hashtable proxySettingsSave;
  private boolean reopenFeeds;
  private GUI rssOwlGui;
  private String selectedEncoding;
  private String selectedLanguage;
  private boolean showChannelInfo;
  private boolean showErrors;
  private boolean showSystrayIcon;
  private boolean showTabCloseButton;
  private boolean showTrayPopup;
  private boolean simpleTabs;
  private ArrayList sortOrder;
  private RGB syntaxHighlightColor;
  private Font tableFont;
  private Font textFont;
  private boolean trayOnExit;
  private boolean trayOnStartup;
  private Font treeFont;
  private boolean updateProxyForAllFavorites;
  private boolean useAuthentification;
  private boolean useBrowserForNewsText;

  /**
   * Instantiates a new PropertyChangeManager
   * 
   * @param rssOwlGui The Maincontroller
   */
  public PropertyChangeManager(GUI rssOwlGui) {
    this.rssOwlGui = rssOwlGui;
  }

  /**
   * @return Returns the amphetaRateId.
   */
  public String getAmphetaRateId() {
    return amphetaRateId;
  }

  /**
   * @return Returns the amphetaRatePassword.
   */
  public String getAmphetaRatePassword() {
    return amphetaRatePassword;
  }

  /**
   * @return Returns the amphetaRateUsername.
   */
  public String getAmphetaRateUsername() {
    return amphetaRateUsername;
  }

  /**
   * @return Returns the bloggerArguments.
   */
  public String getBloggerArguments() {
    return bloggerArguments;
  }

  /**
   * @return Returns the bloggerPath.
   */
  public String getBloggerPath() {
    return bloggerPath;
  }

  /**
   * @return int The connectionTimeout
   */
  public int getConnectionTimeout() {
    return connectionTimeout;
  }

  /**
   * @return Returns the customBrowserArguments.
   */
  public String getCustomBrowserArguments() {
    return customBrowserArguments;
  }

  /**
   * @return Returns the customBrowserPath.
   */
  public String getCustomBrowserPath() {
    return customBrowserPath;
  }

  /**
   * @return Returns the dialogFont.
   */
  public Font getDialogFont() {
    return dialogFont;
  }

  /**
   * @return Returns the favDefaultAutoReloadInterval.
   */
  public int getFavDefaultAutoReloadInterval() {
    return favDefaultAutoReloadInterval;
  }

  /**
   * @return Returns the headerFont.
   */
  public Font getHeaderFont() {
    return headerFont;
  }

  /**
   * @return Returns the hotkeys.
   */
  public Hashtable getHotkeys() {
    return hotkeys;
  }

  /**
   * @return Returns the linkColor.
   */
  public RGB getLinkColor() {
    return linkColor;
  }

  /**
   * @return Returns the mailBody.
   */
  public String getMailBody() {
    return mailBody;
  }

  /**
   * @return Returns the mailSubject.
   */
  public String getMailSubject() {
    return mailSubject;
  }

  /**
   * @return the maxConnectionCount
   */
  public int getMaxConnectionCount() {
    return maxConnectionCount;
  }

  /**
   * @return Returns the proxySettings.
   */
  public Hashtable getProxySettingsSave() {
    return proxySettingsSave;
  }

  /**
   * @return Returns the selectedEncoding.
   */
  public String getSelectedEncoding() {
    return selectedEncoding;
  }

  /**
   * @return Returns the selectedLanguage.
   */
  public String getSelectedLanguage() {
    return selectedLanguage;
  }

  /**
   * @return Returns the sortOrder.
   */
  public ArrayList getSortOrder() {
    return sortOrder;
  }

  /**
   * @return Returns the syntaxHighlightColor.
   */
  public RGB getSyntaxHighlightColor() {
    return syntaxHighlightColor;
  }

  /**
   * @return Returns the tableFont.
   */
  public Font getTableFont() {
    return tableFont;
  }

  /**
   * @return Returns the textFont.
   */
  public Font getTextFont() {
    return textFont;
  }

  /**
   * @return Returns the treeFont.
   */
  public Font getTreeFont() {
    return treeFont;
  }

  /**
   * @return Returns the animateNewsPopup.
   */
  public boolean isAnimateNewsPopup() {
    return animateNewsPopup;
  }

  /**
   * @return Returns the autoCloseNewsPopup
   */
  public boolean isAutoCloseNewsPopup() {
    return autoCloseNewsPopup;
  }

  /**
   * @return Returns the autoOpenEachNews.
   */
  public boolean isAutoOpenEachNews() {
    return autoOpenEachNews;
  }

  /**
   * @return Returns the autoOpenEmpyNews.
   */
  public boolean isAutoOpenEmptyNews() {
    return autoOpenEmptyNews;
  }

  /**
   * @return Returns the autoSortNews.
   */
  public boolean isAutoSortNews() {
    return autoSortNews;
  }

  /**
   * @return Returns the blockPopups.
   */
  public boolean isBlockPopups() {
    return blockPopups;
  }

  /**
   * @return Returns the checkForUpdate.
   */
  public boolean isCheckForUpdate() {
    return checkForUpdate;
  }

  /**
   * @return Returns the confirmBlogrollDeletion.
   */
  public boolean isConfirmBlogrollDeletion() {
    return confirmBlogrollDeletion;
  }

  /**
   * @return Returns the confirmCategoryDeletion.
   */
  public boolean isConfirmCategoryDeletion() {
    return confirmCategoryDeletion;
  }

  /**
   * @return Returns the confirmFavoriteDeletion.
   */
  public boolean isConfirmFavoriteDeletion() {
    return confirmFavoriteDeletion;
  }

  /**
   * @return Returns the displaySingleTab.
   */
  public boolean isDisplaySingleTab() {
    return displaySingleTab;
  }

  /**
   * @return Returns the isDoubleClickOpen.
   */
  public boolean isDoubleClickOpen() {
    return isDoubleClickOpen;
  }

  /**
   * @return Returns the favDefaultOpenOnStartup.
   */
  public boolean isFavDefaultOpenOnStartup() {
    return favDefaultOpenOnStartup;
  }

  /**
   * @return Returns the favDefaultReloadOnStartup.
   */
  public boolean isFavDefaultReloadOnStartup() {
    return favDefaultReloadOnStartup;
  }

  /**
   * @return Returns the focusNewTabs.
   */
  public boolean isFocusNewTabs() {
    return focusNewTabs;
  }

  /**
   * @return Returns the htmlFormatMail.
   */
  public boolean isHtmlFormatMail() {
    return htmlFormatMail;
  }

  /**
   * @return Returns the localCacheFeeds.
   */
  public boolean isLocalCacheFeeds() {
    return localCacheFeeds;
  }

  /**
   * @return Returns the markAllReadOnMinimize.
   */
  public boolean isMarkAllReadOnMinimize() {
    return markAllReadOnMinimize;
  }

  /**
   * @return Returns the markFeedReadOnTabClose.
   */
  public boolean isMarkFeedReadOnTabClose() {
    return markFeedReadOnTabClose;
  }

  /**
   * @return Returns the openBrowserExtern.
   */
  public boolean isOpenBrowserExtern() {
    return openBrowserExtern;
  }

  /**
   * @return Returns the openBrowserInNewTab.
   */
  public boolean isOpenBrowserInNewTab() {
    return openBrowserInNewTab;
  }

  /**
   * @return Returns the reopenFeeds.
   */
  public boolean isReopenFeeds() {
    return reopenFeeds;
  }

  /**
   * @return Returns the showChannelInfo.
   */
  public boolean isShowChannelInfo() {
    return showChannelInfo;
  }

  /**
   * @return Returns the showErrors.
   */
  public boolean isShowErrors() {
    return showErrors;
  }

  /**
   * @return Returns the showSystrayIcon.
   */
  public boolean isShowSystrayIcon() {
    return showSystrayIcon;
  }

  /**
   * @return boolean The showTabCloseButton
   */
  public boolean isShowTabCloseButton() {
    return showTabCloseButton;
  }

  /**
   * @return Returns the showTrayPopup.
   */
  public boolean isShowTrayPopup() {
    return showTrayPopup;
  }

  /**
   * @return Returns the simpleTabs.
   */
  public boolean isSimpleTabs() {
    return simpleTabs;
  }

  /**
   * @return Returns the isThreeColumnGUI.
   */
  public boolean isThreeColumnGUI() {
    return isThreeColumnGUI;
  }

  /**
   * @return Returns the trayOnExit.
   */
  public boolean isTrayOnExit() {
    return trayOnExit;
  }

  /**
   * @return Returns the trayOnStartup.
   */
  public boolean isTrayOnStartup() {
    return trayOnStartup;
  }

  /**
   * @return Returns the updateAllFavorites.
   */
  public boolean isUpdateProxyForAllFavorites() {
    return updateProxyForAllFavorites;
  }

  /**
   * @return Returns the useBrowserForNewsText.
   */
  public boolean isUseBrowserForNewsText() {
    return useBrowserForNewsText;
  }

  /** Save properties the user has made */
  public void saveProperties() {

    /** Confirmations */
    GlobalSettings.confirmFavoriteDeletion = confirmFavoriteDeletion;
    GlobalSettings.confirmCategoryDeletion = confirmCategoryDeletion;
    GlobalSettings.confirmBlogrollDeletion = confirmBlogrollDeletion;

    /** Browser */
    GlobalSettings.customBrowser = customBrowserPath;
    GlobalSettings.customBrowserArguments = customBrowserArguments;

    /** Internal Browser */
    if (GlobalSettings.useInternalBrowser()) {
      GlobalSettings.openNewBrowserWindow = openBrowserInNewTab;
      GlobalSettings.openBrowserExtern = openBrowserExtern;
      GlobalSettings.blockPopups = blockPopups;
    }

    /** Language */
    if (!selectedLanguage.equals(Dictionary.selectedLanguage)) {
      GUI.i18n = new RSSOwlI18n(new Locale(selectedLanguage));
      rssOwlGui.updateI18N();
    }

    /** Sort Order */
    GlobalSettings.sortOrder = sortOrder;
    GlobalSettings.autoSortNews = autoSortNews;

    /** Browser view for Newstext */
    if (GlobalSettings.useInternalBrowser() && GlobalSettings.useBrowserForNewsText != useBrowserForNewsText) {
      GlobalSettings.useBrowserForNewsText = useBrowserForNewsText;
      rssOwlGui.getEventManager().actionSetBrowserView(GlobalSettings.useBrowserForNewsText);
    }

    /** Show channel info */
    GlobalSettings.showChannelInfo = showChannelInfo;

    /** Three / Two column GUI */
    if (GlobalSettings.isThreeColumnGUI != isThreeColumnGUI) {
      GlobalSettings.isThreeColumnGUI = isThreeColumnGUI;
      rssOwlGui.changeWindowLayout();
    }

    /** Systray Icon */
    if (GlobalSettings.useSystemTray() && GlobalSettings.showSystrayIcon != showSystrayIcon) {
      GlobalSettings.showSystrayIcon = showSystrayIcon;

      /** Update in GUI */
      rssOwlGui.enableSystrayIcon(GlobalSettings.showSystrayIcon);
    }

    /** Text font */
    FontShop.textFont = textFont;
    FontShop.dialogFont = dialogFont;
    FontShop.treeFont = treeFont;
    FontShop.tableFont = tableFont;
    FontShop.headerFont = headerFont;

    /** Init styled fonts and Apply */
    if (FontProperties.possibleFontChange) {
      FontShop.updateFonts();
      FontShop.setFontForAll(rssOwlGui);
    }

    /** Encoding */
    GlobalSettings.charEncoding = selectedEncoding;

    /** Hotkeys */
    HotkeyShop.hotKeys = hotkeys;
    rssOwlGui.getRSSOwlMenu().updateAccelerators();
    rssOwlGui.getRSSOwlMenu().initMnemonics();
    rssOwlGui.getRSSOwlQuickview().updateI18N();
    rssOwlGui.getRSSOwlNewsText().updateI18N();

    /** Proxy */
    GlobalSettings.setProxyForAllFavorites = updateProxyForAllFavorites;
    ProxyShop.setUseProxy((String) proxySettingsSave.get("proxySet"));
    ProxyShop.setHost((String) proxySettingsSave.get("proxyHost"));
    ProxyShop.setPort((String) proxySettingsSave.get("proxyPort"));

    if (useAuthentification) {
      ProxyShop.setUsername((String) proxySettingsSave.get("username"));
      ProxyShop.setPassword((String) proxySettingsSave.get("password"));
      ProxyShop.setDomain((String) proxySettingsSave.get("domain"));
    } else {
      ProxyShop.setUsername("");
      ProxyShop.setPassword("");
      ProxyShop.setDomain("");
    }

    /** Connection */
    GlobalSettings.maxConnectionCount = maxConnectionCount;
    GlobalSettings.connectionTimeout = connectionTimeout;

    /** Mail */
    GlobalSettings.mailBody = mailBody;
    GlobalSettings.mailSubject = mailSubject;
    GlobalSettings.htmlFormatMail = htmlFormatMail;

    /** Blogger */
    GlobalSettings.bloggerArguments = bloggerArguments;
    GlobalSettings.bloggerPath = bloggerPath;

    /** Link Color */
    if (!linkColor.equals(GlobalSettings.linkColor)) {
      GlobalSettings.linkColor = linkColor;
      PaintShop.initLinkColor(GUI.display);
      rssOwlGui.getRSSOwlNewsText().updateLinkColor();
    }

    /** Syntaxhighlight Color */
    if (!syntaxHighlightColor.equals(GlobalSettings.syntaxHighlightColor)) {
      GlobalSettings.syntaxHighlightColor = syntaxHighlightColor;
      PaintShop.initSyntaxHighlightColor(GUI.display);
    }

    /** Tab Style */
    if (GlobalSettings.simpleTabs != simpleTabs) {
      rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setSimple(simpleTabs);
      GlobalSettings.simpleTabs = simpleTabs;
    }

    GlobalSettings.showTabCloseButton = showTabCloseButton;

    if (GlobalSettings.displaySingleTab != displaySingleTab) {
      GlobalSettings.displaySingleTab = displaySingleTab;
      rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setSelectionBackground((GlobalSettings.displaySingleTab) ? PaintShop.grayViewFormColor : GUI.display.getSystemColor(SWT.COLOR_WHITE));
      rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabHeight(GlobalSettings.displaySingleTab ? 0 : -1);

      /** Single Tab View looks better if single tab is bottom aligned */
      if (GlobalSettings.displaySingleTab)
        rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabPosition(SWT.BOTTOM);
      else
        rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().setTabPosition(GlobalSettings.tabPositionIsTop ? SWT.TOP : SWT.BOTTOM);

      /** Layout CTabFolder */
      rssOwlGui.getRSSOwlNewsTabFolder().getNewsHeaderTabFolder().layout();
    }

    /** Favorite Defaults */
    GlobalSettings.favDefaultAutoReloadInterval = favDefaultAutoReloadInterval;
    GlobalSettings.favDefaultOpenOnStartup = favDefaultOpenOnStartup;
    GlobalSettings.favDefaultReloadOnStartup = favDefaultReloadOnStartup;

    /** Misc settings */
    GlobalSettings.directOpenNews = autoOpenEmptyNews;
    GlobalSettings.directOpenEachNews = autoOpenEachNews;
    GlobalSettings.checkUpdate = checkForUpdate;
    GlobalSettings.isDoubleClickOpen = isDoubleClickOpen;
    GlobalSettings.reopenFeeds = reopenFeeds;
    GlobalSettings.focusNewTabs = focusNewTabs;
    GlobalSettings.trayOnStartup = trayOnStartup;
    GlobalSettings.trayOnExit = trayOnExit;
    GlobalSettings.showErrors = showErrors;
    GlobalSettings.showTrayPopup = showTrayPopup;
    GlobalSettings.autoCloseNewsPopup = autoCloseNewsPopup;
    GlobalSettings.animateNewsPopup = animateNewsPopup;
    GlobalSettings.markAllReadOnMinimize = markAllReadOnMinimize;
    GlobalSettings.markFeedReadOnTabClose = markFeedReadOnTabClose;
    GlobalSettings.localCacheFeeds = localCacheFeeds;

    /** Update last opened feeds vector in tab folder */
    if (GlobalSettings.reopenFeeds)
      rssOwlGui.getRSSOwlNewsTabFolder().updateLastOpenedFeeds();
  }

  /**
   * @param amphetaRateId The amphetaRateId to set.
   */
  public void setAmphetaRateId(String amphetaRateId) {
    this.amphetaRateId = amphetaRateId;
  }

  /**
   * @param amphetaRatePassword The amphetaRatePassword to set.
   */
  public void setAmphetaRatePassword(String amphetaRatePassword) {
    this.amphetaRatePassword = amphetaRatePassword;
  }

  /**
   * @param amphetaRateUsername The amphetaRateUsername to set.
   */
  public void setAmphetaRateUsername(String amphetaRateUsername) {
    this.amphetaRateUsername = amphetaRateUsername;
  }

  /**
   * @param animateNewsPopup The animateNewsPopup to set.
   */
  public void setAnimateNewsPopup(boolean animateNewsPopup) {
    this.animateNewsPopup = animateNewsPopup;
  }

  /**
   * @param autoCloseNewsPopup The autoCloseNewsPopup to set
   */
  public void setAutoCloseNewsPopup(boolean autoCloseNewsPopup) {
    this.autoCloseNewsPopup = autoCloseNewsPopup;
  }

  /**
   * @param autoOpenNews The autoOpenEachNews to set.
   */
  public void setAutoOpenEachNews(boolean autoOpenNews) {
    this.autoOpenEachNews = autoOpenNews;
  }

  /**
   * @param autoOpenEmpyNews The autoOpenEmpyNews to set.
   */
  public void setAutoOpenEmptyNews(boolean autoOpenEmpyNews) {
    this.autoOpenEmptyNews = autoOpenEmpyNews;
  }

  /**
   * @param autoSortNews The autoSortNews to set.
   */
  public void setAutoSortNews(boolean autoSortNews) {
    this.autoSortNews = autoSortNews;
  }

  /**
   * @param blockPopups The blockPopups to set.
   */
  public void setBlockPopups(boolean blockPopups) {
    this.blockPopups = blockPopups;
  }

  /**
   * @param bloggerArguments The bloggerArguments to set.
   */
  public void setBloggerArguments(String bloggerArguments) {
    this.bloggerArguments = bloggerArguments;
  }

  /**
   * @param bloggerPath The bloggerPath to set.
   */
  public void setBloggerPath(String bloggerPath) {
    this.bloggerPath = bloggerPath;
  }

  /**
   * @param checkForUpdate The checkForUpdate to set.
   */
  public void setCheckForUpdate(boolean checkForUpdate) {
    this.checkForUpdate = checkForUpdate;
  }

  /**
   * @param confirmBlogrollDeletion The confirmBlogrollDeletion to set.
   */
  public void setConfirmBlogrollDeletion(boolean confirmBlogrollDeletion) {
    this.confirmBlogrollDeletion = confirmBlogrollDeletion;
  }

  /**
   * @param confirmCategoryDeletion The confirmCategoryDeletion to set.
   */
  public void setConfirmCategoryDeletion(boolean confirmCategoryDeletion) {
    this.confirmCategoryDeletion = confirmCategoryDeletion;
  }

  /**
   * @param confirmFavoriteDeletion The confirmFavoriteDeletion to set.
   */
  public void setConfirmFavoriteDeletion(boolean confirmFavoriteDeletion) {
    this.confirmFavoriteDeletion = confirmFavoriteDeletion;
  }

  /**
   * @param connectionTimeout The connectionTimeout to set.
   */
  public void setConnectionTimeout(int connectionTimeout) {
    this.connectionTimeout = connectionTimeout;
  }

  /**
   * @param customBrowserArguments The customBrowserArguments to set.
   */
  public void setCustomBrowserArguments(String customBrowserArguments) {
    this.customBrowserArguments = customBrowserArguments;
  }

  /**
   * @param customBrowserPath The customBrowserPath to set.
   */
  public void setCustomBrowserPath(String customBrowserPath) {
    this.customBrowserPath = customBrowserPath;
  }

  /**
   * @param dialogFont The dialogFont to set.
   */
  public void setDialogFont(Font dialogFont) {
    this.dialogFont = dialogFont;
  }

  /**
   * @param displaySingleTab The displaySingleTab to set.
   */
  public void setDisplaySingleTab(boolean displaySingleTab) {
    this.displaySingleTab = displaySingleTab;
  }

  /**
   * @param isDoubleClickOpen The isDoubleClickOpen to set.
   */
  public void setDoubleClickOpen(boolean isDoubleClickOpen) {
    this.isDoubleClickOpen = isDoubleClickOpen;
  }

  /**
   * @param favDefaultAutoReloadInterval The favDefaultAutoReloadInterval to
   * set.
   */
  public void setFavDefaultAutoReloadInterval(int favDefaultAutoReloadInterval) {
    this.favDefaultAutoReloadInterval = favDefaultAutoReloadInterval;
  }

  /**
   * @param favDefaultOpenOnStartup The favDefaultOpenOnStartup to set.
   */
  public void setFavDefaultOpenOnStartup(boolean favDefaultOpenOnStartup) {
    this.favDefaultOpenOnStartup = favDefaultOpenOnStartup;
  }

  /**
   * @param favDefaultReloadOnStartup The favDefaultReloadOnStartup to set.
   */
  public void setFavDefaultReloadOnStartup(boolean favDefaultReloadOnStartup) {
    this.favDefaultReloadOnStartup = favDefaultReloadOnStartup;
  }

  /**
   * @param focusNewTabs The focusNewTabs to set.
   */
  public void setFocusNewTabs(boolean focusNewTabs) {
    this.focusNewTabs = focusNewTabs;
  }

  /**
   * @param headerFont The headerFont to set.
   */
  public void setHeaderFont(Font headerFont) {
    this.headerFont = headerFont;
  }

  /**
   * @param hotkeys The hotkeys to set.
   */
  public void setHotkeys(Hashtable hotkeys) {
    this.hotkeys = new Hashtable();
    Enumeration keys = hotkeys.keys();
    while (keys.hasMoreElements()) {
      String key = (String) keys.nextElement();
      this.hotkeys.put(key, hotkeys.get(key));
    }
  }

  /**
   * @param htmlFormatMail The htmlFormatMail to set.
   */
  public void setHtmlFormatMail(boolean htmlFormatMail) {
    this.htmlFormatMail = htmlFormatMail;
  }

  /**
   * @param linkColor The linkColor to set.
   */
  public void setLinkColor(RGB linkColor) {
    this.linkColor = linkColor;
  }

  /**
   * @param localCacheFeeds The localCacheFeeds to set.
   */
  public void setLocalCacheFeeds(boolean localCacheFeeds) {
    this.localCacheFeeds = localCacheFeeds;
  }

  /**
   * @param mailBody The mailBody to set.
   */
  public void setMailBody(String mailBody) {
    this.mailBody = mailBody;
  }

  /**
   * @param mailSubject The mailSubject to set.
   */
  public void setMailSubject(String mailSubject) {
    this.mailSubject = mailSubject;
  }

  /**
   * @param markAllReadOnMinimize The markAllReadOnMinimize to set.
   */
  public void setMarkAllReadOnMinimize(boolean markAllReadOnMinimize) {
    this.markAllReadOnMinimize = markAllReadOnMinimize;
  }

  /**
   * @param markFeedReadOnTabClose The markFeedReadOnTabClose to set.
   */
  public void setMarkFeedReadOnTabClose(boolean markFeedReadOnTabClose) {
    this.markFeedReadOnTabClose = markFeedReadOnTabClose;
  }

  /**
   * @param maxConnectionCount The maxConnectionCount to set.
   */
  public void setMaxConnectionCount(int maxConnectionCount) {
    this.maxConnectionCount = maxConnectionCount;
  }

  /**
   * @param openBrowserExtern The openBrowserExtern to set.
   */
  public void setOpenBrowserExtern(boolean openBrowserExtern) {
    this.openBrowserExtern = openBrowserExtern;
  }

  /**
   * @param openBrowserInNewTab The openBrowserInNewTab to set.
   */
  public void setOpenBrowserInNewTab(boolean openBrowserInNewTab) {
    this.openBrowserInNewTab = openBrowserInNewTab;
  }

  /**
   * Copy the proxySettings Hashtable
   * 
   * @param proxySettings The proxySettings to set.
   */
  public void setProxySettings(Hashtable proxySettings) {
    proxySettingsSave = new Hashtable();
    Enumeration keys = proxySettings.keys();
    while (keys.hasMoreElements()) {
      String key = (String) keys.nextElement();
      proxySettingsSave.put(key, proxySettings.get(key));
    }
  }

  /**
   * @param reopenFeeds The reopenFeeds to set.
   */
  public void setReopenFeeds(boolean reopenFeeds) {
    this.reopenFeeds = reopenFeeds;
  }

  /**
   * @param selectedEncoding The selectedEncoding to set.
   */
  public void setSelectedEncoding(String selectedEncoding) {
    this.selectedEncoding = selectedEncoding;
  }

  /**
   * @param selectedLanguage The selectedLanguage to set.
   */
  public void setSelectedLanguage(String selectedLanguage) {
    this.selectedLanguage = selectedLanguage;
  }

  /**
   * @param showChannelInfo The showChannelInfo to set.
   */
  public void setShowChannelInfo(boolean showChannelInfo) {
    this.showChannelInfo = showChannelInfo;
  }

  /**
   * @param showErrors The showErrors to set.
   */
  public void setShowErrors(boolean showErrors) {
    this.showErrors = showErrors;
  }

  /**
   * @param showSystrayIcon The showSystrayIcon to set.
   */
  public void setShowSystrayIcon(boolean showSystrayIcon) {
    this.showSystrayIcon = showSystrayIcon;
  }

  /**
   * @param showTabCloseButton The showTabCloseButton to set
   */
  public void setShowTabCloseButton(boolean showTabCloseButton) {
    this.showTabCloseButton = showTabCloseButton;
  }

  /**
   * @param showTrayPopup The showTrayPopup to set.
   */
  public void setShowTrayPopup(boolean showTrayPopup) {
    this.showTrayPopup = showTrayPopup;
  }

  /**
   * @param simpleTabs The simpleTabs to set.
   */
  public void setSimpleTabs(boolean simpleTabs) {
    this.simpleTabs = simpleTabs;
  }

  /**
   * @param sortOrder The sortOrder to set.
   */
  public void setSortOrder(ArrayList sortOrder) {
    this.sortOrder = sortOrder;
  }

  /**
   * @param syntaxHighlightColor The syntaxHighlightColor to set.
   */
  public void setSyntaxHighlightColor(RGB syntaxHighlightColor) {
    this.syntaxHighlightColor = syntaxHighlightColor;
  }

  /**
   * @param tableFont The tableFont to set.
   */
  public void setTableFont(Font tableFont) {
    this.tableFont = tableFont;
  }

  /**
   * @param textFont The textFont to set.
   */
  public void setTextFont(Font textFont) {
    this.textFont = textFont;
  }

  /**
   * @param isThreeColumnGUI The isThreeColumnGUI to set.
   */
  public void setThreeColumnGUI(boolean isThreeColumnGUI) {
    this.isThreeColumnGUI = isThreeColumnGUI;
  }

  /**
   * @param trayOnExit The trayOnExit to set.
   */
  public void setTrayOnExit(boolean trayOnExit) {
    this.trayOnExit = trayOnExit;
  }

  /**
   * @param trayOnStartup The trayOnStartup to set.
   */
  public void setTrayOnStartup(boolean trayOnStartup) {
    this.trayOnStartup = trayOnStartup;
  }

  /**
   * @param treeFont The treeFont to set.
   */
  public void setTreeFont(Font treeFont) {
    this.treeFont = treeFont;
  }

  /**
   * @param updateAllFavorites The updateAllFavorites to set.
   */
  public void setUpdateProxyForAllFavorites(boolean updateAllFavorites) {
    this.updateProxyForAllFavorites = updateAllFavorites;
  }

  /**
   * @param useAuthentification The useAuthentification to set.
   */
  public void setUseAuthentification(boolean useAuthentification) {
    this.useAuthentification = useAuthentification;
  }

  /**
   * @param useBrowserForNewsText The useBrowserForNewsText to set.
   */
  public void setUseBrowserForNewsText(boolean useBrowserForNewsText) {
    this.useBrowserForNewsText = useBrowserForNewsText;
  }
}