/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.properties;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;
import net.sourceforge.rssowl.util.shop.FontShop;
import net.sourceforge.rssowl.util.shop.LayoutDataShop;
import net.sourceforge.rssowl.util.shop.LayoutShop;
import net.sourceforge.rssowl.util.shop.WidgetShop;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Class displays a PropertyPage to configure general settings in RSSOwl
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class WorkbenchProperties extends PropertyPage {
  private Button checkForUpdateCheck;
  private Button confirmCatDeletionCheck;
  private Button confirmFavDeletionCheck;
  private Button confirmSubDeletionCheck;
  private Button directOpenCheck;
  private Button directOpenEachCheck;
  private Button doubleClickRadio;
  private Button localCacheFeedsCheck;
  private Button markAllReadOnMinimizeCheck;
  private Button markFeedReadOnTabCloseCheck;
  private Button reopenFeedsCheck;
  private Button singleClickRadio;

  /**
   * Instatiate a new WorkbenchProperties PropertyPage
   * 
   * @param parent Composite's parent
   * @param rssOwlGui The MainController
   */
  public WorkbenchProperties(Composite parent, GUI rssOwlGui) {
    super(parent, rssOwlGui);
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#applyButtonPressed()
   */
  public void applyButtonPressed() {
    GlobalSettings.isDoubleClickOpen = doubleClickRadio.getSelection();
    GlobalSettings.directOpenNews = directOpenCheck.getSelection();
    GlobalSettings.directOpenEachNews = directOpenEachCheck.getSelection();
    GlobalSettings.checkUpdate = checkForUpdateCheck.getSelection();
    GlobalSettings.reopenFeeds = reopenFeedsCheck.getSelection();
    GlobalSettings.markAllReadOnMinimize = markAllReadOnMinimizeCheck.getSelection();
    GlobalSettings.markFeedReadOnTabClose = markFeedReadOnTabCloseCheck.getSelection();
    GlobalSettings.localCacheFeeds = localCacheFeedsCheck.getSelection();
    GlobalSettings.confirmFavoriteDeletion = confirmFavDeletionCheck.getSelection();
    GlobalSettings.confirmCategoryDeletion = confirmCatDeletionCheck.getSelection();
    GlobalSettings.confirmBlogrollDeletion = confirmSubDeletionCheck.getSelection();

    /** Update last opened feeds vector in tab folder */
    if (GlobalSettings.reopenFeeds)
      rssOwlGui.getRSSOwlNewsTabFolder().updateLastOpenedFeeds();

    updatePropertiesChangeManager();
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#updatePropertiesChangeManager()
   */
  public void updatePropertiesChangeManager() {
    propertyChangeManager.setDoubleClickOpen(doubleClickRadio.getSelection());
    propertyChangeManager.setAutoOpenEachNews(directOpenEachCheck.getSelection());
    propertyChangeManager.setAutoOpenEmptyNews(directOpenCheck.getSelection());
    propertyChangeManager.setCheckForUpdate(checkForUpdateCheck.getSelection());
    propertyChangeManager.setReopenFeeds(reopenFeedsCheck.getSelection());
    propertyChangeManager.setMarkAllReadOnMinimize(markAllReadOnMinimizeCheck.getSelection());
    propertyChangeManager.setMarkFeedReadOnTabClose(markFeedReadOnTabCloseCheck.getSelection());
    propertyChangeManager.setLocalCacheFeeds(localCacheFeedsCheck.getSelection());
    propertyChangeManager.setConfirmFavoriteDeletion(confirmFavDeletionCheck.getSelection());
    propertyChangeManager.setConfirmCategoryDeletion(confirmCatDeletionCheck.getSelection());
    propertyChangeManager.setConfirmBlogrollDeletion(confirmSubDeletionCheck.getSelection());
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#initComponents()
   */
  protected void initComponents() {

    /** Open mode for favorite tree */
    Group openModeGroup = new Group(composite, SWT.NONE);
    openModeGroup.setText(GUI.i18n.getTranslation("GROUP_OPEN_MODE"));
    openModeGroup.setLayout(new GridLayout(2, false));
    openModeGroup.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    openModeGroup.setFont(FontShop.dialogFont);

    /** Open with single click */
    singleClickRadio = new Button(openModeGroup, SWT.RADIO);
    singleClickRadio.setText(GUI.i18n.getTranslation("LABEL_SINGLE_CLICK"));
    singleClickRadio.setSelection(!propertyChangeManager.isDoubleClickOpen());
    singleClickRadio.setFont(dialogFont);

    /** Open with double click */
    doubleClickRadio = new Button(openModeGroup, SWT.RADIO);
    doubleClickRadio.setText(GUI.i18n.getTranslation("LABEL_DOUBLE_CLICK"));
    doubleClickRadio.setSelection(propertyChangeManager.isDoubleClickOpen());
    doubleClickRadio.setFont(dialogFont);

    /** Group holding the confirmation settings */
    Group confirmGroup = new Group(composite, SWT.NONE);
    confirmGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    confirmGroup.setText(GUI.i18n.getTranslation("GROUP_CONFIRM_DIALOG"));
    confirmGroup.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
    confirmGroup.setFont(FontShop.dialogFont);

    /** Confirm deletion of favorites */
    confirmFavDeletionCheck = new Button(confirmGroup, SWT.CHECK);
    confirmFavDeletionCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    confirmFavDeletionCheck.setSelection(propertyChangeManager.isConfirmFavoriteDeletion());
    confirmFavDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_FAVORITE"));
    confirmFavDeletionCheck.setFont(dialogFont);

    /** Confirm deletion of categories */
    confirmCatDeletionCheck = new Button(confirmGroup, SWT.CHECK);
    confirmCatDeletionCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    confirmCatDeletionCheck.setSelection(propertyChangeManager.isConfirmCategoryDeletion());
    confirmCatDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_CATEGORY"));
    confirmCatDeletionCheck.setFont(dialogFont);

    /** Confirm deletion of blogrolls */
    confirmSubDeletionCheck = new Button(confirmGroup, SWT.CHECK);
    confirmSubDeletionCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    confirmSubDeletionCheck.setSelection(propertyChangeManager.isConfirmBlogrollDeletion());
    confirmSubDeletionCheck.setText(GUI.i18n.getTranslation("BUTTON_DELETE_SUBSCRIPTION"));
    confirmSubDeletionCheck.setFont(dialogFont);

    /** Group holding the misc. settings */
    Group settingsGroup = new Group(composite, SWT.NONE);
    settingsGroup.setLayoutData(LayoutDataShop.createGridData(GridData.VERTICAL_ALIGN_BEGINNING | GridData.FILL_HORIZONTAL, 2));
    settingsGroup.setText(GUI.i18n.getTranslation("MENU_MISC"));
    settingsGroup.setLayout(LayoutShop.createGridLayout(2, 5, 5, 10));
    settingsGroup.setFont(FontShop.dialogFont);

    /** Re-open feeds on startup */
    reopenFeedsCheck = new Button(settingsGroup, SWT.CHECK);
    reopenFeedsCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    reopenFeedsCheck.setSelection(propertyChangeManager.isReopenFeeds());
    reopenFeedsCheck.setText(GUI.i18n.getTranslation("LABEL_REOPEN_DISPLAYED_FEEDS"));
    reopenFeedsCheck.setFont(dialogFont);

    /** Local Cache Newsfeeds */
    localCacheFeedsCheck = new Button(settingsGroup, SWT.CHECK);
    localCacheFeedsCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    localCacheFeedsCheck.setSelection(propertyChangeManager.isLocalCacheFeeds());
    localCacheFeedsCheck.setText(GUI.i18n.getTranslation("BUTTON_CACHE_FEEDS"));
    localCacheFeedsCheck.setFont(dialogFont);

    /** Mark news of displayed feed read on tab close */
    markFeedReadOnTabCloseCheck = new Button(settingsGroup, SWT.CHECK);
    markFeedReadOnTabCloseCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    markFeedReadOnTabCloseCheck.setSelection(propertyChangeManager.isMarkFeedReadOnTabClose());
    markFeedReadOnTabCloseCheck.setText(GUI.i18n.getTranslation("BUTTON_READ_ON_CLOSE"));
    markFeedReadOnTabCloseCheck.setFont(dialogFont);

    /** Mark all news read on window minimization */
    markAllReadOnMinimizeCheck = new Button(settingsGroup, SWT.CHECK);
    markAllReadOnMinimizeCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    markAllReadOnMinimizeCheck.setSelection(propertyChangeManager.isMarkAllReadOnMinimize());
    markAllReadOnMinimizeCheck.setText(GUI.i18n.getTranslation("BUTTON_READ_ON_MINIMIZE"));
    markAllReadOnMinimizeCheck.setFont(dialogFont);

    /** Direct open news with no description in browser */
    directOpenCheck = new Button(settingsGroup, SWT.CHECK);
    directOpenCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    directOpenCheck.setSelection(propertyChangeManager.isAutoOpenEmptyNews());
    directOpenCheck.setText(GUI.i18n.getTranslation("MENU_DIRECTOPEN"));
    directOpenCheck.setFont(dialogFont);

    /** Direct open each news in browser */
    directOpenEachCheck = new Button(settingsGroup, SWT.CHECK);
    directOpenEachCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    directOpenEachCheck.setSelection(propertyChangeManager.isAutoOpenEachNews());
    directOpenEachCheck.setText(GUI.i18n.getTranslation("MENU_DIRECTOPENEACH"));
    directOpenEachCheck.setFont(dialogFont);

    /** Check for an update after startup */
    checkForUpdateCheck = new Button(settingsGroup, SWT.CHECK);
    checkForUpdateCheck.setLayoutData(LayoutDataShop.createGridData(GridData.FILL_HORIZONTAL, 2));
    checkForUpdateCheck.setSelection(propertyChangeManager.isCheckForUpdate());
    checkForUpdateCheck.setText(GUI.i18n.getTranslation("MENU_CHECK_UPDATE"));
    checkForUpdateCheck.setFont(dialogFont);

    /** Set Mnemonics to Buttons */
    WidgetShop.initMnemonics(new Button[] { singleClickRadio, doubleClickRadio, confirmFavDeletionCheck, confirmCatDeletionCheck, confirmSubDeletionCheck, reopenFeedsCheck, localCacheFeedsCheck, markFeedReadOnTabCloseCheck, markAllReadOnMinimizeCheck, directOpenCheck, directOpenEachCheck, checkForUpdateCheck });
  }

  /**
   * @see net.sourceforge.rssowl.controller.properties.PropertyPage#restoreButtonPressed()
   */
  protected void restoreButtonPressed() {
    directOpenCheck.setSelection(false);
    directOpenEachCheck.setSelection(false);
    checkForUpdateCheck.setSelection(true);
    singleClickRadio.setSelection(GlobalSettings.useSingleClickOpen());
    doubleClickRadio.setSelection(!GlobalSettings.useSingleClickOpen());
    reopenFeedsCheck.setSelection(false);
    markAllReadOnMinimizeCheck.setSelection(false);
    markFeedReadOnTabCloseCheck.setSelection(false);
    localCacheFeedsCheck.setSelection(true);
    confirmFavDeletionCheck.setSelection(true);
    confirmCatDeletionCheck.setSelection(true);
    confirmSubDeletionCheck.setSelection(true);
  }
}