/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.sort;

import net.sourceforge.rssowl.model.NewsItem;

import java.util.Date;
import java.util.Hashtable;

/**
 * Class used to compare two RSSNewsItems by publication date.
 * 
 * @author <a href="mailto:masterludo@gmx.net">Ludovic Kim-Xuan Galibert </a>
 * @version 1.2.3
 */
public class PubDateSorter extends AbstractSorter {

  /**
   * Creates a new instance of PubDateSorter.
   * 
   * @param someItems a Hashtable containing RSSNewsItems, may be null.
   */
  public PubDateSorter(Hashtable someItems) {
    super(someItems);
  }

  /**
   * Compare the given objects by publication date.
   * 
   * @param o1 the first key (news title) to retrieve the first NewsItem to
   * compare
   * @param o2 the second key (news title) to retrieve the second NewsItem to
   * compare
   * @return 0 if both RSSNewsItems have exactly the same publication date, -1
   * if the first NewsItem has been published before the second, and 1 if the
   * second NewsItem has been published before the first.
   */
  public int compare(Object o1, Object o2) {
    NewsItem item1 = (NewsItem) getItems().get(o1);
    NewsItem item2 = (NewsItem) getItems().get(o2);

    Date date1 = (item1.getPubDate() != null) ? item1.getPubDateParsed() : null;
    Date date2 = (item2.getPubDate() != null) ? item2.getPubDateParsed() : null;

    int result;

    /** Compare both values */
    if (date1 != null && date2 != null) {
      result = date1.compareTo(date2);

      /** If publish Date are same, order the news by next sort order item */
      if (0 == result)
        result = completeCompare(o1, o2);
    }

    /** NewsItem2 is alphabetical before NewsItem1 */
    else if (date1 != null) {
      result = -1;
    }

    /** NewsItem1 is alphabetical before NewsItem2 */
    else {
      result = 1;
    }

    /** Return result of compare */
    return result;
  }
}