/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.sort;

import net.sourceforge.rssowl.model.NewsItem;

import java.util.Hashtable;

/**
 * Class used to compare two RSSNewsItems by status (read / unread).
 * 
 * @author <a href="mailto:masterludo@gmx.net">Ludovic Kim-Xuan Galibert </a>
 * @version 1.2.3
 */
public class StatusSorter extends AbstractSorter {

  /**
   * Creates a new instance of StatusSorter.
   * 
   * @param someItems a Hashtable containing RSSNewsItems, may be null.
   */
  public StatusSorter(Hashtable someItems) {
    super(someItems);
  }

  /**
   * Compare the given objects by status (read / unread).
   * 
   * @param o1 the first key (news title) to retrieve the first NewsItem to
   * compare
   * @param o2 the second key (news title) to retrieve the second NewsItem to
   * compare
   * @return 0 if both RSSNewsItems have exactly the same status, -1 if the
   * first NewsItem's status is alphabetically before the second, and 1 if the
   * second NewsItem's status is alphabetically before the first.
   */
  public int compare(Object o1, Object o2) {
    NewsItem item1 = (NewsItem) getItems().get(o1);
    NewsItem item2 = (NewsItem) getItems().get(o2);

    String status1 = String.valueOf(item1.isRead());
    String status2 = String.valueOf(item2.isRead());

    int result;

    /** Compare both values */
    result = status1.compareTo(status2);

    /** If status is the same, order the news by next sort order item */
    if (0 == result)
      result = completeCompare(o1, o2);

    /** Return result of compare */
    return result;
  }
}