/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.sort;

/**
 * Class used to compare two RSSNewsItems by title.
 * 
 * @author <a href="mailto:masterludo@gmx.net">Ludovic Kim-Xuan Galibert </a>
 * @version 1.2.3
 */
public class TitleSorter extends AbstractSorter {

  /**
   * Creates a new instance of RSSOwlTitleSorting
   */
  public TitleSorter() {
    super(null);
  }

  /**
   * Compare the given objects by title.
   * 
   * @param o1 the first key (news title) to retrieve the first NewsItem to
   * compare
   * @param o2 the second key (news title) to retrieve the second NewsItem to
   * compare
   * @return 0 if both RSSNewsItems have exactly the same title, -1 if the first
   * NewsItem's title is alphabetically before the second, and 1 if the second
   * NewsItem's title is alphabetically before the first.
   */
  public int compare(Object o1, Object o2) {
    return o1.toString().compareTo((String) o2);
  }
}