/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.thread;

/**
 * This simple extension of the Thread class uses a boolean flag to indicate
 * wether it was stopped or not. This avoids the need of using the stop() method
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class ExtendedThread extends Thread {

  /** Flag indicating status of the Thread */
  protected boolean stopped = false;

  /**
   * Instantiate a new Extended Thread
   * 
   * @see java.lang.Thread
   */
  public ExtendedThread() {
    super();
    setDaemon(true);
  }

  /**
   * Instantiate a new Extended Thread
   * 
   * @param name the name of the new thread.
   * @see java.lang.Thread
   */
  public ExtendedThread(String name) {
    super(name);
    setDaemon(true);
  }

  /**
   * Check if this Thread was stopped
   * 
   * @return boolean TRUE if stopped
   */
  public boolean isStopped() {
    return stopped;
  }

  /**
   * Starts this Thread
   */
  public void startThread() {
    start();
  }

  /**
   * Stops this Thread by setting the stopped-flag to TRUE
   */
  public synchronized void stopThread() {
    stopped = true;
  }
}