/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.controller.thread;

import net.sourceforge.rssowl.controller.GUI;

/**
 * This Thread will exit RSSOwl in a clean way in case the virtual machine is
 * terminated in response to a user interrupt, such as typing ^C, or a
 * system-wide event, such as user logoff or system shutdown. A clean shutdown
 * in this case is saving data to the user directory on exit.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class ShutdownHook extends Thread {
  private GUI gui;

  /**
   * Instantiate a new ShutdownHook which will be added to the Runtime with
   * calling addShutdownHook().
   * 
   * @param gui The Main Controller
   */
  public ShutdownHook(GUI gui) {
    this.gui = gui;
    setName("Shutdown Hook Thread");
    setPriority(Thread.MAX_PRIORITY);
  }

  /**
   * Call the shutDown() Method of the Maincontroller in the Main Thread
   * 
   * @see java.lang.Thread#run()
   */
  public void run() {

    /**
     * Only call shutdown() in case the Java VM is terminating by an unnormal
     * exit (for example process terminating due to a System Shutdown). This is
     * indicated by the isAlive() Method of the Maincontroller.
     */
    if (GUI.isAlive()) {
      GUI.isClosing = true;
      gui.abnormalShutDown();
    }
  }
}