/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.model;

/**
 * Model for a Enclosure. A newsitem may contain one ore more enclosures (e.g.
 * link to a mp3 or other file)
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class Enclosure {
  private String length;
  private String type;
  private String url;

  /** Default Constructor. Init with "?" */
  public Enclosure() {
    this.url = "?";
    this.length = "?";
    this.type = "?";
  }

  /**
   * Get the length of the enclosure
   * 
   * @param formatted If TRUE return length formatted
   * @return String
   */
  public String getLength(boolean formatted) {

    /** Return Unformatted */
    if (!formatted)
      return length;

    /** Return Formatted */
    try {

      /** Parse Value */
      int value = Integer.parseInt(length);

      /** Divide into Megabytes */
      if (value >= 1000000)
        return (value / 1000000) + " MB";

      /** Divide into Kilobytes */
      else if (value >= 1000)
        return (value / 1000) + " KB";

      /** Return Bytes */
      else
        return length + " Bytes";
    }

    /** Not a Number */
    catch (NumberFormatException e) {
      return length;
    }
  }

  /**
   * Get the type of the enclosure
   * 
   * @return String
   */
  public String getType() {
    return type;
  }

  /**
   * Get the URL of the enclosure
   * 
   * @return String
   */
  public String getUrl() {
    return url;
  }

  /**
   * Set the feedSize for the enclosure
   * 
   * @param length
   */
  public void setLength(String length) {
    this.length = length;
  }

  /**
   * Set the type of the enclosure
   * 
   * @param type
   */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Set the enclosure of the enclosure
   * 
   * @param url
   */
  public void setUrl(String url) {
    this.url = url;
  }
}