/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.model;

import net.sourceforge.rssowl.controller.sort.SortingSelectionAdapter;

import org.eclipse.swt.widgets.TableColumn;

import java.util.Hashtable;

/**
 * Model class to store Data in a Table. All columns and sorters of the Table
 * are stored in two Hashtables.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class TableData {
  private Hashtable columnSorter;
  private Hashtable tableColumns;

  /**
   * Private constructor which is used by the factory methods.
   */
  private TableData() {
    columnSorter = new Hashtable();
    tableColumns = new Hashtable();
  }

  /**
   * Create a new TableData to store columns and sorters.
   * 
   * @return TableData An instance of TableData
   */
  public static TableData createTableData() {
    return new TableData();
  }

  /**
   * Add a table column to the list of table columns
   * 
   * @param column The table column to add
   * @param key The unique name of the table column
   */
  public void addColumn(TableColumn column, String key) {
    tableColumns.put(key, column);
  }

  /**
   * Add a sorter to the list of sorters
   * 
   * @param sorter The sorter to add
   * @param key The unique name of the sorter
   */
  public void addColumnSorter(SortingSelectionAdapter sorter, String key) {
    columnSorter.put(key, sorter);
  }

  /**
   * Get a table column from the list of columns
   * 
   * @param key The unique key of the table column
   * @return TableColumn The table column
   */
  public TableColumn getColumn(String key) {
    return (TableColumn) tableColumns.get(key);
  }

  /**
   * Get a sorter from the list of sorters
   * 
   * @param key The unique key of the sorter
   * @return SortingSelectionAdapter The sorter
   */
  public SortingSelectionAdapter getColumnSorter(String key) {
    return (SortingSelectionAdapter) columnSorter.get(key);
  }

  /**
   * Check if this model contains the desired sorter
   * 
   * @param key The unique name of the sorter
   * @return boolean TRUE if the model contains the desired sorter
   */
  public boolean hasColumnSorter(Object key) {
    return columnSorter.containsKey(key);
  }
}