/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.model;

/**
 * Model class to store data in a TableItem. The setData() Method of any
 * TableItem in RSSOwl is used with a TableItemData Object.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class TableItemData {
  private boolean newsRead;

  /**
   * Private constructor that is used by the factory methods.
   * 
   * @param newsRead TRUE if the news is read
   */
  private TableItemData(boolean newsRead) {
    this.newsRead = newsRead;
  }

  /**
   * Create a new TableItemData that tells if a news was read or not
   * 
   * @param isRead TRUE if news was read
   * @return TreeItemData An instance of TableItemData
   */
  public static TableItemData createNewsheaderData(boolean isRead) {
    return new TableItemData(isRead);
  }

  /**
   * @return Returns the newsRead.
   */
  public boolean isNewsRead() {
    return newsRead;
  }

  /**
   * @param newsRead The newsRead to set.
   */
  public void setNewsRead(boolean newsRead) {
    this.newsRead = newsRead;
  }
}