/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.archive;

/**
 * An archive entry is the smallest unit in the RSSOwl archive. It stores the
 * title, link and date of a news. Any news that are stored as archive entry are
 * read. Each archive entry is stored in the archive item that is connected to
 * the newsfeed where these entries come from.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class ArchiveEntry {
  private String newsdate;
  private String newslink;
  private String newstitle;

  /**
   * Instantiate a new ArchiveEntry
   * 
   * @param newsurl The URL of the news
   * @param newstitle The title of the news
   * @param newsdate The publish date of the news
   */
  public ArchiveEntry(String newsurl, String newstitle, String newsdate) {
    this.newslink = newsurl;
    this.newstitle = newstitle;
    this.newsdate = newsdate;
  }

  /**
   * Create an identifier from the given Title, Link and Date.
   * 
   * @param newstitle Title of the news
   * @param newslink Link of the news
   * @param newsdate The publish date of the news
   * @return String An identifier from the given Title and Link
   */
  public static String toID(String newstitle, String newslink, String newsdate) {
    StringBuffer strBuf = new StringBuffer();
    strBuf.append((newstitle != null) ? newstitle : "NULL");
    strBuf.append((newslink != null) ? newslink : "NULL");
    strBuf.append((newsdate != null) ? newsdate : "NULL");
    return new String(strBuf);
  }

  /**
   * @return String The publish date.
   */
  public String getNewsdate() {
    return newsdate;
  }

  /**
   * @return Returns the newslink.
   */
  public String getNewsLink() {
    return newslink;
  }

  /**
   * @return Returns the newstitle.
   */
  public String getNewsTitle() {
    return newstitle;
  }

  /**
   * Create an identifier from this entry.
   * 
   * @return String An identifier from this entry
   */
  public String toID() {
    return ArchiveEntry.toID(newstitle, newslink, newsdate);
  }

  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return "\tNewsTitle: " + newstitle + "   NewsLink: " + newslink + "   NewsDate: " + newsdate + "\n";
  }
}