/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.controller.GUI;
import net.sourceforge.rssowl.util.GlobalSettings;

import org.eclipse.swt.SWT;

/**
 * Class to parse a given KeyCode as Int value and return the name as String.
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class KeyCodeParser {

  /** This utility class constructor is hidden */
  private KeyCodeParser() {
  // Protect default constructor
  }

  /**
   * Format a given keycode constant to a String.
   * 
   * @param keyCode Selected key
   * @return String Representation of the key as String
   */
  public static String format(int keyCode) {
    switch (keyCode) {
      case SWT.CTRL:
        return GUI.i18n.getTranslation("LABEL_KEY_CONTROL");
      case SWT.SHIFT:
        return GUI.i18n.getTranslation("LABEL_KEY_SHIFT");
      case SWT.ALT:
        return GlobalSettings.isMac() ? "Opt" : "Alt";
      case SWT.COMMAND:
        return GUI.i18n.getTranslation("LABEL_KEY_COMMAND");
      case SWT.F1:
        return "F1";
      case SWT.F2:
        return "F2";
      case SWT.F3:
        return "F3";
      case SWT.F4:
        return "F4";
      case SWT.F5:
        return "F5";
      case SWT.F6:
        return "F6";
      case SWT.F7:
        return "F7";
      case SWT.F8:
        return "F8";
      case SWT.F9:
        return "F9";
      case SWT.F10:
        return "F10";
      case SWT.F11:
        return "F11";
      case SWT.F12:
        return "F12";
      case SWT.F13:
        return "F13";
      case SWT.F14:
        return "F14";
      case SWT.F15:
        return "F15";
      case SWT.TAB:
        return "Tab";
      case SWT.ESC:
        return "Esc";
      case SWT.ARROW_DOWN:
        return GUI.i18n.getTranslation("LABEL_KEY_ARROW_DOWN");
      case SWT.ARROW_UP:
        return GUI.i18n.getTranslation("LABEL_KEY_ARROW_UP");
      case SWT.ARROW_LEFT:
        return GUI.i18n.getTranslation("LABEL_KEY_ARROW_LEFT");
      case SWT.ARROW_RIGHT:
        return GUI.i18n.getTranslation("LABEL_KEY_ARROW_RIGHT");
      case SWT.PAGE_UP:
        return GUI.i18n.getTranslation("LABEL_KEY_PAGE_UP");
      case SWT.PAGE_DOWN:
        return GUI.i18n.getTranslation("LABEL_KEY_PAGE_DOWN");
      case SWT.HOME:
        return "Home";
      case SWT.END:
        return "End";
      case SWT.INSERT:
        return GUI.i18n.getTranslation("LABEL_KEY_INSERT");
      case SWT.KEYPAD_MULTIPLY:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Multiply";
      case SWT.KEYPAD_ADD:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Add";
      case SWT.KEYPAD_SUBTRACT:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Subtract";
      case SWT.KEYPAD_DECIMAL:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Decimal";
      case SWT.KEYPAD_DIVIDE:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Divide";
      case SWT.KEYPAD_0:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_0";
      case SWT.KEYPAD_1:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_1";
      case SWT.KEYPAD_2:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_2";
      case SWT.KEYPAD_3:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_3";
      case SWT.KEYPAD_4:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_4";
      case SWT.KEYPAD_5:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_5";
      case SWT.KEYPAD_6:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_6";
      case SWT.KEYPAD_7:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_7";
      case SWT.KEYPAD_8:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_8";
      case SWT.KEYPAD_9:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_9";
      case SWT.KEYPAD_EQUAL:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Equal";
      case SWT.KEYPAD_CR:
        return GUI.i18n.getTranslation("LABEL_KEY_NUMPAD") + "_Enter";
      case SWT.HELP:
        return "Help";
      case SWT.PAUSE:
        return GUI.i18n.getTranslation("LABEL_KEY_PAUSE");
      case SWT.BREAK:
        return "Break";
      case SWT.PRINT_SCREEN:
        return "PRINT_SCREEN";
      case SWT.CR:
        return "Enter";
      case 32:
        return GUI.i18n.getTranslation("LABEL_KEY_SPACE");
      case 8:
        return "DEL";

      default:
        String key = String.valueOf((char) keyCode);

        /** User has typed a alnum key */
        if (key.toLowerCase().matches("[a-zäüöß0-9]"))
          return key.toUpperCase();

        /** User has typed a printable key */
        else if (key.matches("\\p{Print}"))
          return key;

        /** User has typed an unprintable key */
        else
          return "";
    }
  }
}