/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Czech internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nCS extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nCS(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {
    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Soubor");
    translation.put("MENU_SAVE", "Uložit jako");
    translation.put("MENU_TOOLBAR", "Nástrojová lišta");
    translation.put("MENU_GENERATE_PDF", "Vytvořit PDF");
    translation.put("MENU_GENERATE_HTML", "Vytvořit HTML");
    translation.put("MENU_GENERATE_RTF", "Vytvořit RTF");
    translation.put("MENU_IMPORT", "Importovat nastavení");
    translation.put("MENU_EXPORT", "Exportovat nastavení");
    translation.put("MENU_EXIT", "Ukončit");
    translation.put("MENU_WINDOW", "Zobrazení");
    translation.put("MENU_QUICKVIEW", "Panel Rychlé zobrazení");
    translation.put("MENU_PREFERENCES", "Možnosti");
    translation.put("MENU_BROWSER", "Prohlížeč");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Zvolte externí prohlížeč");
    translation.put("MENU_FONT", "Písmo");
    translation.put("MENU_ENCODING", "Kódování textu");
    translation.put("MENU_LANGUAGE", "Jazyk");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Další");
    translation.put("MENU_DIRECTOPEN", "Automaticky otevírat prázdné zpravy v prohlížeči");
    translation.put("MENU_DIRECTOPENEACH", "Automaticky otevírat zvolené zprávy v prohlížeči");
    translation.put("MENU_SYSTRAY", "Při minimalizaci umístit RSSOwl v Oznamovací oblasti");
    translation.put("MENU_CHANNELINFO", "Zobrazit informace o Zdroji");
    translation.put("MENU_OPENNEW_BROWSER", "Vždy otevírat novou záložku interního prohlížeče");
    translation.put("MENU_BROWSER_EXTERN", "Používat externí prohlížeč");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Zobrazit text zprávy v prohlížeči");
    translation.put("MENU_CHECK_UPDATE", "Při spuštění programu kontrolovat aktualizace");
    translation.put("MENU_INFO", "Nápověda");
    translation.put("MENU_ABOUT", "O programu RSSOwl");
    translation.put("MENU_LICENSE", "Licence");
    translation.put("MENU_UPDATE", "Zkontrolovat aktualizace");
    translation.put("MENU_WELCOME", "Vítejte");
    translation.put("MENU_DONATE", "Přispějte na projekt");
    translation.put("MENU_TOOLS", "Nástroje");
    translation.put("MENU_FEEDSEARCH", "Vyhledávat Zdroje");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimalizovat RSSOwl");
    translation.put("MENU_GOTO", "Přejít");
    translation.put("MENU_NEXT_NEWS", "Další zpráva");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Další nepřečtená zpráva");
    translation.put("MENU_CLOSE", "Zavřít");
    translation.put("MENU_CLOSE_ALL", "Zavřít vše");
    translation.put("MENU_PREVIOUS_TAB", "Předchozi záložka");
    translation.put("MENU_NEXT_TAB", "Následující záložka");
    translation.put("MENU_HOTKEYS", "Klávesové zkratky");
    translation.put("MENU_NEWSTIP_MAIL", "Úprava NewsTip e-mailu");
    translation.put("MENU_TELL_FRIENDS", "Doporučit přátelům");
    translation.put("MENU_RELOAD", "Aktualizovat");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Vytvořit PDF ze zvolených zpráv");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Vytvořit HTML ze zvolených zpráv");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Vytvořit RTF ze zvolených zpráv");
    translation.put("MENU_MAILING_LIST", "Mailing List");
    translation.put("MENU_TUTORIAL", "Návod Krok za krokem");
    translation.put("MENU_COLORS", "Barvy");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Pracovní plocha");
    translation.put("MENU_IMPORT_OPML", "Importovat z OPML");
    translation.put("MENU_VALIDATE", "Ověřit Zdroj");
    translation.put("MENU_FEED_DISCOVERY", "Objevit Zdroje na webové stránce");
    translation.put("MENU_EDIT", "Úpravy");
    translation.put("MENU_EDIT_COPY", "Kopírovat");
    translation.put("MENU_EDIT_PASTE", "Vložit");
    translation.put("MENU_EDIT_SELECT_ALL", "Vybrat vše");
    translation.put("MENU_EDIT_DELETE", "Smazat");
    translation.put("MENU_EDIT_CUT", "Vyjmout");
    translation.put("MENU_DISPLAY_FEED_PDF", "Zobrazit Zdroj ve formátu PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Zobrazit Zdroj ve formátu RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Zobrazit Zdroj ve formátu HTML");
    translation.put("MENU_NEW_FAVORITE", "Nový Oblíbený");
    translation.put("MENU_CONNECTION", "Připojení");
    translation.put("MENU_EDIT_RENAME", "Přejmenovat");
    translation.put("MENU_WORK_OFFLINE", "Pracovat offline");
    translation.put("MENU_WORK_ONLINE", "Pracovat online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Označit");
    translation.put("TOOL_NEXT", "Následující");
    translation.put("TOOL_SEPARATOR", "Oddělovač");
    translation.put("TOOL_ICONS_TEXT", "Ikony a text");
    translation.put("TOOL_ICONS", "Pouze ikony");
    translation.put("TOOL_TEXT", "Pouze text");
    translation.put("TOOL_RATE", "Hodnocení");
    translation.put("TOOL_HISTORY", "Historie");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nový");
    translation.put("POP_SUB_CATEGORY", "Podkategorie");
    translation.put("POP_UNSUBSCRIBE", "Zrušit");
    translation.put("POP_USEPROXY", "Použít proxy");
    translation.put("POP_AGGREGATE_FAV", "Načíst oblíbené");
    translation.put("POP_AUTO_UPDATE", "Automatická aktualizace");
    translation.put("POP_UPDATE_ONSTARTUP", "po spuštění");
    translation.put("POP_IMPORT", "Import");
    translation.put("POP_FROM_OPML", "Z OPML souboru");
    translation.put("POP_EXPORT_OPML", "Do OPML souboru");
    translation.put("POP_COPY", "Kopírovat");
    translation.put("POP_OPEN_IN_BROWSER", "Otevřít zvolené v prohlížeči");
    translation.put("POP_MARK_UNREAD", "Označit jako nepřečtené");
    translation.put("POP_COPY_NEWS_URL", "Kopírovat odkaz");
    translation.put("POP_RATE_NEWS", "Hodnotit zprávu");
    translation.put("POP_MAIL_LINK", "Odeslat NewsTip příteli");
    translation.put("POP_OPEN_EXTERN", "Otevřít externě");
    translation.put("POP_BLOG_NEWS", "Blogovat o zprávě");
    translation.put("POP_OPEN_STARTUP", "Otevřít po spuštění");
    translation.put("POP_KEEP_CURRENT", "Zavřít ostatní");
    translation.put("POP_KEEP_NEWSFEEDS", "Zavřít vše kromě Zdrojů");
    translation.put("POP_MARK_ALL_READ", "Označit vše jako přečtené");
    translation.put("POP_MARK_CATEGORY_READ", "Označit kategorii za přečtenou");
    translation.put("POP_TAB_POSITION", "Umístění");
    translation.put("POP_TAB_POS_TOP", "Nahoře");
    translation.put("POP_TAB_POS_BOTTOM", "Dole");
    translation.put("POP_PROPERTIES", "Vlastnosti");
    translation.put("POP_MARK_FAVORITE_READ", "Označit Oblíbený za přečtený");
    translation.put("POP_IMPORT_BLOGROLL", "Synchronizovaný Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synchronizovat");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Přizpůsobit nástrojovou lištu");
    translation.put("POP_CLEAR_HISTORY", "Vyčistit Historii");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Došlo k neočekávané chybě! Nastavení bylo uloženo a RSSOwl bude nyní ukončen.\nChyba byla zaznamenána v '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nPřejete si kontaktovat tým RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Chyba");
    translation.put("ERROR_NO_NEWS_FOUND", "Chyba: Nebyly nalezeny žádné zprávy!");
    translation.put("ERROR_CAT_EXISTS", "Kategorie s tímto jménem již existuje!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Oblíbená položka s tímto názvem již existuje!");
    translation.put("ERROR_FAV_URL_EXISTS", "Oblíbená položka s tímto URL již existuje!");
    translation.put("ERROR_CONNECTION_FAILED", "Připojení selhalo!");
    translation.put("ERROR_GRABTITLE_FAILED", "Nepodařilo se získat název!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl není schopný zobrazit tento Zdroj");
    translation.put("ERROR_FILE_NOT_FOUND", "Nemohu nalézt příslušný soubor");
    translation.put("ERROR_AUTH_REQUIRED", "Zdroj je chráněný a vyžaduje autentifikaci");
    translation.put("ERROR_REASON", "Důvod");
    translation.put("ERROR_LOADING_FEED", "Nepodařilo se načíst Zdroj \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Stav");
    translation.put("ERROR_WORKING_OFFLINE", "Zdroj nelze zobrazit, dokud pracujete offline");
    translation.put("ERROR_NOT_A_XML", "Soubor není platným XML dokumentem");
    translation.put("ERROR_NOT_A_RSS", "XML dokument není platným Zdrojem RSS, RDF nebo Atom");
    translation.put("ERROR_NOT_A_OPML", "XML dokument není platným OMPL souborem");
    translation.put("ERROR_SUB_EXISTS", "K tomuto Zdroji jste již přihlášeni!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Cesta");
    translation.put("LABEL_CATEGORY", "Kategorie");
    translation.put("LABEL_NO_INFOS", "Žádné další informace nejsou dostupné!");
    translation.put("LABEL_FAVORITE", "Oblíbené");
    translation.put("LABEL_TITLE", "Název");
    translation.put("LABEL_USE_PROXY", "Používat proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy vyžaduje autorizaci");
    translation.put("LABEL_USERNAME", "Uživatelské jméno");
    translation.put("LABEL_PASSWORD", "Heslo");
    translation.put("LABEL_PROXY_HOST", "Proxy Server");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_CATEGORY", "Kategorie");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Používat proxy pro všechny oblíbené");
    translation.put("LABEL_NEWS_RATED", "Novinka hodnocena");
    translation.put("LABEL_SEARCH_TOPIC", "Zadejte hledaný text");
    translation.put("LABEL_SEARCH_FINISHED", "Hledání dokončeno.");
    translation.put("LABEL_SEARCH_RUNNING", "Probíhá vyhledávání...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intenzivní vyhledávání");
    translation.put("LABEL_PREFERED_LANGUAGE", "Upřednosňovaný jazyk");
    translation.put("LABEL_DESCRIPTION", "Popis");
    translation.put("LABEL_CREATED", "Vytvořen");
    translation.put("LABEL_LAST_VISIT", "Naposledy navštíven");
    translation.put("LABEL_USED_BY", "Použit");
    translation.put("LABEL_NAME", "Jméno");
    translation.put("LABEL_KEY_SEQUENCE", "Posloupnost kláves");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Posloupnost kláves je neplatná!");
    translation.put("LABEL_SIZE", "Velikost");
    translation.put("LABEL_STYLE", "Styl");
    translation.put("LABEL_SELECT_ENCODING", "Zvolte kódování");
    translation.put("LABEL_MAIL_SUBJECT", "Předmět");
    translation.put("LABEL_MAIL_BODY", "Tělo textu");
    translation.put("LABEL_MAIL_USAGE", "Jako parametry pro informaci o zprávě použijte [TITLE], [LINK] a [DESCRIPTION]");
    translation.put("LABEL_EMPTY_LINK", "Nebyl zadán žádný odkaz");
    translation.put("LABEL_USE_SYSTEM_FONT", "Použít systémové písmo");
    translation.put("LABEL_HTML_FORMAT_MAIL", "E-Mail ve formátu HTML");
    translation.put("LABEL_CURRENT_COLOR", "Aktuální barva");
    translation.put("LABEL_OPTIONS", "Možnosti");
    translation.put("LABEL_SEARCH_RESULTS", "Hledání výrazu \"%TERM%\" vrátilo %NUM% záznamů");
    translation.put("LABEL_SEARCH_EMPTY", "Hledáni výrazu \"%TERM%\" bylo neúspěšné.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Zvolte prosím jeden ze dvou rozvržení plochy");
    translation.put("LABEL_SINGLE_CLICK", "Jedním kliknutím");
    translation.put("LABEL_DOUBLE_CLICK", "Dvojklikem");
    translation.put("LABEL_SELECT_BLOGGER", "Zvolte externí blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Jako parametry pro informaci o zprávě použijte [NEWSLINK], [FEEDLINK] a [TITLE].");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Po přihlášení znovu otevřít aktivní Zdroje");
    translation.put("LABEL_TRADITIONAL_TABS", "Tradiční záložky");
    translation.put("LABEL_CURVED_TABS", "Zakulacené záložky");
    translation.put("LABEL_READY", "Připraven");
    translation.put("LABEL_VALIDATION_FINISHED", "Ověřování dokončeno");
    translation.put("LABEL_VALIDATING", "Probíhá ověřování");
    translation.put("LABEL_FEED_TYPE", "Typ Zdroje");
    translation.put("LABEL_OVERRIDE_DTD", "Vnutit deklaraci typu dokumentu");
    translation.put("LABEL_ADDRESS", "Adresa");
    translation.put("LABEL_BROWSER_USAGE", "Jako parametr pro URL použijte [URL].");
    translation.put("LABEL_OLD_ID", "Staré ID uživatele (volitelné)");
    translation.put("LABEL_AMPHETARATE_ID", "ID uživatele");
    translation.put("LABEL_SORT_EXPLANATION", "Upřednostnit automatické řazení zpráv. RSSOwl se nejprve pokusí seřadit zprávy podle nejvyšší položky. Pokud tato položka neexistuje, RSSOwl bude pokračovat s další položkou.");
    translation.put("LABEL_SORT_ORDER", "Řazení novinek");
    translation.put("LABEL_NOT_UNSUPPORTED", "Váš operační systém zatím není podporován.");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Tyto nastavitelne hodnoty budou přijaty jako výchozí pro každou další Oblíbenou položku.");
    translation.put("LABEL_RESTART", "Provedené změny vyžadují restart RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Vítá Vás RSSOwl - Čtečka pro RSS / RDF / Atom Zdroje");
    translation.put("LABEL_FIRST_STEPS", "První kroky");
    translation.put("LABEL_NEWS", "Novinky");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Zdroj RSSOwl");
    translation.put("LABEL_SUPPORT", "Podpora");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskusní fórum");
    translation.put("LABEL_PROMOTION", "Propagace");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Začít");
    translation.put("LABEL_DOWNLOAD", "Stáhnout");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximální počet spojení");
    translation.put("LABEL_CON_TIMEOUT", "Připojení vyprší za (v sekundách)");
    translation.put("LABEL_DELETE_FAVORITE", "Smazat Oblíbený");
    translation.put("LABEL_DELETE_CATEGORY", "Smazat kategorii");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Smazat Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registrace byla úspěšná");
    translation.put("LABEL_SHOW", "Zobrazit");
    translation.put("LABEL_SEARCH_IN", "Hledat v");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Otevřít");
    translation.put("BUTTON_RELOAD_CAT", "Aktualizovat oblíbené");
    translation.put("BUTTON_ADD", "Přidat");
    translation.put("BUTTON_FILE", "Otevřít soubor");
    translation.put("BUTTON_SEARCH", "Hledat");
    translation.put("BUTTON_RELOAD", "Aktualizovat zprávy");
    translation.put("BUTTON_CANCLE", "Zrušit");
    translation.put("BUTTON_EXPORT", "Exportovat");
    translation.put("BUTTON_STOP_SEARCH", "Zastavit hledání");
    translation.put("BUTTON_CLEAR_RESULTS", "Vymazat výsledky");
    translation.put("BUTTON_EXPORT_TO_OPML", "Export do OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Přidat k oblíbeným");
    translation.put("BUTTON_ASSIGN", "Přiřadit");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Obnovit výchozí nastavení");
    translation.put("BUTTON_APPLY", "Použít");
    translation.put("BUTTON_CHANGE_FONT", "Změnit písmo");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Ověřit");
    translation.put("BUTTON_STOP_VALIDATION", "Zastavit ověřování");
    translation.put("BUTTON_FOCUS_TABS", "Přepnout na nové záložky");
    translation.put("BUTTON_DISPLAY_TABS", "Zobrazovat Zdroje v záložkách");
    translation.put("BUTTON_TRAY_STARTUP", "Po spuštění umístit RSSOwl do Oznamovací oblasti");
    translation.put("BUTTON_TRAY_EXIT", "Po ukončení umístit RSSOwl do Oznamovací oblasti");
    translation.put("BUTTON_SHOW_ERRORS", "Zobrazovat chyby ve složce se záložkami");
    translation.put("BUTTON_CHANGE", "Změnit");
    translation.put("BUTTON_MARK_ALL_READ", "Označit všechny Oblíbené jako přečtené");
    translation.put("BUTTON_AGGREGATE_ALL", "Synchronizovat všechny Oblíbené");
    translation.put("BUTTON_RELOAD_ALL", "Obnovit všechny Oblíbené");
    translation.put("BUTTON_SEARCH_ALL", "Hledat ve všech Oblíbených");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Při minimalizaci označit všechny zprávy za přečtené");
    translation.put("BUTTON_TRAY_POPUP", "Při získání nové zprávy zobrazit vyskakovací okno");
    translation.put("BUTTON_READ_ON_CLOSE", "Při zavření záložky označit Zdroj jako přečtený");
    translation.put("BUTTON_UP", "Nahoru");
    translation.put("BUTTON_DOWN", "Dolů");
    translation.put("BUTTON_NO_SORT", "Netřídit zprávy automaticky");
    translation.put("BUTTON_CREATE_ACCOUNT", "Vytvořit účet");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Automaticky zavírat okénko s novinkami");
    translation.put("BUTTON_CACHE_FEEDS", "Automaticky ukládat Zdroje pro prohlížení offline");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Otevřít v Prohlížeči");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Zobrazit zavíraci tlačítko na Panelech");
    translation.put("BUTTON_DELETE_FAVORITE", "Při mazání Oblíbeného");
    translation.put("BUTTON_DELETE_CATEGORY", "Při mazání katagorie");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Při mazání Blogrollu");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Již se neptat");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokovat vyskakovací okna");
    translation.put("BUTTON_ANIMATE_POPUP", "Animovat vyskakovací okno");
    translation.put("BUTTON_REMOVE", "Odstranit");
    translation.put("BUTTON_SMALL_ICONS", "Použít malé ikony");
    translation.put("BUTTON_LINK_TAB", "Provázat s tímto Zdrojem");
    translation.put("BUTTON_CLEAR", "Vyčistit");

    /** Header */
    translation.put("HEADER_NEWS", "Titulek");
    translation.put("HEADER_RSS_FAVORITES", "Oblíbené");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Klikněte pro otevření stránky!");
    translation.put("TOOLTIP_PRINT", "Tisknout zprávy");
    translation.put("TOOLTIP_RATE", "Klikněte pro ohodnocení");
    translation.put("TOOLTIP_GRAB_TITLE", "Použít název ze Zdroje");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Přijaty nové zprávy");
    translation.put("TOOLTIP_SKIP", "Přeskočit");
    translation.put("TOOLTIP_OPEN_TAB", "Otevřít novou záložku");
    translation.put("TOOLTIP_QUICKSEARCH", "Rychlé hledání");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Datum uveřejnění");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategorie");
    translation.put("TABLE_HEADER_PUBLISHER", "Vydavatel");
    translation.put("TABLE_HEADER_NEWSTITLE", "Titulek");
    translation.put("TABLE_HEADER_FEED", "Zdroj");
    translation.put("TABLE_HEADER_FEEDURL", "Adresa Zdroje");
    translation.put("TABLE_HEADER_FEEDTITLE", "Název Zdroje");
    translation.put("TABLE_HEADER_LINE", "Řádka");
    translation.put("TABLE_HEADER_STATUS", "Stav přečtení");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Domovská stránka");
    translation.put("CHANNEL_INFO_PUBDATE", "Datum uveřejnění");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Poslední úprava Zdroje");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Zodpovědný redaktor");
    translation.put("CHANNEL_INFO_WEBMASTER", "Správce");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategorie");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Čas do vypršení zdroje");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formát");
    translation.put("CHANNEL_INFO_GENERATOR", "Generátor RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Vydavatel");
    translation.put("CHANNEL_INFO_LANGUAGE", "Jazyk");
    translation.put("CHANNEL_INFO_CREATOR", "Tvůrce");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Aktualizace");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "krát");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Zdroj");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Ochrana");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Komentáře");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Upozornění");
    translation.put("MESSAGEBOX_FILL_URL", "Zadejte prosím cestu nebo URL");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategorie s takovým jménem již existuje");
    translation.put("MESSAGEBOX_SELECT_CAT", "Zvolte prosím kategorii");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Soubor již existuje. Skutečně přepsat?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Soubor neobsahuje nastavení RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Import nastavění proběhl úspěšně!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Text zprávy je prázdný. Zvolte prosím zprávu.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Přidat novou oblíbenou položku");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Přidat novou kategorii");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Vložte název, prosím");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Vlože prosím URL / cestu a název");
    translation.put("BASE_AUTH_TITLE", "Žádaná stránka vyžaduje autorizaci!");
    translation.put("BASE_AUTH_MESSAGE", "Vložte prosím uživatelské jméno a heslo");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "V panelu záložek není žádné platné RSS!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Potvrďte prosím");
    translation.put("SEARCH_DIALOG_TITLE", "Hledat");
    translation.put("SEARCH_DIALOG_MESSAGE", "Pro omezení vyhledávání použijte AND, OR a NOT");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Vyhledat");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Pouze celé slovo");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Dodržovat velikost písmen");
    translation.put("SEARCH_DIALOG_REGEX", "Používat Regulární výrazy");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Žádná nová verze");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Právě používáte aktuální verzi RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informace");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Upravit kategorii");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Upravit oblíbenou položku");
    translation.put("DIALOG_TITLE_UPDATE", "Nová verze RSSOwl je dostupná");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Vložte prosím cestu ke spouštěcímu souboru");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Nemohu se připojit k http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Nejprve je nutné nastavit AmphetaRate ID uživatele!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorie neobsahuje žádné oblíbené!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Prosím, zvolte posloupnost kláves");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Nepodařilo se spustit prohlížeč!\nZvolte prosím prohlížeč v 'Možnosti'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Musíte nejprve nastavit blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Zvolte kategorii");
    translation.put("DIALOG_ID_ATTENTION", "Nejprve si musíte vytvořit AmphetaRate účet!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Prosím, vložte adresu stránky");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl nenašel žádnou aplikaci s podporou formátu %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Upravit Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Nepodařilo se načíst vnitřní Prohlížeč!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Přidat nový Zdroj");
    translation.put("QUESTION_DEL_FAV", "Opravdu chcete smazat Oblíbený \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Opravdu chcete smazat kategorii \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Opravdu chcete smazat tento zdroj?");

    /** Browser */
    translation.put("BROWSER_BACK", "Zpět");
    translation.put("BROWSER_FORWARD", "Vpřed");
    translation.put("BROWSER_STOP", "Zastavit");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastické");
    translation.put("RATE_GOOD", "Dobré");
    translation.put("RATE_MODERATE", "Průměrné");
    translation.put("RATE_BAD", "Špatné");
    translation.put("RATE_VERY_BAD", "Otřesné");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nikdy");
    translation.put("UPDATE_INTERVAL_ONE", "po 1 minutě");
    translation.put("UPDATE_INTERVAL_FIVE", "po 5 minutách");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "po 15 minutách");
    translation.put("UPDATE_INTERVAL_THIRTY", "po 30 minutách");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "po 1 hodině");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "po 3 hodinách");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "po 6 hodinách");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "po 12 hodinách");
    translation.put("UPDATE_INTERVAL_ONEDAY", "po 24 hodinách");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Šipka vzhůru");
    translation.put("LABEL_KEY_ARROW_DOWN", "Šipka dolů");
    translation.put("LABEL_KEY_ARROW_LEFT", "Šipka vlevo");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Šipka vpravo");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Mezerník");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Příkaz");
    translation.put("LABEL_REMEMBER_AUTH", "Pamatovat uživatelské jméno a heslo");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Písmo textů");
    translation.put("FONT_AREA_DIALOG", "Písmo dialogů");
    translation.put("FONT_AREA_TREE", "Písmo stromů");
    translation.put("FONT_AREA_TABLE", "Písmo tabulek");
    translation.put("FONT_AREA_HEADER", "Písmo nadpisů");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Písmo textů se používá pro text zpráv, informace o Zdroji, upozornění a chyby.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Písmo dialogů se používá ve všech dialozích.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Písmo stromů se používá ve stromu, který obsahuje oblíbené položky.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Písmo tabulek se používá v tabulce, která obsahuje zprávy ze Zdroje.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Písmo nadpisů se užívá pro nadpisy jednotlivých sekcí.");
    translation.put("FONT_STYLE_BOLD", "Tučné");
    translation.put("FONT_STYLE_ITALIC", "Kurzíva");
    translation.put("FONT_STYLE_NORMAL", "Běžné");

    /** Groups */
    translation.put("GROUP_COMMAND", "Příkaz");
    translation.put("GROUP_SELECTED_FONT", "Zvolené písmo");
    translation.put("GROUP_FONT_AREA", "Oblast písma");
    translation.put("GROUP_WINDOW_LAYOUT", "Rozvržení plochy");
    translation.put("GROUP_OPEN_MODE", "Režim otevření");
    translation.put("GROUP_ARGUMENTS", "Parametry");
    translation.put("GROUP_LINK_COLOR", "Barva odkazu");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Barva výsledků hledání");
    translation.put("GROUP_TAB_LAYOUT", "Rozvržení záložek");
    translation.put("GROUP_TRAY", "Oznamovací oblast");
    translation.put("GROUP_GENERAL", "Hlavní");
    translation.put("GROUP_EXISTING_ACCOUNT", "Exstující účet");
    translation.put("GROUP_NEW_ACCOUNT", "Vytvořit nový účet");
    translation.put("GROUP_NEWS_POPUP", "Okénko s novinkami");
    translation.put("GROUP_CONFIRM_DIALOG", "Zobrazit potvrzovací dialog");

    /** Languages */
    translation.put("de", "Německy");
    translation.put("da", "Dánsky");
    translation.put("el", "Řecky");
    translation.put("en", "Anglicky");
    translation.put("es", "Španělsky");
    translation.put("fr", "Francouzsky");
    translation.put("gl", "Galsky");
    translation.put("it", "Italsky");
    translation.put("nl", "Holandsky");
    translation.put("pt", "Portugalsky (Brazilsky)");
    translation.put("ru", "Rusky");
    translation.put("bg", "Bulharsky");
    translation.put("zhcn", "Zjednodušená čínčtina");
    translation.put("zhtw", "Tradiční čínština");
    translation.put("ja", "Japonsky");
    translation.put("ko", "korejsky");
    translation.put("pl", "Polsky");
    translation.put("no", "Norsky");
    translation.put("sv", "Švédsky");
    translation.put("bn", "Bengali");
    translation.put("fi", "Finsky");
    translation.put("uk", "Ukrajinsky");
    translation.put("cs", "Česky");
    translation.put("sl", "Slovinsky");
    translation.put("hu", "Maďarsky");
    translation.put("tr", "Turecky");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Žádný popis není dostupný!");
    translation.put("LOAD_FEED", "Načítám");
    translation.put("SEARCH_FEED", "Vyhledávám");
    translation.put("RELOAD_FEED", "Aktualizuji");
    translation.put("PRINTED_FROM_RSSOWL", "Vytištěno z RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Tisku zprávy z RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Zobrazit RSSOwl");
    translation.put("TAB_WELCOME", "Vítejte");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument vytvořen v RSSOwl");
    translation.put("NO_TITLE", "Žádný název");
    translation.put("RECOMMENDED_ARTICLES", "Doporučené články");
    translation.put("RSSOWL_TEASER", "RSSOwl je bezplatná RSS a RDF čtečka s otevřeným zdrojovým kódem. Speciální funkce jsou:\n\n- Export zpráv do PDF, HTML, RTF, OPML\n- Import oblíbených z OPML\n- Fulltextové vyhledávání se zvýrazněním hledaného textu.\n- Mocný RSS / RDF / Atom vyhledávač\n- Prohlížení novinek v zabudovaném prohlížeči\n- Správa novinek v kategoriích\n- Verze pro Windows, Linux, Solaris a Mac\n\nPro kompletní seznam funkcí navštivte: http://www.rssowl.org/overview\n\nDownload from: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Prosím přiložte k této zprávě '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' a stručný popis co jste dělali a co se stalo, než došlo k této chybě. Děkujeme!");
    translation.put("FORMAT_AUTO_DETECT", "Zjistit automaticky");
    translation.put("NEWSFEED_VALID", "Zdroj je platný");
    translation.put("OPML_IMPORTED", "Importované");
    translation.put("ENTIRE_NEWS", "Všechny zprávy");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}