/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Danish internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard and Arne Eckmann <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nDA extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nDA(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Fil");
    translation.put("MENU_SAVE", "Gem som");
    translation.put("MENU_TOOLBAR", "Toolbar");
    translation.put("MENU_GENERATE_PDF", "Generér PDF");
    translation.put("MENU_GENERATE_HTML", "Generér HTML");
    translation.put("MENU_GENERATE_RTF", "Generér RTF");
    translation.put("MENU_IMPORT", "Importér opsætning");
    translation.put("MENU_EXPORT", "Eksportér opsætning");
    translation.put("MENU_EXIT", "Afslut");
    translation.put("MENU_WINDOW", "Vindue");
    translation.put("MENU_QUICKVIEW", "Quickview");
    translation.put("MENU_PREFERENCES", "Præferencer");
    translation.put("MENU_FONT", "Skrifttype");
    translation.put("MENU_ENCODING", "Tekstkodning");
    translation.put("MENU_LANGUAGE", "Sprog");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Diverse");
    translation.put("MENU_DIRECTOPEN", "Åben automatisk tomme nyheder i browseren");
    translation.put("MENU_DIRECTOPENEACH", "Åben automatisk alle nyheder i browseren");
    translation.put("MENU_SYSTRAY", "Placer RSSOwl i bakken når den er minimeret");
    translation.put("MENU_CHANNELINFO", "Hvis kanalinformation");
    translation.put("MENU_BROWSER_EXTERN", "Åben browseren eksternt");
    translation.put("MENU_CHECK_UPDATE", "Check for opdatering efter opstart");
    translation.put("MENU_ABOUT", "Om RSSOwl");
    translation.put("MENU_LICENSE", "Licens");
    translation.put("MENU_UPDATE", "Check for opdateringer");
    translation.put("MENU_WELCOME", "Velkommen");
    translation.put("MENU_BROWSER", "Browseren");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Vis nyhedstekst i browseren");
    translation.put("MENU_DONATE", "Donation");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Vælg extern browser");
    translation.put("MENU_INFO", "Hjælp");
    translation.put("MENU_TOOLS", "Funktioner");
    translation.put("MENU_GOTO", "Gå til");
    translation.put("MENU_NEXT_NEWS", "Næste nyhed");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Næste ulæste nyhed");
    translation.put("MENU_CLOSE", "Luk");
    translation.put("MENU_CLOSE_ALL", "Luk alt");
    translation.put("MENU_PREVIOUS_TAB", "Forrige faneblad");
    translation.put("MENU_NEXT_TAB", "Næste faneblad");
    translation.put("MENU_HOTKEYS", "Hotkeys");
    translation.put("MENU_TELL_FRIENDS", "Fortæl mine venner");
    translation.put("MENU_RELOAD", "Genindlæs");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generér PDF fra valgte nyheder");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generér HTML fra valgte nyheder ");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generér RTF fra valgte nyheder ");
    translation.put("MENU_NEWSTIP_MAIL", "Formater NewsTip");
    translation.put("MENU_MAILING_LIST", "Postliste");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimér RSSOwl");
    translation.put("MENU_OPENNEW_BROWSER", "Åben altid den interne browser i et nyt faneblad");
    translation.put("MENU_TUTORIAL", "Fuld hjælp");
    translation.put("MENU_COLORS", "Farver");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_FEEDSEARCH", "Søg efter Nyheder");
    translation.put("MENU_IMPORT_OPML", "Importér fra OPML");
    translation.put("MENU_VALIDATE", "Validér nyheder");
    translation.put("MENU_DISPLAY_FEED_PDF", "Vis nyhedsstrøm i PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Vis nyhedsstrøm i RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Vis nyhedsstrøm i HTML");
    translation.put("MENU_NEW_FAVORITE", "Ny Favorit");
    translation.put("MENU_EDIT", "Rediger");
    translation.put("MENU_EDIT_COPY", "Kopiér");
    translation.put("MENU_EDIT_PASTE", "Indsæt");
    translation.put("MENU_EDIT_SELECT_ALL", "Vælg alt");
    translation.put("MENU_EDIT_DELETE", "Slet");
    translation.put("MENU_EDIT_CUT", "Klip");
    translation.put("MENU_FEED_DISCOVERY", "Søg nyhedsstrømme på website");
    translation.put("MENU_CONNECTION", "Forbindelse");
    translation.put("MENU_EDIT_RENAME", "Omdøb");
    translation.put("MENU_WORK_OFFLINE", "Brug Offline");
    translation.put("MENU_WORK_ONLINE", "Brug Online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Markér");
    translation.put("TOOL_NEXT", "Næste");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Ikoner og tekst");
    translation.put("TOOL_ICONS", "Ikoner");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Bedøm");
    translation.put("TOOL_HISTORY", "Historik");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Ny");
    translation.put("POP_SUB_CATEGORY", "Underkategori");
    translation.put("POP_UNSUBSCRIBE", "Afmeld abonnement");
    translation.put("POP_USEPROXY", "Brug proxy");
    translation.put("POP_AGGREGATE_FAV", "Aggregér favoritter");
    translation.put("POP_AUTO_UPDATE", "Auto update");
    translation.put("POP_UPDATE_ONSTARTUP", "ved opstart");
    translation.put("POP_IMPORT", "Importér");
    translation.put("POP_FROM_OPML", "Fra OPML fil");
    translation.put("POP_EXPORT_OPML", "Til OPML fil");
    translation.put("POP_COPY", "Kopiér");
    translation.put("POP_OPEN_IN_BROWSER", "Åben det udvalgte i browseren");
    translation.put("POP_MARK_UNREAD", "Marker som ulæst");
    translation.put("POP_COPY_NEWS_URL", "Kopiér linket");
    translation.put("POP_MAIL_LINK", "Send NewsTip til en ven");
    translation.put("POP_RATE_NEWS", "Bedøm nyheder");
    translation.put("POP_BLOG_NEWS", "Blog nyheder");
    translation.put("POP_OPEN_EXTERN", "Åben ekstern");
    translation.put("POP_KEEP_CURRENT", "Luk andre");
    translation.put("POP_KEEP_NEWSFEEDS", "Luk andre en nyhederne");
    translation.put("POP_OPEN_STARTUP", "Åben ved opstart");
    translation.put("POP_MARK_ALL_READ", "Marker alt som læst");
    translation.put("POP_MARK_CATEGORY_READ", "Marker kategorien som læst");
    translation.put("POP_PROPERTIES", "Egenskaber");
    translation.put("POP_TAB_POSITION", "Position");
    translation.put("POP_TAB_POS_TOP", "Top");
    translation.put("POP_TAB_POS_BOTTOM", "Bund");
    translation.put("POP_MARK_FAVORITE_READ", "Marker favorit som læst");
    translation.put("POP_IMPORT_BLOGROLL", "Synkroniseret Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synkroniser");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Tilpas værktøjslinje");
    translation.put("POP_CLEAR_HISTORY", "Slet historik");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "En uforudset fejl er netop indtruffet! RSSOwl vil afslutte men din opsætning vil blive gemt.\nGemte fejlinformationerne i '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nVil du sende en fejlrapport til RSSOwl Teamet?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Fejl");
    translation.put("ERROR_NO_NEWS_FOUND", "Fejl: Kunne ikke finde nogen nyheder!");
    translation.put("ERROR_CAT_EXISTS", "En kategori med dette navn findes allerede!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "En favorit med denne titel findes allerede!");
    translation.put("ERROR_FAV_URL_EXISTS", "en favorit med denne URL findes allerede!");
    translation.put("ERROR_CONNECTION_FAILED", "Forbindelsen fejlede!");
    translation.put("ERROR_GRABTITLE_FAILED", "Kunne ikke fange titlen!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl kan ikke vise newsfeed.");
    translation.put("ERROR_FILE_NOT_FOUND", "Filen kunne ikke findes");
    translation.put("ERROR_AUTH_REQUIRED", "Newsfeed er beskyttet og kræver godkendelse");
    translation.put("ERROR_REASON", "Årsag");
    translation.put("ERROR_LOADING_FEED", "Fejl ved indlæsning af Newsfeed \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Newsfeed kan ikke vises i offline tilstand");
    translation.put("ERROR_NOT_A_XML", "Filen er ikke et gyldigt XML dokument");
    translation.put("ERROR_NOT_A_RSS", "XML dokumentet er ikke et gyldigt RSS, RDF eller Atom newsfeed");
    translation.put("ERROR_NOT_A_OPML", "XML dokumentet er ikke en OPML fil");
    translation.put("ERROR_SUB_EXISTS", "Du abonnerer allerede i forvejen på den Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Sti");
    translation.put("LABEL_CATEGORY", "kategori");
    translation.put("LABEL_NO_INFOS", "Ingen yderligere information!");
    translation.put("LABEL_FAVORITE", "Favorit");
    translation.put("LABEL_TITLE", "Titel");
    translation.put("LABEL_USE_PROXY", "Brug proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy autorisation er nødvendig");
    translation.put("LABEL_USERNAME", "Brugernavn");
    translation.put("LABEL_PASSWORD", "Kendeord");
    translation.put("LABEL_PROXY_HOST", "Proxy vært");
    translation.put("LABEL_PROXY_PORT", "Proxy port");
    translation.put("LABEL_CATEGORY", "Kategori");
    translation.put("LABEL_USE_SYSTEM_FONT", "Brug systemskriften");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Mail i HTML-format");
    translation.put("LABEL_MAIL_SUBJECT", "Emne");
    translation.put("LABEL_MAIL_BODY", "Krop");
    translation.put("LABEL_MAIL_USAGE", "Brug [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] og [DESCRIPTION] som wildcards for den nye information.");
    translation.put("LABEL_EMPTY_LINK", "Intet link givet");
    translation.put("LABEL_SELECT_ENCODING", "Vælg kodning");
    translation.put("LABEL_SIZE", "Størrelse");
    translation.put("LABEL_STYLE", "Stil");
    translation.put("LABEL_SEARCH_FINISHED", "Søgning afsluttet.");
    translation.put("LABEL_SEARCH_RUNNING", "Søgning kører");
    translation.put("LABEL_OPTIONS", "Muligheder");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensiv søgning");
    translation.put("LABEL_PREFERED_LANGUAGE", "Foretrukket sprog");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_DESCRIPTION", "Beskrivelse");
    translation.put("LABEL_CREATED", "Oprettet");
    translation.put("LABEL_LAST_VISIT", "Sidst besøgt");
    translation.put("LABEL_USED_BY", "Brugt af");
    translation.put("LABEL_NAME", "Navn");
    translation.put("LABEL_KEY_SEQUENCE", "Tastesekvens");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Tastekombinationen ser ud til at være ulovlig!");
    translation.put("LABEL_CURRENT_COLOR", "Nuværende farve");
    translation.put("LABEL_SEARCH_TOPIC", "Specificér din søgning");
    translation.put("LABEL_NEWS_RATED", "Bedømte nyheder");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Brug proxy til alle favoritterne");
    translation.put("LABEL_BLOGGER_USAGE", "Brug [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] og [TITLE] som wildcards for den nye information.");
    translation.put("LABEL_SEARCH_RESULTS", "Søgningen efter \"%TERM%\" gav %NUM% resultat(er)");
    translation.put("LABEL_SEARCH_EMPTY", "Søgningen efter \"%TERM%\" gav ingen resultater.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Venligst vælg et af de to vindueslayouts");
    translation.put("LABEL_SINGLE_CLICK", "Enkeltklik");
    translation.put("LABEL_DOUBLE_CLICK", "Dobbeltklik");
    translation.put("LABEL_SELECT_BLOGGER", "Vælg ekstern blogger");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Genåben de sidst åbnede nyheder ved opstart");
    translation.put("LABEL_TRADITIONAL_TABS", "Traditionelle faneblade");
    translation.put("LABEL_CURVED_TABS", "Kurvede faneblade");
    translation.put("LABEL_READY", "Klar");
    translation.put("LABEL_FEED_TYPE", "Nyhedstype");
    translation.put("LABEL_VALIDATION_FINISHED", "Validering slut");
    translation.put("LABEL_VALIDATING", "Validerer");
    translation.put("LABEL_OVERRIDE_DTD", "Tilsidesæt Doctype Declaration");
    translation.put("LABEL_ADDRESS", "Adresse");
    translation.put("LABEL_BROWSER_USAGE", "Brug [URL] som erstatningsparameter for URL'en.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Endnu ikke understøttet af dit operativsystem");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "De værdier der kan indstilles her vil blive brugt startværdier for nye favoritter.");
    translation.put("LABEL_RESTART", "Ændringerne kræver genstart af RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Velkommen i RSSOwl - Newsreader for RSS / RDF / Atom Nyhedsstrømme");
    translation.put("LABEL_FIRST_STEPS", "Første trin");
    translation.put("LABEL_NEWS", "Nyheder");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl nyhedsstrøm");
    translation.put("LABEL_SUPPORT", "Support");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskussionsforum");
    translation.put("LABEL_PROMOTION", "Promotion");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Download");
    translation.put("LABEL_OLD_ID", "Gammelt brugernavn (valgfri)");
    translation.put("LABEL_AMPHETARATE_ID", "Brugernavn");
    translation.put("LABEL_SORT_ORDER", "Nyhedssortering");
    translation.put("LABEL_REMEMBER_AUTH", "Husk brugernavn og password");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl first attempts to sort the newsfeed by the top item of the list. In case that item is not available in the newsfeed, RSSOwl continues with the next item from the list.");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksimalt antal forbindelser");
    translation.put("LABEL_CON_TIMEOUT", "Forbindelses timeout i sekunder");
    translation.put("LABEL_DELETE_FAVORITE", "Slet en favorit");
    translation.put("LABEL_DELETE_CATEGORY", "Slet en kategori");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Slet en Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registrering lykkedes");
    translation.put("LABEL_SHOW", "Vis");
    translation.put("LABEL_SEARCH_IN", "Søg i");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Åben");
    translation.put("BUTTON_RELOAD_CAT", "Genopfrisk favoritter");
    translation.put("BUTTON_ADD", "Tilføj");
    translation.put("BUTTON_FILE", "Vælg fil");
    translation.put("BUTTON_SEARCH", "Søg");
    translation.put("BUTTON_RELOAD", "Genopfrisk nyheder");
    translation.put("BUTTON_CANCLE", "Fortryd");
    translation.put("BUTTON_EXPORT", "Eksportér");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Genskab standard");
    translation.put("BUTTON_APPLY", "Udfør");
    translation.put("BUTTON_CHANGE_FONT", "Ændre skrift");
    translation.put("BUTTON_OK", "Ok");
    translation.put("BUTTON_STOP_SEARCH", "Stop søgning");
    translation.put("BUTTON_CLEAR_RESULTS", "Slet resultat");
    translation.put("BUTTON_EXPORT_TO_OPML", "Eksportér til OPML");
    translation.put("BUTTON_ASSIGN", "Tilføj");
    translation.put("BUTTON_ADDTO_FAVORITS", "Tilføj til favoritter");
    translation.put("BUTTON_STOP_VALIDATION", "Stop validering");
    translation.put("BUTTON_FOCUS_TABS", "Sæt focus på nye faneblade");
    translation.put("BUTTON_DISPLAY_TABS", "Vis nyheder i faneblade");
    translation.put("BUTTON_TRAY_STARTUP", "Placér RSSOwl i systembakken ved opstart");
    translation.put("BUTTON_TRAY_EXIT", "Placér RSSOwl i systembakken ved afslutning");
    translation.put("BUTTON_SHOW_ERRORS", "Vis fejl i tabfolder");
    translation.put("BUTTON_VALIDATE", "Validér");
    translation.put("BUTTON_MARK_ALL_READ", "Markér alle kategorier som læst");
    translation.put("BUTTON_AGGREGATE_ALL", "Aggregér alle kategorier");
    translation.put("BUTTON_RELOAD_ALL", "Genindlæs alle kategorier");
    translation.put("BUTTON_SEARCH_ALL", "Søg i alle kategorier");
    translation.put("BUTTON_CHANGE", "Skift");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Luk hyhedspopup automatisk");
    translation.put("BUTTON_CACHE_FEEDS", "Gem automatisk nyhedsstrømme offline læsning");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marke alle nyheder som læst ved minimering");
    translation.put("BUTTON_TRAY_POPUP", "Vis popup når der er ulæste nyheder til rådighed");
    translation.put("BUTTON_READ_ON_CLOSE", "Marker strømmen som læst når fanen lukkes");
    translation.put("BUTTON_UP", "Op");
    translation.put("BUTTON_DOWN", "Ned");
    translation.put("BUTTON_NO_SORT", "Nyhedsstrøm skal ikke sorteres automatisk");
    translation.put("BUTTON_CREATE_ACCOUNT", "Opret konto");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Åben i browser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Vis lukkeknap på faner");
    translation.put("BUTTON_DELETE_FAVORITE", "Ved sletning af en favorit");
    translation.put("BUTTON_DELETE_CATEGORY", "Ved sletning af en kategori");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Ved sletning af");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Spørg ikke igen");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokker Popupvinduer");
    translation.put("BUTTON_ANIMATE_POPUP", "Animeret Popup");
    translation.put("BUTTON_REMOVE", "Fjern");
    translation.put("BUTTON_SMALL_ICONS", "Brug små ikoner");
    translation.put("BUTTON_LINK_TAB", "Synkroniser med vist Feed");
    translation.put("BUTTON_CLEAR", "Nulstil");

    /** Header */
    translation.put("HEADER_NEWS", "Nyhedsoverskrift");
    translation.put("HEADER_RSS_FAVORITES", "Favoritter");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Vær venlig at klikke for at åbne dette site!");
    translation.put("TOOLTIP_PRINT", "Udskriv nyheder");
    translation.put("TOOLTIP_RATE", "Klik for at bedømme");
    translation.put("TOOLTIP_GRAB_TITLE", "Fang titlen fra nyhedssitet");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Ulæste nyheder");
    translation.put("TOOLTIP_OPEN_TAB", "Åben et nyt faneblad");
    translation.put("TOOLTIP_SKIP", "Skip");
    translation.put("TOOLTIP_QUICKSEARCH", "Hurtigsøgning");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Udgivet dato");
    translation.put("TABLE_HEADER_AUTHOR", "Forfatter");
    translation.put("TABLE_HEADER_CATEGORY", "Kategori");
    translation.put("TABLE_HEADER_PUBLISHER", "Udgiver");
    translation.put("TABLE_HEADER_NEWSTITLE", "Nyhedsoverskrift");
    translation.put("TABLE_HEADER_FEED", "Nyhedsstrøm");
    translation.put("TABLE_HEADER_FEEDURL", "Nyhedssite URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Nyhedssite titel");
    translation.put("TABLE_HEADER_LINE", "Linje");
    translation.put("TABLE_HEADER_STATUS", "Læst status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Udgivet dato");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Sidste kanal ændring");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Redaktør");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategori");
    translation.put("CHANNEL_INFO_DOCS", "Dokumenter");
    translation.put("CHANNEL_INFO_TTL", "Kanal 'time to live'");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Udgiver");
    translation.put("CHANNEL_INFO_LANGUAGE", "Sprog");
    translation.put("CHANNEL_INFO_CREATOR", "Ophavsmand");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Opdager");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "gange");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Hjemmeside");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Kilde");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Indhold");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Kommentarer");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Bemærk");
    translation.put("MESSAGEBOX_FILL_URL", "Vær venlig at indtaste en URL eller en sti");
    translation.put("MESSAGEBOX_CAT_EXISTS", "En kategori med dette navn, eksisterer allerede");
    translation.put("MESSAGEBOX_SELECT_CAT", "Vær venlig at vælge en kategori");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Fil eksisterer. Overskriv?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Fil indeholder ikke RSSOwl opsætning!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Succesfuld import af opsætning!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Nyhedsteksten er tom! Vær venlig at vælge en nyhed.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Tilføj en ny favorit");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Tilføj en ny kategori");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Vær venlig at indtaste en titel");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Vær venlig at indtaste url / sti og titel");
    translation.put("BASE_AUTH_TITLE", "Den adspurgte vært forlanger autorisation!");
    translation.put("BASE_AUTH_MESSAGE", "Vær venlig at indtaste brugernavn og kendeord.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Ingen gyldig RSS valg i folderen!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Bekræft venligst");
    translation.put("SEARCH_DIALOG_TITLE", "Søg");
    translation.put("SEARCH_DIALOG_MESSAGE", "Brug venligst OG, ELLER og IKKE til at afgrænse søgningen");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Søg efter");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Kun hele ordet");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Forskel på små og store bogstaver");
    translation.put("SEARCH_DIALOG_REGEX", "Brug regulære udtryk");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Ingen ny version");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Du bruger allerede den nyeste version af RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Information");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Rediger kategori");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Rediger favorit");
    translation.put("DIALOG_TITLE_UPDATE", "Ny RSSOwl version tilgængelig");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Venligst angiv stien til browseren");
    translation.put("DIALOG_ID_ATTENTION", "Du bliver nødt til at sætte din AmphetaRate bruger ID først!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Tast en tastesekvens");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Kan ikke etablere forbindelse til http://www.rssowl.org");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategori indeholder ingen favoritter!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Kunne ikke eksekvere browseren!\nVælg venligst browseren i 'Preferenser'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Du skal sætte en blogger først!");
    translation.put("DIALOG_TITLE_CATEGORY", "Vælg en kategori");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl kunne ikke finde nogen applikation at fremvise %FORMAT%");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Indtast venligst websitets URL");
    translation.put("DIALOG_ID_ATTENTION", "Du bliver nødt til at sætte din AmphetaRate bruger ID først!");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Rediger Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Intern browser kunne ikke indlæses!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Tilføj ny Blogroll");
    translation.put("QUESTION_DEL_FAV", "Er du sikker på at du vil slette favoritten \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Er du sikker på at du vil slette kategorien \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Er du sikker på at du vil slette Blogrollen?");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ingen");
    translation.put("UPDATE_INTERVAL_ONE", "efter 1 minut");
    translation.put("UPDATE_INTERVAL_FIVE", "efter 5 minutter");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "efter 15 minutter");
    translation.put("UPDATE_INTERVAL_THIRTY", "efter 30 minutter");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "efter 1 time");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "efter 3 timer");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "efter 6 timer");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "efter 12 timer");
    translation.put("UPDATE_INTERVAL_ONEDAY", "efter 24 timer");

    /** Browser */
    translation.put("BROWSER_BACK", "Tilbage");
    translation.put("BROWSER_FORWARD", "Fremad");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastisk");
    translation.put("RATE_GOOD", "God");
    translation.put("RATE_MODERATE", "Middel");
    translation.put("RATE_BAD", "Dårlig");
    translation.put("RATE_VERY_BAD", "Meget dårlig");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Skift");
    translation.put("LABEL_KEY_ARROW_UP", "Pil_op");
    translation.put("LABEL_KEY_ARROW_DOWN", "Pil_ned");
    translation.put("LABEL_KEY_ARROW_LEFT", "Pil_venstre");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Pil_højre");
    translation.put("LABEL_KEY_PAGE_UP", "Side_op");
    translation.put("LABEL_KEY_PAGE_DOWN", "Side_ned");
    translation.put("LABEL_KEY_SPACE", "Mellemrum");
    translation.put("LABEL_KEY_INSERT", "Indsæt");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "NumLock");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_STYLE_BOLD", "Fed");
    translation.put("FONT_STYLE_ITALIC", "Kursiv");
    translation.put("FONT_STYLE_NORMAL", "Normal");
    translation.put("FONT_AREA_TEXT", "Tekst skrift");
    translation.put("FONT_AREA_DIALOG", "Dialog skrift");
    translation.put("FONT_AREA_TREE", "Træ skrift");
    translation.put("FONT_AREA_TABLE", "Tabel skrift");
    translation.put("FONT_AREA_HEADER", "Overskrift skrift");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Tekstskriften bruges til nyhedstekst, kanal informationer, beskeder og fejl.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Dialogskriften bruges til alle dialoger.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Træskrften bruges til de træer der holder favoritterne.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Tabelskriften bruges til de tabeller som holder nyhederne fra et nyhedssite.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Overskriftskriften bruges til sektions overskrifter.");

    /** Groups */
    translation.put("GROUP_SELECTED_FONT", "Valgt skrifttype");
    translation.put("GROUP_FONT_AREA", "Skrifttype område");
    translation.put("GROUP_COMMAND", "Kommando");
    translation.put("GROUP_WINDOW_LAYOUT", "Vindueslayout");
    translation.put("GROUP_OPEN_MODE", "Åben modus");
    translation.put("GROUP_ARGUMENTS", "Argumenter");
    translation.put("GROUP_LINK_COLOR", "Henvisningsfarve");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Søgeresultatfarve");
    translation.put("GROUP_TAB_LAYOUT", "Fanelayout");
    translation.put("GROUP_TRAY", "Systembakke");
    translation.put("GROUP_GENERAL", "Generelt");
    translation.put("GROUP_NEWS_POPUP", "Nyhedspopup");
    translation.put("GROUP_EXISTING_ACCOUNT", "Eksisterende konto");
    translation.put("GROUP_NEW_ACCOUNT", "Opret ny konto");
    translation.put("GROUP_CONFIRM_DIALOG", "Vis bekræftelsesdialog");

    /** Languages */
    translation.put("en", "Engelsk");
    translation.put("de", "Tysk");
    translation.put("fr", "Fransk");
    translation.put("da", "Dansk");
    translation.put("es", "Spansk");
    translation.put("gl", "Gælisk");
    translation.put("it", "Italiensk");
    translation.put("nl", "Hollandsk");
    translation.put("el", "Græsk");
    translation.put("ru", "Russisk");
    translation.put("pt", "Portugesisk");
    translation.put("bg", "Bulgarsk");
    translation.put("no", "Norsk");
    translation.put("zhcn", "Simplificeret kinesisk");
    translation.put("ja", "Japansk");
    translation.put("ko", "Koreansk");
    translation.put("sv", "Svensk");
    translation.put("pl", "Polsk");
    translation.put("bn", "Bengalsk");
    translation.put("uk", "Ukrainsk");
    translation.put("fi", "Finsk");
    translation.put("zhtw", "Traditionel kinesisk");
    translation.put("cs", "Tjekkisk");
    translation.put("sl", "Slovakisk");
    translation.put("tr", "Tyrkisk");
    translation.put("hu", "Ungarnsk");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Ingen beskrivelse tilgængelig!");
    translation.put("PRINTED_FROM_RSSOWL", "Udskrevet fra RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Udskriver nyheder fra RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Vis RSSOwl");
    translation.put("TAB_WELCOME", "Velkommen");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument generéret fra RSSOwl");
    translation.put("NO_TITLE", "Ingen titel");
    translation.put("RSSOWL_TEASER", "RSSOwl er en gratis, opensource RSS / RDF / Atom nyhedslæser. Specielle egenskaber er:\n\n- Eksportér nyheder til PDF, HTML, RTF, OPML\n- Importér fra OPML\n- Heltekst-søgning med syntaksvisning af resultaterne\n- Kraftfuld RSS / RDF / Atom søgemaskine\n- Vis nyheder i intern browser\n- Opdel favoritter i kategorier\n- Kører på Windows, Linux, Solaris og Mac\n\nFor at få en komplet liste af muligheder, se: http://www.rssowl.org/overview\n\nDownload fra: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Anbefalede artikler");
    translation.put("LOAD_FEED", "Indlæser");
    translation.put("SEARCH_FEED", "Søger");
    translation.put("RELOAD_FEED", "Opfrisker");
    translation.put("MAIL_ERROR_BODY", "Vær venlig at vedhæfte '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' til denne e-mail, og giv en kort beskrivelse af hvad RSSOwl gjorde lige inden fejlen skete, på forhånd TAK!");
    translation.put("FORMAT_AUTO_DETECT", "Detektér automatisk");
    translation.put("NEWSFEED_VALID", "Nyhederne er gyldige");
    translation.put("OPML_IMPORTED", "Importeret");
    translation.put("ENTIRE_NEWS", "Alle nyheder");
    translation.put("SEARCH_AND", "OG");
    translation.put("SEARCH_OR", "ELLER");
    translation.put("SEARCH_NOT", "IKKE");
  }
}