/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Greek internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nEL extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nEL(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Αρχείο");
    translation.put("MENU_SAVE", "Αποθήκευση ως");
    translation.put("MENU_TOOLBAR", "Γραμμή εργαλείων");
    translation.put("MENU_QUICKVIEW", "Προβολή γραμμής διευθύνσεων");
    translation.put("MENU_GENERATE_PDF", "Εξαγωγή σε PDF");
    translation.put("MENU_GENERATE_HTML", "Εξαγωγή σε HTML");
    translation.put("MENU_GENERATE_RTF", "Εξαγωγή σε RTF");
    translation.put("MENU_IMPORT", "Εισαγωγή ρυθμίσεων");
    translation.put("MENU_EXPORT", "Εξαγωγή ρυθμίσεων");
    translation.put("MENU_EXIT", "Έξοδος");
    translation.put("MENU_WINDOW", "Παράθυρο");
    translation.put("MENU_PREFERENCES", "Προτιμήσεις");
    translation.put("MENU_BROWSER", "Πρόγραμμα περιήγησης");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Επιλογή προγράμματος περιήγησης");
    translation.put("MENU_FONT", "Γραμματοσειρά");
    translation.put("MENU_ENCODING", "Κωδικοποίηση κειμένου");
    translation.put("MENU_LANGUAGE", "Γλώσσα");
    translation.put("MENU_PROXY", "Ρυθμίσεις");
    translation.put("MENU_MISC", "Διάφορα");
    translation.put("MENU_DIRECTOPEN", "Αυτόματα άνοιγμα κενών νέων στον περιηγητή");
    translation.put("MENU_DIRECTOPENEACH", "Αυτόματο άνοιγμα κάθε νέου στον περιηγητή");
    translation.put("MENU_SYSTRAY", "Εμφάνιση του RSSOwl στο χώρο των ειδοποιήσεων (tray) όταν ελαχιστοποιείται");
    translation.put("MENU_CHANNELINFO", "Προβολή πληροφοριών");
    translation.put("MENU_OPENNEW_BROWSER", "Άνοιγμα του προγράμματος περιήγησης σε νέα σελίδα");
    translation.put("MENU_BROWSER_EXTERN", "Χρήση του εξωτερικού προγράμματος περιήγησης");
    translation.put("MENU_CHECK_UPDATE", "Έλεγχος για νέες εκδόσεις μετά την εκκίνηση");
    translation.put("MENU_INFO", "Πληροφορίες");
    translation.put("MENU_ABOUT", "Ταυτότητα");
    translation.put("MENU_LICENSE", "Άδεια χρήσης");
    translation.put("MENU_UPDATE", "Έλεγχος για νέα έκδοση");
    translation.put("MENU_WELCOME", "Καλώς ήρθατε");
    translation.put("MENU_DONATE", "Χορηγία");
    translation.put("MENU_GOTO", "Μετάβαση");
    translation.put("MENU_NEXT_NEWS", "Επόμενο νέο");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Επόμενο μη αναγνωσμένο");
    translation.put("MENU_INFO", "Βοήθεια");
    translation.put("MENU_TOOLS", "Εργαλεία");
    translation.put("MENU_MINIMIZE_RSSOWL", "Ελαχιστοποίηση του RSSOwl");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Εμφάνιση του κειμένου των νέων στο πρόγραμμα περιήγησης");
    translation.put("MENU_TELL_FRIENDS", "Πες το στους φίλους μου");
    translation.put("MENU_RELOAD", "Ανανέωση");
    translation.put("MENU_NEWSTIP_MAIL", "Μορφοποίηση του μηνύματος για το NewsTip");
    translation.put("MENU_CLOSE", "Κλείσιμο");
    translation.put("MENU_CLOSE_ALL", "Κλείσιμο Όλων");
    translation.put("MENU_PREVIOUS_TAB", "Προηγούμενη Σελίδα");
    translation.put("MENU_NEXT_TAB", "Επόμενη Σελίδα");
    translation.put("MENU_HOTKEYS", "Πλήκτρα συντομεύσεων");
    translation.put("MENU_OPENNEW_BROWSER", "Άνοιγμα του εσωτερικού προγράμματος περιήγησης πάντα στην ίδια σελίδα");
    translation.put("MENU_MAILING_LIST", "Λίστα ηλεκτρονικού ταχυδρομείου");
    translation.put("MENU_TUTORIAL", "Βοήθεια για το RSSOwl");
    translation.put("MENU_COLORS", "Χρώματα");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Γενικά");
    translation.put("MENU_FEEDSEARCH", "Αναζήτηση νέων");
    translation.put("MENU_IMPORT_OPML", "Εισαγωγή από OPML");
    translation.put("MENU_VALIDATE", "Έλεγχος Εγκυρότητας Newsfeed");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Δημιουργία PDF από τα επιλεγμένα Νέα");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Δημιουργία HTML από τα επιλεγμένα Νέα");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Δημιουργία RTF από τα επιλεγμένα Νέα");
    translation.put("MENU_FEED_DISCOVERY", "Αναζήτηση νέων στην ιστοσελίδα");
    translation.put("MENU_EDIT", "Επεξεργασία");
    translation.put("MENU_EDIT_COPY", "Αντιγραφή");
    translation.put("MENU_EDIT_PASTE", "Επικόλληση");
    translation.put("MENU_EDIT_SELECT_ALL", "Επιλογή όλων");
    translation.put("MENU_EDIT_DELETE", "Διαγραφή");
    translation.put("MENU_EDIT_CUT", "Αποκοπή");
    translation.put("MENU_DISPLAY_FEED_PDF", "Προβολή Νέου ως PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Προβολή Νέου ως RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Προβολή Νέου ως HTML");
    translation.put("MENU_NEW_FAVORITE", "Προσθήκη Αγαπημένου");
    translation.put("MENU_CONNECTION", "Σύνδεση");
    translation.put("MENU_EDIT_RENAME", "Μετονομασία");
    translation.put("MENU_WORK_OFFLINE", "Εργασία χωρίς σύνδεση");
    translation.put("MENU_WORK_ONLINE", "Εργασία με σύνδεση");

    /** ToolBar */
    translation.put("TOOL_MARK", "Σήμανση");
    translation.put("TOOL_NEXT", "Επομένο");
    translation.put("TOOL_SEPARATOR", "Διαχωριστής");
    translation.put("TOOL_ICONS_TEXT", "Εικονίδια και Κείμενο");
    translation.put("TOOL_ICONS", "Εικονίδια");
    translation.put("TOOL_TEXT", "Κείμενο");
    translation.put("TOOL_RATE", "Βαθμολόγηση");
    translation.put("TOOL_HISTORY", "Ιστορικό");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Προσθήκη");
    translation.put("POP_SUB_CATEGORY", "Υποκατηγορία");
    translation.put("POP_UNSUBSCRIBE", "Κατάργηση συνδρομής");
    translation.put("POP_USEPROXY", "Χρησιμοποίηση διακομιστή μεσολάβησης (proxy)");
    translation.put("POP_AGGREGATE_FAV", "Συγκέντρωση αγαπημένων");
    translation.put("POP_AUTO_UPDATE", "Αυτόματη ενημέρωση");
    translation.put("POP_UPDATE_ONSTARTUP", "στην εκκίνηση");
    translation.put("POP_IMPORT", "Εισαγωγή");
    translation.put("POP_FROM_OPML", "Από αρχείο OPML");
    translation.put("POP_EXPORT_OPML", "προς αρχείο OPML");
    translation.put("POP_COPY", "Αντιγραφή");
    translation.put("POP_OPEN_IN_BROWSER", "Άνοιγμα επιλογής στο πρόγραμμα περιήγησης");
    translation.put("POP_MARK_UNREAD", "Σήμανση ως αναγνωσμένου");
    translation.put("POP_MARK_UNREAD", "Σήμανση ως αναγνωσμένου");
    translation.put("POP_COPY_NEWS_URL", "Αντιγραφή συνδέσμου");
    translation.put("POP_MAIL_LINK", "Αποστολή με ηλεκτρονικό ταχυδρομείο του NewsTip, σε κάποιο φίλο");
    translation.put("POP_RATE_NEWS", "Βαθμολόγηση νέων");
    translation.put("POP_OPEN_EXTERN", "Άνοιγμα με τον εξωτερικό περιηγητή");
    translation.put("POP_OPEN_STARTUP", "Άνοιγμα κατά την εκκίνηση");
    translation.put("POP_BLOG_NEWS", "Blog news");
    translation.put("POP_KEEP_CURRENT", "Κλείσιμο των άλλων");
    translation.put("POP_KEEP_NEWSFEEDS", "Κλείσιμο όλων εκτός των νέων");
    translation.put("POP_MARK_ALL_READ", "Σήμανση όλων ως αναγνωσμένων");
    translation.put("POP_MARK_CATEGORY_READ", "Σήμανση Κατηγορίας ως Αναγνωσμένης");
    translation.put("POP_PROPERTIES", "Ιδιότητες");
    translation.put("POP_TAB_POSITION", "Θέση");
    translation.put("POP_TAB_POS_TOP", "Πάνω");
    translation.put("POP_TAB_POS_BOTTOM", "Κάτω");
    translation.put("POP_MARK_FAVORITE_READ", "Σήμανση Αγαπημένου ως αναγνωσμένου");
    translation.put("POP_IMPORT_BLOGROLL", "Συγχρονισμός Blogroll");
    translation.put("POP_SYNCHRONIZE", "Συγχρονισμός");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Προσαρμογή γραμμών εργαλείων");
    translation.put("POP_CLEAR_HISTORY", "Καθαρισμός ιστορικού");

    /** Errors in RSSOwl */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Σφάλμα");
    translation.put("ERROR_NO_NEWS_FOUND", "Σφάλμα: Δεν βρέθηκαν καθόλου νέα!");
    translation.put("ERROR_CAT_EXISTS", "Η κατηγορία υπάρχει ήδη!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Το αγαπημένο με αυτόν τον τίτλο υπάρχει ήδη!");
    translation.put("ERROR_FAV_URL_EXISTS", "Υπάρχει ήδη αγαπημένο για τον συγκεκριμένο σύνδεσμο!");
    translation.put("ERROR_CONNECTION_FAILED", "Σφάλμα σύνδεσης!");
    translation.put("ERROR_GRABTITLE_FAILED", "Δεν ήταν δυνατός ο προσδιορισμός του τίτλου!");
    translation.put("ERROR_UNEXPECTED", "Παρουσιάστηκε απροσδόκητο σφάλμα! Το RSSOwl θα τερματίσει αλλά οι ρυθμίσεις έχουν αποθηκευτεί.\nΤο σφάλμα καταγράφηκε στο αρχείο '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nΘέλετε να στείλετε μια αναφορά σφάλματος στην ομάδα του RSSOwl;");
    translation.put("ERROR_NEWSFEED_GENERAL", "Το πρόγραμμα RSSOwl δεν μπόρεσε να εμφανίσει το νέο.");
    translation.put("ERROR_FILE_NOT_FOUND", "Δεν είναι δυνατός ο εντοπισμός του αρχείου");
    translation.put("ERROR_AUTH_REQUIRED", "Το νέο είναι προστατευμένο και χρειάζεται εξουσιοδότηση");
    translation.put("ERROR_REASON", "Αιτία");
    translation.put("ERROR_LOADING_FEED", "Σφάλμα κατά την φόρτωση του νέου με τίτλο \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Κατάσταση");
    translation.put("ERROR_WORKING_OFFLINE", "Το νέο δεν μπορεί να εμφανιστεί σε κατάσταση αποσύνδεσης");
    translation.put("ERROR_NOT_A_XML", "Το αρχείο δεν είναι έγκυρο XML έγγραφο");
    translation.put("ERROR_NOT_A_RSS", "Το XML έγγραφο δεν είναι έγκυρη RSS, RDF ή Atom τροφοδότηση νέων");
    translation.put("ERROR_NOT_A_OPML", "To XML έγγραφο δεν είναι OPML αρχείο");
    translation.put("ERROR_SUB_EXISTS", "Είστε ήδη συνδρομητής στο συγκεκριμένο Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "Διεύθυνση (URL)");
    translation.put("LABEL_CATEGORY", "Κατηγορία");
    translation.put("LABEL_NO_INFOS", "Δεν υπάρχουν επιπλέον πληροφορίες!");
    translation.put("LABEL_FAVORITE", "Αγαπημένο");
    translation.put("LABEL_TITLE", "Τίτλος");
    translation.put("LABEL_USE_PROXY", "Χρησιμοποίηση διακομιστή μεσολάβησης (proxy)");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Ο διακομιστής μεσολάβησης απαιτεί έλεγχο ασφαλείας");
    translation.put("LABEL_USERNAME", "Όνομα χρήστη");
    translation.put("LABEL_PASSWORD", "Κωδικός πρόσβασης");
    translation.put("LABEL_PROXY_HOST", "Όνομα διακομιστή μεσολάβησης");
    translation.put("LABEL_PROXY_PORT", "Θύρα διακομιστή μεσολάβησης");
    translation.put("LABEL_CATEGORY", "Κατηγορία");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Χρησιμοποίηση διακομιστή μεσολάβησης για όλα τα αγαπημένα");
    translation.put("LABEL_SEARCH_FINISHED", "Η εύρεση ολοκληρώθηκε.");
    translation.put("LABEL_SEARCH_RUNNING", "Αναζήτηση σε εξέλιξη");
    translation.put("LABEL_OPTIONS", "Ρυθμίσεις");
    translation.put("LABEL_INTENSIVE_SEARCH", "Σχολαστική αναζήτηση");
    translation.put("LABEL_PREFERED_LANGUAGE", "Προτιμώμενη γλώσσα");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_DESCRIPTION", "Περιγραφή");
    translation.put("LABEL_CREATED", "Δημιουργήθηκε");
    translation.put("LABEL_LAST_VISIT", "Τελευταία επίσκεψη");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Χρήση διακομιστή μεσολάβησης για όλα τα αγαπημένα");
    translation.put("LABEL_NEWS_RATED", "Βαθμολόγηση νέων");
    translation.put("LABEL_SEARCH_TOPIC", "Παρακαλώ προσδιορίστε την αναζήτηση σας");
    translation.put("LABEL_NAME", "Όνομα");
    translation.put("LABEL_KEY_SEQUENCE", "Συνδυασμός πλήκτρων");
    translation.put("LABEL_CURRENT_COLOR", "Τρέχων χρώμα");
    translation.put("LABEL_SELECT_ENCODING", "Επιλογή κωδικοποίησης");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Εμπλουτισμένο κείμενο (HTML)");
    translation.put("LABEL_MAIL_SUBJECT", "Θέμα");
    translation.put("LABEL_MAIL_BODY", "Κείμενο μηνύματος");
    translation.put("LABEL_MAIL_USAGE", "Χρησιμοποιήστε τα  [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] και [DESCRIPTION] ως χαρακτήρες μπαλαντέρ");
    translation.put("LABEL_EMPTY_LINK", "Χωρίς σύνδεσμο");
    translation.put("LABEL_SIZE", "Μέγεθος");
    translation.put("LABEL_STYLE", "Στυλ");
    translation.put("LABEL_USED_BY", "Χρησιμοποιείται από");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Ο συνδυασμός πλήκτρων δεν είναι έγκυρος!");
    translation.put("LABEL_USE_SYSTEM_FONT", "Χρήση γραμματοσειράς συστήματος");
    translation.put("LABEL_BLOGGER_USAGE", "Χρησιμοποιήστε τα  [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] και [TITLE] ως χαρακτήρες μπαλαντέρ");
    translation.put("LABEL_SEARCH_RESULTS", "Η αναζήτηση για  \"%TERM%\" επέστρεψε %NUM% αποτελέσματα");
    translation.put("LABEL_SEARCH_EMPTY", "Η αναζήτηση για  \"%TERM%\" δεν επέστρεψε κανένα αποτέλεσμα.");
    translation.put("LABEL_SINGLE_CLICK", "Μονό κλικ");
    translation.put("LABEL_DOUBLE_CLICK", "Διπλό κλικ");
    translation.put("LABEL_SELECT_BLOGGER", "Επιλογή εξωτερικού προγράμματος περιήγησης");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Να ξαναφορτώνονται τα τελευταία ανοιγμένα feeds, κατά την εκκίνηση");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Παρακαλώ επιλέξτε μια από τις δύο διατάξεις");
    translation.put("LABEL_TRADITIONAL_TABS", "Τυπικές Σελίδες");
    translation.put("LABEL_CURVED_TABS", "Στρογγυλεμένες Σελίδες");
    translation.put("LABEL_READY", "Έτοιμος");
    translation.put("LABEL_OLD_ID", "Παλιό Όνομα Χρήστη (προαιρετικό)");
    translation.put("LABEL_AMPHETARATE_ID", "Όνομα Χρήστη");
    translation.put("LABEL_VALIDATION_FINISHED", "Ο Έλεγχος Ολοκληρώθηκε");
    translation.put("LABEL_VALIDATING", "Έλεγχος σε εξέλιξη");
    translation.put("LABEL_OVERRIDE_DTD", "Override Doctype Declaration");
    translation.put("LABEL_FEED_TYPE", "Τύπος");
    translation.put("LABEL_ADDRESS", "Διεύθυνση");
    translation.put("LABEL_BROWSER_USAGE", "Χρήση του [URL] ως παράμετρου αντικατάστασης για την διεύθυνση.");
    translation.put("LABEL_REMEMBER_AUTH", "Αποθήκευση ονόματος χρήστη και κωδικού");
    translation.put("LABEL_SORT_EXPLANATION", "Το RSSOwl αρχικά προσπαθεί να ταξινομήσει τα νέα με την πρώτη καταχώρηση της λίστας. Σε περίπτωση που αυτή δεν είναι διαθέσιμη, το πρόγραμμα συνεχίζει με την επόμενη της λίστας.");
    translation.put("LABEL_SORT_ORDER", "Ταξινόμηση Νέων");
    translation.put("LABEL_NOT_UNSUPPORTED", "Δεν υποστηρίζεται ακόμη στο λειτουργικό σας σύστημα");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Οι ρυθμίσεις και οι τιμές που ορίζονται εδώ θα χρησιμοποιηθούν ως αρχικές σε κάθε νέο αγαπημένο.");
    translation.put("LABEL_RESTART", "Για να ισχύσουν οι αλλαγές πρέπει να επανεκκινήσετε το RSSOwl.");
    translation.put("LABEL_WELCOME_TITLE", "Καλώς ήρθατε  στο πρόγραμμα RSSOwl - έναν αναγνώστη για RSS / RDF / Atom τροφοδοτήσεις");
    translation.put("LABEL_FIRST_STEPS", "Πρώτα Βήματα");
    translation.put("LABEL_NEWS", "Νέα");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Χορηγία");
    translation.put("LABEL_DISCUSSION_FORUM", "Φόρουμ συζητήσεων");
    translation.put("LABEL_PROMOTION", "Διαφήμιση");
    translation.put("LABEL_CONTACT", "Επικοινωνία");
    translation.put("LABEL_START", "Έναρξη");
    translation.put("LABEL_DOWNLOAD", "Λήψη Αρχείου");
    translation.put("LABEL_MAX_CONNECTIONS", "Μέγιστος αριθμός συνδέσεων");
    translation.put("LABEL_CON_TIMEOUT", "Χρόνος μη απόκρισης της σύνδεσης σε δευτερόλεπτα");
    translation.put("LABEL_DELETE_FAVORITE", "Διαγραφή ενός αγαπημένου");
    translation.put("LABEL_DELETE_CATEGORY", "Διαγραφή μιας κατηγορίας");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Διαγραφή Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Η εγγραφή έγινε με επιτυχία");
    translation.put("LABEL_SHOW", "Προβολή");
    translation.put("LABEL_SEARCH_IN", "Αναζήτηση σε");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Άνοιγμα");
    translation.put("BUTTON_RELOAD_CAT", "Επαναφόρτωση αγαπημένων");
    translation.put("BUTTON_ADD", "Προσθήκη");
    translation.put("BUTTON_FILE", "Επιλογή αρχείου");
    translation.put("BUTTON_SEARCH", "Έυρεση");
    translation.put("BUTTON_RELOAD", "Ανανέωση νέων");
    translation.put("BUTTON_CANCLE", "Άκυρο");
    translation.put("BUTTON_EXPORT", "Εξαγωγή");
    translation.put("BUTTON_STOP_SEARCH", "Διακοπή εύρεσης");
    translation.put("BUTTON_CLEAR_RESULTS", "Καθαρισμός αποτελεσμάτων");
    translation.put("BUTTON_ADDTO_FAVORITS", "Προσθήκη στα αγαπημένα");
    translation.put("BUTTON_EXPORT_TO_OPML", "Εξαγωγή σε OPML");
    translation.put("BUTTON_ASSIGN", "Ορισμός");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Επαναφορά προκαθορισμένων ρυθμίσεων");
    translation.put("BUTTON_APPLY", "Εφαρμογή");
    translation.put("BUTTON_CHANGE_FONT", "Αλλαγή γραμματοσειράς");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_CHANGE", "Αλλαγή");
    translation.put("BUTTON_MARK_ALL_READ", "Σήμανση όλων των αγαπημένων ως αναγνωσμένων");
    translation.put("BUTTON_AGGREGATE_ALL", "Συγχώνευση όλων των αγαπημένων");
    translation.put("BUTTON_RELOAD_ALL", "Επαναφόρτωση όλων των αγαπημένων");
    translation.put("BUTTON_SEARCH_ALL", "Αναζήτηση σε όλα τα αγαπημένα");
    translation.put("BUTTON_CREATE_ACCOUNT", "Δημιουργία Λογαριασμού");
    translation.put("BUTTON_DISPLAY_TABS", "Προβολή των νέων σε σελίδες");
    translation.put("BUTTON_FOCUS_TABS", "Εστίαση στις νέες σελίδες");
    translation.put("BUTTON_STOP_VALIDATION", "Διακοπή");
    translation.put("BUTTON_VALIDATE", "Έλεγχος");
    translation.put("BUTTON_TRAY_STARTUP", "Ελαχιστοποίηση του RSSOwl στον χώρο των ειδοποιήσεων κατά την εκκίνηση");
    translation.put("BUTTON_TRAY_EXIT", "Ελαχιστοποίηση του RSSOwl στον χώρο των ειδοποιήσεων κατά την έξοδο");
    translation.put("BUTTON_SHOW_ERRORS", "Προβολή σφαλμάτων μέσα στην σελίδα");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Σήμανση όλων ως αναγνωσμένων, κατά την ελαχιστοποίηση");
    translation.put("BUTTON_TRAY_POPUP", "Ειδοποιήση όταν υπάρχουν μη αναγνωσμένα μηνύματα");
    translation.put("BUTTON_READ_ON_CLOSE", "Σήμανση ως αναγνωσμένου όταν κλείνει η σελίδα");
    translation.put("BUTTON_UP", "Πάνω");
    translation.put("BUTTON_DOWN", "Κάτω");
    translation.put("BUTTON_NO_SORT", "Να μην ταξινομούνται αυτόματα τα νέα");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Αυτόματο κλείσιμο των αναδυόμενων νέων");
    translation.put("BUTTON_CACHE_FEEDS", "Αυτόματη αποθήκευση των νέων για διάβασμα αργότερα");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Άνοιγμα σε πρόγραμμα περιήγησης");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Εμφάνιση κουμπιού κλεισίματος στις σελίδες");
    translation.put("BUTTON_DELETE_FAVORITE", "Κατά την διαγραφή ενός αγαπημένου");
    translation.put("BUTTON_DELETE_CATEGORY", "Κατά την διαγραφή μιας κατηγορίας");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Κατά την διαγραφή ενός Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Να μην ερωτηθώ ξανά");
    translation.put("BUTTON_BLOCK_POPUPS", "Μπλοκάρισμα των αναδυόμενων παραθύρων");
    translation.put("BUTTON_ANIMATE_POPUP", "Κινούμενο αναδυόμενο παράθυρο");
    translation.put("BUTTON_REMOVE", "Διαγραφή");
    translation.put("BUTTON_SMALL_ICONS", "Μικρά εικονίδια");
    translation.put("BUTTON_LINK_TAB", "Σύνδεση με το εμφανιζόμενο νέο");
    translation.put("BUTTON_CLEAR", "Καθαρισμός");

    /** Header */
    translation.put("HEADER_NEWS", "Νέα");
    translation.put("HEADER_RSS_FAVORITES", "Αγαπημένα");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Παρακαλώ κάντε διπλό κλικ για να ανοίξετε το Δικτυακό τόπο!");
    translation.put("TOOLTIP_PRINT", "Εκτύπωση νέων");
    translation.put("TOOLTIP_RATE", "Παρακαλώ κάντε κλικ για να βαθμολογήσετε");
    translation.put("TOOLTIP_GRAB_TITLE", "Τίτλος από το newsfeed");
    translation.put("TOOLTIP_SKIP", "Παράβλεψη");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Υπάρχουν μη Αναγνωσμένα Νέα");
    translation.put("TOOLTIP_OPEN_TAB", "Άνοιγμα σε νέα σελίδα");
    translation.put("TOOLTIP_QUICKSEARCH", "Γρήγορη αναζήτηση");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Ημερομηνία Έκδοσης");
    translation.put("TABLE_HEADER_AUTHOR", "Συγγραφέας");
    translation.put("TABLE_HEADER_CATEGORY", "Κατηγορία");
    translation.put("TABLE_HEADER_PUBLISHER", "Εκδότης");
    translation.put("TABLE_HEADER_NEWSTITLE", "Τίτλος νέων");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "Σύνδεσμος Newsfeed");
    translation.put("TABLE_HEADER_FEEDTITLE", "Τίτλος Newsfeed");
    translation.put("TABLE_HEADER_LINE", "Γραμμή");
    translation.put("TABLE_HEADER_STATUS", "Ανάγνωση κατάστασης");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Ημερομηνία έκδοσης");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Hμερομηνία τελευταίας τροποποίησης");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "E-mail διεύθυνση εκδότη");
    translation.put("CHANNEL_INFO_WEBMASTER", "E-mail διεύθυνση Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Κατηγορία");
    translation.put("CHANNEL_INFO_DOCS", "URL");
    translation.put("CHANNEL_INFO_TTL", "Channel time to live");
    translation.put("CHANNEL_INFO_RSSVERSION", "Μορφή");
    translation.put("CHANNEL_INFO_GENERATOR", "Γεννήτρια RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Εκδότης");
    translation.put("CHANNEL_INFO_LANGUAGE", "Γλώσσα");
    translation.put("CHANNEL_INFO_CREATOR", "Δημιουργός");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Ενημέρωση");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "φορές");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Ιστοσελίδα");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Πηγή");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Επισυναπτόμενο");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Παρατηρήσεις");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Παρατηρήσεις");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Προσοχή");
    translation.put("MESSAGEBOX_FILL_URL", "Παρακαλώ καταχωρήστε μια διεύθυνση");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Μια κατηγορία με το ίδιο όνομα υπάρχει ήδη");
    translation.put("MESSAGEBOX_SELECT_CAT", "Παρακαλώ επιλέξτε μια κατηγορία");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Το αρχείο υπάρχει ήδη. Θέλετε να αντικατασταθεί το υπάρχον αρχείο;");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Το αρχείο δεν περιέχει ρυθμίσεις για το πρόγραμμα RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Η εισαγωγή των ρυθμίσεων έγινε με επιτυχία!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Το κείμενο των νέων είναι κενό! Παρακαλώ επιλέξτε νέα.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Προσθήκη νέου αγαπημένου");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Προσθήκη νέας κατηγορίας");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Παρακαλώ δώστε έναν τίτλο");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Παρακαλώ καταχωρήστε την διεύθυνση και τον τίτλο");
    translation.put("BASE_AUTH_TITLE", "Ο τόπος που ζητήσατε απαιτεί έλεγχο πρόσβασης!");
    translation.put("BASE_AUTH_MESSAGE", "Παρακαλώ εισάγετε το όνομα και των κωδικό σας.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Επιλέχθηκε μη αποδεκτό RSS!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Παρακαλώ επιβεβαιώστε");
    translation.put("SEARCH_DIALOG_TITLE", "Εύρεση");
    translation.put("SEARCH_DIALOG_MESSAGE", "Χρησιμοποιήστε τους τελεστές AND, OR και NOT για να προσδιορίστε την αναζήτηση!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Εύρεση για");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Μόνο ολόκληρες λέξεις");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Ταίριασμα πεζών - κεφαλαίων");
    translation.put("SEARCH_DIALOG_REGEX", "Χρήση κανονικής έκφρασης");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Δεν υπάρχει νέα έκδοση");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Χρησιμοποιείτε ήδη την νεώτερη έκδοση του RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Πληροφορία");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Επεξεργασία κατηγορίας");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Επεξεργασία αγαπημένου");
    translation.put("DIALOG_TITLE_UPDATE", "Υπάρχει νέα έκδοση του RSSOwl ");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Παρακαλώ εισάγετε την πλήρη διαδρομή για το πρόγραμμα περιήγησης");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Δεν είναι δυνατή η σύνδεση με την ιστοσελίδα http://www.rssowl.org");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Σφάλμα κατά την εκτέλεση του προγράμματος περιήγησης!\nΠαρακαλώ επιλέξτε κάποιο πρόγραμμα περιήγησης από τις 'Προτιμήσεις'");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Παρακαλώ επιλέξτε την διαδρομή του προγράμματος");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Παρακαλώ έναν συνδυασμό πλήκτρων");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Δεν περιέχονται αγαπημένα στην κατηγορία!");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Θα πρέπει πρώτα να ορίστε κάποιο blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Επιλέξτε μια Κατηγορία");
    translation.put("DIALOG_ID_ATTENTION", "Πρέπει να δημιουργήσετε έναν AmphetaRate λογαριασμό!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Παρακαλώ καταχωρήστε την διεύθυνση της ιστοσελίδας");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "Το RSSOwl δεν μπόρεσε να εντοπίσει καμία εφαρμογή για να εμφανίσει αρχεία %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Επεξεργασία Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Το εσωτερικό πρόγραμμα περιήγησης δεν μπόρεσε να φορτωθεί!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Προσθήκη ενός νέου Blogroll");
    translation.put("QUESTION_DEL_FAV", "Είστε σίγουροι ότι θέλετε να διαγράψετε το αγαπημένο \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Είστε σίγουροι ότι θέλετε να διαγράψετε την κατηγορία \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Είστε σίγουροι ότι θέλετε να διαγράψετε το  Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Πίσω");
    translation.put("BROWSER_FORWARD", "Εμπρός");
    translation.put("BROWSER_STOP", "Διακοπή");

    /** Keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Καταπληκτικό");
    translation.put("RATE_GOOD", "Καλό");
    translation.put("RATE_MODERATE", "Μέτριο");
    translation.put("RATE_BAD", "Κακό");
    translation.put("RATE_VERY_BAD", "Πολύ κακό");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "Ποτέ");
    translation.put("UPDATE_INTERVAL_ONE", "Κάθε λεπτό");
    translation.put("UPDATE_INTERVAL_FIVE", "κάθε 5 λεπτά");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "Κάθε 15 λεπτά");
    translation.put("UPDATE_INTERVAL_THIRTY", "Κάθε 30 λεπτά");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "Κάθε ώρα");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "Κάθε 3 ώρες");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "μετά από 6 ώρες");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "Κάθε 12 ώρες");
    translation.put("UPDATE_INTERVAL_ONEDAY", "Κάθε 24 ώρες");

    /** Font settings */
    translation.put("FONT_STYLE_BOLD", "Έντονα");
    translation.put("FONT_STYLE_ITALIC", "Πλάγια");
    translation.put("FONT_STYLE_NORMAL", "Κανονικά");
    translation.put("FONT_AREA_TEXT", "Γραμματοσειρά του κειμένου");
    translation.put("FONT_AREA_DIALOG", "Γραμματοσειρά των διαλόγων");
    translation.put("FONT_AREA_TREE", "Γραμματοσειρά του δέντρου");
    translation.put("FONT_AREA_TABLE", "Γραμματοσειρά των πινάκων");
    translation.put("FONT_AREA_HEADER", "Γραμματοσειρά των επικεφαλίδων");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Η γραμματοσειρά του κειμένου χρησιμοποιείται στο κείμενο των μηνυμάτων, στις πληροφορίες των καναλιών, στα διάφορα μηνύματα και σφάλματα.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Η γραμματοσειρά των διαλόγων χρησιμοποιείται σε όλους τους διάλογους.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Η γραμματοσειρά του δέντρου χρησιμοποιείται στο δέντρο που εμφανίζει τα αγαπημένα.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Η γραμματοσειρά των πινάκων χρησιμοποιείται για τους πίνακες που παρουσιάζουν τα νέα.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Η γραμματοσειρά των επικεφαλίδων χρησιμοποιείται στις επικεφαλίδες όλων των τμημάτων.");

    /** Groups */
    translation.put("GROUP_COMMAND", "Εντολή");
    translation.put("GROUP_SELECTED_FONT", "Επιλεγμένη γραμματοσειρά");
    translation.put("GROUP_FONT_AREA", "Κύρια γραμματοσειρά");
    translation.put("GROUP_WINDOW_LAYOUT", "Διάταξη Παραθύρων");
    translation.put("GROUP_ARGUMENTS", "Παράμετροι");
    translation.put("GROUP_LINK_COLOR", "Χρώμα Συνδέσμων");
    translation.put("GROUP_OPEN_MODE", "Άνοιγμα με");
    translation.put("GROUP_TAB_LAYOUT", "Μορφή Σελίδων");
    translation.put("GROUP_EXISTING_ACCOUNT", "Υπάρχων Λογαριασμός");
    translation.put("GROUP_NEW_ACCOUNT", "Δημιουργία Νέου Λογαριασμού");
    translation.put("GROUP_TRAY", "Χώρος Ειδοποιήσεων");
    translation.put("GROUP_GENERAL", "Γενικά");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Χρώμα αποτελεσμάτων αναζήτησης");
    translation.put("GROUP_NEWS_POPUP", "Αναδυόμενο παράθυρο νέων");
    translation.put("GROUP_CONFIRM_DIALOG", "Εμφάνιση διαλόγου επιβεβαίωσης");

    /** Languages */
    translation.put("en", "Αγγλικά");
    translation.put("de", "Γερμανικά");
    translation.put("fr", "Γαλλικά");
    translation.put("es", "Ισπανικά");
    translation.put("gl", "Γαλικικά");
    translation.put("da", "Δανικά");
    translation.put("it", "Ιταλικά");
    translation.put("nl", "Ολλανδικά");
    translation.put("el", "Ελληνικά");
    translation.put("ru", "Ρωσικά");
    translation.put("pt", "Πορτογαλικά (Βραζιλίας)");
    translation.put("bg", "Βουλγαρικά");
    translation.put("no", "Νορβηγικά");
    translation.put("zhcn", "Κινέζικα");
    translation.put("ja", "Γιαπωνέζικα");
    translation.put("pl", "Πολωνικά");
    translation.put("ko", "Κορεάτικα");
    translation.put("sv", "Σουηδικά");
    translation.put("bn", "Βεγγαλικά");
    translation.put("uk", "Ουκρανικά");
    translation.put("fi", "Φινλανδικά");
    translation.put("zhtw", "Κινεζικά Παραδοσιακά");
    translation.put("uk", "Ουκρανικά");
    translation.put("cs", "Τσεχικά");
    translation.put("sl", "Σλοβενικά");
    translation.put("tr", "Τουρκικά");
    translation.put("hu", "Ουγγρικά");
    translation.put("th", "Ταϊλανδική");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Δεν υπάρχει διαθέσιμη περιγραφή!");
    translation.put("PRINTED_FROM_RSSOWL", "Εκτυπώθηκε από το πρόγραμμα RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Εκτύπωση νέων από το RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Εμφάνιση RSSOwl");
    translation.put("TAB_WELCOME", "Καλώς ήρθατε");
    translation.put("DOCUMENT_GENERATED_FROM", "Το έγγραφο δημιουργήθηκε από το πρόγραμμα RSSOwl");
    translation.put("NO_TITLE", "Χωρίς τίτλο");
    translation.put("RSSOWL_TEASER", "Το πρόγραμμα RSSOwl είναι ένας ελεύθερος, ανοιχτού λογισμικού, αναγνώστης μηνυμάτων RSS / RDF / Atom. Ειδικά χαρακτηριστικά:\n\n- Εξαγωγή νέων σε PDF, HTML, RTF, OPML\n- Εισαγωγή αγαπημένων από το OPML\n- Πλήρη αναζήτηση κειμένου με χρωματισμό των αποτελεσμάτων\n- Ισχυρή RSS / RDF / Atom μηχανή αναζήτησης \n- Εμφάνιση μηνυμάτων σε εσωτερικό περιηγητή\n- Διαχείριση αγαπημένων σε κατηγορίες\n- Εκτελείται σε Windows, Linux, Solaris και Mac\n\nΓια μια πλήρη λίστα των χαρακτηριστικών του προγράμματος, επισκεφτείτε την ιστοσελίδα: http://www.rssowl.org/overview\n\nΛήψη αρχείων από: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Προτεινόμενα άρθρα");
    translation.put("LOAD_FEED", "Φόρτωση");
    translation.put("SEARCH_FEED", "Αναζήτηση");
    translation.put("RELOAD_FEED", "Επαναφόρτωση");
    translation.put("FORMAT_AUTO_DETECT", "Αυτόματη Αναγνώριση");
    translation.put("NEWSFEED_VALID", "Το NewsFeed είναι έγκυρο");
    translation.put("MAIL_ERROR_BODY", "Παρακαλώ επισυνάψτε το αρχείο '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' στο μήνυμα και δώστε μια σύντομη περιγραφή για το τι έκανε το RSSOwl πριν συμβεί το σφάλμα. Ευχαριστούμε!");
    translation.put("OPML_IMPORTED", "Εισήχθησαν");
    translation.put("ENTIRE_NEWS", "Σύνολο Νέων");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}