/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * English internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nEN extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nEN(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "File");
    translation.put("MENU_SAVE", "Save As");
    translation.put("MENU_IMPORT", "Import Settings");
    translation.put("MENU_EXPORT", "Export Settings");
    translation.put("MENU_EXIT", "Exit");
    translation.put("MENU_WINDOW", "View");
    translation.put("MENU_QUICKVIEW", "Quickview");
    translation.put("MENU_TOOLBAR", "Toolbar");
    translation.put("MENU_PREFERENCES", "Preferences");
    translation.put("MENU_FONT", "Font");
    translation.put("MENU_LANGUAGE", "Language");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Misc");
    translation.put("MENU_SYSTRAY", "Minimize RSSOwl to the System Tray");
    translation.put("MENU_DIRECTOPEN", "Open news without text automatically in browser");
    translation.put("MENU_DIRECTOPENEACH", "Open any news automatically in browser");
    translation.put("MENU_OPENNEW_BROWSER", "Always open Browser into a new tab");
    translation.put("MENU_CHANNELINFO", "Show Newsfeed Info");
    translation.put("MENU_BROWSER_EXTERN", "Use external Browser");
    translation.put("MENU_INFO", "Help");
    translation.put("MENU_ABOUT", "About RSSOwl");
    translation.put("MENU_GENERATE_PDF", "Generate PDF");
    translation.put("MENU_GENERATE_RTF", "Generate RTF");
    translation.put("MENU_GENERATE_HTML", "Generate HTML");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generate PDF from selected Message");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generate HTML from selected Message");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generate RTF from selected Message");
    translation.put("MENU_BROWSER", "Browser");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Use external Browser");
    translation.put("MENU_DONATE", "Donate");
    translation.put("MENU_ENCODING", "Text Encoding");
    translation.put("MENU_LICENSE", "License");
    translation.put("MENU_UPDATE", "Check for Version Update");
    translation.put("MENU_WELCOME", "Welcome");
    translation.put("MENU_MAILING_LIST", "Mailing List");
    translation.put("MENU_CHECK_UPDATE", "Check for updates after startup");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "View Newstext in Browser");
    translation.put("MENU_TOOLS", "Tools");
    translation.put("MENU_FEEDSEARCH", "Search for Newsfeeds");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimize RSSOwl");
    translation.put("MENU_GOTO", "Go");
    translation.put("MENU_NEXT_NEWS", "Next Message");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Next Unread Message ");
    translation.put("MENU_CLOSE", "Close");
    translation.put("MENU_CLOSE_ALL", "Close All");
    translation.put("MENU_PREVIOUS_TAB", "Previous Tab");
    translation.put("MENU_NEXT_TAB", "Next Tab");
    translation.put("MENU_HOTKEYS", "Hotkeys");
    translation.put("MENU_NEWSTIP_MAIL", "Format NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Tell Your Friends");
    translation.put("MENU_RELOAD", "Reload");
    translation.put("MENU_TUTORIAL", "Tutorial");
    translation.put("MENU_COLORS", "Colors");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_IMPORT_OPML", "Import from OPML");
    translation.put("MENU_VALIDATE", "Validate Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "Discover Newsfeeds on a Website");
    translation.put("MENU_DISPLAY_FEED_PDF", "Show Newsfeed in PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Show Newsfeed in RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Show Newsfeed in HTML");
    translation.put("MENU_EDIT", "Edit");
    translation.put("MENU_EDIT_COPY", "Copy");
    translation.put("MENU_EDIT_PASTE", "Paste");
    translation.put("MENU_EDIT_SELECT_ALL", "Select All");
    translation.put("MENU_EDIT_DELETE", "Delete");
    translation.put("MENU_EDIT_CUT", "Cut");
    translation.put("MENU_EDIT_RENAME", "Rename");
    translation.put("MENU_NEW_FAVORITE", "New Favorite");
    translation.put("MENU_CONNECTION", "Connection");
    translation.put("MENU_WORK_OFFLINE", "Work Offline");
    translation.put("MENU_WORK_ONLINE", "Work Online");

    /** Toolbar */
    translation.put("TOOL_NEWSTIP", "NewsTip");
    translation.put("TOOL_MARK", "Mark");
    translation.put("TOOL_NEXT", "Next");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Icons and Text");
    translation.put("TOOL_ICONS", "Icons");
    translation.put("TOOL_TEXT", "Text");
    translation.put("TOOL_RATE", "Rate");
    translation.put("TOOL_HISTORY", "History");

    /** Popup Menu */
    translation.put("POP_NEW", "New");
    translation.put("POP_SUB_CATEGORY", "Sub-Category");
    translation.put("POP_UNSUBSCRIBE", "Unsubscribe");
    translation.put("POP_IMPORT", "Import");
    translation.put("POP_FROM_OPML", "From OPML File");
    translation.put("POP_EXPORT_OPML", "To OPML File");
    translation.put("POP_COPY", "Copy");
    translation.put("POP_OPEN_IN_BROWSER", "Open Selection in Browser");
    translation.put("POP_AUTO_UPDATE", "Update Automatically");
    translation.put("POP_UPDATE_ONSTARTUP", "on Startup");
    translation.put("POP_MARK_UNREAD", "Mark Unread");
    translation.put("POP_COPY_NEWS_URL", "Copy Link");
    translation.put("POP_RATE_NEWS", "Rate News");
    translation.put("POP_MAIL_LINK", "Send Newstip");
    translation.put("POP_AGGREGATE_FAV", "Aggregate Favorites");
    translation.put("POP_USEPROXY", "Use Proxy");
    translation.put("POP_OPEN_EXTERN", "Open Externally");
    translation.put("POP_BLOG_NEWS", "Blog News");
    translation.put("POP_OPEN_STARTUP", "Open on Startup");
    translation.put("POP_KEEP_CURRENT", "Close Others");
    translation.put("POP_KEEP_NEWSFEEDS", "Close all except Newsfeeds");
    translation.put("POP_MARK_ALL_READ", "Mark All as Read");
    translation.put("POP_MARK_CATEGORY_READ", "Mark Category as read");
    translation.put("POP_PROPERTIES", "Properties");
    translation.put("POP_TAB_POSITION", "Position");
    translation.put("POP_TAB_POS_TOP", "Top");
    translation.put("POP_TAB_POS_BOTTOM", "Bottom");
    translation.put("POP_MARK_FAVORITE_READ", "Mark Favorite as Read");
    translation.put("POP_IMPORT_BLOGROLL", "Synchronized Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synchronize");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Customize Toolbar");
    translation.put("POP_CLEAR_HISTORY", "Clear History");

    /** Errors in RSSOwl */
    translation.put("ERROR_NOT_A_XML", "The file is not a valid XML File");
    translation.put("ERROR_NOT_A_RSS", "The XML Document is not a valid RSS, RDF or Atom Newsfeed");
    translation.put("ERROR_NOT_A_OPML", "The XML Document is not a valid OPML File");
    translation.put("ERROR_UNEXPECTED", "An unexpected Error occurred!\nRSSOwl has to Shut Down. The Current Settings will be saved.\nError logged in '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nDo you want to send an Error Report to the RSSOwl Team?");
    translation.put("ERROR_CAT_EXISTS", "A Category with that name already exists!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "A Favorite with that name already exists!");
    translation.put("ERROR_FAV_URL_EXISTS", "A Favorite with that URL already exists!");
    translation.put("ERROR_NO_NEWS_FOUND", "Error: Unable to locate any news!");
    translation.put("ERROR_SUB_EXISTS", "You're already subscribed to that Blogroll!");
    translation.put("ERROR_CONNECTION_FAILED", "Connection Failed!");
    translation.put("ERROR_GRABTITLE_FAILED", "Unable to locate Title!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl is not able to display that Newsfeed.");
    translation.put("ERROR_FILE_NOT_FOUND", "Unable to locate that file. ");
    translation.put("ERROR_AUTH_REQUIRED", "Authentication to access the Newsfeed is required.");
    translation.put("ERROR_REASON", "Reason");
    translation.put("ERROR_LOADING_FEED", "Error loading Newsfeed \"%TITLE%\"");
    translation.put("ERROR_WORKING_OFFLINE", "The Newsfeed can not be accessed offline");
    translation.put("ERROR_HTTP_STATUS", "Status");

    /** Labels */
    translation.put("LABEL_NO_INFOS", "No further information available.");
    translation.put("LABEL_FAVORITE", "Favorite");
    translation.put("LABEL_USE_PROXY", "Use Proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy requires Authentication");
    translation.put("LABEL_USERNAME", "Username");
    translation.put("LABEL_PASSWORD", "Password");
    translation.put("LABEL_URL_PATH", "URL/Path");
    translation.put("LABEL_CATEGORY", "Category");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_TITLE", "Title");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Use Proxy for All Favorites");
    translation.put("LABEL_NEWS_RATED", "News Rated");
    translation.put("LABEL_SEARCH_TOPIC", "Enter Search");
    translation.put("LABEL_SEARCH_FINISHED", "Search completed.");
    translation.put("LABEL_SEARCH_RUNNING", "Searching");
    translation.put("LABEL_OPTIONS", "Options");
    translation.put("LABEL_INTENSIVE_SEARCH", "Thorough Search");
    translation.put("LABEL_PREFERED_LANGUAGE", "Preferred Language");
    translation.put("LABEL_DESCRIPTION", "Description");
    translation.put("LABEL_CREATED", "Created");
    translation.put("LABEL_LAST_VISIT", "Last Visit");
    translation.put("LABEL_NAME", "Name");
    translation.put("LABEL_KEY_SEQUENCE", "Key Sequence");
    translation.put("LABEL_USED_BY", "Used by");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Cannot use that Key Sequence!");
    translation.put("LABEL_SIZE", "Size");
    translation.put("LABEL_STYLE", "Style");
    translation.put("LABEL_SELECT_ENCODING", "Select Text Encoding");
    translation.put("LABEL_MAIL_SUBJECT", "Subject");
    translation.put("LABEL_MAIL_BODY", "Message Body");
    translation.put("LABEL_MAIL_USAGE", " Use [TITLE], [LINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] and [SOURCE] as replaceable parameters for the news information. ");
    translation.put("LABEL_EMPTY_LINK", "No link given");
    translation.put("LABEL_USE_SYSTEM_FONT", "Use System Font");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Format E-Mail using HTML");
    translation.put("LABEL_CURRENT_COLOR", "Current color");
    translation.put("LABEL_CATEGORY", "Category");
    translation.put("LABEL_SEARCH_RESULTS", "The search for \"%TERM%\" produced %NUM% results");
    translation.put("LABEL_SEARCH_EMPTY", "The search for \"%TERM%\" delivered no results.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Please select one of the two Window-Layouts");
    translation.put("LABEL_SINGLE_CLICK", "Single click");
    translation.put("LABEL_DOUBLE_CLICK", "Double click");
    translation.put("LABEL_SELECT_BLOGGER", "Select external Blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Use [NEWSLINK], [FEEDLINK], [TITLE], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER] and [SOURCE] as replaceable parameters for the news information.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Re-Open last opened feeds on startup");
    translation.put("LABEL_TRADITIONAL_TABS", "Traditional tabs");
    translation.put("LABEL_CURVED_TABS", "Curved tabs");
    translation.put("LABEL_READY", "Ready");
    translation.put("LABEL_VALIDATION_FINISHED", "Validation finished");
    translation.put("LABEL_VALIDATING", "Validating");
    translation.put("LABEL_FEED_TYPE", "Type of Newsfeed");
    translation.put("LABEL_OVERRIDE_DTD", "Override Doctype Declaration");
    translation.put("LABEL_ADDRESS", "Address");
    translation.put("LABEL_BROWSER_USAGE", "Use [URL] as replaceable parameter for the URL.");
    translation.put("LABEL_OLD_ID", "Old User ID (optional)");
    translation.put("LABEL_AMPHETARATE_ID", "User ID");
    translation.put("LABEL_REMEMBER_AUTH", "Remember Username and Password");
    translation.put("LABEL_SORT_ORDER", "News Sorting");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl first attempts to sort the newsfeed by the top item of the list. In case that item is not available in the newsfeed, RSSOwl continues with the next item from the list.");
    translation.put("LABEL_NOT_UNSUPPORTED", "This feature is not yet supported on your operating system");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "The values that are adjustable here will be taken as initial values for any new favorite.");
    translation.put("LABEL_RESTART", "The changes require a restart of RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Welcome to RSSOwl - Newsreader for RSS / RDF / Atom Newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "First Steps");
    translation.put("LABEL_NEWS", "News");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Support");
    translation.put("LABEL_DISCUSSION_FORUM", "Discussion Forum");
    translation.put("LABEL_PROMOTION", "Promotion");
    translation.put("LABEL_CONTACT", "Contact");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Download");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximum number of connections");
    translation.put("LABEL_CON_TIMEOUT", "Connection timeout in seconds");
    translation.put("LABEL_DELETE_FAVORITE", "Delete Favorite");
    translation.put("LABEL_DELETE_CATEGORY", "Delete Category");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Delete Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registration Successful!");
    translation.put("LABEL_DOMAIN", "Domain");
    translation.put("LABEL_SHOW", "Show");
    translation.put("LABEL_SEARCH_IN", "Search In");

    /** Buttons */
    translation.put("BUTTON_ADD", "Add");
    translation.put("BUTTON_FILE", "Open File");
    translation.put("BUTTON_OPEN", "Open");
    translation.put("BUTTON_RELOAD", "Reload News");
    translation.put("BUTTON_CANCLE", "Cancel");
    translation.put("BUTTON_RELOAD_CAT", "Reload Favorites");
    translation.put("BUTTON_EXPORT", "Export");
    translation.put("BUTTON_SEARCH", "Search");
    translation.put("BUTTON_STOP_SEARCH", "Stop Search");
    translation.put("BUTTON_CLEAR_RESULTS", "Clear Results");
    translation.put("BUTTON_EXPORT_TO_OPML", "Export to OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Add to Favorites");
    translation.put("BUTTON_ASSIGN", "Assign");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Restore Defaults");
    translation.put("BUTTON_APPLY", "Apply");
    translation.put("BUTTON_CHANGE_FONT", "Change Font");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Validate");
    translation.put("BUTTON_FOCUS_TABS", "Set focus on new tabs");
    translation.put("BUTTON_DISPLAY_TABS", "Display newsfeeds in tabs");
    translation.put("BUTTON_TRAY_STARTUP", "Place RSSOwl in system tray on startup");
    translation.put("BUTTON_TRAY_EXIT", "Place RSSOwl in system tray on exit");
    translation.put("BUTTON_CHANGE", "Change");
    translation.put("BUTTON_MARK_ALL_READ", "Mark All Favorites as Read");
    translation.put("BUTTON_AGGREGATE_ALL", "Aggregate All Favorites");
    translation.put("BUTTON_RELOAD_ALL", "Reload All Favorites");
    translation.put("BUTTON_SEARCH_ALL", "Search in All Favorites");
    translation.put("BUTTON_CREATE_ACCOUNT", "Create Account");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Mark all news read on minimize");
    translation.put("BUTTON_TRAY_POPUP", "Show Popup when unread news are available");
    translation.put("BUTTON_READ_ON_CLOSE", "Mark newsfeed read when closing tab");
    translation.put("BUTTON_UP", "Up");
    translation.put("BUTTON_DOWN", "Down");
    translation.put("BUTTON_NO_SORT", "Do not sort Newsfeeds automatically");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Close News Popup automatically");
    translation.put("BUTTON_CACHE_FEEDS", "Automatically save newsfeeds for offline reading");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Open in Browser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Show button to close tabs");
    translation.put("BUTTON_DELETE_FAVORITE", "When deleting a Favorite");
    translation.put("BUTTON_DELETE_CATEGORY", "When deleting a Category");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "When deleting a Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Don't ask me again");
    translation.put("BUTTON_BLOCK_POPUPS", "Block Popups");
    translation.put("BUTTON_ANIMATE_POPUP", "Animate Popup");
    translation.put("BUTTON_STOP_VALIDATION", "Stop Validation");
    translation.put("BUTTON_REMOVE", "Remove");
    translation.put("BUTTON_SMALL_ICONS", "Use small Icons");
    translation.put("BUTTON_LINK_TAB", "Link with displayed Feed");
    translation.put("BUTTON_CLEAR", "Clear");
    translation.put("BUTTON_SHOW_ERRORS", "Display errors in the tabfolder");

    /** Header */
    translation.put("HEADER_NEWS", "Newsheader");
    translation.put("HEADER_RSS_FAVORITES", "Favorites");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Please click to open the site");
    translation.put("TOOLTIP_PRINT", "Print News");
    translation.put("TOOLTIP_RATE", "Click here to rate this Message");
    translation.put("TOOLTIP_GRAB_TITLE", "Use title from Newsfeed");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Unread News Available");
    translation.put("TOOLTIP_SKIP", "Skip");
    translation.put("TOOLTIP_QUICKSEARCH", "Quick Search");
    translation.put("TOOLTIP_OPEN_TAB", "Open a new tab");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Date Published");
    translation.put("TABLE_HEADER_AUTHOR", "Author");
    translation.put("TABLE_HEADER_CATEGORY", "Category");
    translation.put("TABLE_HEADER_PUBLISHER", "Publisher");
    translation.put("TABLE_HEADER_NEWSTITLE", "Headline");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed Title");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_LINE", "Line");
    translation.put("TABLE_HEADER_STATUS", "Read Status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Homepage");
    translation.put("CHANNEL_INFO_PUBDATE", "Date Published");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Last Build Update");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Managing Editor");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Category");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Channel Time to Live");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Publisher");
    translation.put("CHANNEL_INFO_LANGUAGE", "Language");
    translation.put("CHANNEL_INFO_CREATOR", "Creator");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Update");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "times");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Source");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Comments");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Attachment");

    /** Messagebox / Dialogs */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Error");
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Attention!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Information");
    translation.put("MESSAGEBOX_FILL_URL", "Please Enter URL or Path");
    translation.put("MESSAGEBOX_CAT_EXISTS", "A Category with that name already exists!");
    translation.put("MESSAGEBOX_SELECT_CAT", "Please Select a Category");
    translation.put("MESSAGEBOX_FILE_EXISTS", "File Exists. Overwrite?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "File has no RSSOwl Settings saved!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Settings Imported!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Message is empty. Please choose another Message.");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Unable to connect to http://www.rssowl.org !");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "No new version available");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "You're already using the latest Version of RSSOwl!");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Add Favorite ");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Add Category");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Please Enter a Title");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Add Blogroll");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Please enter URL/Path and a Title");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Please enter path to the executable");
    translation.put("SEARCH_DIALOG_TITLE", "Search");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Search For");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Whole Word");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Case Sensitive ");
    translation.put("SEARCH_DIALOG_REGEX", "Use regular expressions ");
    translation.put("SEARCH_DIALOG_MESSAGE", "Please use AND, OR and NOT to limit the Search");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Edit Category");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Edit Blogroll");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Edit Favorite");
    translation.put("DIALOG_ID_ATTENTION", "You have to create an AmphetaRate Account first!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Error Starting the Browser!\nPlease enter a Browser under Settings");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Error loading internal Browser!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "No Favorites in this Category!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Please enter Hotkey to use");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Please confirm");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "No newsfeed selected in tabfolder!");
    translation.put("DIALOG_TITLE_UPDATE", "A new RSSOwl Version is now available");
    translation.put("DIALOG_BLOGGER_ATTENTION", "You have to set a Blogger first!");
    translation.put("DIALOG_TITLE_CATEGORY", "Please select a Category");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Please Enter URL of the Website");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl was not able to locate an application to view %FORMAT%");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "Don't Reload");
    translation.put("UPDATE_INTERVAL_ONE", "Every minute");
    translation.put("UPDATE_INTERVAL_FIVE", "Every 5 minutes");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "Every 15 minutes");
    translation.put("UPDATE_INTERVAL_THIRTY", "Every 30 minutes");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "Every hour");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "Every 3 hours");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "Every 6 hours");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "Every 12 hours");
    translation.put("UPDATE_INTERVAL_ONEDAY", "Every 24 hours");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Text Font");
    translation.put("FONT_AREA_DIALOG", "Dialog Font");
    translation.put("FONT_AREA_TREE", "Tree Font");
    translation.put("FONT_AREA_TABLE", "Table Font");
    translation.put("FONT_AREA_HEADER", "Header Font");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "The text font is used for the Newstext, Channel information, messages and errors.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "The dialog font is used in all dialogs.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "The tree font is used for the Favorites Tree.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "The table font is used for the table that holds the news of a newsfeed.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "The header font is used for Section Headers.");
    translation.put("FONT_STYLE_BOLD", "Bold");
    translation.put("FONT_STYLE_ITALIC", "Italic");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Browser */
    translation.put("BROWSER_BACK", "Back");
    translation.put("BROWSER_FORWARD", "Forward");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastic");
    translation.put("RATE_GOOD", "Good");
    translation.put("RATE_MODERATE", "Moderate");
    translation.put("RATE_BAD", "Bad");
    translation.put("RATE_VERY_BAD", "Very bad");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Groups */
    translation.put("GROUP_COMMAND", "Command");
    translation.put("GROUP_SELECTED_FONT", "Selected Font");
    translation.put("GROUP_FONT_AREA", "Font Area");
    translation.put("GROUP_WINDOW_LAYOUT", "Window Layout");
    translation.put("GROUP_OPEN_MODE", "Open mode");
    translation.put("GROUP_ARGUMENTS", "Arguments");
    translation.put("GROUP_LINK_COLOR", "Links");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Search Results");
    translation.put("GROUP_TAB_LAYOUT", "Tab Layout");
    translation.put("GROUP_TRAY", "System Tray");
    translation.put("GROUP_GENERAL", "General");
    translation.put("GROUP_EXISTING_ACCOUNT", "Existing Account");
    translation.put("GROUP_NEW_ACCOUNT", "Create New Account");
    translation.put("GROUP_NEWS_POPUP", "News Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "Show Confirmation");

    /** Languages */
    translation.put("de", "German");
    translation.put("da", "Danish");
    translation.put("el", "Greek");
    translation.put("en", "English");
    translation.put("es", "Spanish");
    translation.put("fr", "French");
    translation.put("gl", "Galician");
    translation.put("it", "Italian");
    translation.put("nl", "Dutch");
    translation.put("pt", "Portuguese (Brazil)");
    translation.put("ru", "Russian");
    translation.put("bg", "Bulgarian");
    translation.put("no", "Norwegian");
    translation.put("zhcn", "Chinese (Simple)");
    translation.put("ja", "Japanese");
    translation.put("ko", "Korean");
    translation.put("pl", "Polish");
    translation.put("sv", "Swedish");
    translation.put("bn", "Bengali");
    translation.put("zhtw", "Chinese (Traditional)");
    translation.put("uk", "Ukrainian");
    translation.put("fi", "Finnish");
    translation.put("cs", "Czech");
    translation.put("sl", "Slovenian");
    translation.put("tr", "Turkish");
    translation.put("hu", "Hungarian");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("TAB_WELCOME", "Welcome");
    translation.put("NEWS_NO_DESCRIPTION", "No Description Available!");
    translation.put("LOAD_FEED", "Loading");
    translation.put("SEARCH_FEED", "Searching");
    translation.put("PRINTED_FROM_RSSOWL", "Printed from RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Print from RSSOwl (http://www.rssowl.org)");
    translation.put("QUESTION_DEL_CAT", "Are you sure you want to delete \"%NAME%\" from your Categories?");
    translation.put("QUESTION_DEL_FAV", "Are you sure you want to delete \"%NAME%\" from your Favorites?");
    translation.put("BASE_AUTH_TITLE", "The requested site requires authorization!");
    translation.put("BASE_AUTH_MESSAGE", "Please enter Username and Password.");
    translation.put("SYSTRAY_SHOW", "Restore RSSOwl");
    translation.put("QUESTION_DEL_SUB", "Are you sure you want to delete the Blogroll?");
    translation.put("DOCUMENT_GENERATED_FROM", "Document generated from RSSOwl");
    translation.put("NO_TITLE", "No Title");
    translation.put("RELOAD_FEED", "Reloading");
    translation.put("RSSOWL_TEASER", "RSSOwl is a free, opensource RSS / RDF / Atom Newsreader. Some special features are:\n\n- Export News to PDF, HTML, RTF, OPML\n- Import Favorites from OPML\n- Full text-search with syntax-highlight of the results\n- Powerful Newsfeed search-engine\n- View news in internal browser\n- Manage favorites in categories (Drag and Drop support)\n- Runs on Windows, Linux, Solaris and Mac\n\nFor a complete list of features, see: http://www.rssowl.org/overview\n\nDownload from: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Please attach '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' to this e-mail and provide a short description of what RSSOwl did just before the error occurred! Thanks!");
    translation.put("RECOMMENDED_ARTICLES", "Recommended Articles");
    translation.put("FORMAT_AUTO_DETECT", "Detect Automatically");
    translation.put("NEWSFEED_VALID", "The newsfeed is valid!");
    translation.put("OPML_IMPORTED", "Imported");
    translation.put("ENTIRE_NEWS", "Entire News");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");

    /** New Translations */
    translation.put("sr", "Serbian (Cyrillic)");
    translation.put("sh", "Serbian (Latin)");
    translation.put("hr", "Croatian");
    translation.put("sk", "Slovak");
    translation.put("hy", "Armenian");
  }
}