/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Spanish internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez, Ruben and Vicente Rico <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nES extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nES(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Archivo");
    translation.put("MENU_SAVE", "Guardar como");
    translation.put("MENU_TOOLBAR", "Barra de herramientas");
    translation.put("MENU_QUICKVIEW", "Vistazo rápido");
    translation.put("MENU_GENERATE_PDF", "Generar PDF");
    translation.put("MENU_GENERATE_HTML", "Generar HTML");
    translation.put("MENU_GENERATE_RTF", "Generar RTF");
    translation.put("MENU_IMPORT", "Importar configuración");
    translation.put("MENU_EXPORT", "Exportar configuración");
    translation.put("MENU_EXIT", "Salir");
    translation.put("MENU_WINDOW", "Ventana");
    translation.put("MENU_PREFERENCES", "Preferencias");
    translation.put("MENU_FONT", "Fuente");
    translation.put("MENU_LANGUAGE", "Idioma");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Varios");
    translation.put("MENU_DIRECTOPEN", "Autoabrir noticias vacías en el navegador");
    translation.put("MENU_DIRECTOPENEACH", "Autoabrir cada noticia en el navegador");
    translation.put("MENU_SYSTRAY", "Poner RSSOwl en la bandeja al minimizar");
    translation.put("MENU_BROWSER_EXTERN", "Abrir navegador externo");
    translation.put("MENU_CHECK_UPDATE", "Buscar actualizaciones después de iniciar");
    translation.put("MENU_ABOUT", "Acerca de RSSOwl");
    translation.put("MENU_LICENSE", "Licencia");
    translation.put("MENU_UPDATE", "Buscar actualización");
    translation.put("MENU_WELCOME", "Bienvenido");
    translation.put("MENU_DONATE", "Haga una donación");
    translation.put("MENU_BROWSER", "Navegador");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Seleccione el navegador externo");
    translation.put("MENU_INFO", "Ayuda");
    translation.put("MENU_TOOLS", "Herramientas");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimizar RSSOwl");
    translation.put("MENU_GOTO", "Navegación");
    translation.put("MENU_NEXT_NEWS", "Siguiente noticia");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Siguiente noticia no leída");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Mostrar noticia en el navegador");
    translation.put("MENU_CLOSE", "Cerrar");
    translation.put("MENU_CLOSE_ALL", "Cerrar Todos");
    translation.put("MENU_PREVIOUS_TAB", "Pestaña Anterior");
    translation.put("MENU_NEXT_TAB", "Pestaña Siguiente");
    translation.put("MENU_HOTKEYS", "Teclas Rápidas");
    translation.put("MENU_TELL_FRIENDS", "Decírselo a mis amigos");
    translation.put("MENU_RELOAD", "Recargar");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generar PDF de las noticias seleccionadas");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generar HTML de las noticias seleccionadas");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generar RTF de las noticias seleccionadas");
    translation.put("MENU_OPENNEW_BROWSER", "Abrir el navegador interno siempre en una nueva pestaña");
    translation.put("MENU_MAILING_LIST", "Lista de Correo");
    translation.put("MENU_NEWSTIP_MAIL", "Dar formato a Correo NewsTip");
    translation.put("MENU_TUTORIAL", "Preceptoral");
    translation.put("MENU_ENCODING", "Codificación de Texto");
    translation.put("MENU_COLORS", "Colores");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_FEEDSEARCH", "Buscar líneas de suministro de noticias");
    translation.put("MENU_IMPORT_OPML", "Importar desde OPML");
    translation.put("MENU_VALIDATE", "Validar noticias");
    translation.put("MENU_CHANNELINFO", "Mostrar información de noticias");
    translation.put("MENU_FEED_DISCOVERY", "Buscar Noticias en el sitio web");
    translation.put("MENU_EDIT", "Edición");
    translation.put("MENU_EDIT_COPY", "Copiar");
    translation.put("MENU_EDIT_PASTE", "Pegar");
    translation.put("MENU_EDIT_SELECT_ALL", "Seleccionar Todo");
    translation.put("MENU_EDIT_DELETE", "Borrar");
    translation.put("MENU_EDIT_CUT", "Cortar");
    translation.put("MENU_DISPLAY_FEED_PDF", "Mostrar noticias en PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Mostrar noticias en RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Mostrar noticias en HTML");
    translation.put("MENU_NEW_FAVORITE", "Nuevo Favorito");
    translation.put("MENU_CONNECTION", "Conexión");
    translation.put("MENU_EDIT_RENAME", "Renombrar");
    translation.put("MENU_WORK_OFFLINE", "Trabajar Desconectado");
    translation.put("MENU_WORK_ONLINE", "Trabajar Conectado");

    /** ToolBar */
    translation.put("TOOL_MARK", "Marcar");
    translation.put("TOOL_NEXT", "Siguiente");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Iconos y Texto");
    translation.put("TOOL_ICONS", "Iconos");
    translation.put("TOOL_TEXT", "Texto");
    translation.put("TOOL_RATE", "Puntuación");
    translation.put("TOOL_HISTORY", "Historial");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nuevo");
    translation.put("POP_SUB_CATEGORY", "Subcategoría");
    translation.put("POP_UNSUBSCRIBE", "Cancelar suscripción");
    translation.put("POP_USEPROXY", "Usar proxy");
    translation.put("POP_AGGREGATE_FAV", "Agregar favoritos");
    translation.put("POP_IMPORT", "Importar");
    translation.put("POP_FROM_OPML", "De archivo OPML");
    translation.put("POP_EXPORT_OPML", "A archivo OPML");
    translation.put("POP_COPY", "Copiar");
    translation.put("POP_OPEN_IN_BROWSER", "Abra la selección en navegador");
    translation.put("POP_AUTO_UPDATE", "Autoactualización");
    translation.put("POP_UPDATE_ONSTARTUP", "al inicio");
    translation.put("POP_MARK_UNREAD", "Marcar como no leída");
    translation.put("POP_COPY_NEWS_URL", "Copiar vínculo");
    translation.put("POP_MAIL_LINK", "Enviar NewsTip a un amigo");
    translation.put("POP_RATE_NEWS", "Valorar noticias");
    translation.put("POP_BLOG_NEWS", "Noticias Blog");
    translation.put("POP_OPEN_EXTERN", "Abrir externo");
    translation.put("POP_OPEN_STARTUP", "Abrir al iniciar");
    translation.put("POP_KEEP_CURRENT", "Cerrar Otros");
    translation.put("POP_KEEP_NEWSFEEDS", "Cerrar Todo Excepto Suministro");
    translation.put("POP_MARK_ALL_READ", "Marcar Todo como Leído");
    translation.put("POP_MARK_CATEGORY_READ", "Marcar Categoría como Leída");
    translation.put("POP_PROPERTIES", "Propiedades");
    translation.put("POP_TAB_POSITION", "Posición");
    translation.put("POP_TAB_POS_TOP", "Arriba");
    translation.put("POP_TAB_POS_BOTTOM", "Abajo");
    translation.put("POP_MARK_FAVORITE_READ", "Marcar Favorito como Leído");
    translation.put("POP_IMPORT_BLOGROLL", "Blogroll Sincronizado");
    translation.put("POP_SYNCHRONIZE", "Sincronizar");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Personalizar Barra de Herramientas");
    translation.put("POP_CLEAR_HISTORY", "Borrar Historial");

    /** Errors in RSSOwl */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Error");
    translation.put("ERROR_NO_NEWS_FOUND", "Error: ¡No se han podido encontrar noticias!");
    translation.put("ERROR_CAT_EXISTS", "¡Ya existe una categoría con este nombre!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "¡Ya existe un favorito con este título!");
    translation.put("ERROR_FAV_URL_EXISTS", "¡Ya existe un favorito con esta URL!");
    translation.put("ERROR_GRABTITLE_FAILED", "¡No se ha podido conseguir el título!");
    translation.put("ERROR_CONNECTION_FAILED", "Conexión fallida!");
    translation.put("ERROR_UNEXPECTED", "Ha ocurrido un error inesperado! RSSOwl saldrá ahora pero la configuración ha sido guardada.\nSe registró el error en '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nDesea enviar un informe de error al equipo de RSSOwl?");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl es incapaz de mostrar la noticia.");
    translation.put("ERROR_FILE_NOT_FOUND", "No se pudo encontrar el fichero");
    translation.put("ERROR_AUTH_REQUIRED", "La noticia está protegida y requiere autenticación");
    translation.put("ERROR_REASON", "Motivo");
    translation.put("ERROR_LOADING_FEED", "Error mientras se cargaba la noticia \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Estado");
    translation.put("ERROR_WORKING_OFFLINE", "La noticia no puede mostrarse mientras esté desconectado");
    translation.put("ERROR_NOT_A_XML", "Este fichero no es un documento XML válido");
    translation.put("ERROR_NOT_A_RSS", "Este documento XML no es una noticia RSS, RDF o Atom válida");
    translation.put("ERROR_NOT_A_OPML", "Este documento XML no es un fichero OPML");
    translation.put("ERROR_SUB_EXISTS", "Ya está suscrito a este Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Ruta");
    translation.put("LABEL_CATEGORY", "Categoría");
    translation.put("LABEL_NO_INFOS", "¡No hay información adicional!");
    translation.put("LABEL_FAVORITE", "Favorito");
    translation.put("LABEL_TITLE", "Título");
    translation.put("LABEL_USE_PROXY", "Usar proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "El proxy requiere autentificación");
    translation.put("LABEL_USERNAME", "Nombre de usuario");
    translation.put("LABEL_PASSWORD", "Contraseña");
    translation.put("LABEL_PROXY_HOST", "Servidor del proxy");
    translation.put("LABEL_PROXY_PORT", "Puerto del proxy");
    translation.put("LABEL_CATEGORY", "Categoría");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Usar proxy para todos los favoritos");
    translation.put("LABEL_SEARCH_TOPIC", "Por favor, especifique su búsqueda");
    translation.put("LABEL_SEARCH_FINISHED", "Búsqueda finalizada.");
    translation.put("LABEL_SEARCH_RUNNING", "Búsqueda en curso");
    translation.put("LABEL_OPTIONS", "Opciones");
    translation.put("LABEL_INTENSIVE_SEARCH", "Búsqueda intensiva");
    translation.put("LABEL_PREFERED_LANGUAGE", "Idioma preferido");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_DESCRIPTION", "Descripción");
    translation.put("LABEL_CREATED", "Creado");
    translation.put("LABEL_LAST_VISIT", "Visitado por última vez");
    translation.put("LABEL_NEWS_RATED", "Noticia valorada");
    translation.put("LABEL_MAIL_SUBJECT", "Asunto");
    translation.put("LABEL_MAIL_BODY", "Cuerpo");
    translation.put("LABEL_MAIL_USAGE", "Usar [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] y [DESCRIPTION] como comodines para la información de noticias.");
    translation.put("LABEL_EMPTY_LINK", "No se ha proporcionado vínculo");
    translation.put("LABEL_USE_SYSTEM_FONT", "Usar Fuente del Sistema");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Correo en Formato HTML");
    translation.put("LABEL_USED_BY", "Usado por");
    translation.put("LABEL_SELECT_ENCODING", "Seleccionar codificación");
    translation.put("LABEL_SIZE", "Tamaño");
    translation.put("LABEL_STYLE", "Estilo");
    translation.put("LABEL_NAME", "Nombre");
    translation.put("LABEL_KEY_SEQUENCE", "Secuencia de teclas");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "¡La secuencia de teclas parece errónea!");
    translation.put("LABEL_CURRENT_COLOR", "Color actual");
    translation.put("LABEL_BLOGGER_USAGE", "Usar [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] y [TITLE] como comodines para la información de noticias.");
    translation.put("LABEL_SEARCH_RESULTS", "La búsqueda de \"%TERM%\" ha producido %NUM% resultados");
    translation.put("LABEL_SEARCH_EMPTY", "La búsqueda de \"%TERM%\" no ha producido resultados.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Por favor, seleccione una de las dos distribuciones de Ventana");
    translation.put("LABEL_SINGLE_CLICK", "Un click");
    translation.put("LABEL_DOUBLE_CLICK", "Doble click");
    translation.put("LABEL_SELECT_BLOGGER", "Seleccionar blogger externo");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Reabrir los últimos suministros abiertos al iniciar");
    translation.put("LABEL_TRADITIONAL_TABS", "Etiquetas tradicionales");
    translation.put("LABEL_CURVED_TABS", "Etiquetas Curvadas");
    translation.put("LABEL_READY", "Preparado");
    translation.put("LABEL_VALIDATION_FINISHED", "Validación terminada");
    translation.put("LABEL_VALIDATING", "Validando");
    translation.put("LABEL_FEED_TYPE", "Tipo de suministro de noticias");
    translation.put("LABEL_ADDRESS", "Dirección URL");
    translation.put("LABEL_BROWSER_USAGE", "Use [URL] como parámetro para la URL.");
    translation.put("LABEL_OVERRIDE_DTD", "Saltar Declaración de Tipo de Documento");
    translation.put("LABEL_OLD_ID", "Antiguo ID de usuario (opcional)");
    translation.put("LABEL_AMPHETARATE_ID", "ID de usuario");
    translation.put("LABEL_SORT_ORDER", "Orden de Noticias");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl intenta primero ordenar las noticias por el primer ítem de la lista. En caso de que este ítem no se encuentre, RSSOwl continua por el siguiente ítem de la misma.");
    translation.put("LABEL_REMEMBER_AUTH", "Recordar Nombre de Usuario y Contraseña");
    translation.put("LABEL_NOT_UNSUPPORTED", "No está soportado en su sistema operativo");
    translation.put("LABEL_KEY_DEL", "Suprimir");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Los valores que ajuste aquí serán aplicados por defecto para los nuevos favoritos.");
    translation.put("LABEL_RESTART", "Estos cambios requieren que reinicie RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Bienvenido a RSSOwl - Agregador para RSS / RDF / Atom");
    translation.put("LABEL_FIRST_STEPS", "Primeros Pasos");
    translation.put("LABEL_NEWS", "Noticias");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Noticias RSSOwl");
    translation.put("LABEL_SUPPORT", "Soporte");
    translation.put("LABEL_DISCUSSION_FORUM", "Foro de Discusión");
    translation.put("LABEL_PROMOTION", "Publicidad");
    translation.put("LABEL_CONTACT", "Contacto");
    translation.put("LABEL_START", "Empezar");
    translation.put("LABEL_DOWNLOAD", "Descargar");
    translation.put("LABEL_MAX_CONNECTIONS", "Número máximo de conexiones");
    translation.put("LABEL_CON_TIMEOUT", "Límite de tiempo en segundos");
    translation.put("LABEL_DELETE_FAVORITE", "Borrar un favorito");
    translation.put("LABEL_DELETE_CATEGORY", "Borrar una categoría");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Borrar Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "EL registro fue satisfactorio");
    translation.put("LABEL_SHOW", "Mostrar");
    translation.put("LABEL_SEARCH_IN", "Buscar");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Abrir");
    translation.put("BUTTON_ADD", "Añadir");
    translation.put("BUTTON_FILE", "Seleccionar archivo");
    translation.put("BUTTON_SEARCH", "Buscar");
    translation.put("BUTTON_RELOAD", "Recargar noticias");
    translation.put("BUTTON_CANCLE", "Cancelar");
    translation.put("BUTTON_EXPORT", "Exportar");
    translation.put("BUTTON_STOP_SEARCH", "Detener búsqueda");
    translation.put("BUTTON_CLEAR_RESULTS", "Borrar resultados");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exportar a OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Añadir a favoritos");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Restaurar valores por defecto");
    translation.put("BUTTON_APPLY", "Aplicar");
    translation.put("BUTTON_CHANGE_FONT", "Cambiar Fuente");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_ASSIGN", "Asignar");
    translation.put("BUTTON_CHANGE", "Cambiar");
    translation.put("BUTTON_MARK_ALL_READ", "Marcar todos los favoritos como leídos");
    translation.put("BUTTON_AGGREGATE_ALL", "Agregar todos los favoritos");
    translation.put("BUTTON_RELOAD_ALL", "Recargar todos los favoritos");
    translation.put("BUTTON_SEARCH_ALL", "Buscar en todos los favoritos");
    translation.put("BUTTON_CREATE_ACCOUNT", "Crear cuenta");
    translation.put("BUTTON_VALIDATE", "Validar");
    translation.put("BUTTON_TRAY_STARTUP", "Poner RSSOwl en la bandeja del sistema al inicio");
    translation.put("BUTTON_TRAY_EXIT", "Poner RSSOwl en la bandeja del sistema al salir");
    translation.put("BUTTON_SHOW_ERRORS", "Muestra errores en la pestaña");
    translation.put("BUTTON_STOP_VALIDATION", "Detener Validación");
    translation.put("BUTTON_FOCUS_TABS", "Establecer foco en nuevas pestañas");
    translation.put("BUTTON_DISPLAY_TABS", "Mostrar noticias en pestañas");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marcar todas las noticias como leídas al minimizar");
    translation.put("BUTTON_TRAY_POPUP", "Mostrar mensaje emergente cuando haya noticias no leídas");
    translation.put("BUTTON_READ_ON_CLOSE", "Marcar feed como leída al cerrar la pestaña");
    translation.put("BUTTON_UP", "Subir");
    translation.put("BUTTON_DOWN", "Bajar");
    translation.put("BUTTON_NO_SORT", "No ordenar las noticias automáticamente");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Cerrar automáticamente nuevas ventanas emergentes");
    translation.put("BUTTON_CACHE_FEEDS", "Guardar automáticamente noticias para leer fuera de línea");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Abrir en Navegador");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Mostrar botón de cerrar en pestañas");
    translation.put("BUTTON_DELETE_FAVORITE", "al borrar un favorito");
    translation.put("BUTTON_DELETE_CATEGORY", "al borrar una categoría");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "al borrar un Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "No volver a preguntar");
    translation.put("BUTTON_BLOCK_POPUPS", "Bloquear Ventanas Emergentes");
    translation.put("BUTTON_ANIMATE_POPUP", "Animar ventana");
    translation.put("BUTTON_REMOVE", "Borrar");
    translation.put("BUTTON_SMALL_ICONS", "Usar Iconos pequeños");
    translation.put("BUTTON_LINK_TAB", "Enlace a la noticia mostrada");
    translation.put("BUTTON_CLEAR", "Borrar");

    /** Header */
    translation.put("HEADER_NEWS", "Titular");
    translation.put("HEADER_RSS_FAVORITES", "Favoritos");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "¡Por favor, haga click para abrir la página!");
    translation.put("TOOLTIP_PRINT", "Imprimir noticia");
    translation.put("TOOLTIP_RATE", "Por favor, haga click para valorar");
    translation.put("TOOLTIP_GRAB_TITLE", "Conseguir título desde el suministro de noticias");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Hay noticias disponibles sin leer");
    translation.put("TOOLTIP_SKIP", "Saltar");
    translation.put("TOOLTIP_OPEN_TAB", "Abrir una nueva pestaña");
    translation.put("TOOLTIP_QUICKSEARCH", "Búsqueda Rápida");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Fecha de Publicación");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Categoría");
    translation.put("TABLE_HEADER_PUBLISHER", "Editor");
    translation.put("TABLE_HEADER_NEWSTITLE", "Titular");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "URL de suministro de noticias");
    translation.put("TABLE_HEADER_FEEDTITLE", "Título de suministro de noticias");
    translation.put("TABLE_HEADER_LINE", "Línea");
    translation.put("TABLE_HEADER_STATUS", "Estado de lectura");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Fecha de publicación");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Modificar último canal");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Editor Jefe");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Categoría");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Tiempo de existencia del canal");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formato");
    translation.put("CHANNEL_INFO_GENERATOR", "Generador RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Editor");
    translation.put("CHANNEL_INFO_LANGUAGE", "Idioma");
    translation.put("CHANNEL_INFO_CREATOR", "Creador");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Actualización");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "veces");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Inicio");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Fuente");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Adjunto");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Comentarios");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Atención");
    translation.put("MESSAGEBOX_FILL_URL", "Por favor, introduzca una URL o una ruta");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Ya existe una categoría con ese nombre");
    translation.put("MESSAGEBOX_SELECT_CAT", "Por favor, seleccione una categoría");
    translation.put("MESSAGEBOX_FILE_EXISTS", "El archivo ya existe. ¿Sobreescribir?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "¡El archivo no contiene configuración RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "¡Se ha importado la configuración con éxito!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "¡La noticia no tiene texto! Por favor, seleccione una noticia.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Añadir un nuevo favorito");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Añadir una nueva categoría");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Por favor, introduzca título");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Por favor, introduzca url / ruta y título");
    translation.put("BASE_AUTH_TITLE", "¡La página solicitada necesita autentificación!");
    translation.put("BASE_AUTH_MESSAGE", "Por favor, introduzca nombre de usuario y contraseña.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "¡No se ha seleccionado un RSS válido en la carpeta de etiquetas!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Por favor, confirme");
    translation.put("SEARCH_DIALOG_TITLE", "Buscar");
    translation.put("SEARCH_DIALOG_MESSAGE", "¡Use AND, OR y NOT para especificar la búsqueda!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Buscar");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Sólo palabra entera");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Respetar mayúsculas y minúsculas");
    translation.put("SEARCH_DIALOG_REGEX", "Use expresión regular");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "No hay versión nueva");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "¡Ya está usando la última versión de RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Información");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Editar categoría");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Editar favorito");
    translation.put("DIALOG_TITLE_UPDATE", "Disponible nueva versión de RSSOwl");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "No puede conectar con http://www.rssowl.org");
    translation.put("DIALOG_BROWSERSTART_FAILED", "¡No se ha podido ejecutar el navegador!\nPor favor, seleccione un navegador en 'Preferencias'");
    translation.put("DIALOG_ID_ATTENTION", "¡Tiene que introducir su ID de Usuario de AmphetaRate antes!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "¡La Categoría no contiene ningún favorito!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Por favor, introduzca una secuencia de teclas");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Por favor, introduzca la ruta del ejecutable");
    translation.put("DIALOG_BLOGGER_ATTENTION", "¡Primero tienes que seleccionar un blogger!");
    translation.put("DIALOG_ID_ATTENTION", "Tiene que crear un cuenta AmphetaRate primero");
    translation.put("DIALOG_TITLE_CATEGORY", "Seleccionar una Categoría");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Por favor, introduzca la URL del sitio web");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl no fue capaz de encontrar una aplicación para mostrar este %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Editar Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Fallo al cargar el navegador interno!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Añadir un Blogroll nuevo");
    translation.put("QUESTION_DEL_FAV", "¿Está seguro de que quiere borrar el favorito? \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "¿Está seguro de que quiere borrar la categoría \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "¿Está seguro de que quiere borrar el Blogroll?");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ninguno");
    translation.put("UPDATE_INTERVAL_ONE", "después de 1 minuto");
    translation.put("UPDATE_INTERVAL_FIVE", "después de 5 minutos");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "después de 15 minutos");
    translation.put("UPDATE_INTERVAL_THIRTY", "después de 30 minutos");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "después de 1 hora");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "después de 3 horas");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "después de 6 horas");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "después de 12 horas");
    translation.put("UPDATE_INTERVAL_ONEDAY", "después de 24 horas");

    /** Browser */
    translation.put("BROWSER_BACK", "Atrás");
    translation.put("BROWSER_FORWARD", "Adelante");
    translation.put("BROWSER_STOP", "Parar");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantástica");
    translation.put("RATE_GOOD", "Buena");
    translation.put("RATE_MODERATE", "Normal");
    translation.put("RATE_BAD", "Mala");
    translation.put("RATE_VERY_BAD", "Muy mala");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Flecha_Arriba");
    translation.put("LABEL_KEY_ARROW_DOWN", "Flecha_Abajo");
    translation.put("LABEL_KEY_ARROW_LEFT", "Flecha_Izquierda");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Flecha_Derecha");
    translation.put("LABEL_KEY_PAGE_UP", "Re_Pág");
    translation.put("LABEL_KEY_PAGE_DOWN", "Av_Pág");
    translation.put("LABEL_KEY_SPACE", "Espacio");
    translation.put("LABEL_KEY_INSERT", "Insertar");
    translation.put("LABEL_KEY_PAUSE", "Pausa");
    translation.put("LABEL_KEY_NUMPAD", "Teclado Numérico");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font settings */
    translation.put("FONT_AREA_TEXT", "Fuente de Texto");
    translation.put("FONT_AREA_DIALOG", "Fuente de Diálogo");
    translation.put("FONT_AREA_TREE", "Fuente de Arbol");
    translation.put("FONT_AREA_TABLE", "Fuente de Tabla");
    translation.put("FONT_AREA_HEADER", "Fuente de Encabezamiento");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "La fuente del texto se usa para el texto de las noticias, informaciones del canal, mensajes y errores.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "La fuente de diálogo se usa en todos los diálogos.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "La fuente del árbol se usa para el árbol que contiene los favoritos.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "La fuente de la tabla se usa para la tabla que contiene las noticias de un suministro.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "La fuente de encabezamiento se usa para los encabezamientos de las secciones.");
    translation.put("FONT_STYLE_BOLD", "Negrita");
    translation.put("FONT_STYLE_ITALIC", "Cursiva");
    translation.put("FONT_STYLE_NORMAL", "Normal");

    /** Groups */
    translation.put("GROUP_COMMAND", "Comando");
    translation.put("GROUP_SELECTED_FONT", "Fuente Seleccionada");
    translation.put("GROUP_FONT_AREA", "Area de Fuente");
    translation.put("GROUP_WINDOW_LAYOUT", "Distribución de la Ventana");
    translation.put("GROUP_ARGUMENTS", "Argumentos");
    translation.put("GROUP_LINK_COLOR", "Color de Vínculo");
    translation.put("GROUP_OPEN_MODE", "Modo Abierto");
    translation.put("GROUP_TAB_LAYOUT", "Distribución de Etiquetas");
    translation.put("GROUP_GENERAL", "General");
    translation.put("GROUP_EXISTING_ACCOUNT", "Cuenta existente");
    translation.put("GROUP_NEW_ACCOUNT", "Crear nueva cuenta");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Color de los resultados de búsqueda");
    translation.put("GROUP_TRAY", "Bandeja del sistema");
    translation.put("GROUP_NEWS_POPUP", "Noticias Emergentes");
    translation.put("GROUP_CONFIRM_DIALOG", "Mostrar Diálogo de Confirmación");

    /** Languages */
    translation.put("en", "Inglés");
    translation.put("de", "Alemán");
    translation.put("fr", "Francés");
    translation.put("es", "Español");
    translation.put("gl", "Gallego");
    translation.put("da", "Danés");
    translation.put("nl", "Holandés");
    translation.put("it", "Italiano");
    translation.put("el", "Griego");
    translation.put("ru", "Ruso");
    translation.put("pt", "Portugués (Brasil)");
    translation.put("bg", "Búlgaro");
    translation.put("no", "Noruego");
    translation.put("zhcn", "Chino Simplificado");
    translation.put("ja", "Japonés");
    translation.put("bn", "Bengalí");
    translation.put("sv", "Sueco");
    translation.put("pl", "Polaco");
    translation.put("ko", "Coreano");
    translation.put("zhtw", "Chino Tradicional");
    translation.put("uk", "Ucraniano");
    translation.put("fi", "Finés");
    translation.put("cs", "Checo");
    translation.put("sl", "Esloveno");
    translation.put("hu", "Húngaro");
    translation.put("tr", "Turco");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "¡No hay descripción disponible!");
    translation.put("PRINTED_FROM_RSSOWL", "Impresos del RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Imprimiendo noticias del RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Mostrar RSSOwl");
    translation.put("TAB_WELCOME", "Bienvenido");
    translation.put("DOCUMENT_GENERATED_FROM", "Documento generado de RSSOwl");
    translation.put("NO_TITLE", "Sin título");
    translation.put("BUTTON_RELOAD_CAT", "Recargar favoritos");
    translation.put("RSSOWL_TEASER", "RSSOwl es un lector de noticias de código libre y abierto. Sus características especiales son:\n\n- Exportar noticias a PDF, HTML, RTF, OPML\n- Importar favoritos de OPML\n- Búsqueda a texto completo resaltando la sintaxis en los resultados\n- Potente motor de búsqueda RSS y RDF\n- Ver noticias en navegador interno\n- Manejar favoritos en categorías\n- Funciona bajo Windows, Linux, Solaris y Mac\n\nPara una lista completa de características, vea: http://www.rssowl.org/overview\n\nBájeselo de: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Artículos Recomendados");
    translation.put("LOAD_FEED", "Cargando");
    translation.put("SEARCH_FEED", "Buscando");
    translation.put("RELOAD_FEED", "Recargando");
    translation.put("FORMAT_AUTO_DETECT", "Detectar Automaticamente");
    translation.put("MAIL_ERROR_BODY", "Por favor, adjunte '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' a este correo y denos una breve descripción de qué hizo RSSOwl justo antes de que ocurriera el error. Gracias!");
    translation.put("NEWSFEED_VALID", "El suministro de noticias es válido");
    translation.put("OPML_IMPORTED", "Importado");
    translation.put("ENTIRE_NEWS", "Todas las noticias");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}