/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Galician internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nGL extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nGL(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Arquivo");
    translation.put("MENU_QUICKVIEW", "Vistazo rápido");
    translation.put("MENU_GENERATE_PDF", "Xerar PDF");
    translation.put("MENU_GENERATE_HTML", "Xerar HTML");
    translation.put("MENU_GENERATE_RTF", "Xerar RTF");
    translation.put("MENU_IMPORT", "Importar configuración");
    translation.put("MENU_EXPORT", "Exportar configuración");
    translation.put("MENU_EXIT", "Saír");
    translation.put("MENU_WINDOW", "Ventá");
    translation.put("MENU_PREFERENCES", "Preferencias");
    translation.put("MENU_FONT", "Fonte");
    translation.put("MENU_LANGUAGE", "Idioma");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Varios");
    translation.put("MENU_DIRECTOPEN", "Autoabrir nóvas valeiras no navegador");
    translation.put("MENU_DIRECTOPENEACH", "Autoabrir cada nóva no navegador");
    translation.put("MENU_SYSTRAY", "Poñer RSSOwl na bandexa ó minimizar");
    translation.put("MENU_BROWSER_EXTERN", "Abrir navegador externo");
    translation.put("MENU_CHECK_UPDATE", "Buscar actualizacións ó iniciar");
    translation.put("MENU_ABOUT", "Acerca de RSSOwl");
    translation.put("MENU_LICENSE", "Licencia");
    translation.put("MENU_UPDATE", "Buscar actualización");
    translation.put("MENU_WELCOME", "Benvido");
    translation.put("MENU_DONATE", "Haga una donación");
    translation.put("MENU_BROWSER", "Navegador");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Seleccione el navegador externo");
    translation.put("MENU_ENCODING", "Codificación do Texto");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Amosar nóva no navegador");
    translation.put("MENU_INFO", "Axuda");
    translation.put("MENU_TOOLS", "Ferramentas");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimizar RSSOwl");
    translation.put("MENU_GOTO", "Navegación");
    translation.put("MENU_NEXT_NEWS", "Seguinte nóva");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Seguinte nóva non lída");
    translation.put("MENU_TELL_FRIENDS", "Dicirllo os meus amigos");
    translation.put("MENU_RELOAD", "Recargar");
    translation.put("MENU_NEWSTIP_MAIL", "Dar formato a Correo NewsTip");
    translation.put("MENU_MAILING_LIST", "Lista de Correo");
    translation.put("MENU_OPENNEW_BROWSER", "Abri-lo navegador interno sempre nunha nova pestana");
    translation.put("MENU_CLOSE", "Pechar");
    translation.put("MENU_CLOSE_ALL", "Pechar Todos");
    translation.put("MENU_PREVIOUS_TAB", "Pestana Anterior");
    translation.put("MENU_NEXT_TAB", "Pestana Seguinte");
    translation.put("MENU_HOTKEYS", "Teclas Rápidas");
    translation.put("MENU_TUTORIAL", "Preceptoral");
    translation.put("MENU_COLORS", "Colores");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_FEEDSEARCH", "Busca de liñas de suministro de nóvas");

    /** Popup Menu */
    translation.put("POP_NEW", "Novo");
    translation.put("POP_SUB_CATEGORY", "Subcategoría");
    translation.put("POP_UNSUBSCRIBE", "Cancelar suscripción");
    translation.put("POP_USEPROXY", "Usar proxy");
    translation.put("POP_AGGREGATE_FAV", "Engadir favoritos");
    translation.put("POP_IMPORT", "Importar");
    translation.put("POP_FROM_OPML", "De arquivo OPML");
    translation.put("POP_EXPORT_OPML", "A arquivo OPML");
    translation.put("POP_COPY", "Copiar");
    translation.put("POP_OPEN_IN_BROWSER", "Abra la selección en navegador");
    translation.put("POP_AUTO_UPDATE", "Autoactualización");
    translation.put("POP_UPDATE_ONSTARTUP", "ó inicio");
    translation.put("POP_MARK_UNREAD", "Marcar como non lída");
    translation.put("POP_COPY_NEWS_URL", "Copar ligazón");
    translation.put("POP_MAIL_LINK", "Enviar NewsTip a un amigo");
    translation.put("POP_RATE_NEWS", "Evaluar nóvas");
    translation.put("POP_OPEN_EXTERN", "Abrir externo");
    translation.put("POP_BLOG_NEWS", "Noticias Blog");
    translation.put("POP_KEEP_CURRENT", "Pechar Outros");
    translation.put("POP_KEEP_NEWSFEEDS", "Pechar Todo Excepto Suministros");
    translation.put("POP_OPEN_STARTUP", "Abrir ó iniciar");
    translation.put("POP_MARK_ALL_READ", "Marcar Todo como Lido");
    translation.put("POP_PROPERTIES", "Propiedades");

    /** Errors in RSSOwl */
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Erro");
    translation.put("ERROR_NO_NEWS_FOUND", "Erro: ¡Non se pudo atopar nóvas!");
    translation.put("ERROR_CAT_EXISTS", "¡Xa existe unha categoría con ese nome!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "¡Xa existe un favorito con este título!");
    translation.put("ERROR_FAV_URL_EXISTS", "¡Xa existe un favorito con esta URL!");
    translation.put("ERROR_CONNECTION_FAILED", "¡Conexión fallida!");
    translation.put("ERROR_GRABTITLE_FAILED", "¡Non se pudo consegui-lo título!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Ruta");
    translation.put("LABEL_CATEGORY", "Categoría");
    translation.put("LABEL_NO_INFOS", "¡Non hay información adicional!");
    translation.put("LABEL_FAVORITE", "Favorito");
    translation.put("LABEL_TITLE", "Título");
    translation.put("LABEL_USE_PROXY", "Usar proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "O proxy require autentificación");
    translation.put("LABEL_USERNAME", "Nome de usuario");
    translation.put("LABEL_PASSWORD", "Contrasinal");
    translation.put("LABEL_PROXY_HOST", "Servidor do proxy");
    translation.put("LABEL_PROXY_PORT", "Porto do proxy");
    translation.put("LABEL_CATEGORY", "Categoría");
    translation.put("LABEL_NEWS_RATED", "Nóva evaluada");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Usar proxy para tódo-los favoritos");
    translation.put("LABEL_SEARCH_FINISHED", "Busca rematada.");
    translation.put("LABEL_SEARCH_RUNNING", "Busca en proceso");
    translation.put("LABEL_OPTIONS", "Opcións");
    translation.put("LABEL_INTENSIVE_SEARCH", "Busca intensiva");
    translation.put("LABEL_PREFERED_LANGUAGE", "Idioma preferido");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_DESCRIPTION", "Descripción");
    translation.put("LABEL_CREATED", "Creada");
    translation.put("LABEL_LAST_VISIT", "Visitada por última vez");
    translation.put("LABEL_SEARCH_TOPIC", "Por favor, especifique a súa busca");
    translation.put("LABEL_SELECT_ENCODING", "Seleccionar codificación");
    translation.put("LABEL_SIZE", "Tamaño");
    translation.put("LABEL_STYLE", "Estilo");
    translation.put("LABEL_USE_SYSTEM_FONT", "Usar Fonte do Sistema");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Correo en Formato HTML");
    translation.put("LABEL_MAIL_SUBJECT", "Asunto");
    translation.put("LABEL_MAIL_BODY", "Corpo");
    translation.put("LABEL_MAIL_USAGE", "Usar [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [DESCRIPTION] como comodíns para a información de nóvas.");
    translation.put("LABEL_EMPTY_LINK", "Non se proporcionou ligazón");
    translation.put("LABEL_NAME", "Nome");
    translation.put("LABEL_USED_BY", "Usado por");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "¡A secuencia de teclas parece errónea!");
    translation.put("LABEL_KEY_SEQUENCE", "Secuencia de teclas");
    translation.put("LABEL_CURRENT_COLOR", "Color agora");
    translation.put("LABEL_BLOGGER_USAGE", "Usar [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] e [TITLE] como comodíns para a información de nóvas.");
    translation.put("LABEL_SEARCH_RESULTS", "A busca de \"%TERM%\" produciu %NUM% resultados");
    translation.put("LABEL_SEARCH_EMPTY", "A busca de \"%TERM%\" non produciu resultados.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Por favor, seleccione unha das dúas distribucións de Ventá");
    translation.put("LABEL_SINGLE_CLICK", "Un click");
    translation.put("LABEL_DOUBLE_CLICK", "Doble click");
    translation.put("LABEL_SELECT_BLOGGER", "Seleccionar blogger externo");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Reabrir os derradeiros suministros abertos ó iniciar");
    translation.put("LABEL_TRADITIONAL_TABS", "Etiquetas Tradicionais");
    translation.put("LABEL_CURVED_TABS", "Etiquetas Curvas");
    translation.put("LABEL_READY", "Preparado");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Abrir");
    translation.put("BUTTON_ADD", "Engadir");
    translation.put("BUTTON_FILE", "Seleccionar arquivo");
    translation.put("BUTTON_SEARCH", "Buscar");
    translation.put("BUTTON_RELOAD", "Recargar nóvas");
    translation.put("BUTTON_CANCLE", "Cancelar");
    translation.put("BUTTON_EXPORT", "Exportar");
    translation.put("BUTTON_STOP_SEARCH", "Deter busca");
    translation.put("BUTTON_CLEAR_RESULTS", "Borrar resultados");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exportar a OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Engadir a favoritos");
    translation.put("BUTTON_ASSIGN", "Asignar");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Restaurar valores por defecto");
    translation.put("BUTTON_APPLY", "Aplicar");
    translation.put("BUTTON_CHANGE_FONT", "Cambiar Fonte");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_RELOAD_CAT", "Recargar favoritos");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Marcar todas las noticias como leídas al minimizar");
    translation.put("BUTTON_TRAY_POPUP", "Mostrar mensaje emergente cuando haya noticias no leídas");
    translation.put("BUTTON_READ_ON_CLOSE", "Marcar feed como leída al cerrar la pestaña");

    /** Header */
    translation.put("HEADER_NEWS", "Titular");
    translation.put("HEADER_RSS_FAVORITES", "Favoritos");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "¡Por favor, faga click para abri-la página!");
    translation.put("TOOLTIP_PRINT", "Imprimir nóva");
    translation.put("TOOLTIP_GRAB_TITLE", "¡Conseguir título de suministro de nóvas");
    translation.put("TOOLTIP_RATE", "Por favor, faga click para evaluar");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Data de Publicación");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Categoría");
    translation.put("TABLE_HEADER_PUBLISHER", "Editor");
    translation.put("TABLE_HEADER_NEWSTITLE", "Titular");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "URL do suministro de nóvas");
    translation.put("TABLE_HEADER_FEEDTITLE", "Título do suministro de nóvas");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Data de publicación");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Modificar última canal");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Editor Xefe");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Categoría");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Tempo de existencia da canal");
    translation.put("CHANNEL_INFO_GENERATOR", "Xerador RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Editor");
    translation.put("CHANNEL_INFO_LANGUAGE", "Idioma");
    translation.put("CHANNEL_INFO_CREATOR", "Creador");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Actualización");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "veces");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Inicio");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Comentarios");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Fonte");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Adxunto");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Atención");
    translation.put("MESSAGEBOX_FILL_URL", "Por favor, introduza unha URL ou unha ruta");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Xa existe unha categoría con ese nome");
    translation.put("MESSAGEBOX_SELECT_CAT", "Por favor, seleccione unha categoría");
    translation.put("MESSAGEBOX_FILE_EXISTS", "O arquivo xa existe. ¿Sobreescribir?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "¡O archivo non contén a configuración RSSOwl!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "¡Importouse a configuración con éxito!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "¡A nóva non tén texto! Por favor, seleccione unha nóva.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Engadir un novo favorito");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Engadir unha nova categoría");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Por favor, introduza título");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Por favor, introduza url / ruta e título");
    translation.put("BASE_AUTH_TITLE", "¡A páxina solicitada necesita autentificación!");
    translation.put("BASE_AUTH_MESSAGE", "Por favor, introduza nome de usuario e contrasinal.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "¡Non se seleccionou un RSS válido na carpeta de etiquetas!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Por favor, confirme");
    translation.put("SEARCH_DIALOG_TITLE", "Buscar");
    translation.put("SEARCH_DIALOG_MESSAGE", "¡Use AND, OR e NOT para especifica-la búsqueda!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Buscar");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Só palabra enteira");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Respetar maiúsculas e minúsculas");
    translation.put("SEARCH_DIALOG_REGEX", "Use expresión regular");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Non hai versión nova");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "¡Xa está usando a última versión de RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Información");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Editar categoría");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Editar favorito");
    translation.put("DIALOG_TITLE_UPDATE", "Dispoñible nova versión de RSSOwl");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "No puede conectar con http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "¡Tén que introducí-la súa ID de AmphetaRate antes!");
    translation.put("DIALOG_BROWSERSTART_FAILED", "¡Non se pudo executa-lo navegador!\nPor favor, seleccione un navegador en 'Preferencias'");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Por favor, introduza unha secuencia de teclas");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "¡A Categoría non contén ningún favorito!");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Por favor, introduza a ruta do executable");
    translation.put("DIALOG_BLOGGER_ATTENTION", "¡Primeiro tés que seleccionar un blogger!");

    /** Browser */
    translation.put("BROWSER_BACK", "Atrás");
    translation.put("BROWSER_FORWARD", "Adiante");
    translation.put("BROWSER_STOP", "Parar");

    /** Update Interval */
    translation.put("UPDATE_INTERVAL_NO", "ningún");
    translation.put("UPDATE_INTERVAL_ONE", "despois de 1 minuto");
    translation.put("UPDATE_INTERVAL_FIVE", "despois de 5 minutos");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "despois de 15 minutos");
    translation.put("UPDATE_INTERVAL_THIRTY", "despois de 30 minutos");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "despois de 1 hora");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "despois de 3 horas");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "despois de 6 horas");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "despois de 12 horas");
    translation.put("UPDATE_INTERVAL_ONEDAY", "despois de 24 horas");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantástica");
    translation.put("RATE_GOOD", "Boa");
    translation.put("RATE_MODERATE", "Normal");
    translation.put("RATE_BAD", "Mala");
    translation.put("RATE_VERY_BAD", "Moi mala");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Frecha_Arriba");
    translation.put("LABEL_KEY_ARROW_DOWN", "Frecha_Abaixo");
    translation.put("LABEL_KEY_ARROW_LEFT", "Frecha_Esquerda");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Frecha_Dereita");
    translation.put("LABEL_KEY_PAGE_UP", "Re_Pág");
    translation.put("LABEL_KEY_PAGE_DOWN", "Av_Pág");
    translation.put("LABEL_KEY_SPACE", "Espacio");
    translation.put("LABEL_KEY_INSERT", "Inserir");
    translation.put("LABEL_KEY_PAUSE", "Pausa");
    translation.put("LABEL_KEY_NUMPAD", "Teclado Numérico");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font settings */
    translation.put("FONT_STYLE_BOLD", "Negriña");
    translation.put("FONT_STYLE_ITALIC", "Cursiva");
    translation.put("FONT_STYLE_NORMAL", "Normal");
    translation.put("FONT_AREA_TEXT", "Fonte de Texto");
    translation.put("FONT_AREA_DIALOG", "Fonte de Diálogo");
    translation.put("FONT_AREA_TREE", "Fonte de Arbore");
    translation.put("FONT_AREA_TABLE", "Fonte de Tabla");
    translation.put("FONT_AREA_HEADER", "Fonte de Encabezamento");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "A fonte do texto úsase para o texto das nóvas, informacións da canal, mensaxes e erros.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "A fonte de diálogo úsase en tódo-los diálogos.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "A fonte da árbore úsase para a árbore que contén os favoritos.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "A fonte da tabla úsase para a tabla que contén as nóvas dun suministro.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "A fonte de encabezamento úsase para os encabezamentos das seccións.");

    /** Groups */
    translation.put("GROUP_COMMAND", "Comando");
    translation.put("GROUP_SELECTED_FONT", "Fonte Seleccionada");
    translation.put("GROUP_FONT_AREA", "Area de Fonte");
    translation.put("GROUP_WINDOW_LAYOUT", "Distribución da Ventá");
    translation.put("GROUP_OPEN_MODE", "Modo Aberto");
    translation.put("GROUP_LINK_COLOR", "Color de Vínculo");
    translation.put("GROUP_ARGUMENTS", "Argumentos");
    translation.put("GROUP_TAB_LAYOUT", "Distribución de etiquetas");

    /** Languages */
    translation.put("en", "Inglés");
    translation.put("de", "Alemán");
    translation.put("fr", "Francés");
    translation.put("es", "Español");
    translation.put("gl", "Galego");
    translation.put("da", "Danés");
    translation.put("nl", "Holandés");
    translation.put("it", "Italiano");
    translation.put("ru", "Ruso");
    translation.put("el", "Grego");
    translation.put("pt", "Portugués (Brasil)");
    translation.put("bg", "Búlgaro");
    translation.put("no", "Noruego");
    translation.put("zhcn", "Chino Simplificado");
    translation.put("ja", "Xaponés");
    translation.put("zhtw", "Chino Tradicional");
    translation.put("uk", "Ucraniano");
    translation.put("fi", "Finés");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "¡Non hai descripción dispoñible!");
    translation.put("PRINTED_FROM_RSSOWL", "Impresos do RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Imprimindo nóvas do RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Amosar RSSOwl");
    translation.put("TAB_WELCOME", "Benvido");
    translation.put("DOCUMENT_GENERATED_FROM", "Documento xerado de RSSOwl");
    translation.put("NO_TITLE", "Sen título");
    translation.put("RSSOWL_TEASER", "RSSOwl é un lector de nóvas de código libre e aberto. As súas características especiais son:\n\n- Exportar nóvas a PDF, HTML, RTF, OPML\n- Importar favoritos de OPML\n- Busca a texto completo resaltando a sintaxis nos resultados\n- Potente motor de busca RSS e RDF\n- Ver nóvas no navegador interno\n- Manexar favoritos en categorías\n- Funciona baixo Windows, Linux, Solaris e Mac\n\nPara unha lista completa de características, vexa: http://www.rssowl.org/overview\n\nBaixeo de: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Artigos recomendados");
    translation.put("LOAD_FEED", "Cargando");
    translation.put("SEARCH_FEED", "Busca");
    translation.put("RELOAD_FEED", "Recargando");

    /** Spanish translations temporary used for Galician */
    translation.put("MENU_IMPORT_OPML", "Importar desde OPML");
    translation.put("MENU_VALIDATE", "Validar noticias");
    translation.put("BUTTON_VALIDATE", "Validar");
    translation.put("ko", "Coreano");
    translation.put("FORMAT_AUTO_DETECT", "Detectar Automaticamente");
    translation.put("LABEL_FEED_TYPE", "Tipo de suministro de noticias");
    translation.put("TABLE_HEADER_LINE", "Línea");
    translation.put("BUTTON_STOP_VALIDATION", "Detener Validación");
    translation.put("LABEL_VALIDATION_FINISHED", "Validación terminada");
    translation.put("LABEL_VALIDATING", "Validando");
    translation.put("LABEL_OVERRIDE_DTD", "Saltar Declaración de Tipo de Documento");
    translation.put("BUTTON_FOCUS_TABS", "Establecer foco en nuevas pestañas");
    translation.put("LABEL_ADDRESS", "Dirección URL");
    translation.put("pl", "Polaco");
    translation.put("LABEL_BROWSER_USAGE", "Use [URL] como parámetro para la URL.");
    translation.put("BUTTON_DISPLAY_TABS", "Mostrar noticias en pestañas");
    translation.put("GROUP_TRAY", "Bandeja del sistema");
    translation.put("BUTTON_TRAY_STARTUP", "Poner RSSOwl en la bandeja del sistema al inicio");
    translation.put("BUTTON_TRAY_EXIT", "Poner RSSOwl en la bandeja del sistema al salir");
    translation.put("BUTTON_SHOW_ERRORS", "Muestra errores en la pestaña");
    translation.put("MAIL_ERROR_BODY", "Por favor, adjunte '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' a este correo y denos una breve descripción de qué hizo RSSOwl justo antes de que ocurriera el error. Gracias!");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Hay noticias disponibles sin leer");
    translation.put("sv", "Sueco");
    translation.put("POP_MARK_CATEGORY_READ", "Marcar Categoría como Leída");
    translation.put("NEWSFEED_VALID", "El suministro de noticias es válido");
    translation.put("GROUP_GENERAL", "General");
    translation.put("BUTTON_CHANGE", "Cambiar");
    translation.put("DIALOG_TITLE_CATEGORY", "Seleccionar una Categoría");
    translation.put("bn", "Bengalí");
    translation.put("BUTTON_MARK_ALL_READ", "Marcar todos los favoritos como leídos");
    translation.put("BUTTON_AGGREGATE_ALL", "Agregar todos los favoritos");
    translation.put("BUTTON_RELOAD_ALL", "Recargar todos los favoritos");
    translation.put("BUTTON_SEARCH_ALL", "Buscar en todos los favoritos");
    translation.put("TOOLTIP_SKIP", "Saltar");
    translation.put("MENU_CHANNELINFO", "Mostrar información de noticias");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Color de los resultados de búsqueda");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generar PDF de las noticias seleccionadas");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generar HTML de las noticias seleccionadas");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generar RTF de las noticias seleccionadas");
    translation.put("ERROR_UNEXPECTED", "Ha ocurrido un error inesperado! RSSOwl saldrá ahora pero la configuración ha sido guardada.\nSe registró el error en '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nDesea enviar un informe de error al equipo de RSSOwl?");
    translation.put("GROUP_EXISTING_ACCOUNT", "Cuenta existente");
    translation.put("GROUP_NEW_ACCOUNT", "Crear nueva cuenta");
    translation.put("DIALOG_ID_ATTENTION", "Tiene que crear un cuenta AmphetaRate primero");
    translation.put("BUTTON_CREATE_ACCOUNT", "Crear cuenta");
    translation.put("LABEL_OLD_ID", "Antiguo ID de usuario (opcional)");
    translation.put("LABEL_AMPHETARATE_ID", "ID de usuario");
    translation.put("POP_TAB_POSITION", "Posición");
    translation.put("POP_TAB_POS_TOP", "Arriba");
    translation.put("POP_TAB_POS_BOTTOM", "Abajo");
    translation.put("TABLE_HEADER_STATUS", "Estado de lectura");
    translation.put("LABEL_SORT_ORDER", "Orden de Noticias");
    translation.put("BUTTON_UP", "Subir");
    translation.put("BUTTON_DOWN", "Bajar");
    translation.put("BUTTON_NO_SORT", "No ordenar las noticias automáticamente");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl intenta primero ordenar las noticias por el primer ítem de la lista. En caso de que este ítem no se encuentre, RSSOwl continua por el siguiente ítem de la misma.");
    translation.put("MENU_FEED_DISCOVERY", "Buscar Noticias en el sitio web");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Por favor, introduzca la URL del sitio web");
    translation.put("LABEL_REMEMBER_AUTH", "Recordar Nombre de Usuario y Contraseña");
    translation.put("cs", "Checo");
    translation.put("sl", "Esloveno");
    translation.put("MENU_EDIT", "Edición");
    translation.put("MENU_EDIT_COPY", "Copiar");
    translation.put("MENU_EDIT_PASTE", "Pegar");
    translation.put("MENU_EDIT_SELECT_ALL", "Seleccionar Todo");
    translation.put("MENU_EDIT_DELETE", "Borrar");
    translation.put("MENU_EDIT_CUT", "Cortar");
    translation.put("MENU_DISPLAY_FEED_PDF", "Mostrar noticias en PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Mostrar noticias en RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Mostrar noticias en HTML");
    translation.put("MENU_NEW_FAVORITE", "Nuevo Favorito");
    translation.put("LABEL_NOT_UNSUPPORTED", "No está soportado en su sistema operativo");
    translation.put("LABEL_KEY_DEL", "Suprimir");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Los valores que ajuste aquí serán aplicados por defecto para los nuevos favoritos.");
    translation.put("LABEL_RESTART", "Estos cambios requieren que reinicie RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Bienvenido a RSSOwl - Agregador para RSS / RDF / Atom");
    translation.put("LABEL_FIRST_STEPS", "Primeros Pasos");
    translation.put("LABEL_NEWS", "Noticias");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Noticias RSSOwl");
    translation.put("LABEL_SUPPORT", "Soporte");
    translation.put("LABEL_DISCUSSION_FORUM", "Foro de Discusión");
    translation.put("LABEL_PROMOTION", "Publicidad");
    translation.put("LABEL_CONTACT", "Contacto");
    translation.put("LABEL_START", "Empezar");
    translation.put("LABEL_DOWNLOAD", "Descargar");
    translation.put("GROUP_NEWS_POPUP", "Noticias Emergentes");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Cerrar automáticamente nuevas ventanas emergentes");
    translation.put("BUTTON_CACHE_FEEDS", "Guardar automáticamente noticias para leer fuera de línea");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl no fue capaz de encontrar una aplicación para mostrar este %FORMAT%");
    translation.put("TOOLTIP_OPEN_TAB", "Abrir una nueva pestaña");
    translation.put("MENU_CONNECTION", "Conexión");
    translation.put("MENU_EDIT_RENAME", "Renombrar");
    translation.put("MENU_WORK_OFFLINE", "Trabajar Desconectado");
    translation.put("MENU_WORK_ONLINE", "Trabajar Conectado");
    translation.put("POP_MARK_FAVORITE_READ", "Marcar Favorito como Leído");
    translation.put("POP_IMPORT_BLOGROLL", "Blogroll Sincronizado");
    translation.put("POP_SYNCHRONIZE", "Sincronizar");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl es incapaz de mostrar la noticia.");
    translation.put("ERROR_FILE_NOT_FOUND", "No se pudo encontrar el fichero");
    translation.put("ERROR_AUTH_REQUIRED", "La noticia está protegida y requiere autenticación");
    translation.put("ERROR_REASON", "Motivo");
    translation.put("ERROR_LOADING_FEED", "Error mientras se cargaba la noticia \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Estado");
    translation.put("ERROR_WORKING_OFFLINE", "La noticia no puede mostrarse mientras esté desconectado");
    translation.put("LABEL_MAX_CONNECTIONS", "Número máximo de conexiones");
    translation.put("LABEL_CON_TIMEOUT", "Límite de tiempo en segundos");
    translation.put("LABEL_DELETE_FAVORITE", "Borrar un favorito");
    translation.put("LABEL_DELETE_CATEGORY", "Borrar una categoría");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Borrar Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "EL registro fue satisfactorio");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Abrir en Navegador");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Mostrar botón de cerrar en pestañas");
    translation.put("BUTTON_DELETE_FAVORITE", "al borrar un favorito");
    translation.put("BUTTON_DELETE_CATEGORY", "al borrar una categoría");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "al borrar un Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "No volver a preguntar");
    translation.put("BUTTON_BLOCK_POPUPS", "Bloquear Ventanas Emergentes");
    translation.put("BUTTON_ANIMATE_POPUP", "Animar ventana");
    translation.put("TOOLTIP_QUICKSEARCH", "Búsqueda Rápida");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Editar Blogroll");
    translation.put("GROUP_CONFIRM_DIALOG", "Mostrar Diálogo de Confirmación");
    translation.put("hu", "Húngaro");
    translation.put("MENU_SAVE", "Guardar como");
    translation.put("MENU_TOOLBAR", "Barra de herramientas");
    translation.put("ERROR_NOT_A_XML", "Este fichero no es un documento XML válido");
    translation.put("ERROR_NOT_A_RSS", "Este documento XML no es una noticia RSS, RDF o Atom válida");
    translation.put("ERROR_NOT_A_OPML", "Este documento XML no es un fichero OPML");
    translation.put("ERROR_SUB_EXISTS", "Ya está suscrito a este Blogroll!");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Fallo al cargar el navegador interno!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Añadir un Blogroll nuevo");
    translation.put("QUESTION_DEL_FAV", "¿Está seguro de que quiere borrar el favorito? \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "¿Está seguro de que quiere borrar la categoría \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "¿Está seguro de que quiere borrar el Blogroll?");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formato");
    translation.put("TOOL_MARK", "Marcar");
    translation.put("TOOL_NEXT", "Siguiente");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Iconos y Texto");
    translation.put("TOOL_ICONS", "Iconos");
    translation.put("TOOL_TEXT", "Texto");
    translation.put("TOOL_RATE", "Puntuación");
    translation.put("TOOL_HISTORY", "Historial");
    translation.put("LABEL_SHOW", "Mostrar");
    translation.put("LABEL_SEARCH_IN", "Buscar");
    translation.put("BUTTON_REMOVE", "Borrar");
    translation.put("BUTTON_SMALL_ICONS", "Usar Iconos pequeños");
    translation.put("BUTTON_LINK_TAB", "Enlace a la noticia mostrada");
    translation.put("BUTTON_CLEAR", "Borrar");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Personalizar Barra de Herramientas");
    translation.put("POP_CLEAR_HISTORY", "Borrar Historial");
    translation.put("th", "Thai");
    translation.put("OPML_IMPORTED", "Importado");
    translation.put("ENTIRE_NEWS", "Todas las noticias");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
    translation.put("tr", "Turco");
    translation.put("TOOL_NEWSTIP", "NewsTip");
    translation.put("LABEL_DOMAIN", "Domain");
  }
}