/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Croatian internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov and Vassil Hristov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nHR extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nHR(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Datoteka");
    translation.put("MENU_SAVE", "Spremi kao");
    translation.put("MENU_QUICKVIEW", "Brzi pregled");
    translation.put("MENU_TOOLBAR", "Alatna traka");
    translation.put("MENU_GENERATE_PDF", "Generiraj PDF");
    translation.put("MENU_GENERATE_HTML", "Generiraj HTML");
    translation.put("MENU_GENERATE_RTF", "Generiraj RTF");
    translation.put("MENU_IMPORT", "Uvezi postavke");
    translation.put("MENU_EXPORT", "Izvezi postavke");
    translation.put("MENU_EXIT", "Izlaz");
    translation.put("MENU_WINDOW", "Pregled");
    translation.put("MENU_PREFERENCES", "Postavke");
    translation.put("MENU_BROWSER", "Preglednik");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Izaberite vanjski web preglednik");
    translation.put("MENU_FONT", "Font");
    translation.put("MENU_ENCODING", "Tekst kodna stranica");
    translation.put("MENU_LANGUAGE", "Jezik");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Razno.");
    translation.put("MENU_DIRECTOPEN", "Otvori vijesti bez opisa automatski");
    translation.put("MENU_DIRECTOPENEACH", "Automatski otvori odabrane vijesti u pregledniku");
    translation.put("MENU_SYSTRAY", "Prikaži RSSOwl na tray-u, kada je smanjen");
    translation.put("MENU_CHANNELINFO", "Prikaži info o newsfed-u");
    translation.put("MENU_OPENNEW_BROWSER", "Uvijek otvori interni preglednik u novoj kartici");
    translation.put("MENU_BROWSER_EXTERN", "Koristi vanjski web preglednik");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Prikaži novosti u pregledniku");
    translation.put("MENU_CHECK_UPDATE", "Provjeri postojanje nove verzije nakon pokretanja");
    translation.put("MENU_INFO", "Pomoæ");
    translation.put("MENU_ABOUT", "Info RSSOwl");
    translation.put("MENU_LICENSE", "Licence");
    translation.put("MENU_UPDATE", "Provjeri za nadogradnju");
    translation.put("MENU_WELCOME", "Dobrodošli");
    translation.put("MENU_DONATE", "Donirajte");
    translation.put("MENU_TOOLS", "Alati");
    translation.put("MENU_FEEDSEARCH", "Traži RSS novosti");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimiziraj RSSOwl");
    translation.put("MENU_GOTO", "IdiNa");
    translation.put("MENU_NEXT_NEWS", "Sljedeæa novost");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Sljedeæa neproèitana novost");
    translation.put("MENU_CLOSE", "Zatvori");
    translation.put("MENU_CLOSE_ALL", "Zatvori sve");
    translation.put("MENU_PREVIOUS_TAB", "Prethodna kartica");
    translation.put("MENU_NEXT_TAB", "Sljedeæa kartica");
    translation.put("MENU_HOTKEYS", "Tipke za preèace");
    translation.put("MENU_NEWSTIP_MAIL", "Formatiraj NewsTip e-poštu");
    translation.put("MENU_TELL_FRIENDS", "Reci prijateljima...");
    translation.put("MENU_RELOAD", "Uèitaj");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Generiraj PDF od odabranih vijesti");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Generiraj HTML od odabranih vijesti");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Generiraj RTF od odabranih vijesti");
    translation.put("MENU_MAILING_LIST", "Lista e-pošte");
    translation.put("MENU_TUTORIAL", "Vodiè");
    translation.put("MENU_COLORS", "Boje");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Generalno");
    translation.put("MENU_IMPORT_OPML", "Uvezi iz OPML");
    translation.put("MENU_VALIDATE", "Validiraj Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "Otkrij Newsfeed na nekoj stranici");
    translation.put("MENU_DISPLAY_FEED_PDF", "Prikaži Newsfeed kao PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Prikaži Newsfeed kao RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Prikaži Newsfeed kao HTML");
    translation.put("MENU_NEW_FAVORITE", "Novi Favorit");
    translation.put("MENU_EDIT", "Uredi");
    translation.put("MENU_EDIT_COPY", "Kopiraj");
    translation.put("MENU_EDIT_PASTE", "Zalijepi");
    translation.put("MENU_EDIT_SELECT_ALL", "Oznaèi sve");
    translation.put("MENU_EDIT_DELETE", "Obriši");
    translation.put("MENU_EDIT_CUT", "Odreži");
    translation.put("MENU_CONNECTION", "Veza");
    translation.put("MENU_EDIT_RENAME", "Preimenuj");
    translation.put("MENU_WORK_OFFLINE", "Radi Offline");
    translation.put("MENU_WORK_ONLINE", "Radi Online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Oznaèi");
    translation.put("TOOL_NEXT", "Sljedeæi");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Ikone i tekst");
    translation.put("TOOL_ICONS", "Ikone");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Ocijeni");
    translation.put("TOOL_HISTORY", "Povijest");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Novo");
    translation.put("POP_SUB_CATEGORY", "Podkategorija");
    translation.put("POP_UNSUBSCRIBE", "Odjavi pretplatu");
    translation.put("POP_USEPROXY", "Koristi proxy");
    translation.put("POP_AGGREGATE_FAV", "Sakupi favorite");
    translation.put("POP_AUTO_UPDATE", "Automatska nadogradnja");
    translation.put("POP_UPDATE_ONSTARTUP", "kod pokretanja");
    translation.put("POP_IMPORT", "Uvezi");
    translation.put("POP_FROM_OPML", "Iz OPML datoteke");
    translation.put("POP_EXPORT_OPML", "U OPML datoteku");
    translation.put("POP_COPY", "Kopiraj");
    translation.put("POP_OPEN_IN_BROWSER", "Otvori oznaèeno u web pregledniku");
    translation.put("POP_MARK_UNREAD", "Oznaèi neproèitano");
    translation.put("POP_COPY_NEWS_URL", "Kopiraj link");
    translation.put("POP_RATE_NEWS", "Ocijeni novosti");
    translation.put("POP_MAIL_LINK", "Poèalji NewsTip prijatelju");
    translation.put("POP_OPEN_EXTERN", "Otvori u vanjskom web pregledniku");
    translation.put("POP_BLOG_NEWS", "Dodaj novost u Blog");
    translation.put("POP_OPEN_STARTUP", "Otvori pri pokretanju programa");
    translation.put("POP_KEEP_CURRENT", "Zatvori sve ostale");
    translation.put("POP_KEEP_NEWSFEEDS", "Zatvori sve osim prikaza NewsFed-ova");
    translation.put("POP_MARK_ALL_READ", "Oznaèi sve kao proèitano");
    translation.put("POP_MARK_CATEGORY_READ", "Oznaèi kategoriju proèitanom");
    translation.put("POP_TAB_POSITION", "Pozicija");
    translation.put("POP_TAB_POS_TOP", "Vrh");
    translation.put("POP_TAB_POS_BOTTOM", "Dno");
    translation.put("POP_PROPERTIES", "Svojstva");
    translation.put("POP_MARK_FAVORITE_READ", "Oznaèi Favorit proèitanim");
    translation.put("POP_IMPORT_BLOGROLL", "Sinhroniziran Blogroll");
    translation.put("POP_SYNCHRONIZE", "Sinhroniziraj");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Uredi alatnu traku");
    translation.put("POP_CLEAR_HISTORY", "Obriši povijest");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Upravo se dogodila neoèekivana greška! RSSOwl æe se sada ugasiti, no postavke æe biti saèuvane.\nGreška je zapisana u '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nŽelite li poslati obavijest RSSOwl razvojnom timu?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Greška");
    translation.put("ERROR_NO_NEWS_FOUND", "Greška: Ne mogu pronaæi ni jednu novost!");
    translation.put("ERROR_CAT_EXISTS", "Kategorija tog imena veæ postoji!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Favorit tog imena veæ postoji!");
    translation.put("ERROR_FAV_URL_EXISTS", "Favorit tog linka veæ postoji!");
    translation.put("ERROR_CONNECTION_FAILED", "Neuspješno uspostavljenje veze!");
    translation.put("ERROR_GRABTITLE_FAILED", "Ne mogu dohvatiti naslov!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl nije u moguænosti prikazati traženi newsfeed.");
    translation.put("ERROR_FILE_NOT_FOUND", "Ne mogu pronaæi datoteku");
    translation.put("ERROR_AUTH_REQUIRED", "Ovaj newsfeed je zaštiæen i zahtijeva autentifikaciju");
    translation.put("ERROR_REASON", "Razlog");
    translation.put("ERROR_LOADING_FEED", "Greška prilikom uèitavanja Newsfeed-a \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Ovaj newsfeed se ne može prikazati jer niste spojeni na internet");
    translation.put("ERROR_NOT_A_XML", "Ovo nije valjana XML datoteka");
    translation.put("ERROR_NOT_A_RSS", "Ova XML datoteka nije valjani RSS, RDF ili Atom newsfeed");
    translation.put("ERROR_NOT_A_OPML", "Ova XML datoteka nije valjani OPML podatak");
    translation.put("ERROR_SUB_EXISTS", "Veæ ste pretplaæeni na taj Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Put");
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_NO_INFOS", "Nema dodatnih informacija!");
    translation.put("LABEL_FAVORITE", "Favorit");
    translation.put("LABEL_TITLE", "Naslov");
    translation.put("LABEL_USE_PROXY", "Koristi proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy zahtijeva autorizaciju");
    translation.put("LABEL_USERNAME", "Korisnièko ime");
    translation.put("LABEL_PASSWORD", "Lozinka");
    translation.put("LABEL_PROXY_HOST", "Proxy ime");
    translation.put("LABEL_PROXY_PORT", "Proxy port");
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Koristi proxy za sve favorite");
    translation.put("LABEL_NEWS_RATED", "Novosti ocijenjene");
    translation.put("LABEL_SEARCH_TOPIC", "Molim definirajte pretraživanje");
    translation.put("LABEL_SEARCH_FINISHED", "Pretraživanje završeno.");
    translation.put("LABEL_SEARCH_RUNNING", "Pretraživanje u tijeku...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intenzivno pretraživanje");
    translation.put("LABEL_PREFERED_LANGUAGE", "Preferirani jezik");
    translation.put("LABEL_DESCRIPTION", "Opis");
    translation.put("LABEL_CREATED", "Objavljeno");
    translation.put("LABEL_LAST_VISIT", "Posljednja posjeta");
    translation.put("LABEL_USED_BY", "Korišten od");
    translation.put("LABEL_NAME", "Ime");
    translation.put("LABEL_KEY_SEQUENCE", "Sekvenca znakova");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Sekvenca znakova izgleda pogrešna!");
    translation.put("LABEL_SIZE", "Velièina");
    translation.put("LABEL_STYLE", "Stil");
    translation.put("LABEL_SELECT_ENCODING", "Izaberite kodnu mapu");
    translation.put("LABEL_MAIL_SUBJECT", "Subjekt");
    translation.put("LABEL_MAIL_BODY", "Sadržaj e-pošte");
    translation.put("LABEL_MAIL_USAGE", "Koristite [TITLE], [LINK] i [DESCRIPTION] kao zamijenjive parametre za informacije o novostima");
    translation.put("LABEL_EMPTY_LINK", "Poveznica nije zadana");
    translation.put("LABEL_USE_SYSTEM_FONT", "Koristi sistemski font");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML format e-pošte");
    translation.put("LABEL_CURRENT_COLOR", "Trenutna boja");
    translation.put("LABEL_OPTIONS", "Opcije");
    translation.put("LABEL_SEARCH_RESULTS", "Pretraga za pojmom: \"%TERM%\" , dala je %NUM% rezultata");
    translation.put("LABEL_SEARCH_EMPTY", "Pretraga za pojmom: \"%TERM%\" , nije dala rezultata.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Molim odaberite jdan od dva moguæa izgleda prozora");
    translation.put("LABEL_SINGLE_CLICK", "Jednostruki klik");
    translation.put("LABEL_DOUBLE_CLICK", "Dvostruki klick");
    translation.put("LABEL_SELECT_BLOGGER", "Izaberite vanjski blogger alat");
    translation.put("LABEL_BLOGGER_USAGE", "Koristi [NEWSLINK], [FEEDLINK] i [TITLE] kao zamjenjive parametre za informacije o novostima.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Ponovno otvori posljednje otvoreno prilikom pokretanja programa");
    translation.put("LABEL_TRADITIONAL_TABS", "Tradicionalne kartice");
    translation.put("LABEL_CURVED_TABS", "Zakrivljene kartice");
    translation.put("LABEL_READY", "Spreman");
    translation.put("LABEL_VALIDATION_FINISHED", "Validacija završena");
    translation.put("LABEL_VALIDATING", "Validiram");
    translation.put("LABEL_FEED_TYPE", "Tip Newsfeed");
    translation.put("LABEL_OVERRIDE_DTD", "Nadjaèaj deklaraciju tipa dokumenta");
    translation.put("LABEL_ADDRESS", "Adresa");
    translation.put("LABEL_BROWSER_USAGE", "Koristi [URL] kao zamjenjivi parametar za URL (poveznicu).");
    translation.put("LABEL_OLD_ID", "Stara korisnièka identifikacija (opcionalno)");
    translation.put("LABEL_AMPHETARATE_ID", "Korisnièka identifikacija");
    translation.put("LABEL_SORT_EXPLANATION", "Napravi listu prioriteta za redoslijed po kojem æe newsfeed-ovi biti sortirani automatski. RSSOwl prvo pokušava sortirati newsfeed-ove prema prvom na listi. Ukoliko taj pojam nije prisutan u newsfeed-u, RSSOwl nastavlja sa sljedeæim na listi.");
    translation.put("LABEL_SORT_ORDER", "Sortiranje nosvosti");
    translation.put("LABEL_REMEMBER_AUTH", "Zapamti korisnièko ime i lozinku");
    translation.put("LABEL_NOT_UNSUPPORTED", "Nažalost, nije još podržano u vašem operativnom sustavu");
    translation.put("LABEL_KEY_DEL", "Obriši");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Sve vrijednosti koje su promijenjive, ovdje æe se uzeti kao poèetne vrijednosti za sve nove favorite.");
    translation.put("LABEL_RESTART", "Ove promjene zahtijevaju ponovno pokretanje programa");
    translation.put("LABEL_WELCOME_TITLE", "Dobrodošli u - èitaè novosti  RSS / RDF / Atom Newsfeeds formata");
    translation.put("LABEL_FIRST_STEPS", "Prvi koraci");
    translation.put("LABEL_NEWS", "Novosti");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Podrška");
    translation.put("LABEL_DISCUSSION_FORUM", "Forum za rasprave");
    translation.put("LABEL_PROMOTION", "Promocija");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Spremanje");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksimalni broj konekcija");
    translation.put("LABEL_CON_TIMEOUT", "Broj sekundi potrebnih za prekid veze u sluèaju neuspješnog uspostavljanja veze");
    translation.put("LABEL_DELETE_FAVORITE", "Obriši favorit");
    translation.put("LABEL_DELETE_CATEGORY", "Obriši kategoriju");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Obriši Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registracija je bila uspješna");
    translation.put("LABEL_SHOW", "Prikaži");
    translation.put("LABEL_SEARCH_IN", "Potraži u");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Otvori");
    translation.put("BUTTON_RELOAD_CAT", "Uèitaj favorite");
    translation.put("BUTTON_ADD", "Dodaj");
    translation.put("BUTTON_FILE", "Otvori datoteku");
    translation.put("BUTTON_SEARCH", "Pretraga");
    translation.put("BUTTON_RELOAD", "Uèitaj novosti");
    translation.put("BUTTON_CANCLE", "Odustani");
    translation.put("BUTTON_EXPORT", "Izvezi");
    translation.put("BUTTON_STOP_SEARCH", "Zaustavi pretragu");
    translation.put("BUTTON_CLEAR_RESULTS", "Obriši rezultate");
    translation.put("BUTTON_EXPORT_TO_OPML", "Izvezi u OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Dodaj u favorite");
    translation.put("BUTTON_ASSIGN", "Dodijeli");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Vrati poèetne postavke");
    translation.put("BUTTON_APPLY", "Primjeni");
    translation.put("BUTTON_CHANGE_FONT", "Promijeni font");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Validiraj");
    translation.put("BUTTON_STOP_VALIDATION", "Zaustavi validaciju");
    translation.put("BUTTON_FOCUS_TABS", "Postavi fokus na nove kartice");
    translation.put("BUTTON_DISPLAY_TABS", "Prikaži newsfeed-ove u karticama");
    translation.put("BUTTON_TRAY_STARTUP", "Stavi RSSOwl u tray alatne trake prilikom pokretanja operativnog sustava");
    translation.put("BUTTON_TRAY_EXIT", "Stavi RSSOwl u tray alatne trake prilikom gašenja operativnog sustava");
    translation.put("BUTTON_SHOW_ERRORS", "Prikaži greške u karticama");
    translation.put("BUTTON_CHANGE", "Promijeni");
    translation.put("BUTTON_MARK_ALL_READ", "Oznaèi sve kategorije proèitanima");
    translation.put("BUTTON_AGGREGATE_ALL", "Povuci novosti iz svih kategorija");
    translation.put("BUTTON_RELOAD_ALL", "Uèitaj sve kategorije");
    translation.put("BUTTON_SEARCH_ALL", "Traži u svim kategorijama");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Oznaèi sve novosti proèitanima prilikom smanjivanja programa");
    translation.put("BUTTON_TRAY_POPUP", "Prikaži pop-up prozor ako ima neproèitanih novosti");
    translation.put("BUTTON_READ_ON_CLOSE", "Oznaèi vijest proèitanom, kada se zatvori kartica");
    translation.put("BUTTON_UP", "Gore");
    translation.put("BUTTON_DOWN", "Dolje");
    translation.put("BUTTON_CREATE_ACCOUNT", "Kreiraj korisnièki raèun");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Zatvori pop-up sa novostima automatski");
    translation.put("BUTTON_CACHE_FEEDS", "Automatski spremi newsfeed-ove za èitanje i kada niste spojeni na internet");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Otvori u web pregledniku");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Prikaži gumb za zatvaranje kartica");
    translation.put("BUTTON_DELETE_FAVORITE", "Kada brišete favorit");
    translation.put("BUTTON_DELETE_CATEGORY", "Kada brišete kategoriju");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Kada brišete Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Ne pitaj ponovno");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokiraj pop-up prozore");
    translation.put("BUTTON_ANIMATE_POPUP", "Animacija prilikom pop-up prozora");
    translation.put("BUTTON_REMOVE", "Ukloni");
    translation.put("BUTTON_SMALL_ICONS", "Koristi male ikone");
    translation.put("BUTTON_LINK_TAB", "Poveži sa prikazanim Feed-om");
    translation.put("BUTTON_CLEAR", "Obriši");
    translation.put("BUTTON_NO_SORT", "Ne sortiraj Newsfeed-ove automatski");

    /** Header */
    translation.put("HEADER_NEWS", "Zaglavlje");
    translation.put("HEADER_RSS_FAVORITES", "Favoriti");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Kliknite da se otvore stranice!");
    translation.put("TOOLTIP_PRINT", "Ispiši novosti");
    translation.put("TOOLTIP_RATE", "Kliknite za ocjenu");
    translation.put("TOOLTIP_GRAB_TITLE", "Koristi naslov od newsfeed-a");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Neproèitane novosti dostupne");
    translation.put("TOOLTIP_SKIP", "Preskoèi");
    translation.put("TOOLTIP_OPEN_TAB", "Otvori u novoj kartici");
    translation.put("TOOLTIP_QUICKSEARCH", "Brza pretraga");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Datum objave");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategorija");
    translation.put("TABLE_HEADER_PUBLISHER", "Objavio");
    translation.put("TABLE_HEADER_NEWSTITLE", "Zaglavlje");
    translation.put("TABLE_HEADER_FEED", "Newsfeed");
    translation.put("TABLE_HEADER_FEEDURL", "Newsfeed URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Newsfeed naslov");
    translation.put("TABLE_HEADER_LINE", "Linija");
    translation.put("TABLE_HEADER_STATUS", "Status proèitanog");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Poèetna stranica");
    translation.put("CHANNEL_INFO_PUBDATE", "Datum objave");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Posljednji puta izmjenjeno");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Èime upravljati");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategorija");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Vrijeme života kanala");
    translation.put("CHANNEL_INFO_RSSVERSION", "Format");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Objavio");
    translation.put("CHANNEL_INFO_LANGUAGE", "Jezik");
    translation.put("CHANNEL_INFO_CREATOR", "Kreator");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Obnova");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "puta");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Izvor");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Ograðivanje");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Komentari");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Pozor");
    translation.put("MESSAGEBOX_FILL_URL", "Unesite URL");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategorija tog imena veæ postoji");
    translation.put("MESSAGEBOX_SELECT_CAT", "Molim odaberite kategoriju");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Datoteka veæ postoji. Pregaziti?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Datoteka ne sadrži postavke ovog programa!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Uvoz postavki je obavljen uspješno!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Newstext je prazan! Molim odaberite novosti.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Dodaj novi favorit");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Dodaj novu kategoriju");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Molim unesite naslov");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Molim unesite URL i naslov");
    translation.put("BASE_AUTH_TITLE", "Odabrane stranice zahtijevaju autorizaciju!");
    translation.put("BASE_AUTH_MESSAGE", "Molim unesite korisnièko ime i lozinku.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Valjani RSS nije odabran!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Molim potvrdite");
    translation.put("SEARCH_DIALOG_TITLE", "Pretraga");
    translation.put("SEARCH_DIALOG_MESSAGE", "Molim koristite AND (kao i), OR (kao ili) i NOT (kao ne), za specifièniju pretragu!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Traži");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Samo cijelu rijeè");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Pazi na velika-mala slova");
    translation.put("SEARCH_DIALOG_REGEX", "Koristi regularne izraze");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nema nove verzije");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Veæ imate instaliranu najnoviju verziju!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informacija");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Uredi kategoriju");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Uredi favorite");
    translation.put("DIALOG_TITLE_UPDATE", "Nova verija programa je dostupna!");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Molimo odaberite put do izvršne datoteke");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Ne mogu se spojiti na http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Morate prvo unijeti AmphetaRate korisnièki ID!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorija ne sadrži ni jedan favorit!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Molim pritisnite sekvencu znakova");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Neuspješno pokretanje preglednika!\nMolim odaberite preglednik u 'Postavkama'");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Molimo najprije izaberite blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Odaberite kategoriju");
    translation.put("DIALOG_ID_ATTENTION", "Najprije kreirajte AmphetaRate korisnièki raèun!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Molim unesite URL web stranice");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl nije uspio pronaæi ni jednu aplikaciju kako bi prikazao %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Uredi Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Neuspješno uèitavanje internog preglednika!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Dodaj novi Blogroll");
    translation.put("QUESTION_DEL_FAV", "Jeste li sigurni da želite obrisati favorit \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Jeste li sigurni da želite obrisati kategoriju \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Jeste li sigurni da želite obrisati Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Natrag");
    translation.put("BROWSER_FORWARD", "Naprijed");
    translation.put("BROWSER_STOP", "Stop");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastièno");
    translation.put("RATE_GOOD", "Dobro");
    translation.put("RATE_MODERATE", "Osrednje");
    translation.put("RATE_BAD", "Loše");
    translation.put("RATE_VERY_BAD", "Jako loše");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "Nema");
    translation.put("UPDATE_INTERVAL_ONE", "nakon jedne minute");
    translation.put("UPDATE_INTERVAL_FIVE", "nakon 5 minuta");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "nakon 15 minuta");
    translation.put("UPDATE_INTERVAL_THIRTY", "Svakih 30 minuta");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "nakon jednog sata");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "nakon 3 sata");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "Svakih 6 sati");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "nakon 12 sati");
    translation.put("UPDATE_INTERVAL_ONEDAY", "nakon 24 sata");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Font teksta");
    translation.put("FONT_AREA_DIALOG", "Font dijaloga");
    translation.put("FONT_AREA_TREE", "Font stabla");
    translation.put("FONT_AREA_TABLE", "Font tabele");
    translation.put("FONT_AREA_HEADER", "Font zaglavlja");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Font teksta se koristi za novosti, informacije o kanalu, poruke i poruke o grešci.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Font dijaloga se koristi za sve dijaloge.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Font stabla se koristi za prikaz stabla koje sadrži favorite.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Font tabele se koristi za tabelu koja sadrži novosti.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Font zaglavlja se koristi za prikaz zaglavlja.");
    translation.put("FONT_STYLE_BOLD", "Podebljano");
    translation.put("FONT_STYLE_ITALIC", "Ukošeno");
    translation.put("FONT_STYLE_NORMAL", "Normalno");

    /** Groups */
    translation.put("GROUP_COMMAND", "Zapovijed");
    translation.put("GROUP_SELECTED_FONT", "Izaberi Font");
    translation.put("GROUP_FONT_AREA", "Font polje");
    translation.put("GROUP_WINDOW_LAYOUT", "Izgled i pozicija prozora");
    translation.put("GROUP_OPEN_MODE", "Otvori naèin");
    translation.put("GROUP_ARGUMENTS", "Argumenti");
    translation.put("GROUP_LINK_COLOR", "Boja linka");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Boja rezultata pretrage");
    translation.put("GROUP_TAB_LAYOUT", "Izgled kartice");
    translation.put("GROUP_TRAY", "Sistemski Tray");
    translation.put("GROUP_GENERAL", "Generalno");
    translation.put("GROUP_EXISTING_ACCOUNT", "Postojeæi raèun");
    translation.put("GROUP_NEW_ACCOUNT", "Kreiraj novi korisnièki raèun");
    translation.put("GROUP_NEWS_POPUP", "Popup novosti");
    translation.put("GROUP_CONFIRM_DIALOG", "Prikaži dijalog o potvrdi");

    /** Languages */
    translation.put("de", "Njemaèki");
    translation.put("da", "Danski");
    translation.put("el", "Grèki");
    translation.put("en", "Engleski");
    translation.put("es", "Španjolski");
    translation.put("fr", "Francuski");
    translation.put("gl", "Galicijski");
    translation.put("it", "Talijanski");
    translation.put("nl", "Nizozemski");
    translation.put("pt", "Portugalski (Brazil)");
    translation.put("ru", "Ruski");
    translation.put("bg", "Bugarski");
    translation.put("zhcn", "Pojednostavljeni Kineski");
    translation.put("zhtw", "Tradicionalni Kineski");
    translation.put("ja", "Japanski");
    translation.put("ko", "Korejski");
    translation.put("pl", "Poljski");
    translation.put("no", "Norveški");
    translation.put("sv", "Švedski");
    translation.put("bn", "Bengalski");
    translation.put("fi", "Finski");
    translation.put("uk", "Ukrainski");
    translation.put("tr", "Turski");
    translation.put("hu", "Madžarski");
    translation.put("sl", "Slovenjanski");
    translation.put("cs", "Èeški");
    translation.put("hu", "Madžarski");
    translation.put("th", "Tajlandski");
    translation.put("sr", "Srpski (Èirilica)");
    translation.put("sh", "Srpski (Latinica)");
    translation.put("hr", "Hrvatski");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Opis nije dostupan!");
    translation.put("LOAD_FEED", "Uèitavam");
    translation.put("SEARCH_FEED", "Pretražujem");
    translation.put("RELOAD_FEED", "Osvježavam");
    translation.put("PRINTED_FROM_RSSOWL", "Ispisano sa RSSOwl-a (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Ispisujem novosti sa RSSOwl-a (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Pokaži RSSOwl");
    translation.put("TAB_WELCOME", "Dobrodošli");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument generirao RSSOwl");
    translation.put("NO_TITLE", "Nema naslova");
    translation.put("RECOMMENDED_ARTICLES", "Preporuèeni èlanci");
    translation.put("RSSOWL_TEASER", "RSSOwl je besplatn, opensource RSS i RDF èitaè novosti. Posebne osobine su:\n\n- Izvoz novosti u PDF, HTML, RTF, OPML format\n- Uvoz favorita iz OPML\n- Ptretraga cijelog teskta sa obilježavanjem rezultata\n- Snažan RSS i RDF pretraživaèki alat\n- Pregld vijesti iz ugraðenog preglednika\n- Upravljanje favoritima preko kategorija\n- Moguæe ga je pokrenuti na Windows, Linux, Solaris i Mac operativnim sustavima\n\nZa kompletnu listu svojstava posjetite: http://www.rssowl.org/features.html\n\nPreuzimanje sa: http://sourceforge.net/project/showfiles.php?group_id=86683");
    translation.put("MAIL_ERROR_BODY", "Molim priložite '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' ovom e-mailu, te dodajte kratak opis što je RSSOwl radio baš prije nego se dogodila greška. Zahvaljujemo!");
    translation.put("FORMAT_AUTO_DETECT", "Otkrij automatski");
    translation.put("NEWSFEED_VALID", "NewsFeed je valjan");
    translation.put("OPML_IMPORTED", "Uvezeno");
    translation.put("ENTIRE_NEWS", "Cijele novosti");
    translation.put("SEARCH_AND", "i");
    translation.put("SEARCH_OR", "ili");
    translation.put("SEARCH_NOT", "ne");
  }
}