/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Hungarian internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nHU extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nHU(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Fájl");
    translation.put("MENU_SAVE", "Mentés másként");
    translation.put("MENU_TOOLBAR", "Eszköztár");
    translation.put("MENU_QUICKVIEW", "Gyorsnézet");
    translation.put("MENU_GENERATE_PDF", "PDF generálása");
    translation.put("MENU_GENERATE_HTML", "HTML generálása");
    translation.put("MENU_GENERATE_RTF", "RTF generálása");
    translation.put("MENU_IMPORT", "Beállítások importálása");
    translation.put("MENU_EXPORT", "Beállítások exportálása");
    translation.put("MENU_EXIT", "Kilépés");
    translation.put("MENU_WINDOW", "Nézet");
    translation.put("MENU_PREFERENCES", "Beállítások");
    translation.put("MENU_BROWSER", "Böngésző");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Válassz külső böngészőt");
    translation.put("MENU_FONT", "Betűtípus");
    translation.put("MENU_ENCODING", "Szöveg kódolás");
    translation.put("MENU_LANGUAGE", "Nyelv");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Egyéb");
    translation.put("MENU_DIRECTOPEN", "Az üres hírek automatikus megnyitása a böngészőben");
    translation.put("MENU_DIRECTOPENEACH", "A kijelölt hírek automatikus megnyitása a böngészőben");
    translation.put("MENU_SYSTRAY", "Az RSSOwl a tálcára kerüljön kicsinyítés helyett");
    translation.put("MENU_CHANNELINFO", "Híretető információk mutatása");
    translation.put("MENU_OPENNEW_BROWSER", "A belső böngészőt mindig új tab alatt nyissa meg");
    translation.put("MENU_BROWSER_EXTERN", "Használjon külső böngészőt");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Hírek szövegének megjelenítése a böngészőben");
    translation.put("MENU_CHECK_UPDATE", "Újabb verzió ellenőrzése indításkor");
    translation.put("MENU_INFO", "Súgó");
    translation.put("MENU_ABOUT", "Az RSSOwl névjegye");
    translation.put("MENU_LICENSE", "Licensz");
    translation.put("MENU_UPDATE", "Új verzió ellenőrzése");
    translation.put("MENU_WELCOME", "Üdvözlés");
    translation.put("MENU_DONATE", "Hozzájárulások");
    translation.put("MENU_TOOLS", "Eszközök");
    translation.put("MENU_FEEDSEARCH", "Híretetők keresése");
    translation.put("MENU_MINIMIZE_RSSOWL", "Az RSSOwl kicsinyítése");
    translation.put("MENU_GOTO", "Ugrás");
    translation.put("MENU_NEXT_NEWS", "Következő hír");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Következő olvasatlan hír");
    translation.put("MENU_CLOSE", "Bezárás");
    translation.put("MENU_CLOSE_ALL", "Mindegyik bezárása");
    translation.put("MENU_PREVIOUS_TAB", "Előző Tab");
    translation.put("MENU_NEXT_TAB", "Következő Tab");
    translation.put("MENU_HOTKEYS", "Gyorsbillentyűk");
    translation.put("MENU_NEWSTIP_MAIL", "NewsTip Levél formázása");
    translation.put("MENU_TELL_FRIENDS", "Ezt elmondom a barátaimnak...");
    translation.put("MENU_RELOAD", "Újratöltés");
    translation.put("MENU_GENERATE_PDF_SELECTION", "PDF generálása a kijelölt hírekből");
    translation.put("MENU_GENERATE_HTML_SELECTION", "HTML generálása a kijelölt hírekből");
    translation.put("MENU_GENERATE_RTF_SELECTION", "RTF generálása a kijelölt hírekből");
    translation.put("MENU_MAILING_LIST", "Levelezési lista");
    translation.put("MENU_TUTORIAL", "Gyorstalpaló");
    translation.put("MENU_COLORS", "Színek");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Általános");
    translation.put("MENU_IMPORT_OPML", "Importálás OPML fájlból");
    translation.put("MENU_VALIDATE", "Híradag hitelesítése");
    translation.put("MENU_FEED_DISCOVERY", "Híradagok keresése webhelyen");
    translation.put("MENU_DISPLAY_FEED_PDF", "Híradagok megjelenítése PDF-ként");
    translation.put("MENU_DISPLAY_FEED_RTF", "Híradagok megjelenítése RTF-ként");
    translation.put("MENU_DISPLAY_FEED_HTML", "Híradagok megjelenítése HTML-ként");
    translation.put("MENU_NEW_FAVORITE", "Új kedvenc");
    translation.put("MENU_EDIT", "Szerkesztés");
    translation.put("MENU_EDIT_COPY", "Másolás");
    translation.put("MENU_EDIT_PASTE", "Beillesztés");
    translation.put("MENU_EDIT_SELECT_ALL", "Minden kijelölése");
    translation.put("MENU_EDIT_DELETE", "Törlés");
    translation.put("MENU_EDIT_CUT", "Kivágás");
    translation.put("MENU_CONNECTION", "Kapcsolat");
    translation.put("MENU_EDIT_RENAME", "Átnevezés");
    translation.put("MENU_WORK_OFFLINE", "Kapcsolat nélküli munka");
    translation.put("MENU_WORK_ONLINE", "Online munka");

    /** ToolBar */
    translation.put("TOOL_MARK", "Megjelöl");
    translation.put("TOOL_NEXT", "Köv");
    translation.put("TOOL_SEPARATOR", "Szeparátor");
    translation.put("TOOL_ICONS_TEXT", "Ikonok és szöveg");
    translation.put("TOOL_ICONS", "Ikonok");
    translation.put("TOOL_TEXT", "Szöveg");
    translation.put("TOOL_RATE", "Értékelés");
    translation.put("TOOL_HISTORY", "Elõzmény");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Új");
    translation.put("POP_SUB_CATEGORY", "Al-kategória");
    translation.put("POP_UNSUBSCRIBE", "Lemondás");
    translation.put("POP_USEPROXY", "Proxy használata");
    translation.put("POP_AGGREGATE_FAV", "Kedvencek csoportosítása");
    translation.put("POP_AUTO_UPDATE", "Autom. frissítés");
    translation.put("POP_UPDATE_ONSTARTUP", "induláskor");
    translation.put("POP_IMPORT", "Importálás");
    translation.put("POP_FROM_OPML", "OPML fájlból");
    translation.put("POP_EXPORT_OPML", "OPML fájlba");
    translation.put("POP_COPY", "Másolás");
    translation.put("POP_OPEN_IN_BROWSER", "Kijelölt rész megnyitása böngészőben");
    translation.put("POP_MARK_UNREAD", "Megjelölés olvasatlanként");
    translation.put("POP_COPY_NEWS_URL", "Link másolása");
    translation.put("POP_RATE_NEWS", "Hír értékelése");
    translation.put("POP_MAIL_LINK", "NewsTip küldése egy barátodnak");
    translation.put("POP_OPEN_EXTERN", "Megnyitás programon kívül");
    translation.put("POP_BLOG_NEWS", "Hír blogolása");
    translation.put("POP_OPEN_STARTUP", "Megnyitás indításkor");
    translation.put("POP_KEEP_CURRENT", "A többi bezárása");
    translation.put("POP_KEEP_NEWSFEEDS", "Minden más bezárása a Hírek kivételével");
    translation.put("POP_MARK_ALL_READ", "Minden megjelölése olvasottként");
    translation.put("POP_MARK_CATEGORY_READ", "Kategória megjelölése olvasottként");
    translation.put("POP_TAB_POSITION", "Pozíció");
    translation.put("POP_TAB_POS_TOP", "Fent");
    translation.put("POP_TAB_POS_BOTTOM", "Lent");
    translation.put("POP_PROPERTIES", "Tulajdonságok");
    translation.put("POP_MARK_FAVORITE_READ", "Megjelölés olvasottként");
    translation.put("POP_IMPORT_BLOGROLL", "Szinkronizált Blogroll");
    translation.put("POP_SYNCHRONIZE", "Szinkronizálás");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Eszköztár testreszabása");
    translation.put("POP_CLEAR_HISTORY", "Elõzmények törlése");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Nem várt hiba történt! Az RSSOwl most kilép, de a beállítások mentve lesznek.\nA hiba naplózásra került a(z) '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' fájlban.\n\nSzeretnél egy hibajelentést küldeni az RSSOwl csapatnak?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Hiba");
    translation.put("ERROR_NO_NEWS_FOUND", "Hiba: Nem találhatóak hírek!");
    translation.put("ERROR_CAT_EXISTS", "Ilyen nevű kategória már létezik!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Ilyen nevű kedvenc már létezik!");
    translation.put("ERROR_FAV_URL_EXISTS", "Ez az URL már megtaláható a kedvencek között!");
    translation.put("ERROR_CONNECTION_FAILED", "A kapcsolat megszakadt!");
    translation.put("ERROR_GRABTITLE_FAILED", "Nem található meg a cím!");
    translation.put("ERROR_NEWSFEED_GENERAL", "Az RSSOwl nem tudja megjeleníteni az etetot.");
    translation.put("ERROR_FILE_NOT_FOUND", "Nem található meg a fájl");
    translation.put("ERROR_AUTH_REQUIRED", "Az etető jelszóval védett és hitelesítést igényel");
    translation.put("ERROR_REASON", "Hiba oka");
    translation.put("ERROR_LOADING_FEED", "Hiba történt a(z) \"%TITLE%\" eteto betöltésekor");
    translation.put("ERROR_HTTP_STATUS", "Állapot");
    translation.put("ERROR_WORKING_OFFLINE", "Az etető nem jeleníthető meg kapcsolat nélküli módban");
    translation.put("ERROR_NOT_A_XML", "Ez a fájl nem egy érvényes XML fájl");
    translation.put("ERROR_NOT_A_RSS", "Az XML dokumentum nem egy érvényes RSS, RDF vagy Atom híradag");
    translation.put("ERROR_NOT_A_OPML", "Az XML dokumentum nem egy OPML fájl");
    translation.put("ERROR_SUB_EXISTS", "Már egyszer előfizettél erre Blogrollra!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Útvonal");
    translation.put("LABEL_CATEGORY", "Kategória");
    translation.put("LABEL_NO_INFOS", "Nincs kiegészítő információ!");
    translation.put("LABEL_FAVORITE", "Kedvenc");
    translation.put("LABEL_TITLE", "Cím");
    translation.put("LABEL_USE_PROXY", "Proxy használata");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "A Proxy hitelesítést igényel");
    translation.put("LABEL_USERNAME", "Felhasználónév");
    translation.put("LABEL_PASSWORD", "Jelszó");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Proxy Port");
    translation.put("LABEL_CATEGORY", "Kategória");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Proxy használata minden kedvenchez");
    translation.put("LABEL_NEWS_RATED", "Értékelt hírek");
    translation.put("LABEL_SEARCH_TOPIC", "Kérlek pontosítsd a keresést");
    translation.put("LABEL_SEARCH_FINISHED", "A keresés befejezve.");
    translation.put("LABEL_SEARCH_RUNNING", "A keresés folyamatban...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intenzív keresés");
    translation.put("LABEL_PREFERED_LANGUAGE", "Kívánt nyelv");
    translation.put("LABEL_DESCRIPTION", "Leírás");
    translation.put("LABEL_CREATED", "Létrehozva");
    translation.put("LABEL_LAST_VISIT", "Utoljára látogatott");
    translation.put("LABEL_USED_BY", "használva:");
    translation.put("LABEL_NAME", "Név");
    translation.put("LABEL_KEY_SEQUENCE", "Billentyűsorozat");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "A billentyűsorozat érvénytelennek tűnik!");
    translation.put("LABEL_SIZE", "Méret");
    translation.put("LABEL_STYLE", "Stílus");
    translation.put("LABEL_SELECT_ENCODING", "Kódolás választása");
    translation.put("LABEL_MAIL_SUBJECT", "Téma");
    translation.put("LABEL_MAIL_BODY", "Főszöveg");
    translation.put("LABEL_MAIL_USAGE", "Használhatod a [TITLE], [LINK] és [DESCRIPTION] szavakat keresési paraméterekként.");
    translation.put("LABEL_EMPTY_LINK", "Nincs link megadva");
    translation.put("LABEL_USE_SYSTEM_FONT", "Rendszer-betűtípus");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML formátumú levél");
    translation.put("LABEL_CURRENT_COLOR", "Jelenlegi szín");
    translation.put("LABEL_OPTIONS", "Opciók");
    translation.put("LABEL_SEARCH_RESULTS", "A(z) \"%TERM%\" keresése %NUM% találatot eredményezett.");
    translation.put("LABEL_SEARCH_EMPTY", "A(z) \"%TERM%\" keresése nem adott találatot.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Kérlek, válassz egyet a kétféle Ablak-elrendezés közül");
    translation.put("LABEL_SINGLE_CLICK", "Egy klikk");
    translation.put("LABEL_DOUBLE_CLICK", "Dupla klikk");
    translation.put("LABEL_SELECT_BLOGGER", "Válassz külső bloggert");
    translation.put("LABEL_BLOGGER_USAGE", "Használhatod a [NEWSLINK], [FEEDLINK] és [TITLE] szavakat keresési paraméterekként.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Utolsóként megnyitott hírek megnyitása induláskor");
    translation.put("LABEL_TRADITIONAL_TABS", "Hagyományos Tabok");
    translation.put("LABEL_CURVED_TABS", "Kerekített Tabok");
    translation.put("LABEL_READY", "Kész");
    translation.put("LABEL_VALIDATION_FINISHED", "Hitelesítés befejezve");
    translation.put("LABEL_VALIDATING", "Hitelesítés");
    translation.put("LABEL_FEED_TYPE", "Híradag típusa");
    translation.put("LABEL_OVERRIDE_DTD", "Doctype deklaráció kihagyása");
    translation.put("LABEL_ADDRESS", "Cím");
    translation.put("LABEL_BROWSER_USAGE", "Használhatod az [URL] szót keresési paraméterként.");
    translation.put("LABEL_OLD_ID", "Régi User ID (opcionális)");
    translation.put("LABEL_AMPHETARATE_ID", "User ID");
    translation.put("LABEL_SORT_EXPLANATION", "Add meg azt a feltételt, ami alapján a hírek rendezve lesznek. Az RSSOwl elsőként mindig a lista legelső eleme alapján kezdi a rendezést és amennyiben az nem található, akkor lép át a következő elemekre.");
    translation.put("LABEL_SORT_ORDER", "Hírek rendezése");
    translation.put("LABEL_REMEMBER_AUTH", "Felhasználónév és Jelszó megjegyzése");
    translation.put("LABEL_NOT_UNSUPPORTED", "Egyelőre nincs támogatva ezen az operációs rendszeren.");
    translation.put("LABEL_KEY_DEL", "Törl");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Az itt beállított értékek lesznek az alapértelmezettek minden új kedvenc létrehozásakor.");
    translation.put("LABEL_RESTART", "A változtatások miatt újra kell indítani az RSSOwl-t.");
    translation.put("LABEL_WELCOME_TITLE", "Üdvözök az RSSOwl - Hírolvasó az RSS / RDF / Atom Híradagokhoz");
    translation.put("LABEL_FIRST_STEPS", "Első lépések");
    translation.put("LABEL_NEWS", "Hírek");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Híretető");
    translation.put("LABEL_SUPPORT", "Támogatás");
    translation.put("LABEL_DISCUSSION_FORUM", "Vitafórum");
    translation.put("LABEL_PROMOTION", "Promóció");
    translation.put("LABEL_CONTACT", "Kapcsolat");
    translation.put("LABEL_START", "Indítás");
    translation.put("LABEL_DOWNLOAD", "Letöltés");
    translation.put("LABEL_MAX_CONNECTIONS", "Kapcsolatok maximális száma");
    translation.put("LABEL_CON_TIMEOUT", "Kapcsolat időtúllépés másodpercben");
    translation.put("LABEL_DELETE_FAVORITE", "Kedvenc törlése");
    translation.put("LABEL_DELETE_CATEGORY", "Kategória törlése");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Blogroll törlése");
    translation.put("LABEL_REGISTRATION_SUCCESS", "A regisztráció sikeres volt");
    translation.put("LABEL_SHOW", "Megjelenítés");
    translation.put("LABEL_SEARCH_IN", "Keresés itt");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Megnyitás");
    translation.put("BUTTON_RELOAD_CAT", "Kedvencek újratöltése");
    translation.put("BUTTON_ADD", "Hozzáadás");
    translation.put("BUTTON_FILE", "Fájl megnyitása");
    translation.put("BUTTON_SEARCH", "Keresés");
    translation.put("BUTTON_RELOAD", "Hírek újratöltése");
    translation.put("BUTTON_CANCLE", "Mégsem");
    translation.put("BUTTON_EXPORT", "Exportálás");
    translation.put("BUTTON_STOP_SEARCH", "Keresés leállítása");
    translation.put("BUTTON_CLEAR_RESULTS", "Eredmények törlése");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exportálás OPML-ként");
    translation.put("BUTTON_ADDTO_FAVORITS", "Hozzáadás a Kedvencekhez");
    translation.put("BUTTON_ASSIGN", "Beállít");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Alapértékek visszaállítása");
    translation.put("BUTTON_APPLY", "Alkalmaz");
    translation.put("BUTTON_CHANGE_FONT", "Betűtípus váltása");
    translation.put("BUTTON_OK", "Rendben");
    translation.put("BUTTON_VALIDATE", "Hitelesítés");
    translation.put("BUTTON_STOP_VALIDATION", "Hitelesítés leállítása");
    translation.put("BUTTON_FOCUS_TABS", "Fókuszálás az új tabokra");
    translation.put("BUTTON_DISPLAY_TABS", "Híradagok megjelenítése tabok segítségével");
    translation.put("BUTTON_TRAY_STARTUP", "Az RSSOwl elhelyezése a Tálcán induláskor");
    translation.put("BUTTON_TRAY_EXIT", "Az RSSOwl elhelyezése a Tálcán kilépéskor");
    translation.put("BUTTON_SHOW_ERRORS", "Hibák megjelenítése a tabok között");
    translation.put("BUTTON_CHANGE", "Változtatás");
    translation.put("BUTTON_MARK_ALL_READ", "Összes kategória megjelölése olvasottként");
    translation.put("BUTTON_AGGREGATE_ALL", "Összes kategória csoportosítása");
    translation.put("BUTTON_RELOAD_ALL", "Összes kategória újratöltése");
    translation.put("BUTTON_SEARCH_ALL", "Keresés minden kategóriában");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Kicsinyítéskor minden hír megjelölése olvasottként");
    translation.put("BUTTON_TRAY_POPUP", "Előugró ablakok használata új hírek esetén");
    translation.put("BUTTON_READ_ON_CLOSE", "Hír megjelölése olvasottként a tab bezárásakor");
    translation.put("BUTTON_UP", "Fel");
    translation.put("BUTTON_DOWN", "Le");
    translation.put("BUTTON_NO_SORT", "Ne rendezze a híreket automatikusan");
    translation.put("BUTTON_CREATE_ACCOUNT", "Létrehozás");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Az előugró ablak automatikus bezárása");
    translation.put("BUTTON_CACHE_FEEDS", "A híradagok automatikus mentése az offline olvasáshoz");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Megnyitás a böngészőben");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Bezárás gomb mutatása a tabokon");
    translation.put("BUTTON_DELETE_FAVORITE", "Kedvenc törlésekor");
    translation.put("BUTTON_DELETE_CATEGORY", "Kategória törlésekor");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Blogroll törlésekor");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Többet ne kérdezzelek");
    translation.put("BUTTON_BLOCK_POPUPS", "Előugró ablakok blokkolása");
    translation.put("BUTTON_ANIMATE_POPUP", "Popup animációja");
    translation.put("BUTTON_REMOVE", "Törlés");
    translation.put("BUTTON_SMALL_ICONS", "Kisméretû ikonok használata");
    translation.put("BUTTON_LINK_TAB", "Kapcsolás a megjelenített híradaghoz");
    translation.put("BUTTON_CLEAR", "Töröl");

    /** Header */
    translation.put("HEADER_NEWS", "Főcímek");
    translation.put("HEADER_RSS_FAVORITES", "Kedvencek");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Klikk ide a webhely megnyitásához!");
    translation.put("TOOLTIP_PRINT", "Hírek nyomtatása");
    translation.put("TOOLTIP_RATE", "Klikk az értékeléshez");
    translation.put("TOOLTIP_GRAB_TITLE", "A híretető címének használata");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Olvasatlan hírek érkeztek");
    translation.put("TOOLTIP_SKIP", "Kihagy");
    translation.put("TOOLTIP_OPEN_TAB", "Új tab nyitása");
    translation.put("TOOLTIP_QUICKSEARCH", "Gyorskeresés");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Publikálás dátuma");
    translation.put("TABLE_HEADER_AUTHOR", "Szerző");
    translation.put("TABLE_HEADER_CATEGORY", "Kategória");
    translation.put("TABLE_HEADER_PUBLISHER", "Kiadó");
    translation.put("TABLE_HEADER_NEWSTITLE", "Hírfejléc");
    translation.put("TABLE_HEADER_FEED", "Híretető");
    translation.put("TABLE_HEADER_FEEDURL", "Híretető URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Híretető Címe");
    translation.put("TABLE_HEADER_LINE", "Sor");
    translation.put("TABLE_HEADER_STATUS", "Olvasási állapot");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Honlap");
    translation.put("CHANNEL_INFO_PUBDATE", "Publikálás dátuma");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Utolsó csatorna módosítás");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Főszerkesztő");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmester");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategória");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "A csatorna életideje");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formátum");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generátor");
    translation.put("CHANNEL_INFO_PUBLISHER", "Kiadó");
    translation.put("CHANNEL_INFO_LANGUAGE", "Nyelv");
    translation.put("CHANNEL_INFO_CREATOR", "Létrehozó");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Frissítés");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "alkalommal");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Forrás");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Melléklet");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Megjegyzések");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Figyelem");
    translation.put("MESSAGEBOX_FILL_URL", "Kérlek adj meg egy URL-t vagy útvonalat");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Ilyen nevű kategória már létezik");
    translation.put("MESSAGEBOX_SELECT_CAT", "Kérlek válassz kategóriát");
    translation.put("MESSAGEBOX_FILE_EXISTS", "A fájl létezik. Felülírjam?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "A fájl nem tartalmaz RSSOwl beállításokat!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "A beállítások importálása sikeres volt!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "A hír szövege üres! Kérlek válassz egy hírt.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Új kedvenc hozzáadása");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Új kategória hozzáadása");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Add meg a címet");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Kérlek add meg az url / útvonalat és a címet");
    translation.put("BASE_AUTH_TITLE", "A kért oldal hitelesítést igényel!");
    translation.put("BASE_AUTH_MESSAGE", "Kérlek add meg a felhasználónevet és a jelszót.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Nincsen hiteles RSS kijelölve a tabok között!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Erősítsd meg");
    translation.put("SEARCH_DIALOG_TITLE", "Keresés");
    translation.put("SEARCH_DIALOG_MESSAGE", "Használd az ÉS, VAGY és NEM szavakat a keresés szûkítéséhez");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Keresendő");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Csak teljes szóként");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Kis-nagybetű érzékenység");
    translation.put("SEARCH_DIALOG_REGEX", "Reguláris kifejezések használata");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nincsen új verzió");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Jelenleg a legfrissebb RSSOwl verziót használod!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Információ");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Kategória szerkesztése");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Kedvenc szerkesztése");
    translation.put("DIALOG_TITLE_UPDATE", "Újabb RSSOwl verzió elérhető");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Kérlek add meg a program útvonalát");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Nem lehet a http://www.rssowl.org címhez csatlakozni");
    translation.put("DIALOG_ID_ATTENTION", "Először meg kell adnod az AmphetaRate User ID-t!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "A kategória nem tartalmaz kedvenceket!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Adj meg egy billentyűsorozatot");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Nem sikerült elindítani a böngészőt!\nKérlek válassz egy böngészőt a 'Beállítások' menüpontban");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Először meg kell adnod egy blogger-t!");
    translation.put("DIALOG_TITLE_CATEGORY", "Válassz egy kategóriát");
    translation.put("DIALOG_ID_ATTENTION", "Először létre kell hoznod egy AmphetaRate felhasználót!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Kérlek add meg a honlap URL-jét");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "Az RSSOwl nem talált a(z) %FORMAT% megjelenítésére alkalmas programot");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Blogroll szerkesztése");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Nem sikerült betölteni a belso böngészőt!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Új Blogroll hozzáadása");
    translation.put("QUESTION_DEL_FAV", "Biztosan szeretnéd törölni ezt a kedvencet: \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Biztosan szeretnéd törölni ezt a kategóriát: \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Biztosan szeretnéd törölni ezt a Blogrollt?");

    /** Browser */
    translation.put("BROWSER_BACK", "Vissza");
    translation.put("BROWSER_FORWARD", "Előre");
    translation.put("BROWSER_STOP", "Leállítás");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantasztikus");
    translation.put("RATE_GOOD", "Jó");
    translation.put("RATE_MODERATE", "Közepes");
    translation.put("RATE_BAD", "Rossz");
    translation.put("RATE_VERY_BAD", "Nagyon rossz");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nincs");
    translation.put("UPDATE_INTERVAL_ONE", "1 perc után");
    translation.put("UPDATE_INTERVAL_FIVE", "5 perc után");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15 perc után");
    translation.put("UPDATE_INTERVAL_THIRTY", "30 perc után");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1 óra után");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3 óra után");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6 óra után");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12 óra után");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24 óra után");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Szöveg betűtípus");
    translation.put("FONT_AREA_DIALOG", "Ablakok betűtípus");
    translation.put("FONT_AREA_TREE", "Fa betűtípus");
    translation.put("FONT_AREA_TABLE", "Táblázat betűtípus");
    translation.put("FONT_AREA_HEADER", "Fejléc betűtípus");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "A hírszövegekhez, csatorna információkhoz, hibákhoz és üzenetekhez használt betűtípus.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "A párbeszédablakokhoz használt betűtípus.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "A kedvenceket mutató faszerkezetnél használt betűtípus.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Az etető híreinek megjelenítéséhez használt betűtípus.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "A a hírek fejlécénél használt betűtípus.");
    translation.put("FONT_STYLE_BOLD", "Félkövér");
    translation.put("FONT_STYLE_ITALIC", "Dőlt");
    translation.put("FONT_STYLE_NORMAL", "Normál");

    /** Groups */
    translation.put("GROUP_COMMAND", "Parancs");
    translation.put("GROUP_SELECTED_FONT", "Választott betűtípus");
    translation.put("GROUP_FONT_AREA", "Betűtípus területe");
    translation.put("GROUP_WINDOW_LAYOUT", "Ablakok elrendezése");
    translation.put("GROUP_OPEN_MODE", "Megnyitás módja");
    translation.put("GROUP_ARGUMENTS", "Argumentumok");
    translation.put("GROUP_LINK_COLOR", "Linkek színe");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Keresési eredmények színe");
    translation.put("GROUP_TAB_LAYOUT", "Tabok elrendezése");
    translation.put("GROUP_TRAY", "Tálca");
    translation.put("GROUP_GENERAL", "Általános");
    translation.put("GROUP_EXISTING_ACCOUNT", "Meglévő felhasználó");
    translation.put("GROUP_NEW_ACCOUNT", "Új felhasználó létrehozása");
    translation.put("GROUP_NEWS_POPUP", "Hírek előugró ablak");
    translation.put("GROUP_CONFIRM_DIALOG", "Megerősítési ablak mutatása");

    /** Languages */
    translation.put("de", "Német");
    translation.put("da", "Dán");
    translation.put("el", "Görög");
    translation.put("en", "Angol");
    translation.put("es", "Spanyol");
    translation.put("fr", "Francia");
    translation.put("gl", "Gall");
    translation.put("it", "Olasz");
    translation.put("nl", "Holland");
    translation.put("pt", "Portugál (Brazil)");
    translation.put("ru", "Orosz");
    translation.put("bg", "Bulgár");
    translation.put("zhcn", "Egyszerűsített Kínai");
    translation.put("zhtw", "Hagyományos Kínai");
    translation.put("ja", "Japán");
    translation.put("ko", "Koreai");
    translation.put("pl", "Lengyel");
    translation.put("no", "Norvég");
    translation.put("sv", "Svéd");
    translation.put("bn", "Bengáli");
    translation.put("fi", "Finn");
    translation.put("uk", "Ukrán");
    translation.put("tr", "Török");
    translation.put("hu", "Magyar");
    translation.put("cs", "Cseh");
    translation.put("sl", "Szlovák");
    translation.put("hu", "Magyar");
    translation.put("th", "Thai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Nem található leírás!");
    translation.put("LOAD_FEED", "Letöltés");
    translation.put("SEARCH_FEED", "Keresés");
    translation.put("RELOAD_FEED", "Frissítés");
    translation.put("PRINTED_FROM_RSSOWL", "Nyomtatta az RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Hírek nyomtatása - RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "RSSOwl mutatása");
    translation.put("TAB_WELCOME", "Üdvözlés");
    translation.put("DOCUMENT_GENERATED_FROM", "A dokumentumot az RSSOwl generálta");
    translation.put("NO_TITLE", "Nincs cím");
    translation.put("RECOMMENDED_ARTICLES", "Javasolt cikkek");
    translation.put("RSSOWL_TEASER", "Az RSSOwl egy ingyenes, nyíltforrású RSS & RDF hírolvasó. Különleges jellemzői:\n\n- Hírek exportálása PDF, HTML, RTF, OPML formátumba\n- Kedvencek importálása OPML fájlból\n- Teljesszövegű keresés a találatok szintaxis-kiemelésével\n- Erőteljes RSS & RDF keresőmotor\n- Hírek megtekintése beépített böngészővel\n- Kedvencek kategóriákba rendezése\n- Futtatható Windows, Linux, Solaris és Mac alatt\n\nA jellemzők teljes listáját lásd itt: http://www.rssowl.org/overview\n\nLetölthető: http://www.rssowl.org/download");
    translation.put("MAIL_ERROR_BODY", "Kérlek csatold az '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' fájlt ehhez a levélhez és röviden írd le, mi történt a hiba bekövetkezte előtt. Köszönöm!");
    translation.put("FORMAT_AUTO_DETECT", "Automatikus felismerés");
    translation.put("NEWSFEED_VALID", "A híradag hiteles");
    translation.put("OPML_IMPORTED", "Importált");
    translation.put("ENTIRE_NEWS", "Összes Hírek");
    translation.put("SEARCH_AND", "ÉS");
    translation.put("SEARCH_OR", "VAGY");
    translation.put("SEARCH_NOT", "NEM");
  }
}