/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Armenian internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * o Armenian - by Vardan Movsisyan<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nHY extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nHY(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Ֆայլ");
    translation.put("MENU_SAVE", "Պահպանել իբրև");
    translation.put("MENU_QUICKVIEW", "Արագ դիտում");
    translation.put("MENU_TOOLBAR", "Գործիքաշերտ");
    translation.put("MENU_GENERATE_PDF", "Ստեղծել PDF");
    translation.put("MENU_GENERATE_HTML", "Ստեղծել HTML");
    translation.put("MENU_GENERATE_RTF", "Ստեղծել RTF");
    translation.put("MENU_IMPORT", "Ներմուծել պարամետրերը");
    translation.put("MENU_EXPORT", "Արտածել պարամետրերը");
    translation.put("MENU_EXIT", "Ելք");
    translation.put("MENU_WINDOW", "Տեսք");
    translation.put("MENU_PREFERENCES", "Պարամետրեր");
    translation.put("MENU_BROWSER", "Բրաուզեր");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Ընտրել արտաքին բրաուզեր");
    translation.put("MENU_FONT", "Ֆոնտ");
    translation.put("MENU_ENCODING", "Տեսքտի կոդավորում");
    translation.put("MENU_LANGUAGE", "Լեզու");
    translation.put("MENU_PROXY", "Պրոքսի");
    translation.put("MENU_MISC", "Այլ");
    translation.put("MENU_DIRECTOPEN", "Բացել դատարկ լուրերը բրաուզերի մեջ");
    translation.put("MENU_DIRECTOPENEACH", "Բացել նշված լուրերը բրաուզերի մեջ");
    translation.put("MENU_SYSTRAY", "Թաքցնել ծրագիրը թրեյում");
    translation.put("MENU_CHANNELINFO", "Ցուցադրել ժապավենի ինֆոն");
    translation.put("MENU_OPENNEW_BROWSER", "Միշտ բացել ներքին բրաուզերը նոր թաբի մեջ");
    translation.put("MENU_BROWSER_EXTERN", "Օգտագործել արտաքին բրաուզեր");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Ցուցադրել լուրի տեքստը բրաուզերի մեջ");
    translation.put("MENU_CHECK_UPDATE", "Միացնելիս ստուգել թարմացումները");
    translation.put("MENU_INFO", "Օգնություն");
    translation.put("MENU_ABOUT", "RSSOwl-ի մասին");
    translation.put("MENU_LICENSE", "Լիցենզիա");
    translation.put("MENU_UPDATE", "Ստուգել թարմացումը");
    translation.put("MENU_WELCOME", "Բարի գալուստ");
    translation.put("MENU_DONATE", "Նվիրատվություն կատարել");
    translation.put("MENU_TOOLS", "Գործիքներ");
    translation.put("MENU_FEEDSEARCH", "Լուրերի ժապավեններ որոնել");
    translation.put("MENU_MINIMIZE_RSSOWL", "Փոքրացնել պատուհանը");
    translation.put("MENU_GOTO", "Անցում");
    translation.put("MENU_NEXT_NEWS", "Հաջորդ լուրը");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Հաջորդ չընթերցվածը");
    translation.put("MENU_CLOSE", "Փակել");
    translation.put("MENU_CLOSE_ALL", "Փակել բոլորը");
    translation.put("MENU_PREVIOUS_TAB", "Նախորդ թաբ");
    translation.put("MENU_NEXT_TAB", "Հաջորդ թաբ");
    translation.put("MENU_HOTKEYS", "Դյուրանցման ստեղներ");
    translation.put("MENU_NEWSTIP_MAIL", "Ձևավորել NewsTip նամակը");
    translation.put("MENU_TELL_FRIENDS", "Պատմել ընկերներին...");
    translation.put("MENU_RELOAD", "Թարմացնել");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Նշված լուրերից PDF ֆայլ ստեղծել");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Նշված լուրերից HTML ֆայլ ստեղծել");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Նշված լուրերից RTF ֆայլ ստեղծել");
    translation.put("MENU_MAILING_LIST", "Փոստային ցուցակ");
    translation.put("MENU_TUTORIAL", "Ձեռնարկ");
    translation.put("MENU_COLORS", "Գույներ");
    translation.put("MENU_BLOGGER", "Բլոգգեր");
    translation.put("MENU_WORKBENCH", "Ընդհանուր");
    translation.put("MENU_IMPORT_OPML", "Ներմուծել OPML-ից");
    translation.put("MENU_VALIDATE", "Ստուգել ժապավենը");
    translation.put("MENU_FEED_DISCOVERY", "Լուրերի ժապավեն որոնել սայթում");
    translation.put("MENU_DISPLAY_FEED_PDF", "Ցուցադրել ժապավենը PDF-ով");
    translation.put("MENU_DISPLAY_FEED_RTF", "Ցուցադրել ժապավենը RTF-ով");
    translation.put("MENU_DISPLAY_FEED_HTML", "Ցուցադրել ժապավենը HTML-ով");
    translation.put("MENU_NEW_FAVORITE", "Նոր էջանշան");
    translation.put("MENU_EDIT", "Խմբագրում");
    translation.put("MENU_EDIT_COPY", "Պատճենել");
    translation.put("MENU_EDIT_PASTE", "Փակցնել");
    translation.put("MENU_EDIT_SELECT_ALL", "Նշել բոլորը");
    translation.put("MENU_EDIT_DELETE", "Ջնջել");
    translation.put("MENU_EDIT_CUT", "Կտրել");
    translation.put("MENU_CONNECTION", "Կապ");
    translation.put("MENU_EDIT_RENAME", "Վերանվանել");
    translation.put("MENU_WORK_OFFLINE", "Աշխատել օֆլայն");
    translation.put("MENU_WORK_ONLINE", "Աշխատել օնլայն");

    /** ToolBar */
    translation.put("TOOL_MARK", "Նշում");
    translation.put("TOOL_NEXT", "Հաջորդ");
    translation.put("TOOL_SEPARATOR", "Բաժանարար");
    translation.put("TOOL_ICONS_TEXT", "Պատկերակներ և տեքստ");
    translation.put("TOOL_ICONS", "Պատկերակներ");
    translation.put("TOOL_TEXT", "Տեքստ");
    translation.put("TOOL_RATE", "Ռեյտինգ");
    translation.put("TOOL_HISTORY", "Պատմություն");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Նոր");
    translation.put("POP_SUB_CATEGORY", "Ենթակատեգորիա");
    translation.put("POP_UNSUBSCRIBE", "Բաժանորդագրությունը դադարեցնել");
    translation.put("POP_USEPROXY", "Օգտագործել պրոքսի");
    translation.put("POP_AGGREGATE_FAV", "Հավաքել էջանշանները");
    translation.put("POP_AUTO_UPDATE", "Ավտո-թարմացում");
    translation.put("POP_UPDATE_ONSTARTUP", "միացնելիս");
    translation.put("POP_IMPORT", "Ներմուծում");
    translation.put("POP_FROM_OPML", "OPML ֆայլից");
    translation.put("POP_EXPORT_OPML", "Դեպի OPML ֆայլ");
    translation.put("POP_COPY", "Պատճենել");
    translation.put("POP_OPEN_IN_BROWSER", "Բացել նշվածը բրաուզերի մեջ");
    translation.put("POP_MARK_UNREAD", "Նշել չընթերցված");
    translation.put("POP_COPY_NEWS_URL", "Պատճենել հղումը");
    translation.put("POP_RATE_NEWS", "Գնահատել լուրը");
    translation.put("POP_MAIL_LINK", "NewsTip ուղարկել ընկերոջը");
    translation.put("POP_OPEN_EXTERN", "Բացել դրսում");
    translation.put("POP_BLOG_NEWS", "Բլոգի լուրերը");
    translation.put("POP_OPEN_STARTUP", "Բացել միացնելիս");
    translation.put("POP_KEEP_CURRENT", "Փակել մյուսները");
    translation.put("POP_KEEP_NEWSFEEDS", "Փակել բոլորը, բացի ժապավեններից");
    translation.put("POP_MARK_ALL_READ", "Նշել բոլորը ընթերցված");
    translation.put("POP_MARK_CATEGORY_READ", "Նշել կատեգորիան ընթերցված");
    translation.put("POP_TAB_POSITION", "Դիրք");
    translation.put("POP_TAB_POS_TOP", "Վերև");
    translation.put("POP_TAB_POS_BOTTOM", "Ներքև");
    translation.put("POP_PROPERTIES", "Հատկություններ");
    translation.put("POP_MARK_FAVORITE_READ", "Նշել էջանշանը ընթերցված");
    translation.put("POP_IMPORT_BLOGROLL", "Սինխրոնիզացված Blogroll-ից");
    translation.put("POP_SYNCHRONIZE", "Սինխրոնիզացնել");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Ձևափոխել գործիքաշերտը");
    translation.put("POP_CLEAR_HISTORY", "Մաքրել պատմությունը");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Անսպասելի սխալ տեղի ունեցավ: RSSOwl-ը կանջատվի, բայց բոլոր պարամետրերը պահպանված են:\nՍխալը գրանցված է այստեղ` '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nՈւզու՞մ եք սխալի վերաբերյալ լուր ուղարկել RSSOwl թիմին:");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Սխալ");
    translation.put("ERROR_NO_NEWS_FOUND", "Սխալ. Չի հաջողվում լուրեր գտնել:");
    translation.put("ERROR_CAT_EXISTS", "Այս անունով կատեգորիա արդեն գոյություն ունի:");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Այս անունով էջանշան արդեն գոյություն ունի:");
    translation.put("ERROR_FAV_URL_EXISTS", "Այս հասցեով էջանշան արդեն գոյություն ունի:");
    translation.put("ERROR_CONNECTION_FAILED", "Կապն ընդհատված է:");
    translation.put("ERROR_GRABTITLE_FAILED", "Չի հաջողվում ստանալ վերնագիրը:");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl-ը չի կարող ցուցադրել լուրերի ժապավենը:");
    translation.put("ERROR_FILE_NOT_FOUND", "Չի հաջողվում գտնել ֆայլը");
    translation.put("ERROR_AUTH_REQUIRED", "Լուրերի ժապավենը պաշտպանված է և աուտենտիֆիկացիա է պահանջում");
    translation.put("ERROR_REASON", "Պատճառ");
    translation.put("ERROR_LOADING_FEED", "\"%TITLE%\" լուրերի ժապավենի բեռնման ժամանակ սխալ տեղի ունեցավ");
    translation.put("ERROR_HTTP_STATUS", "Վիճակ");
    translation.put("ERROR_WORKING_OFFLINE", "Լուրերի ժապավենը չի կարող ցուցադրվել օֆլայն ռեժիմում");
    translation.put("ERROR_NOT_A_XML", "Ֆայլը ճիշտ XML փաստաթուղթ չէ");
    translation.put("ERROR_NOT_A_RSS", "XML փաստաթուղթը ճիշտ RSS, RDF կամ Atom լուրերի ժապավեն չէ");
    translation.put("ERROR_NOT_A_OPML", "XML փաստաթուղթը OPML ֆայլ չէ");
    translation.put("ERROR_SUB_EXISTS", "Դուք արդեն բաժանորդագրված եք այդ Blogroll-ին:");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Ուղի");
    translation.put("LABEL_CATEGORY", "Կատեգորիա");
    translation.put("LABEL_NO_INFOS", "Լրացուցիչ ինֆո չկա");
    translation.put("LABEL_FAVORITE", "Էջանշան");
    translation.put("LABEL_TITLE", "Վերնագիր");
    translation.put("LABEL_USE_PROXY", "Օգտագործել պրոքսի");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Պրոքսին թույլատրություն է պահանջում");
    translation.put("LABEL_USERNAME", "Լոգին");
    translation.put("LABEL_PASSWORD", "Գաղտնաբառ");
    translation.put("LABEL_PROXY_HOST", "Հոսթ");
    translation.put("LABEL_PROXY_PORT", "Պորտ");
    translation.put("LABEL_CATEGORY", "Կատեգորիա");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Օգտագործել պրոքսին բոլոր էջանշանների համար");
    translation.put("LABEL_NEWS_RATED", "Լուրը գնահատված է");
    translation.put("LABEL_SEARCH_TOPIC", "Ինչ որոնել");
    translation.put("LABEL_SEARCH_FINISHED", "Որոնումը ավարտված է:");
    translation.put("LABEL_SEARCH_RUNNING", "Որոնումը ընթանում է...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Ինտենսիվ որոնում");
    translation.put("LABEL_PREFERED_LANGUAGE", "Նախընտրելի լեզու");
    translation.put("LABEL_DESCRIPTION", "Նկարագրություն");
    translation.put("LABEL_CREATED", "Ստեղծված է");
    translation.put("LABEL_LAST_VISIT", "Վերջին այցելություն");
    translation.put("LABEL_USED_BY", "օգտագործվում է");
    translation.put("LABEL_NAME", "Անուն");
    translation.put("LABEL_KEY_SEQUENCE", "Հաջորդականություն");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Սխալ հաջորդականություն");
    translation.put("LABEL_SIZE", "Չափ");
    translation.put("LABEL_STYLE", "Ոճ");
    translation.put("LABEL_SELECT_ENCODING", "Ընտրել կոդավորումը");
    translation.put("LABEL_MAIL_SUBJECT", "Վերնագիր");
    translation.put("LABEL_MAIL_BODY", "Տեքստ");
    translation.put("LABEL_MAIL_USAGE", "Լուրի փոխարինվող պարամետրերի համար օգտագործեք [TITLE], [LINK] և [DESCRIPTION]");
    translation.put("LABEL_EMPTY_LINK", "Հղումը չի նշված");
    translation.put("LABEL_USE_SYSTEM_FONT", "Օգտագործել համակարգի ֆոնտը");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML ձևաչափով նամակ");
    translation.put("LABEL_CURRENT_COLOR", "Ընթացիկ գույն");
    translation.put("LABEL_OPTIONS", "Ընտրանքներ");
    translation.put("LABEL_SEARCH_RESULTS", "\"%TERM%\" հարցումը տվեց %NUM% արդյունք");
    translation.put("LABEL_SEARCH_EMPTY", "\"%TERM%\" հարցումը ոչ մի արդյունք չտվեց:");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Ընտրեք պատուհանի երկու դասավորումներից մեկը");
    translation.put("LABEL_SINGLE_CLICK", "Միակի կտտոց");
    translation.put("LABEL_DOUBLE_CLICK", "Կրկնակի կտտոց");
    translation.put("LABEL_SELECT_BLOGGER", "Ընտրել արտաքին բլոգ");
    translation.put("LABEL_BLOGGER_USAGE", "Լուրի փոխարինվող պարամետրերի համար օգտագործեք [NEWSLINK], [FEEDLINK] և [TITLE]");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Վերաբացել վերջին բացված ժապավենները ծրագիրը միացնելիս");
    translation.put("LABEL_TRADITIONAL_TABS", "Ավանդական թաբեր");
    translation.put("LABEL_CURVED_TABS", "Կլորաձև թաբեր");
    translation.put("LABEL_READY", "Պատրաստ է");
    translation.put("LABEL_VALIDATION_FINISHED", "Ճշգրտության ստուգումը ավարտված է");
    translation.put("LABEL_VALIDATING", "Ճշգրտության ստուգում");
    translation.put("LABEL_FEED_TYPE", "Լուրերի ժապավենի տիպը");
    translation.put("LABEL_OVERRIDE_DTD", "Վերասահմանել Doctype դեկլարացիան");
    translation.put("LABEL_ADDRESS", "Հասցե");
    translation.put("LABEL_BROWSER_USAGE", "Հասցեի փոխարինվող պարամետրի համար օգտագործեք [URL]");
    translation.put("LABEL_OLD_ID", "Օգտագործողի հին ID-ն (ոչ պարտադիր)");
    translation.put("LABEL_AMPHETARATE_ID", "Օգտագործողի ID");
    translation.put("LABEL_SORT_EXPLANATION", "Սահմանեք լուրերի դասավորման հերթականությունները: RSSOwl-ը կփորձի դասավորել ըստ նշված հերթականության` սկսելով առաջինից:");
    translation.put("LABEL_SORT_ORDER", "Լուրերի դասավորում");
    translation.put("LABEL_REMEMBER_AUTH", "Հիշել լոգինը և գաղտնաբառը");
    translation.put("LABEL_NOT_UNSUPPORTED", "Սա դեռ չի աջակցվում ձեր օպերացիոն համակարգում");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Այստեղ կարգավորվող արժեքները կօգտագործվեն իբրև սկզբնական` նոր էջանշանների համար:");
    translation.put("LABEL_RESTART", "Փոփոխությունները պահանջում են վերագործարկել RSSOwl-ը");
    translation.put("LABEL_WELCOME_TITLE", "Բարի գալուստ RSSOwl - ընթերցիչ RSS / RDF / Atom լուրերի ժապավենների համար");
    translation.put("LABEL_FIRST_STEPS", "Առաջին քայլեր");
    translation.put("LABEL_NEWS", "Լուրեր");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl-ի լուրերի ժապավեն");
    translation.put("LABEL_SUPPORT", "Աջակցություն");
    translation.put("LABEL_DISCUSSION_FORUM", "Քննարկումների ֆորում");
    translation.put("LABEL_PROMOTION", "Առաջ տանել");
    translation.put("LABEL_CONTACT", "Կոնտակտ");
    translation.put("LABEL_START", "Սկիզբ");
    translation.put("LABEL_DOWNLOAD", "Քաշել");
    translation.put("LABEL_MAX_CONNECTIONS", "Միացումների առավելագույն քանակը");
    translation.put("LABEL_CON_TIMEOUT", "Թայմ-աուտը վայրկյաններով");
    translation.put("LABEL_DELETE_FAVORITE", "Ջնջել էջանշան");
    translation.put("LABEL_DELETE_CATEGORY", "Ջնջել կատեգորիա");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Ջնջել Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Գրանցումը հաջող անցավ");
    translation.put("LABEL_SHOW", "Ցուցադրել");
    translation.put("LABEL_SEARCH_IN", "Որտեղ որոնել");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Բացել");
    translation.put("BUTTON_RELOAD_CAT", "Թարմացնել էջանշանները");
    translation.put("BUTTON_ADD", "Ավելացնել");
    translation.put("BUTTON_FILE", "Բացել ֆայլ");
    translation.put("BUTTON_SEARCH", "Որոնել");
    translation.put("BUTTON_RELOAD", "Թարմացնել լուրերը");
    translation.put("BUTTON_CANCLE", "Չեղարկել");
    translation.put("BUTTON_EXPORT", "Արտածում");
    translation.put("BUTTON_STOP_SEARCH", "Կանգնեցնել որոնումը");
    translation.put("BUTTON_CLEAR_RESULTS", "Մաքրել արդյունքները");
    translation.put("BUTTON_EXPORT_TO_OPML", "Արտածել դեպի OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Ավելացնել էջանշաններին");
    translation.put("BUTTON_ASSIGN", "Նշանակել");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Վերականգնել դեֆոլտները");
    translation.put("BUTTON_APPLY", "Կիրառել");
    translation.put("BUTTON_CHANGE_FONT", "Փոխել ֆոնտը");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_VALIDATE", "Ստուգել ճշգրտությունը");
    translation.put("BUTTON_STOP_VALIDATION", "Կանգնեցնել ճշգրտության ստուգումը");
    translation.put("BUTTON_FOCUS_TABS", "Ֆոկուսը տեղափոխել նոր թաբերի վրա");
    translation.put("BUTTON_DISPLAY_TABS", "Լուրերի ժապավենները ցուցադրել թաբերի մեջ");
    translation.put("BUTTON_TRAY_STARTUP", "Միացնելիս տեղակայել RSSOwl-ը թրեյում");
    translation.put("BUTTON_TRAY_EXIT", "Փակելիս տեղակայել RSSOwl-ը թրեյում");
    translation.put("BUTTON_SHOW_ERRORS", "Ցուցադրել սխալները կողային պանելի մեջ");
    translation.put("BUTTON_CHANGE", "Փոփոխել");
    translation.put("BUTTON_MARK_ALL_READ", "Նշել բոլոր կատեգորիաները ընթերցված");
    translation.put("BUTTON_AGGREGATE_ALL", "Հավաքել բոլոր կատեգորիաները");
    translation.put("BUTTON_RELOAD_ALL", "Թարմացնել բոլոր կատեգորիաները");
    translation.put("BUTTON_SEARCH_ALL", "Որոնել բոլոր կատեգորիաներում");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Պատուհանը փոքրացնելիս բոլոր լուրերը ընթերցված նշել");
    translation.put("BUTTON_TRAY_POPUP", "Չընթերցված լուրերի դեպքում` լողացող հաղորդագրություն");
    translation.put("BUTTON_READ_ON_CLOSE", "Թաբը փակելիս ժապավենը ընթերցված նշել");
    translation.put("BUTTON_UP", "Վերև");
    translation.put("BUTTON_DOWN", "Ներքև");
    translation.put("BUTTON_CREATE_ACCOUNT", "Հաշիվ ստեղծել");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Ավտոմատ փակել լողացող լուրերը");
    translation.put("BUTTON_CACHE_FEEDS", "Ավտոմատ պահպանել լուրերի ժապավենները օֆլայն ընթերցման համար");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Բացել բրաուզերի մեջ");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Ցուցադրել փակելու կոճակը թաբերի վրա");
    translation.put("BUTTON_DELETE_FAVORITE", "Էջանշանը ջնջելիս");
    translation.put("BUTTON_DELETE_CATEGORY", "Կատեգորիան ջնջելիս");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Blogroll-ը ջնջելիս");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Երբեք չհարցնել");
    translation.put("BUTTON_BLOCK_POPUPS", "Փակել լողացող պատուհանները");
    translation.put("BUTTON_ANIMATE_POPUP", "Լողացող պատուհանները անիմացիայով ցուցադրել");
    translation.put("BUTTON_REMOVE", "Հեռացնել");
    translation.put("BUTTON_SMALL_ICONS", "Օգտագործել փոքր պատկերակներ");
    translation.put("BUTTON_LINK_TAB", "Հղում ստեղծել դեպի ցուցադրվող ժապավենը");
    translation.put("BUTTON_CLEAR", "Մաքրել");
    translation.put("BUTTON_NO_SORT", "Լուրերը ավտոմատ չդասավորել");

    /** Header */
    translation.put("HEADER_NEWS", "Վերնագիր");
    translation.put("HEADER_RSS_FAVORITES", "Էջանշաններ");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Բացել սայթը");
    translation.put("TOOLTIP_PRINT", "Տպել լուրը");
    translation.put("TOOLTIP_RATE", "Գնահատել");
    translation.put("TOOLTIP_GRAB_TITLE", "Ստանալ վերնագիրը ժապավենից");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Չընթերցված լուրեր կան");
    translation.put("TOOLTIP_SKIP", "Բաց թողնել");
    translation.put("TOOLTIP_OPEN_TAB", "Նոր թաբ բացել");
    translation.put("TOOLTIP_QUICKSEARCH", "Արագ որոնում");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Հրապարակման ամսաթիվ");
    translation.put("TABLE_HEADER_AUTHOR", "Հեղինակ");
    translation.put("TABLE_HEADER_CATEGORY", "Կատեգորիա");
    translation.put("TABLE_HEADER_PUBLISHER", "Հրապարակող");
    translation.put("TABLE_HEADER_NEWSTITLE", "Վերնագիր");
    translation.put("TABLE_HEADER_FEED", "Լուրերի ժապավեն");
    translation.put("TABLE_HEADER_FEEDURL", "Լուրերի ժապավենի հասցե");
    translation.put("TABLE_HEADER_FEEDTITLE", "Լուրերի ժապավենի վերնագիր");
    translation.put("TABLE_HEADER_LINE", "Տող");
    translation.put("TABLE_HEADER_STATUS", "Վիճակ");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Տնային էջ");
    translation.put("CHANNEL_INFO_PUBDATE", "Հրապարակման ամսաթիվ");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Վերջին փոփոխություն");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Խմբագիր");
    translation.put("CHANNEL_INFO_WEBMASTER", "Վեբմաստեր");
    translation.put("CHANNEL_INFO_CATEGORY", "Կատեգորիա");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Հնանալու ժամկետը (TTL)");
    translation.put("CHANNEL_INFO_RSSVERSION", "Ձևաչափ");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS գեներատոր");
    translation.put("CHANNEL_INFO_PUBLISHER", "Հրապարակող");
    translation.put("CHANNEL_INFO_LANGUAGE", "Լեզու");
    translation.put("CHANNEL_INFO_CREATOR", "Ստեղծող");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Թարմացում");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "անգամ");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Աղբյուր");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Կցված նյութեր");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Մեկնաբանություններ");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Ուշադրություն");
    translation.put("MESSAGEBOX_FILL_URL", "Մուտքագրեք URL կամ ուղի");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Այդ անունով կատեգորիա արդեն գոյություն ունի:");
    translation.put("MESSAGEBOX_SELECT_CAT", "Ընտրել կատեգորիա");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Ֆայլը գոյություն ունի: Փոխարինե՞լ:");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Ֆայլը չի պարունակում ծրագրի պարամետրերը:");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Պարամետրերի ներմուծումը հաջողվեց:");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Լուրի տեքստը դատարկ է: Լուր ընտրեք");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Էջանշան ավելացնել");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Կատեգորիա ավելացնել");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Մուտքագրեք վերնագիրը");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Մուտքագրեք հասցեն և վերնագիրը");
    translation.put("BASE_AUTH_TITLE", "Թույլատրություն է անհրաժեշտ:");
    translation.put("BASE_AUTH_MESSAGE", "Մուտքագրեք լոգինը և գաղտնաբառը:");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Նշված թղթապանակում ճիշտ RSS ֆայլեր չկան:");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Հաստատեք");
    translation.put("SEARCH_DIALOG_TITLE", "Որոնում");
    translation.put("SEARCH_DIALOG_MESSAGE", "Օգտագործեք ԵՎ, ԿԱՄ ու ՈՉ` սահմանափակելու որոնումը:");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Որոնել");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Միայն ամբողջական բառը");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Տառաշարազգայուն");
    translation.put("SEARCH_DIALOG_REGEX", "Օգտագործել կանոնավոր արտահայտություններ (RegEx)");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Նոր տարբերակ չկա");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Ձեզ մոտ ծրագրի ամենավերջին տարբերակն է:");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Ինֆո");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Խմբագրել կատեգորիան");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Խմբագրել էջանշանը");
    translation.put("DIALOG_TITLE_UPDATE", "Ծրագրի նոր տարբերակ է հայտնվել");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Մուտքագրեք ֆայլի ուղին");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Չի հաջողվում կապվել http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Անհրաժեշտ է սկզբում մուտքագրել ձեր AmphetaRate օգտագործողի ID-ն:");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Կատեգորիայում էջանշաններ չկան:");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Ստեղների հաջորդականություն մուտքագրեք");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Չի հաջողվում աշխատեցնել բրաուզերը:\nՆշեք բրաուզերը ծրագրի պարամետրերում:");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Անհրաժեշտ է սկզբում բլոգը նշել:");
    translation.put("DIALOG_TITLE_CATEGORY", "Ընտրել կատեգորիա");
    translation.put("DIALOG_ID_ATTENTION", "Անհրաժեշտ է սկզբում AmphetaRate հաշիվ ստեղծել:");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Մուտքագրեք սայթի հասցեն");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl-ը չկարողացավ համապատասխան ծրագիր գտնել` %FORMAT%-ը ցուցադրելու համար");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Խմբագրել Blogroll-ը");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Չի հաջողվում գործարկել ներքին բրաուզերը:");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Ավելացնել Blogroll");
    translation.put("QUESTION_DEL_FAV", "Իսկապե՞ս ուզում եք ջնջել \"%NAME%\" էջանշանը:");
    translation.put("QUESTION_DEL_CAT", "Իսկապե՞ս ուզում եք ջնջել \"%NAME%\" կատեգորիան:");
    translation.put("QUESTION_DEL_SUB", "Իսկապե՞ս ուզում եք ջնջել Blogroll-ը:");

    /** Browser */
    translation.put("BROWSER_BACK", "Ետ");
    translation.put("BROWSER_FORWARD", "Առաջ");
    translation.put("BROWSER_STOP", "Կանգնեցնել");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Գերազանց");
    translation.put("RATE_GOOD", "Լավ");
    translation.put("RATE_MODERATE", "Միջին");
    translation.put("RATE_BAD", "Վատ");
    translation.put("RATE_VERY_BAD", "Շատ վատ");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ոչ");
    translation.put("UPDATE_INTERVAL_ONE", "1 րոպեն մեկ");
    translation.put("UPDATE_INTERVAL_FIVE", "5 րոպեն մեկ");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15 րոպեն մեկ");
    translation.put("UPDATE_INTERVAL_THIRTY", "30 րոպեն մեկ");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1 ժամը մեկ");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3 ժամը մեկ");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6 ժամը մեկ");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12 ժամը մեկ");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24 ժամը մեկ");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Տեքստի ֆոնտը");
    translation.put("FONT_AREA_DIALOG", "Դիալոգի ֆոնտը");
    translation.put("FONT_AREA_TREE", "Ծառի ֆոնտը");
    translation.put("FONT_AREA_TABLE", "Աղյուսակի ֆոնտը");
    translation.put("FONT_AREA_HEADER", "Վերնագրի ֆոնտը");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Տեքստի ֆոնտը օգտագործվում է լուրերի, ալիքների ինֆոյի, հաղորդագրությունների և սխալների համար:");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Դիալոգի ֆոնտը օգտագործվում է բոլոր դիալոգներում:");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Ծառի ֆոնտը օգտագործվում է էջանշանների ծառի համար:");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Աղյուսակի ֆոնտը օգտագործվում է Ժապավենի լուրերի աղյուսակի համար:");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Վերնագրի ֆոնտը օգտագործվում է լուրերի վերնագրերի համար:");
    translation.put("FONT_STYLE_BOLD", "Հաստ");
    translation.put("FONT_STYLE_ITALIC", "Շեղ");
    translation.put("FONT_STYLE_NORMAL", "Նորմալ");

    /** Groups */
    translation.put("GROUP_COMMAND", "Հրամաններ");
    translation.put("GROUP_SELECTED_FONT", "Ընտրված ֆոնտ");
    translation.put("GROUP_FONT_AREA", "Ֆոնտի տեսք");
    translation.put("GROUP_WINDOW_LAYOUT", "Պատուհանի դասավորում");
    translation.put("GROUP_OPEN_MODE", "Բացման ռեժիմ");
    translation.put("GROUP_ARGUMENTS", "Արգումենտներ");
    translation.put("GROUP_LINK_COLOR", "Հղման գույն");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Որոնման արդյունքների գույն");
    translation.put("GROUP_TAB_LAYOUT", "Թաբերի դասավորում");
    translation.put("GROUP_TRAY", "Թրեյ");
    translation.put("GROUP_GENERAL", "Ընդհանուր");
    translation.put("GROUP_EXISTING_ACCOUNT", "Գոյություն ունեցող հաշիվ");
    translation.put("GROUP_NEW_ACCOUNT", "Ստեղծել նոր հաշիվ");
    translation.put("GROUP_NEWS_POPUP", "Լողացող լուրեր");
    translation.put("GROUP_CONFIRM_DIALOG", "Հաստատում պահանջել");

    /** Languages */
    translation.put("de", "German");
    translation.put("da", "Danish");
    translation.put("el", "Greek");
    translation.put("en", "English");
    translation.put("es", "Spanish");
    translation.put("fr", "French");
    translation.put("gl", "Galician");
    translation.put("it", "Italian");
    translation.put("nl", "Dutch");
    translation.put("pt", "Portuguese (Brazil)");
    translation.put("ru", "Russian");
    translation.put("bg", "Bulgarian");
    translation.put("zhcn", "Simplified Chinese");
    translation.put("zhtw", "Traditional Chinese");
    translation.put("ja", "Japanese");
    translation.put("ko", "Korean");
    translation.put("pl", "Polish");
    translation.put("no", "Norwegian");
    translation.put("sv", "Swedish");
    translation.put("bn", "Bengali");
    translation.put("fi", "Finnish");
    translation.put("uk", "Ukrainian");
    translation.put("tr", "Turkish");
    translation.put("hu", "Hungarian");
    translation.put("sl", "Slovenian");
    translation.put("cs", "Czech");
    translation.put("hu", "Hungarian");
    translation.put("th", "Thai");
    translation.put("sr", "Serbian (Cyrillic)");
    translation.put("sh", "Serbian (Latin)");
    translation.put("hy", "Armenian");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Նկարագրություն չկա");
    translation.put("LOAD_FEED", "Բեռնում");
    translation.put("SEARCH_FEED", "Որոնում");
    translation.put("RELOAD_FEED", "Թարմացում");
    translation.put("PRINTED_FROM_RSSOWL", "Տպված է RSSOwl-ից (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Լուրերի տպում RSSOwl-ից (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Ցուցադրել RSSOwl-ը");
    translation.put("TAB_WELCOME", "Բարի գալուստ");
    translation.put("DOCUMENT_GENERATED_FROM", "Փաստաթուղթը ստեղծված է RSSOwl-ից");
    translation.put("NO_TITLE", "Վերնագիր չկա");
    translation.put("RECOMMENDED_ARTICLES", "Խորհուրդ տրվող նյութեր");
    translation.put("RSSOWL_TEASER", "RSSOwl-ը անվճար ու բաց աղբյուրներով ծրագիր է` RSS և RDF լուրերի ընթերցման համար: Ծրագրի հնարավորություններն են.\n\n- Լուրերի արտածում դեպի PDF, HTML, RTF, OPML\n- Էջանշանների ներմուծում OPML-ից\n- Որոնում լրիվ տեքստի մեջ` արդյունքների շարահյուսական գունանշմամբ\n- RSS & RDF հզոր որոնիչ\n- Լուրերի դիտում ներքին բրաուզերի մեջ\n- Էջանշանների կառավարում կատեգորիաների միջոցով\n- Աշխատում է Windows, Linux, Solaris և Mac միջավայրերում\n\nԾրագրի հնարավորությունների լրիվ ցուցակի համար տես` http://www.rssowl.org/features.html\n\nԾրագիրը կարելի է քաշել այստեղից` http://sourceforge.net/project/showfiles.php?group_id=86683");
    translation.put("MAIL_ERROR_BODY", "Ամրակցեք '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' ֆայլը այս նամակին և համառոտ նկարագրեք, թե ինչ էր անում RSSOwl-ը սխալը տեղի ունենալուց անմիջապես առաջ: Շնորհակալություն:");
    translation.put("FORMAT_AUTO_DETECT", "Ավտոմատ որոշել");
    translation.put("NEWSFEED_VALID", "Լուրերի ժապավենը ճիշտ է");
    translation.put("OPML_IMPORTED", "Ներմուծված");
    translation.put("ENTIRE_NEWS", "Բոլոր լուրերը");
    translation.put("SEARCH_AND", "ԵՎ");
    translation.put("SEARCH_OR", "ԿԱՄ");
    translation.put("SEARCH_NOT", "ՈՉ");
  }
}