/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Japanese internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nJA extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nJA(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "ファイル");
    translation.put("MENU_GENERATE_PDF", "PDFを生成");
    translation.put("MENU_GENERATE_HTML", "HTMLを生成");
    translation.put("MENU_GENERATE_RTF", "RTFを生成");
    translation.put("MENU_IMPORT", "設定をインポート");
    translation.put("MENU_EXPORT", "設定をエクスポート");
    translation.put("MENU_EXIT", "終了");
    translation.put("MENU_WINDOW", "表示");
    translation.put("MENU_PREFERENCES", "プリファレンス");
    translation.put("MENU_BROWSER", "ブラウザ");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "外部のブラウザを選択");
    translation.put("MENU_FONT", "フォント");
    translation.put("MENU_ENCODING", "テキスト　エンコーディング");
    translation.put("MENU_LANGUAGE", "言語");
    translation.put("MENU_PROXY", "プロキシ");
    translation.put("MENU_MISC", "その他");
    translation.put("MENU_DIRECTOPEN", "ブラウザで空のニュースを自動でオープンする");
    translation.put("MENU_DIRECTOPENEACH", "ブラウザで個々のニュースを自動でオープンする");
    translation.put("MENU_SYSTRAY", "最小化時にトレイに表示する");
    translation.put("MENU_CHANNELINFO", "ニュースフィードの情報を表示する");
    translation.put("MENU_OPENNEW_BROWSER", "常に新規タブ内で内部ブラウザをオープンする");
    translation.put("MENU_BROWSER_EXTERN", "外部ブラウザをオープンする");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "ブラウザ内にニュース文を表示する");
    translation.put("MENU_CHECK_UPDATE", "起動時に自動でアップデートを確認する");
    translation.put("MENU_INFO", "ヘルプ");
    translation.put("MENU_ABOUT", "RSSOwlについて");
    translation.put("MENU_LICENSE", "ライセンス");
    translation.put("MENU_UPDATE", "アップデートを確認");
    translation.put("MENU_WELCOME", "ようこそ");
    translation.put("MENU_DONATE", "支援をおこなう");
    translation.put("MENU_TOOLS", "ツール");
    translation.put("MENU_MINIMIZE_RSSOWL", "RSSOwlを最小化");
    translation.put("MENU_GOTO", "移動");
    translation.put("MENU_NEXT_NEWS", "次のニュース");
    translation.put("MENU_NEXT_UNREAD_NEWS", "次の未読ニュース");
    translation.put("MENU_CLOSE", "閉じる");
    translation.put("MENU_CLOSE_ALL", "すべて閉じる");
    translation.put("MENU_PREVIOUS_TAB", "前のタブ");
    translation.put("MENU_NEXT_TAB", "次のタブ");
    translation.put("MENU_HOTKEYS", "ホットキー");
    translation.put("MENU_NEWSTIP_MAIL", "ニュースチップメールのフォーマット");
    translation.put("MENU_TELL_FRIENDS", "友人に紹介する");
    translation.put("MENU_RELOAD", "再読み込み");
    translation.put("MENU_GENERATE_PDF_SELECTION", "選択されたニュースからPDFを生成する");
    translation.put("MENU_GENERATE_HTML_SELECTION", "選択されたニュースからHTMLを生成する");
    translation.put("MENU_GENERATE_RTF_SELECTION", "選択されたニュースからRTFを生成する");
    translation.put("MENU_MAILING_LIST", "メーリングリスト");
    translation.put("MENU_TUTORIAL", "チュートリアル");
    translation.put("MENU_COLORS", "色");
    translation.put("MENU_BLOGGER", "ブロガー");
    translation.put("MENU_WORKBENCH", "ワークベンチ");
    translation.put("MENU_FEEDSEARCH", "ニュースフィードを検索");
    translation.put("MENU_IMPORT_OPML", "OPMLからインポートする");
    translation.put("MENU_VALIDATE", "ニュースフィードのエラーをチェックする");
    translation.put("MENU_FEED_DISCOVERY", "ホームページ上のニュースフィードを検索する");
    translation.put("MENU_EDIT", "編集");
    translation.put("MENU_EDIT_COPY", "コピー");
    translation.put("MENU_EDIT_PASTE", "ペースト");
    translation.put("MENU_EDIT_SELECT_ALL", "すべて選択");
    translation.put("MENU_EDIT_DELETE", "削除");
    translation.put("MENU_EDIT_CUT", "カット");
    translation.put("MENU_DISPLAY_FEED_PDF", "ニュースフィードをPDFで表示");
    translation.put("MENU_DISPLAY_FEED_RTF", "ニュースフィードをRTF形式で表示");
    translation.put("MENU_DISPLAY_FEED_HTML", "ニュースフィードをHTML形式で表示");
    translation.put("MENU_NEW_FAVORITE", "新しいお気に入り");
    translation.put("MENU_CONNECTION", "接続");
    translation.put("MENU_EDIT_RENAME", "名前の変更");
    translation.put("MENU_WORK_OFFLINE", "オフラインで作業");
    translation.put("MENU_WORK_ONLINE", "オンラインで作業");
    translation.put("MENU_SAVE", "名前を付けて保存");
    translation.put("MENU_TOOLBAR", "ツールバー");
    translation.put("MENU_QUICKVIEW", "クィックビュー");

    /** ToolBar */
    translation.put("TOOL_MARK", "マーク");
    translation.put("TOOL_NEXT", "次へ");
    translation.put("TOOL_SEPARATOR", "区切り");
    translation.put("TOOL_ICONS_TEXT", "アイコンとテキスト文字");
    translation.put("TOOL_ICONS", "アイコンのみ");
    translation.put("TOOL_TEXT", "テキスト文字のみ");
    translation.put("TOOL_RATE", "評価する");
    translation.put("TOOL_HISTORY", "履歴");
    translation.put("TOOL_NEWSTIP", "ニュースチップ");

    /** Popup Menu */
    translation.put("POP_NEW", "新規");
    translation.put("POP_SUB_CATEGORY", "サブカテゴリ");
    translation.put("POP_UNSUBSCRIBE", "購読をやめる");
    translation.put("POP_USEPROXY", "プロキシを使う");
    translation.put("POP_AGGREGATE_FAV", "お気に入り内をまとめて一度に取得する");
    translation.put("POP_AUTO_UPDATE", "自動でアップデートをおこなう");
    translation.put("POP_UPDATE_ONSTARTUP", "起動時");
    translation.put("POP_IMPORT", "インポート");
    translation.put("POP_FROM_OPML", "OPMLファイルから");
    translation.put("POP_EXPORT_OPML", "OPMLファイルへ");
    translation.put("POP_COPY", "コピー");
    translation.put("POP_OPEN_IN_BROWSER", "選択したアイテムをブラウザ内に表示する");
    translation.put("POP_MARK_UNREAD", "未読マークを付ける");
    translation.put("POP_COPY_NEWS_URL", "リンクのコピー");
    translation.put("POP_RATE_NEWS", "ニュースのレート付けをする");
    translation.put("POP_MAIL_LINK", "ニュースチップを友達にメールする");
    translation.put("POP_BLOG_NEWS", "ブログニュース");
    translation.put("POP_OPEN_EXTERN", "外部で開く");
    translation.put("POP_OPEN_STARTUP", "起動時に開く");
    translation.put("POP_KEEP_CURRENT", "他のタブすべてを閉じる");
    translation.put("POP_KEEP_NEWSFEEDS", "フィード以外のタブをすべて閉じる");
    translation.put("POP_MARK_ALL_READ", "すべて既読済みとする");
    translation.put("POP_MARK_CATEGORY_READ", "カテゴリを既読済みにする");
    translation.put("POP_PROPERTIES", "プロパティ");
    translation.put("POP_TAB_POSITION", "位置");
    translation.put("POP_TAB_POS_TOP", "トップ");
    translation.put("POP_TAB_POS_BOTTOM", "ボトム");
    translation.put("POP_MARK_FAVORITE_READ", "既読済みお気に入りとしてマークする");
    translation.put("POP_IMPORT_BLOGROLL", "ブログロールと同期");
    translation.put("POP_SYNCHRONIZE", "同期");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "ツールバーをカスタマイズ");
    translation.put("POP_CLEAR_HISTORY", "履歴をクリア");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "エラーが発生しました。RSSOwlは一旦終了しますが、設定情報は正しく保存されました。\nエラーのログ情報は、'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' ファイルに記述されています。\n\nこの不具合の開発者チームへ送信しますか？(日本語で書く場合は、To Japanese Developer. と記載してください）");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "エラー");
    translation.put("ERROR_NO_NEWS_FOUND", "エラー:ニュースが見つかりません。");
    translation.put("ERROR_CAT_EXISTS", "この名前に対応するカテゴリはすでに存在しています。");
    translation.put("ERROR_FAV_TITLE_EXISTS", "このタイトルに対応するお気に入りはすでに存在しています。");
    translation.put("ERROR_FAV_URL_EXISTS", "このURLに対応するお気に入りはすでに存在しています。");
    translation.put("ERROR_CONNECTION_FAILED", "接続に失敗しました。");
    translation.put("ERROR_GRABTITLE_FAILED", "タイトルが見つかりませんでした。");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwlはニュースフィードを表示することができませんでした。");
    translation.put("ERROR_FILE_NOT_FOUND", "ファイルが見つかりませんでした");
    translation.put("ERROR_AUTH_REQUIRED", "そのニュースフィードは保護されており、認証が必要です");
    translation.put("ERROR_REASON", "エラーの原因");
    translation.put("ERROR_LOADING_FEED", "タイトル \"%TITLE%\" のニュースフィードの読み込み中にエラーが発生しました。");
    translation.put("ERROR_HTTP_STATUS", "スタイタス");
    translation.put("ERROR_WORKING_OFFLINE", "オフライン中は、ニュースフィードを表示することができません。");
    translation.put("ERROR_NOT_A_XML", "このXMLは有効なXMLファイルではありません");
    translation.put("ERROR_NOT_A_RSS", "このXMLファイルは、有効なRSS,RDF,Atomフィードではありません");
    translation.put("ERROR_NOT_A_OPML", "このXMLはOPMLファイルではありません");
    translation.put("ERROR_SUB_EXISTS", "すでにブログロールとして購読済みです!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL/パス");
    translation.put("LABEL_CATEGORY", "カテゴリ");
    translation.put("LABEL_NO_INFOS", "追加情報はありません。");
    translation.put("LABEL_FAVORITE", "お気に入り");
    translation.put("LABEL_TITLE", "タイトル");
    translation.put("LABEL_USE_PROXY", "プロキシを使用する");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "プロキシは認証が必要");
    translation.put("LABEL_USERNAME", "ユーザ名");
    translation.put("LABEL_PASSWORD", "パスワード");
    translation.put("LABEL_PROXY_HOST", "プロキシのホスト名");
    translation.put("LABEL_PROXY_PORT", "プロキシのポート番号");
    translation.put("LABEL_CATEGORY", "カテゴリ");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "すべてのお気に入りでプロキシを使用する");
    translation.put("LABEL_NEWS_RATED", "レート付けられたニュース");
    translation.put("LABEL_SEARCH_TOPIC", "検索を指定してください。");
    translation.put("LABEL_SEARCH_FINISHED", "検索完了");
    translation.put("LABEL_SEARCH_RUNNING", "検索中");
    translation.put("LABEL_OPTIONS", "オプション");
    translation.put("LABEL_INTENSIVE_SEARCH", "詳細検索");
    translation.put("LABEL_PREFERED_LANGUAGE", "好みの言語");
    translation.put("LABEL_DESCRIPTION", "説明");
    translation.put("LABEL_CREATED", "作成");
    translation.put("LABEL_LAST_VISIT", "最終アクセス");
    translation.put("LABEL_NAME", "名前");
    translation.put("LABEL_KEY_SEQUENCE", "キー順");
    translation.put("LABEL_USED_BY", "使用者");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "キー順が無効です");
    translation.put("LABEL_SIZE", "サイズ");
    translation.put("LABEL_STYLE", "スタイル");
    translation.put("LABEL_SELECT_ENCODING", "テキストエンコーディングを選択");
    translation.put("LABEL_MAIL_SUBJECT", "題");
    translation.put("LABEL_MAIL_BODY", "本文");
    translation.put("LABEL_MAIL_USAGE", "ニュース情報では、[TITLE][LINK][DESCRIPTION][AUTHOR][CATEGORY][PUBDATE][PUBLISHER][SOURCE]をワイルドカード代わりに使用できます。");
    translation.put("LABEL_EMPTY_LINK", "リンクがありません");
    translation.put("LABEL_USE_SYSTEM_FONT", "システムフォントを使う");
    translation.put("LABEL_HTML_FORMAT_MAIL", "HTML 形式でメールを送る");
    translation.put("LABEL_CURRENT_COLOR", "現在の色");
    translation.put("LABEL_BLOGGER_USAGE", "ニュース情報では、[NEWSLINK][FEEDLINK][TITLE][DESCRIPTION][AUTHOR][CATEGORY][PUBDATE][PUBLISHER][SOURCE]をワイルドカード代わりに使用できます。");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "2つのウィンドウレイアウトのうち、どちらかを選択してください。");
    translation.put("LABEL_SEARCH_RESULTS", "\"%TERM%\"で%NUM%件ヒットしました");
    translation.put("LABEL_SEARCH_EMPTY", "\"%TERM%\"で検索しましたが、該当する件数がありません。");
    translation.put("LABEL_SELECT_BLOGGER", "外部のブロガーを選択");
    translation.put("LABEL_SINGLE_CLICK", "シングルクリック");
    translation.put("LABEL_DOUBLE_CLICK", "ダブルクリック");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "起動時に前回終了時に参照していたfeedsを開く");
    translation.put("LABEL_TRADITIONAL_TABS", "通常のタブ");
    translation.put("LABEL_CURVED_TABS", "丸みを帯びたタブ");
    translation.put("LABEL_READY", "準備完了");
    translation.put("LABEL_VALIDATION_FINISHED", "チェックが終了しました");
    translation.put("LABEL_VALIDATING", "チェック中");
    translation.put("LABEL_OVERRIDE_DTD", "Doctype宣言を上書きする");
    translation.put("LABEL_FEED_TYPE", "ニュースフィードの種類");
    translation.put("LABEL_ADDRESS", "URLアドレス");
    translation.put("LABEL_BROWSER_USAGE", "[URL] を指定すると、そこにURLを出すことができます。");
    translation.put("LABEL_OLD_ID", "以前のユーザID (オプション)");
    translation.put("LABEL_AMPHETARATE_ID", "ユーザ ID");
    translation.put("LABEL_REMEMBER_AUTH", "ユーザ名とパスワードを保存する");
    translation.put("LABEL_SORT_ORDER", "新しいソート");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl は最初に上位１０個のアイテム毎にソートをおこないます。これは、そのアイテムが入手不可能だった場合に備えて、RSSOwl はリストから次のアイテムを取得します");
    translation.put("LABEL_NOT_UNSUPPORTED", "ご使用のOSではまだサポートされておりません");
    translation.put("LABEL_KEY_DEL", "Delキー");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "ここで指定された値は、新しいお気に入りを作成するときに既定値として使用されます");
    translation.put("LABEL_RESTART", "RSSOwlの再起動が必要です");
    translation.put("LABEL_WELCOME_TITLE", "ようこそ RSSOwl へ - ニュースリーダー ( RSS / RDF / Atom ニュースフィード に対応 )");
    translation.put("LABEL_FIRST_STEPS", "ファーストステップ");
    translation.put("LABEL_NEWS", "ニュース");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwlニュースフィード");
    translation.put("LABEL_SUPPORT", "サポート");
    translation.put("LABEL_DISCUSSION_FORUM", "掲示板");
    translation.put("LABEL_PROMOTION", "プロモーション");
    translation.put("LABEL_CONTACT", "コンタクト");
    translation.put("LABEL_START", "スタート");
    translation.put("LABEL_DOWNLOAD", "ダウンロード");
    translation.put("LABEL_MAX_CONNECTIONS", "接続数の最大値");
    translation.put("LABEL_CON_TIMEOUT", "接続タイムアウトまでの時間(秒)");
    translation.put("LABEL_DELETE_FAVORITE", "お気に入りを削除");
    translation.put("LABEL_DELETE_CATEGORY", "カテゴリの削除");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "ブログロールを削除");
    translation.put("LABEL_REGISTRATION_SUCCESS", "登録に成功しました");
    translation.put("LABEL_SHOW", "表示モード");
    translation.put("LABEL_SEARCH_IN", "検索範囲");
    translation.put("LABEL_DOMAIN", "ドメイン");

    /** Buttons */
    translation.put("BUTTON_OPEN", "開く");
    translation.put("BUTTON_RELOAD_CAT", "お気に入りを更新する");
    translation.put("BUTTON_ADD", "追加");
    translation.put("BUTTON_FILE", "ファイルを選択");
    translation.put("BUTTON_SEARCH", "選択");
    translation.put("BUTTON_RELOAD", "ニュースを更新する");
    translation.put("BUTTON_CANCLE", "キャンセル");
    translation.put("BUTTON_EXPORT", "エクスポート");
    translation.put("BUTTON_STOP_SEARCH", "検索を中止する");
    translation.put("BUTTON_CLEAR_RESULTS", "結果をクリアする");
    translation.put("BUTTON_EXPORT_TO_OPML", "OPML形式でエクスポート");
    translation.put("BUTTON_ADDTO_FAVORITS", "お気に入りに追加する");
    translation.put("BUTTON_ASSIGN", "割り当てる");
    translation.put("BUTTON_RESTORE_DEFAULTS", "デフォルトに戻す");
    translation.put("BUTTON_APPLY", "適用");
    translation.put("BUTTON_CHANGE_FONT", "フォントの変更");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_DISPLAY_TABS", "タブにニュースフィードを表示");
    translation.put("BUTTON_VALIDATE", "チェック");
    translation.put("BUTTON_FOCUS_TABS", "新しいタブを追加したときに、自動的にそのタブにフォーカスを移動する");
    translation.put("BUTTON_TRAY_STARTUP", "起動時にシステムトレイ上にRSSOwlを表示する");
    translation.put("BUTTON_TRAY_EXIT", "終了時にシステムトレイ上にRSSOwlを表示する");
    translation.put("BUTTON_SHOW_ERRORS", "タブフォルダにエラーを表示する");
    translation.put("BUTTON_STOP_VALIDATION", "チェックを中止する");
    translation.put("BUTTON_CHANGE", "変更");
    translation.put("BUTTON_MARK_ALL_READ", "すべてのお気に入りを既読済みにする");
    translation.put("BUTTON_AGGREGATE_ALL", "すべてのお気に入りを集約する");
    translation.put("BUTTON_RELOAD_ALL", "すべてのお気に入りを再読み込みする");
    translation.put("BUTTON_SEARCH_ALL", "すべてのお気に入りの中で検索する");
    translation.put("BUTTON_CREATE_ACCOUNT", "アカウントを作成");
    translation.put("BUTTON_READ_ON_MINIMIZE", "すべてのニュースを最小化する");
    translation.put("BUTTON_TRAY_POPUP", "未読ニュースが入手可能になったら、ポップアップで知らせる");
    translation.put("BUTTON_READ_ON_CLOSE", "タブを閉じるときに、ニュースフィードを既読済みにする");
    translation.put("BUTTON_UP", "アップ");
    translation.put("BUTTON_DOWN", "ダウン");
    translation.put("BUTTON_NO_SORT", "ニュースフィードを自動的にソートしない");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "ニュースポップアップを自動的に閉じる");
    translation.put("BUTTON_CACHE_FEEDS", "オフラインで読むために、自動的にニュースフィードを保存する");
    translation.put("BUTTON_OPEN_IN_BROWSER", "ブラウザ内で表示する");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "タブに閉じるボタンを表示する");
    translation.put("BUTTON_DELETE_FAVORITE", "お気に入りを削除する場合");
    translation.put("BUTTON_DELETE_CATEGORY", "カテゴリを削除する場合");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "ブログロールを削除する場合");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "今後表示しない");
    translation.put("BUTTON_BLOCK_POPUPS", "ポップアップウィンドウをブロックする");
    translation.put("BUTTON_ANIMATE_POPUP", "ポップアップをアニメーションする");
    translation.put("BUTTON_REMOVE", "削除");
    translation.put("BUTTON_SMALL_ICONS", "小さいアイコン");
    translation.put("BUTTON_LINK_TAB", "表示されているフィードでリンクを作る");
    translation.put("BUTTON_CLEAR", "クリア");

    /** Header */
    translation.put("HEADER_NEWS", "ニュースヘッダ");
    translation.put("HEADER_RSS_FAVORITES", "お気に入り");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "クリックするとサイトを表示します。");
    translation.put("TOOLTIP_PRINT", "ニュースを印刷します。");
    translation.put("TOOLTIP_RATE", "クリックするとレート付けします。");
    translation.put("TOOLTIP_GRAB_TITLE", "ニュースフィードからタイトルを取得します。");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "未読のニュースフィードがあります");
    translation.put("TOOLTIP_SKIP", "スキップ");
    translation.put("TOOLTIP_OPEN_TAB", "新しいタブを開く");
    translation.put("TOOLTIP_QUICKSEARCH", "クイックサーチ");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "発行日");
    translation.put("TABLE_HEADER_AUTHOR", "著者");
    translation.put("TABLE_HEADER_CATEGORY", "カテゴリ");
    translation.put("TABLE_HEADER_PUBLISHER", "発行者");
    translation.put("TABLE_HEADER_NEWSTITLE", "ニュースヘッダ");
    translation.put("TABLE_HEADER_FEED", "ニュースフィード");
    translation.put("TABLE_HEADER_FEEDURL", "ニュースフィードURL");
    translation.put("TABLE_HEADER_FEEDTITLE", "ニュースフィードタイトル");
    translation.put("TABLE_HEADER_LINE", "行番号");
    translation.put("TABLE_HEADER_STATUS", "読み込み状況");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "ホームページ");
    translation.put("CHANNEL_INFO_PUBDATE", "発行日");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "最終チャネル変更日");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "編集者");
    translation.put("CHANNEL_INFO_WEBMASTER", "ウェブマスター");
    translation.put("CHANNEL_INFO_CATEGORY", "カテゴリ");
    translation.put("CHANNEL_INFO_DOCS", "文書");
    translation.put("CHANNEL_INFO_TTL", "チャンネル有効時間");
    translation.put("CHANNEL_INFO_RSSVERSION", "フォーマット");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS生成");
    translation.put("CHANNEL_INFO_PUBLISHER", "発行者");
    translation.put("CHANNEL_INFO_LANGUAGE", "言語");
    translation.put("CHANNEL_INFO_CREATOR", "作成者");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "更新日");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "更新回数");
    translation.put("NEWS_ITEM_INFO_SOURCE", "情報元");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "エンクロージャ");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "コメント");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "注意");
    translation.put("MESSAGEBOX_FILL_URL", "URLもしくはパスを入力してください。");
    translation.put("MESSAGEBOX_CAT_EXISTS", "その名前に対応するカテゴリはすでに存在しています。");
    translation.put("MESSAGEBOX_SELECT_CAT", "カテゴリを選択してください。");
    translation.put("MESSAGEBOX_FILE_EXISTS", "ファイルが存在しています。上書きしますか？");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "ファイルにはRSSOwlの設定情報が含まれていません。");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "設定のインポートが完了しました。");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "ニュース本文が空です。ニュースを選択してください。");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "お気に入りに追加する");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "カテゴリを追加してください。");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "タイトルを入力してください。");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "URLもしくはパスとタイトルを入力してください。");
    translation.put("BASE_AUTH_TITLE", "リクエストされたWebサイトは、認証が必要です。");
    translation.put("BASE_AUTH_MESSAGE", "ユーザ名とパスワードを入力してください。");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "タブフォルダ内で選択されたRSSは無効です。");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "確認してください。");
    translation.put("QUESTION_DEL_FAV", "お気に入りアイテム \"%NAME%\" を削除してもよろしいですか?");
    translation.put("QUESTION_DEL_CAT", "カテゴリアイテム \"%NAME%\" を削除してもよろしいですか?");
    translation.put("QUESTION_DEL_SUB", "このブログロールを削除してもよろしいですか?");
    translation.put("SEARCH_DIALOG_TITLE", "検索");
    translation.put("SEARCH_DIALOG_MESSAGE", "AND、OR または NOT を指定して検索します。");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "検索");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "完全一致");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "大文字/小文字を区別する");
    translation.put("SEARCH_DIALOG_REGEX", "通常の形式を使用する");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "新しいバージョンはありません。");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "ご使用のRSSOwlは最新です。");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "情報");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "カテゴリを編集する");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "お気に入りを編集する");
    translation.put("DIALOG_TITLE_UPDATE", "最新のRSSOwlが入手できます。");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "実行可能なパスを入力してください。");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "http://www.rssowl.orgに接続できません。");
    translation.put("DIALOG_ID_ATTENTION", "最初に AmphetaRateアカウントを取得する必要があります");
    translation.put("DIALOG_BROWSERSTART_FAILED", "ブラウザ起動に失敗しました。\n'プリファレンス'でブラウザを選択してください。");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "カテゴリにはお気に入りが登録されていません。");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "キー順を入力してください。");
    translation.put("DIALOG_BLOGGER_ATTENTION", "最初にブロガーを選択する必要があります。");
    translation.put("DIALOG_TITLE_CATEGORY", "カテゴリの選択");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "ホームページのＵＲＬを入力してください");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl は %FORMAT% ファイルを表示するアプリケーションを見つけることができませんでした");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "ブログロールの編集");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "内部ブラウザの読み込みに失敗しました!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "新しいブログロールの追加");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "なし");
    translation.put("UPDATE_INTERVAL_ONE", "1分後");
    translation.put("UPDATE_INTERVAL_FIVE", "5分後");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "15分後");
    translation.put("UPDATE_INTERVAL_THIRTY", "30分後");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "1時間後");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "3時間後");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "6時間後");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "12時間後");
    translation.put("UPDATE_INTERVAL_ONEDAY", "24時間後");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "テキストフォント");
    translation.put("FONT_AREA_DIALOG", "ダイアログフォント");
    translation.put("FONT_AREA_TREE", "ツリーフォント");
    translation.put("FONT_AREA_TABLE", "テーブルフォント");
    translation.put("FONT_AREA_HEADER", "ヘッダーフォント");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "テキストフォントは、ニュース文、チャネルインフォメーション、メッセージそしてエラーで使用されます。");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "ダイアログフォントは、すべてのダイアログで使用されます。");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "ツリーフォントはお気に入りのツリーで使用されます。");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "テーブルフォントは、ニュースフィードが含まれるテーブルで使用されます。");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "ヘッダーフォントはセクションヘッダで使用されます。");
    translation.put("FONT_STYLE_BOLD", "ボールド");
    translation.put("FONT_STYLE_ITALIC", "イタリック");
    translation.put("FONT_STYLE_NORMAL", "ノーマル");

    /** Browser */
    translation.put("BROWSER_BACK", "戻る");
    translation.put("BROWSER_FORWARD", "進む");
    translation.put("BROWSER_STOP", "停止");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "すばらしい");
    translation.put("RATE_GOOD", "良い");
    translation.put("RATE_MODERATE", "中間");
    translation.put("RATE_BAD", "悪い");
    translation.put("RATE_VERY_BAD", "とても悪い");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "↑");
    translation.put("LABEL_KEY_ARROW_DOWN", "↓");
    translation.put("LABEL_KEY_ARROW_LEFT", "←");
    translation.put("LABEL_KEY_ARROW_RIGHT", "→");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Groups */
    translation.put("GROUP_COMMAND", "コマンド");
    translation.put("GROUP_SELECTED_FONT", "選択されたフォント");
    translation.put("GROUP_FONT_AREA", "フォントエリア");
    translation.put("GROUP_WINDOW_LAYOUT", "ウィンドウレイアウト");
    translation.put("GROUP_OPEN_MODE", "オープンモード");
    translation.put("GROUP_ARGUMENTS", "引数");
    translation.put("GROUP_LINK_COLOR", "リンクカラー");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "検索をした際に、マッチした部分のカラー");
    translation.put("GROUP_TAB_LAYOUT", "タブレイアウト");
    translation.put("GROUP_TRAY", "システムトレイ");
    translation.put("GROUP_GENERAL", "一般");
    translation.put("GROUP_EXISTING_ACCOUNT", "既存のアカウント");
    translation.put("GROUP_NEW_ACCOUNT", "新しいアカウントを作成");
    translation.put("GROUP_NEWS_POPUP", "ニュースポップアップ");
    translation.put("GROUP_CONFIRM_DIALOG", "確認ダイアログを表示する");

    /** Languages */
    translation.put("de", "ドイツ語");
    translation.put("da", "デンマーク語");
    translation.put("el", "ギリシャ語");
    translation.put("en", "英語");
    translation.put("es", "スペイン後");
    translation.put("fr", "フランス語");
    translation.put("gl", "ガルシア語");
    translation.put("it", "イタリア語");
    translation.put("nl", "オランダ語");
    translation.put("pt", "ポルトガル語(ブラジル)");
    translation.put("ru", "ロシア語");
    translation.put("bg", "ブルガリア語");
    translation.put("no", "ノルウェー語");
    translation.put("ja", "日本語");
    translation.put("zhcn", "簡体字中国語");
    translation.put("ko", "韓国語");
    translation.put("sv", "スウェーデン語");
    translation.put("pl", "ポーランド語");
    translation.put("bn", "ベンガル語");
    translation.put("zhtw", "繁体字中国語");
    translation.put("fi", "フィンランド語");
    translation.put("uk", "ウクライナ語");
    translation.put("cs", "チェコ語");
    translation.put("sl", "スロベニア語");
    translation.put("tr", "トルコ語");
    translation.put("hu", "ハンガリー語");
    translation.put("th", "タイ語");
    translation.put("sr", "セルビア語(キリル文字)");
    translation.put("sh", "セルビア語(ラテン文字)");
    translation.put("hr", "クロアチア語");
    translation.put("sk", "スロバキア語");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "説明はありません。");
    translation.put("PRINTED_FROM_RSSOWL", "Printed from RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Printing news from RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "RSSOwlを表示");
    translation.put("TAB_WELCOME", "ようこそ");
    translation.put("DOCUMENT_GENERATED_FROM", "RSSOwlがドキュメントを生成しました.");
    translation.put("NO_TITLE", "タイトルなし");
    translation.put("RSSOWL_TEASER", "RSSOwl は無償で、オープンソースの RSS / RDF / Atom ニュースリーダーです。機能のご紹介:\n\n- ニュースを PDF, HTML, RTF, OPML形式でエクスポート\n- OPML形式からお気に入りをインポート\n- フルテキスト検索および検索語句のハイライト化\n- パワフルな RSS / RDF / Atom 検索エンジン\n- ニュースを内部ブラウザで表示\n- カテゴリでお気に入りを管理\n- WindowsやLinuxやSolaris、Macでも動作\n\nすべての機能一覧はこちら: http://www.rssowl.org/overview\n\nダウンロードはこちら: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "お薦めの記事");
    translation.put("LOAD_FEED", "ロード中");
    translation.put("SEARCH_FEED", "検索中");
    translation.put("RELOAD_FEED", "再ロード中");
    translation.put("MAIL_ERROR_BODY", "恐れ入りますが、'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' にあるファイルをこのメールに添付して、エラー発生する前にどのような操作をおこなったのかについて簡単な説明をお願いいたします。");
    translation.put("FORMAT_AUTO_DETECT", "自動で認識");
    translation.put("NEWSFEED_VALID", "新しいニュースフィードは有効です");
    translation.put("OPML_IMPORTED", "インポート済み");
    translation.put("ENTIRE_NEWS", "ニュース全体");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}