/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Dutch internationalization for RSSOwl (i18n). <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nNL extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nNL(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Bestand");
    translation.put("MENU_SAVE", "Bewaar Als");
    translation.put("MENU_TOOLBAR", "Toolbar");
    translation.put("MENU_GENERATE_PDF", "Genereer PDF");
    translation.put("MENU_GENERATE_HTML", "Genereer HTML");
    translation.put("MENU_GENERATE_RTF", "Genereer RTF");
    translation.put("MENU_IMPORT", "Importeer configuratie");
    translation.put("MENU_EXPORT", "Exporteer configuratie");
    translation.put("MENU_EXIT", "Sluiten");
    translation.put("MENU_WINDOW", "Venster");
    translation.put("MENU_QUICKVIEW", "Snelle weergave");
    translation.put("MENU_PREFERENCES", "Configuratie");
    translation.put("MENU_BROWSER", "Browser");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Selecteer externe browser");
    translation.put("MENU_FONT", "Lettertypes");
    translation.put("MENU_ENCODING", "Tekst codering");
    translation.put("MENU_LANGUAGE", "Taal");
    translation.put("MENU_PROXY", "Proxy");
    translation.put("MENU_MISC", "Diversen");
    translation.put("MENU_DIRECTOPEN", "Open leeg nieuwsitem automatisch in browser");
    translation.put("MENU_DIRECTOPENEACH", "Open alle nieuwsitems automatisch in browser");
    translation.put("MENU_SYSTRAY", "Plaats RSSOwl in de Taakbalk");
    translation.put("MENU_CHANNELINFO", "Toon newsfeed informatie");
    translation.put("MENU_BROWSER_EXTERN", "Open externe browser");
    translation.put("MENU_CHECK_UPDATE", "Controleer na het opstarten op nieuwe versies");
    translation.put("MENU_ABOUT", "Over dit programma");
    translation.put("MENU_LICENSE", "Licentie");
    translation.put("MENU_UPDATE", "Controleer voor nieuwe versie");
    translation.put("MENU_WELCOME", "Welkom");
    translation.put("MENU_DONATE", "Doe een donatie");
    translation.put("MENU_INFO", "Help");
    translation.put("MENU_TOOLS", "Opties");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Geef nieuws tekst in browser weer");
    translation.put("MENU_MINIMIZE_RSSOWL", "Minimaliseer RSSOwl");
    translation.put("MENU_GOTO", "Navigatie");
    translation.put("MENU_NEXT_NEWS", "Volgend nieuwsbericht");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Volgend ongelezen bericht");
    translation.put("MENU_CLOSE", "Sluit");
    translation.put("MENU_CLOSE_ALL", "Sluit allen");
    translation.put("MENU_PREVIOUS_TAB", "Vorige Tab");
    translation.put("MENU_NEXT_TAB", "Volgende Tab");
    translation.put("MENU_HOTKEYS", "Sneltoetsen");
    translation.put("MENU_MAILING_LIST", "Mail Lijst");
    translation.put("MENU_NEWSTIP_MAIL", "Maak NewsTip Mail op");
    translation.put("MENU_TELL_FRIENDS", "Vertel mijn vrienden");
    translation.put("MENU_RELOAD", "Herladen");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Genereer PDF uit geselecteerd nieuws");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Genereer HTML uit geselecteerd nieuws");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Genereer RTF uit geselecteerd nieuws");
    translation.put("MENU_TUTORIAL", "Leerprogramma");
    translation.put("MENU_COLORS", "Kleuren");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "General");
    translation.put("MENU_OPENNEW_BROWSER", "Open de interne browser altijd in een nieuwe tab");
    translation.put("MENU_FEEDSEARCH", "Zoek naar Newsfeeds");
    translation.put("MENU_IMPORT_OPML", "Importeer uit OPML");
    translation.put("MENU_VALIDATE", "Controleer Newsfeed");
    translation.put("MENU_FEED_DISCOVERY", "Ontdek Newsfeeds op de website");
    translation.put("MENU_EDIT", "Bewerken");
    translation.put("MENU_EDIT_COPY", "Kopiëren");
    translation.put("MENU_EDIT_PASTE", "Plakken");
    translation.put("MENU_EDIT_SELECT_ALL", "Selecteer Alle");
    translation.put("MENU_EDIT_DELETE", "Verwijder");
    translation.put("MENU_EDIT_CUT", "Knippen");
    translation.put("MENU_DISPLAY_FEED_PDF", "Geef Newsfeed weer in PDF");
    translation.put("MENU_DISPLAY_FEED_RTF", "Geef Newsfeed weer in RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Geef Newsfeed weer in HTML");
    translation.put("MENU_NEW_FAVORITE", "Nieuwe Favoriet");
    translation.put("MENU_CONNECTION", "Verbinding");
    translation.put("MENU_EDIT_RENAME", "Hernoemen");
    translation.put("MENU_WORK_OFFLINE", "Werk Offline");
    translation.put("MENU_WORK_ONLINE", "Werk Online");

    /** ToolBar */
    translation.put("TOOL_MARK", "Markeer");
    translation.put("TOOL_NEXT", "Volgende");
    translation.put("TOOL_SEPARATOR", "Separator");
    translation.put("TOOL_ICONS_TEXT", "Iconen and Tekst");
    translation.put("TOOL_ICONS", "Iconen");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Quoteer");
    translation.put("TOOL_HISTORY", "Geschiedenis");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Nieuw");
    translation.put("POP_SUB_CATEGORY", "Subcategorie");
    translation.put("POP_UNSUBSCRIBE", "Afmelden");
    translation.put("POP_USEPROXY", "Gebruik proxy");
    translation.put("POP_AGGREGATE_FAV", "Verzamel favorieten");
    translation.put("POP_AUTO_UPDATE", "Automatisch bijwerken");
    translation.put("POP_UPDATE_ONSTARTUP", "bij het opstarten");
    translation.put("POP_IMPORT", "Importeer");
    translation.put("POP_FROM_OPML", "Uit OPML bestand");
    translation.put("POP_EXPORT_OPML", "Naar OPML bestand");
    translation.put("POP_COPY", "Kopiëren");
    translation.put("POP_OPEN_IN_BROWSER", "Open selectie in browser");
    translation.put("POP_MARK_UNREAD", "Markeer ongelezen");
    translation.put("POP_COPY_NEWS_URL", "Kopieer link");
    translation.put("POP_OPEN_EXTERN", "Open extern");
    translation.put("POP_RATE_NEWS", "Waardeer nieuws");
    translation.put("POP_MAIL_LINK", "Mail NewsTip naar een vriend");
    translation.put("POP_BLOG_NEWS", "Blog nieuws");
    translation.put("POP_OPEN_STARTUP", "Openen bij het opstarten");
    translation.put("POP_KEEP_CURRENT", "Sluit anderen");
    translation.put("POP_KEEP_NEWSFEEDS", "Sluit alles behalve bronnen");
    translation.put("POP_MARK_ALL_READ", "Markeer Alles als gelezen");
    translation.put("POP_MARK_CATEGORY_READ", "Markeer de categorie als gelezen");
    translation.put("POP_PROPERTIES", "Eigenschappen");
    translation.put("POP_TAB_POSITION", "Positie");
    translation.put("POP_TAB_POS_TOP", "Bovenaan");
    translation.put("POP_TAB_POS_BOTTOM", "Onderaan");
    translation.put("POP_MARK_FAVORITE_READ", "Markeer Favorieten Gelezen");
    translation.put("POP_IMPORT_BLOGROLL", "Gesynchroniseerde Blogroll");
    translation.put("POP_SYNCHRONIZE", "Synchronizeren");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Aanpassen Toolbar");
    translation.put("POP_CLEAR_HISTORY", "Verwijder Geschiedenis");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Er heeft zich een onverwachte fout voorgedaan! RSSOwl moet sluiten maar de instellingen zijn opgeslagen.\nDe fout is vastgelegd in '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nWilt u een foutenrapport zenden naar het RSSOwl Team?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Fout");
    translation.put("ERROR_NO_NEWS_FOUND", "Fout: Kan geen nieuws vinden!");
    translation.put("ERROR_CAT_EXISTS", "Een categorie met deze naam bestaat al!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Een favoriet met deze titel bestaat al!");
    translation.put("ERROR_FAV_URL_EXISTS", "Een favoriet met deze URL bestaat al!");
    translation.put("ERROR_CONNECTION_FAILED", "Connectie faalde!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl kan de newsfeed niet weergeven.");
    translation.put("ERROR_FILE_NOT_FOUND", "Kan de file niet vinden");
    translation.put("ERROR_AUTH_REQUIRED", "De newsfeed is beschermd is vereist authenticatie");
    translation.put("ERROR_REASON", "Oorzaak");
    translation.put("ERROR_LOADING_FEED", "Fout bij het laden van de Newsfeed \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "De newsfeed kan niet offline weergegeven worden");
    translation.put("ERROR_GRABTITLE_FAILED", "Kon de titel niet vinden!");
    translation.put("ERROR_NOT_A_XML", "De file is geen geldig XML document");
    translation.put("ERROR_NOT_A_RSS", "Het XML document is geen geldig RSS, RDF of Atom newsfeed");
    translation.put("ERROR_NOT_A_OPML", "Het XML document is geen OPML file");
    translation.put("ERROR_SUB_EXISTS", "U bent reeds opgegeven voor deze Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Pad");
    translation.put("LABEL_CATEGORY", "Categorie");
    translation.put("LABEL_NO_INFOS", "Geen verdere informatie!");
    translation.put("LABEL_FAVORITE", "Favoriet");
    translation.put("LABEL_TITLE", "Titel");
    translation.put("LABEL_USE_PROXY", "Gebruik proxy");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proxy vereist authenticatie");
    translation.put("LABEL_USERNAME", "Gebruikersnaam");
    translation.put("LABEL_PASSWORD", "Wachtwoord");
    translation.put("LABEL_PROXY_HOST", "Proxy Host");
    translation.put("LABEL_PROXY_PORT", "Proxy Poort");
    translation.put("LABEL_CATEGORY", "Categorie");
    translation.put("LABEL_NEWS_RATED", "Nieuws waardering");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Gebruik proxy voor alle favorieten");
    translation.put("LABEL_MAIL_SUBJECT", "Onderwerp");
    translation.put("LABEL_MAIL_BODY", "Inhoud");
    translation.put("LABEL_MAIL_USAGE", "Gebruik [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] en [DESCRIPTION] als sleutels voor de nieuws informatie.");
    translation.put("LABEL_BLOGGER_USAGE", "Gebruik [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] en [TITLE] als sleutels voor de nieuws informatie.");
    translation.put("LABEL_EMPTY_LINK", "Geen link gegeven");
    translation.put("LABEL_SEARCH_FINISHED", "Zoekopdracht afgerond.");
    translation.put("LABEL_SEARCH_RUNNING", "Zoekopdracht bezig");
    translation.put("LABEL_OPTIONS", "Opties");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intensieve zoekopdracht");
    translation.put("LABEL_PREFERED_LANGUAGE", "Taal voorkeur");
    translation.put("LABEL_DESCRIPTION", "Beschrijving");
    translation.put("LABEL_CREATED", "Gecreëerd");
    translation.put("LABEL_LAST_VISIT", "Laatst bezocht");
    translation.put("LABEL_USE_SYSTEM_FONT", "Gebruik systeem lettertype");
    translation.put("LABEL_SELECT_ENCODING", "Selecteer codering");
    translation.put("LABEL_USED_BY", "Gebruikt door");
    translation.put("LABEL_SEARCH_TOPIC", "Vul a.u.b. een zoekopdracht in");
    translation.put("LABEL_NAME", "Naam");
    translation.put("LABEL_KEY_SEQUENCE", "Toetsen combinatie");
    translation.put("LABEL_SIZE", "Grootte");
    translation.put("LABEL_STYLE", "Stijl");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Mail in HTML formaat");
    translation.put("LABEL_SEARCH_RESULTS", "De zoekopdracht naar \"%TERM%\" leverde %NUM% resultaten op");
    translation.put("LABEL_SEARCH_EMPTY", "De zoekopdracht naar \"%TERM%\" leverde geen resultaten op.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Selecteer a.u.b. één van de twee venster indelingen.");
    translation.put("LABEL_SINGLE_CLICK", "Enkele klik");
    translation.put("LABEL_DOUBLE_CLICK", "Dubbele klik");
    translation.put("LABEL_SELECT_BLOGGER", "Selecteer externe blogger");
    translation.put("LABEL_CURRENT_COLOR", "Huidige kleur");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Toetsencombinatie is ongeldig!");
    translation.put("LABEL_TRADITIONAL_TABS", "Traditionele Tabs");
    translation.put("LABEL_CURVED_TABS", "Geronde Tabs");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Laatst geopende bronnen openen bij het opstarten");
    translation.put("LABEL_READY", "Klaar");
    translation.put("LABEL_OLD_ID", "Oud User ID (optioneel)");
    translation.put("LABEL_AMPHETARATE_ID", "User ID");
    translation.put("LABEL_VALIDATION_FINISHED", "Controle beëindigd");
    translation.put("LABEL_VALIDATING", "Bezig met controleren");
    translation.put("LABEL_OVERRIDE_DTD", "Negeer Doctype declaratie");
    translation.put("LABEL_FEED_TYPE", "Newsfeed type");
    translation.put("LABEL_ADDRESS", "URL adres");
    translation.put("LABEL_BROWSER_USAGE", "Gebruik [URL] als een vervangbare parameter voor de URL.");
    translation.put("LABEL_REMEMBER_AUTH", "Onthoud gebruikersnaam en wachtwoord");
    translation.put("LABEL_SORT_ORDER", "Nieuws Sorteren");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl eerste poging om de newsfeed te sorteren volgens het item bovenaan de lijst. In het geval dat het item niet beschikbaar is gaat RSSOwl verder met het volgende item in de lijst.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Nog niet ondersteund op uw besturings systeem");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "De waarden die aan aanpasbaar zijn, zullen als initiële waarden worden genomen voor elke nieuwe favoriet");
    translation.put("LABEL_RESTART", "Deze aanpassingen vereisen een herstart van RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Welkom bij RSSOwl - Newsreader voor RSS / RDF / Atom Newsfeeds");
    translation.put("LABEL_FIRST_STEPS", "Eerste Stappen");
    translation.put("LABEL_NEWS", "Nieuws");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl Newsfeed");
    translation.put("LABEL_SUPPORT", "Ondersteuning");
    translation.put("LABEL_DISCUSSION_FORUM", "Discussie Forum");
    translation.put("LABEL_PROMOTION", "Promotie");
    translation.put("LABEL_CONTACT", "Contact");
    translation.put("LABEL_START", "Start");
    translation.put("LABEL_DOWNLOAD", "Download");
    translation.put("LABEL_MAX_CONNECTIONS", "Maximum aantal connecties");
    translation.put("LABEL_CON_TIMEOUT", "Verbinding timeout in  seconden");
    translation.put("LABEL_DELETE_FAVORITE", "Verwijder een favoriet");
    translation.put("LABEL_DELETE_CATEGORY", "Verwijder een categorie");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Verwijder een Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registratie was successvol");
    translation.put("LABEL_SHOW", "Toon");
    translation.put("LABEL_SEARCH_IN", "Zoeken in");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Open");
    translation.put("BUTTON_RELOAD_CAT", "Herlaad favorieten");
    translation.put("BUTTON_ADD", "Toevoegen");
    translation.put("BUTTON_FILE", "Selecteer bestand");
    translation.put("BUTTON_SEARCH", "Zoeken");
    translation.put("BUTTON_RELOAD", "Herlaad nieuws");
    translation.put("BUTTON_CANCLE", "Annuleren");
    translation.put("BUTTON_EXPORT", "Exporteer");
    translation.put("BUTTON_EXPORT_TO_OPML", "Exporteer naar OPML");
    translation.put("BUTTON_STOP_SEARCH", "Stop zoekopdracht");
    translation.put("BUTTON_CLEAR_RESULTS", "Verwijder resultaten");
    translation.put("BUTTON_ADDTO_FAVORITS", "Toevoegen aan favorieten");
    translation.put("BUTTON_ASSIGN", "Toekennen");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Herstel standaard waarden");
    translation.put("BUTTON_APPLY", "Toepassen");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_CHANGE_FONT", "Verander Lettertype");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Markeer alle nieuws als gelezen tijdens het minimalizeren");
    translation.put("BUTTON_TRAY_POPUP", "Toon een popup indien ongelezen nieuws verkrijgbaar is");
    translation.put("BUTTON_READ_ON_CLOSE", "Markeer de feed als gelezen waneer de tab wordt gesloten");
    translation.put("BUTTON_CHANGE", "Wijzig");
    translation.put("BUTTON_DISPLAY_TABS", "Toon newsfeeds in tabs");
    translation.put("BUTTON_FOCUS_TABS", "Focus op nieuwe tabs");
    translation.put("BUTTON_STOP_VALIDATION", "Stop controle");
    translation.put("BUTTON_VALIDATE", "Controleer");
    translation.put("BUTTON_TRAY_STARTUP", "Plaats RSSOwl in de system tray bij het opstarten");
    translation.put("BUTTON_TRAY_EXIT", "Plaats RSSOwl in de system tray bij het afsluiten");
    translation.put("BUTTON_MARK_ALL_READ", "Markeer Alle Favorieten Als Gelezen");
    translation.put("BUTTON_AGGREGATE_ALL", "Groepeer Alle Favorieten");
    translation.put("BUTTON_RELOAD_ALL", "Herlaad Alle Favorieten");
    translation.put("BUTTON_SEARCH_ALL", "Zoek In Alle Favorieten");
    translation.put("BUTTON_SHOW_ERRORS", "Toon fouten in de tabfolder");
    translation.put("BUTTON_CREATE_ACCOUNT", "Creëer account");
    translation.put("BUTTON_UP", "Boven");
    translation.put("BUTTON_DOWN", "Onder");
    translation.put("BUTTON_NO_SORT", "Sorteer de Newsfeeds niet automatisch");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Close nieuwe popups automatisch");
    translation.put("BUTTON_CACHE_FEEDS", "Bewaar newsfeeds automatisch voor offline te lezen");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Open in Browser");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Toon sluitknoppen in de Tabs");
    translation.put("BUTTON_DELETE_FAVORITE", "Bij het verwijderen van een favoriet");
    translation.put("BUTTON_DELETE_CATEGORY", "Bij het verwijderen van een categorie");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Bij het verwijderen van een Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Vraag dit nooit meer");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokkeer Popup Vensters");
    translation.put("BUTTON_ANIMATE_POPUP", "Animeer Popup");
    translation.put("BUTTON_REMOVE", "Verwijder");
    translation.put("BUTTON_SMALL_ICONS", "Gebruik kleine iconen");
    translation.put("BUTTON_LINK_TAB", "Link met de getoonde Feed");
    translation.put("BUTTON_CLEAR", "Maak leeg");

    /** Header */
    translation.put("HEADER_NEWS", "Nieuwskop");
    translation.put("HEADER_RSS_FAVORITES", "Favorieten");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Klik om de site te openen!");
    translation.put("TOOLTIP_PRINT", "Nieuws afdrukken");
    translation.put("TOOLTIP_RATE", "Klik a.u.b om uw waardering uit te spreken");
    translation.put("TOOLTIP_GRAB_TITLE", "Zoek de titel van de nieuwsbron");
    translation.put("TOOLTIP_SKIP", "Sla over");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Ongelezen nieuws beschikbaar");
    translation.put("TOOLTIP_OPEN_TAB", "Open nieuwe tab");
    translation.put("TOOLTIP_QUICKSEARCH", "Snel Zoeken");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Publicatiedatum");
    translation.put("TABLE_HEADER_AUTHOR", "Auteur");
    translation.put("TABLE_HEADER_CATEGORY", "Categorie");
    translation.put("TABLE_HEADER_PUBLISHER", "Uitgever");
    translation.put("TABLE_HEADER_NEWSTITLE", "Nieuwskop");
    translation.put("TABLE_HEADER_FEED", "Nieuwsbron");
    translation.put("TABLE_HEADER_FEEDURL", "Nieuwsbron URL");
    translation.put("TABLE_HEADER_FEEDTITLE", "Nieuwsbron Titel");
    translation.put("TABLE_HEADER_LINE", "Rij");
    translation.put("TABLE_HEADER_STATUS", "Lees Status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_PUBDATE", "Publicatie datum");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Laatste kanaalwijziging");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Beheerder");
    translation.put("CHANNEL_INFO_WEBMASTER", "Webmaster");
    translation.put("CHANNEL_INFO_CATEGORY", "Categorie");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Kanaal \"time to live\"");
    translation.put("CHANNEL_INFO_RSSVERSION", "Formaat");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS Generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Publisher");
    translation.put("CHANNEL_INFO_LANGUAGE", "Taal");
    translation.put("CHANNEL_INFO_CREATOR", "Creator");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Bijwerken");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "keer");
    translation.put("CHANNEL_INFO_HOMEPAGE", "Homepage");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Bron");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Enclosure");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Commentaar");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Opgelet");
    translation.put("MESSAGEBOX_FILL_URL", "Vul a.u.b. een URL of een pad in");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Een categorie met deze naam bestaat al");
    translation.put("MESSAGEBOX_SELECT_CAT", "Selecteer een categorie a.u.b.");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Bestand bestaat al. Overschrijven?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Bestand bevat geen RSSOwl configuratie!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Het importeren van de configuratie is gelukt!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Nieuws tekst is leeg! Selecteer a.u.b. een nieuwsitem.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Voeg een nieuwe favoriet toe");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Voeg een nieuwe categorie toe");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Vul a.u.b. een titel in");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Vul a.u.b. een URL / pad en titel in");
    translation.put("BASE_AUTH_TITLE", "De opgevraagde website vereist authenticatie!");
    translation.put("BASE_AUTH_MESSAGE", "Vul a.u.b. een gebruikersnaam en wachtwoord in.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Geen correct RSS geselecteerd!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Bevestig a.u.b.");
    translation.put("SEARCH_DIALOG_TITLE", "Zoeken");
    translation.put("SEARCH_DIALOG_MESSAGE", "Gebruik EN, OF en NIET om de zoekresultaten te beperken");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Zoek naar");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Alleen hele woorden");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Let op verschil tussen grote en kleine letters");
    translation.put("SEARCH_DIALOG_REGEX", "Gebruik regular expression");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Geen nieuwe versie beschikbaar");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "U gebruikt al de nieuwste RSSOwl versie!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informatie");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Categorie aanpassen");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Favoriet aanpassen");
    translation.put("DIALOG_TITLE_UPDATE", "Nieuwe RSSOwl versie beschikbaar");
    translation.put("DIALOG_ID_ATTENTION", "Vul a.u.b. eerst uw AmphetaRate User ID in!");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Kan geen connectie maken met http://www.rssowl.org");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Niet gelukt om browser te starten!\nSelecteer a.u.b. een browser in 'Preferences'");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Categorie bevat geen favorieten!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Type a.u.b. een toetsencombinatie");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Je moet eerst een blogger instellen!");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Vul a.u.b. het pad naar het programma in");
    translation.put("DIALOG_ID_ATTENTION", "U moet eerst een AmphetaRate account aanmaken!");
    translation.put("DIALOG_TITLE_CATEGORY", "Selecteer een categorie");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Vul de URL van de website hier in, a.u.b.");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl heeft geen applicatie kunnen vinden om %FORMAT% weer te geven");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Edit Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Laden van interne browser mislukt!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Voeg een nieuwe Blogroll toe");
    translation.put("QUESTION_DEL_FAV", "Weet u zeker dat u de favoriet \"%NAME%\" wilt verwijderen?");
    translation.put("QUESTION_DEL_CAT", "Weet u zeker dat u de categorie \"%NAME%\" wilt verwijderen?");
    translation.put("QUESTION_DEL_SUB", "Weet u zeker dat u de Blogroll wilt verwijderen?");

    /** Browser */
    translation.put("BROWSER_BACK", "Terug");
    translation.put("BROWSER_FORWARD", "Vooruit");
    translation.put("BROWSER_STOP", "Stop");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "geen");
    translation.put("UPDATE_INTERVAL_ONE", "na 1 minuut");
    translation.put("UPDATE_INTERVAL_FIVE", "na 5 minuten");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "na 15 minuten");
    translation.put("UPDATE_INTERVAL_THIRTY", "na 30 minuten");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "na 1 uur");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "na 3 uur");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "na 6 uur");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "na 12 uur");
    translation.put("UPDATE_INTERVAL_ONEDAY", "na 1 dag");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Fantastisch");
    translation.put("RATE_GOOD", "Goed");
    translation.put("RATE_MODERATE", "Gemiddeld");
    translation.put("RATE_BAD", "Slecht");
    translation.put("RATE_VERY_BAD", "Heel slecht");

    /** Keyboard keys */
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Pijl_Omhoog");
    translation.put("LABEL_KEY_ARROW_DOWN", "Pijl_Omlaag");
    translation.put("LABEL_KEY_ARROW_LEFT", "Pijl_Links");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Pijl_Rechts");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Spatie");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "NumPad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_CONTROL", "Ctrl");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Lettertype Tekst");
    translation.put("FONT_AREA_DIALOG", "Lettertype Dialoogvensters");
    translation.put("FONT_AREA_TREE", "Boom Lettertype ");
    translation.put("FONT_AREA_TABLE", "Tabel Lettertype");
    translation.put("FONT_AREA_HEADER", "Kop Lettertype");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Het tekst lettertype wordt gebruikt voor de nieuwstekst, kanaal informatie, berichten en foutmeldingen.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Het dialoog lettertype wordt gebruikt in alle dialoog vensters.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Het boom lettertype wordt gebruikt voor de boom met de favorieten.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Het tabel lettertype wordt gebruikt voor de tabel met nieuwsberichten van een nieuws kanaal.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Het kop lettertype wordt gebruikt voor sectie koppen.");
    translation.put("FONT_STYLE_BOLD", "Vet");
    translation.put("FONT_STYLE_ITALIC", "Cursief");
    translation.put("FONT_STYLE_NORMAL", "Normaal");

    /** Groups */
    translation.put("GROUP_COMMAND", "Command");
    translation.put("GROUP_SELECTED_FONT", "Selecteer Lettertype");
    translation.put("GROUP_OPEN_MODE", "Open modus");
    translation.put("GROUP_LINK_COLOR", "Link Kleur");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Zoek-resultaten kleur");
    translation.put("GROUP_WINDOW_LAYOUT", "Venster indeling");
    translation.put("GROUP_FONT_AREA", "Lettertyper gebied");
    translation.put("GROUP_ARGUMENTS", "Arguments");
    translation.put("GROUP_TAB_LAYOUT", "Tab layout");
    translation.put("GROUP_TRAY", "System Tray");
    translation.put("GROUP_GENERAL", "Algemeen");
    translation.put("GROUP_EXISTING_ACCOUNT", "Bestaand account");
    translation.put("GROUP_NEW_ACCOUNT", "Creëer een nieuw account");
    translation.put("GROUP_NEWS_POPUP", "News Popup");
    translation.put("GROUP_CONFIRM_DIALOG", "Toon bevestigings-dialoogvenster");

    /** Languages */
    translation.put("en", "Engels");
    translation.put("de", "Duits");
    translation.put("fr", "Frans");
    translation.put("es", "Spaans");
    translation.put("da", "Deens");
    translation.put("zhcn", "Versimpeld Chinees");
    translation.put("ja", "Japans");
    translation.put("pt", "Portugees");
    translation.put("gl", "Galicisch");
    translation.put("nl", "Nederlands");
    translation.put("it", "Italiaans");
    translation.put("el", "Grieks");
    translation.put("ru", "Russisch");
    translation.put("bg", "Bulgaars");
    translation.put("no", "Noors");
    translation.put("bn", "Bengaals");
    translation.put("sv", "Zweeds");
    translation.put("pl", "Pools");
    translation.put("ko", "Koreaans");
    translation.put("uk", "Oekraïens");
    translation.put("fi", "Fins");
    translation.put("zhtw", "Traditioneel Chinees");
    translation.put("cs", "Tsjechisch");
    translation.put("sl", "Sloveens");
    translation.put("tr", "Turks");
    translation.put("hu", "Hongaars");
    translation.put("th", "Thaïs");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Geen beschrijving beschikbaar!");
    translation.put("PRINTED_FROM_RSSOWL", "Afgedrukt vanuit RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Nieuws afdrukken vanuit RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Geef RSSOwl weer");
    translation.put("TAB_WELCOME", "Welkom");
    translation.put("DOCUMENT_GENERATED_FROM", "Document gegenereerd door RSSOwl");
    translation.put("NO_TITLE", "Geen titel");
    translation.put("RSSOWL_TEASER", "RSSOwl is een gratis, opensource RSS / RDF / Atom nieuws lezer. Speciale mogelijkheden zijn:\n\n- Exporteer nieuws naar PDF, HTML, RTF en OPML\n- Importeer favorieten vanuit  OPML\n- Zoekopdrachten met markering van de resultaten\n- Krachtige RSS / RDF / Atom zoek-engine\n- Bekijk nieuws in een interne browser\n- Beheer favorieten in categorien\n- Werkt op Windows, Linux, Solaris en Mac\n\nVoor een complete lijst van mogelijkheden, kijk op: http://www.rssowl.org/overview\n\nDownload van: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Aanbevolen artikelen");
    translation.put("LOAD_FEED", "Bezig met laden");
    translation.put("SEARCH_FEED", "Bezig met zoeken");
    translation.put("RELOAD_FEED", "Bezig met herladen");
    translation.put("MAIL_ERROR_BODY", "Maak indien mogelijk een attachement met daarin de volgende bestanden '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' en geef een korte beschrijving van wat RSSOwl aan het doen was voordat de fout zich voordeed. Bedankt!");
    translation.put("FORMAT_AUTO_DETECT", "Detecteer zelf");
    translation.put("NEWSFEED_VALID", "De NewsFeed is geldig");
    translation.put("OPML_IMPORTED", "Geïmporteerd");
    translation.put("ENTIRE_NEWS", "Alle Nieuws");
    translation.put("SEARCH_AND", "EN");
    translation.put("SEARCH_OR", "OF");
    translation.put("SEARCH_NOT", "NIET");
  }
}