/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Russian internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nRU extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nRU(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Файл");
    translation.put("MENU_SAVE", "Сохранить как");
    translation.put("MENU_TOOLBAR", "Панель инструментов");
    translation.put("MENU_GENERATE_PDF", "Сгенерировать PDF");
    translation.put("MENU_GENERATE_HTML", "Сгенерировать HTML");
    translation.put("MENU_GENERATE_RTF", "Сгенерировать RTF");
    translation.put("MENU_IMPORT", "Импорт настроек");
    translation.put("MENU_EXPORT", "Экспорт настроек");
    translation.put("MENU_EXIT", "Выход");
    translation.put("MENU_WINDOW", "Просмотр");
    translation.put("MENU_QUICKVIEW", "Быстрый просмотр");
    translation.put("MENU_PREFERENCES", "Настройки");
    translation.put("MENU_BROWSER", "Браузер");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Выберите внешний браузер");
    translation.put("MENU_FONT", "Шрифт");
    translation.put("MENU_ENCODING", "Кодировка");
    translation.put("MENU_LANGUAGE", "Язык");
    translation.put("MENU_PROXY", "Прокси");
    translation.put("MENU_MISC", "Прочее");
    translation.put("MENU_DIRECTOPEN", "Открывать пустые новости в браузере");
    translation.put("MENU_DIRECTOPENEACH", "Открывать каждую новость в браузере");
    translation.put("MENU_SYSTRAY", "Прятать программу в трэй");
    translation.put("MENU_CHANNELINFO", "Показывать информацию о канале");
    translation.put("MENU_OPENNEW_BROWSER", "Всегда открывать внутренный браузер в новой закладке");
    translation.put("MENU_BROWSER_EXTERN", "Открывать внешний браузер");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Показывать текст новости в браузере");
    translation.put("MENU_CHECK_UPDATE", "Проверять обновления при запуске");
    translation.put("MENU_INFO", "Помощь");
    translation.put("MENU_ABOUT", "О программе");
    translation.put("MENU_LICENSE", "Лицензия");
    translation.put("MENU_UPDATE", "Проверить обновление");
    translation.put("MENU_WELCOME", "Добро пожаловать");
    translation.put("MENU_DONATE", "Внести пожертвование");
    translation.put("MENU_TOOLS", "Инструменты");
    translation.put("MENU_MINIMIZE_RSSOWL", "Свернуть");
    translation.put("MENU_GOTO", "Перейти");
    translation.put("MENU_NEXT_NEWS", "Следующая новость");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Следующая новая новость");
    translation.put("MENU_CLOSE", "Закрыть");
    translation.put("MENU_CLOSE_ALL", "Закрыть все");
    translation.put("MENU_PREVIOUS_TAB", "Предыдущая закладка");
    translation.put("MENU_NEXT_TAB", "Следующая закладка");
    translation.put("MENU_HOTKEYS", "Горячие клавиши");
    translation.put("MENU_NEWSTIP_MAIL", "Форматировать почту NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Рассказать друзьям");
    translation.put("MENU_RELOAD", "Обновить");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Сгенерировать PDF-файл из выбранных новостей");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Сгенерировать HTML-файл из выбранных новостей");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Сгенерировать RTF-файл из выбранных новостей");
    translation.put("MENU_MAILING_LIST", "Почтовая рассылка");
    translation.put("MENU_TUTORIAL", "Помощь");
    translation.put("MENU_COLORS", "Цвета");
    translation.put("MENU_BLOGGER", "Блоггер");
    translation.put("MENU_WORKBENCH", "Общие");
    translation.put("MENU_FEEDSEARCH", "Поиск источников");
    translation.put("MENU_IMPORT_OPML", "Импортировать из OPML");
    translation.put("MENU_VALIDATE", "Проверить источник новостей");
    translation.put("MENU_FEED_DISCOVERY", "Найти Новостную ленту на сайте");
    translation.put("MENU_EDIT", "Редактировать");
    translation.put("MENU_EDIT_COPY", "Копировать");
    translation.put("MENU_EDIT_PASTE", "Вставить");
    translation.put("MENU_EDIT_SELECT_ALL", "Выбрать Все");
    translation.put("MENU_EDIT_DELETE", "Удалить");
    translation.put("MENU_EDIT_CUT", "Вырезать");
    translation.put("MENU_DISPLAY_FEED_PDF", "Отображать новости в виде ПДФ");
    translation.put("MENU_DISPLAY_FEED_RTF", "Отображать новости в виде RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Отображать новости в виде HTML");
    translation.put("MENU_NEW_FAVORITE", "Создать избранное");
    translation.put("MENU_CONNECTION", "Соединение");
    translation.put("MENU_EDIT_RENAME", "Переименовать");
    translation.put("MENU_WORK_OFFLINE", "Работать автономно");
    translation.put("MENU_WORK_ONLINE", "Работать в сети");

    /** ToolBar */
    translation.put("TOOL_MARK", "Пометка");
    translation.put("TOOL_NEXT", "Дальше");
    translation.put("TOOL_SEPARATOR", "Разделитель");
    translation.put("TOOL_ICONS_TEXT", "Иконки и текст");
    translation.put("TOOL_ICONS", "Только иконки");
    translation.put("TOOL_TEXT", "Только текст");
    translation.put("TOOL_RATE", "Рейтинг");
    translation.put("TOOL_HISTORY", "Журнал");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Добавить");
    translation.put("POP_SUB_CATEGORY", "Подкатегорию");
    translation.put("POP_UNSUBSCRIBE", "Отписаться");
    translation.put("POP_USEPROXY", "Использовать прокси");
    translation.put("POP_AGGREGATE_FAV", "Собрать избранное");
    translation.put("POP_AUTO_UPDATE", "Обновление");
    translation.put("POP_UPDATE_ONSTARTUP", "при старте");
    translation.put("POP_IMPORT", "Импорт");
    translation.put("POP_FROM_OPML", "Из OPML файла");
    translation.put("POP_EXPORT_OPML", "В OPML файл");
    translation.put("POP_COPY", "Копировать");
    translation.put("POP_OPEN_IN_BROWSER", "Открыть выделенное в браузере");
    translation.put("POP_MARK_UNREAD", "Пометить непрочтенным");
    translation.put("POP_COPY_NEWS_URL", "Копировать ссылку");
    translation.put("POP_RATE_NEWS", "Оценить новость");
    translation.put("POP_MAIL_LINK", "Отправить NewsTip другу");
    translation.put("POP_OPEN_EXTERN", "Открыть внешний");
    translation.put("POP_BLOG_NEWS", "Новости блога");
    translation.put("POP_OPEN_STARTUP", "Открывать при запуске");
    translation.put("POP_KEEP_CURRENT", "Закрыть все, кроме текущей");
    translation.put("POP_KEEP_NEWSFEEDS", "Закрыть всё, кроме новостей");
    translation.put("POP_MARK_ALL_READ", "Пометить все как прочтенные");
    translation.put("POP_MARK_CATEGORY_READ", "Пометить Раздел Как Прочитанный");
    translation.put("POP_PROPERTIES", "Свойства");
    translation.put("POP_TAB_POSITION", "Позиция");
    translation.put("POP_TAB_POS_TOP", "Сверху");
    translation.put("POP_TAB_POS_BOTTOM", "Снизу");
    translation.put("POP_MARK_FAVORITE_READ", "Пометить Закладку как прочитанную");
    translation.put("POP_IMPORT_BLOGROLL", "Синхронизированый Blogroll");
    translation.put("POP_SYNCHRONIZE", "Синхронизировать");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Настроить панель");
    translation.put("POP_CLEAR_HISTORY", "Очистить журнал");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Возникла неожиданная ошибка! RSSOwl закроется, но все настройки сохранены.\nСообщение об ошибке в'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nВы хотите отпраить сообщение об ошибке команде RSSOwl");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Ошибка");
    translation.put("ERROR_NO_NEWS_FOUND", "Ошибка: Невозможно найти новости!");
    translation.put("ERROR_CAT_EXISTS", "Категория с таким именем уже существует!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Закладка с таким именем уже существует!");
    translation.put("ERROR_FAV_URL_EXISTS", "Закладка с таким адресом уже существует!");
    translation.put("ERROR_CONNECTION_FAILED", "Соединение прервано!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl не может отобразить новости.");
    translation.put("ERROR_FILE_NOT_FOUND", "Не могу найти файл");
    translation.put("ERROR_AUTH_REQUIRED", "Новости защищены и требуют авторизации");
    translation.put("ERROR_REASON", "Причина");
    translation.put("ERROR_LOADING_FEED", "Ошибка во время чтения новости \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Сосояние");
    translation.put("ERROR_WORKING_OFFLINE", "Новость не может быть отображена в автономном режиме");
    translation.put("ERROR_GRABTITLE_FAILED", "Невозможно отобразить название новости!");
    translation.put("ERROR_NOT_A_XML", "Файл не является корректных документом XML");
    translation.put("ERROR_NOT_A_RSS", "XML документ не является RSS, RDF or Atom newsfeed");
    translation.put("ERROR_NOT_A_OPML", "XML документ не является файлом OPML");
    translation.put("ERROR_SUB_EXISTS", "Вы уже подписаны на этот Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Путь");
    translation.put("LABEL_CATEGORY", "Категория");
    translation.put("LABEL_NO_INFOS", "Нет дополнительной информации!");
    translation.put("LABEL_FAVORITE", "Избранное");
    translation.put("LABEL_TITLE", "Название");
    translation.put("LABEL_USE_PROXY", "Использовать прокси");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Прокси требуется авторизация");
    translation.put("LABEL_USERNAME", "Логин");
    translation.put("LABEL_PASSWORD", "Пароль");
    translation.put("LABEL_PROXY_HOST", "Хост");
    translation.put("LABEL_PROXY_PORT", "Порт");
    translation.put("LABEL_CATEGORY", "Категория");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Использовать прокси для всех закладок");
    translation.put("LABEL_NEWS_RATED", "Новость оценена");
    translation.put("LABEL_SEARCH_TOPIC", "Укажите ваш поиск");
    translation.put("LABEL_SEARCH_FINISHED", "Поиск закончен.");
    translation.put("LABEL_SEARCH_RUNNING", "Производится поиск...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Интенсивный поиск");
    translation.put("LABEL_PREFERED_LANGUAGE", "Препочтительный язык");
    translation.put("LABEL_DESCRIPTION", "Описание");
    translation.put("LABEL_CREATED", "создан");
    translation.put("LABEL_LAST_VISIT", "Последнее посещение");
    translation.put("LABEL_USED_BY", "используется");
    translation.put("LABEL_NAME", "Имя");
    translation.put("LABEL_KEY_SEQUENCE", "Последовательность");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Неверная последовательность!");
    translation.put("LABEL_SIZE", "Размер");
    translation.put("LABEL_STYLE", "Стиль");
    translation.put("LABEL_SELECT_ENCODING", "Выберите кодировку");
    translation.put("LABEL_MAIL_SUBJECT", "Тема");
    translation.put("LABEL_MAIL_BODY", "Текст");
    translation.put("LABEL_MAIL_USAGE", "Используйте [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] и [DESCRIPTION] для шаблона выводимой информации");
    translation.put("LABEL_EMPTY_LINK", "Ссылка не указана");
    translation.put("LABEL_USE_SYSTEM_FONT", "Использовать системный шрифт");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Письмо в формате HTML");
    translation.put("LABEL_CURRENT_COLOR", "Текущий цвет");
    translation.put("LABEL_OPTIONS", "Настройки");
    translation.put("LABEL_BLOGGER_USAGE", "Используйте [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] и [TITLE] для шаблона выводимой информации");
    translation.put("LABEL_SEARCH_RESULTS", "По запросу \"%TERM%\" найдено %NUM% документов");
    translation.put("LABEL_SEARCH_EMPTY", "По запросу \"%TERM%\" ничего не найдено.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Выберите один из двух стилей окна");
    translation.put("LABEL_SINGLE_CLICK", "Одинарный клик");
    translation.put("LABEL_DOUBLE_CLICK", "Двойной клик");
    translation.put("LABEL_SELECT_BLOGGER", "Выберите внешний блог");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Открывать последние открытые новости при запуске");
    translation.put("LABEL_TRADITIONAL_TABS", "Традиционные вкладки");
    translation.put("LABEL_CURVED_TABS", "Закругленные вкладки");
    translation.put("LABEL_READY", "Готово");
    translation.put("LABEL_OLD_ID", "Старый ID Пользователя(выборочно)");
    translation.put("LABEL_AMPHETARATE_ID", "ID Пользователя");
    translation.put("LABEL_FEED_TYPE", "Тип джерела новостей");
    translation.put("LABEL_VALIDATION_FINISHED", "Проверка корректности закончена");
    translation.put("LABEL_VALIDATING", "Проверка корректности");
    translation.put("LABEL_OVERRIDE_DTD", "Переопределить объявление Doctype");
    translation.put("LABEL_ADDRESS", "Электронный Адресс");
    translation.put("LABEL_BROWSER_USAGE", "Использовать [URL] как заменяемый параметр для УРЛ.");
    translation.put("LABEL_REMEMBER_AUTH", "Пам'ятати Ім'я користувача та Пароль");
    translation.put("LABEL_SORT_ORDER", "Сортировка новостей");
    translation.put("LABEL_REMEMBER_AUTH", "Помнить Имя Пользователя и Пароль");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl сначала попробует сортировать новости по первой колонке. Вслучае ее недоступности, RSSOwl продолжит со следующей.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Это еще не поддерживается в Вашей операционной системе");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Значения, которые здесь установлены, будут взяты как начальные при создании избранного.");
    translation.put("LABEL_RESTART", "Изменения требуют перезапуска  RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Добро пожаловать в RSSOwl - Просмотрщик новостей для RSS / RDF / Atom лент новостей.");
    translation.put("LABEL_FIRST_STEPS", "Первые шаги");
    translation.put("LABEL_NEWS", "Новости");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Новости RSSOwl");
    translation.put("LABEL_SUPPORT", "Поддержка");
    translation.put("LABEL_DISCUSSION_FORUM", "Обсуждение в форуме");
    translation.put("LABEL_PROMOTION", "Разкрутка");
    translation.put("LABEL_CONTACT", "Контакт");
    translation.put("LABEL_START", "Начать");
    translation.put("LABEL_MAX_CONNECTIONS", "Максимальное количество соединений");
    translation.put("LABEL_CON_TIMEOUT", "Тайм-аут в секундах");
    translation.put("LABEL_DELETE_FAVORITE", "Удалить закладку");
    translation.put("LABEL_DELETE_CATEGORY", "Удалить раздел");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Удалить Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Регистрация прошла успешно");
    translation.put("LABEL_DOWNLOAD", "Загрузить");
    translation.put("LABEL_SHOW", "Показывать");
    translation.put("LABEL_SEARCH_IN", "Искать в");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Открыть");
    translation.put("BUTTON_RELOAD_CAT", "Обновить избранное");
    translation.put("BUTTON_ADD", "Добавить");
    translation.put("BUTTON_FILE", "Обзор...");
    translation.put("BUTTON_SEARCH", "Поиск");
    translation.put("BUTTON_RELOAD", "Обновить новости");
    translation.put("BUTTON_CANCLE", "Отменить");
    translation.put("BUTTON_EXPORT", "Экспорт");
    translation.put("BUTTON_STOP_SEARCH", "Остановить поиск");
    translation.put("BUTTON_CLEAR_RESULTS", "Очистить результаты");
    translation.put("BUTTON_EXPORT_TO_OPML", "Экспорт в OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Добавить в избранное");
    translation.put("BUTTON_ASSIGN", "Назначить");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Значения по умолчанию");
    translation.put("BUTTON_APPLY", "Применить");
    translation.put("BUTTON_CHANGE_FONT", "Сменить шрифт");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Пометить все новости как прочитаные в свернутом окне");
    translation.put("BUTTON_TRAY_POPUP", "Показывать всплывающее сообщение когда доступны непрочитаные новости");
    translation.put("BUTTON_READ_ON_CLOSE", "Пометить сообщения как прочитанные при закрытии закладки");
    translation.put("BUTTON_CHANGE", "Изменить");
    translation.put("BUTTON_FOCUS_TABS", "Устанавливает фокус на новых закладках");
    translation.put("BUTTON_STOP_VALIDATION", "Остановить Проверку корректности");
    translation.put("BUTTON_VALIDATE", "Проверить корректность");
    translation.put("BUTTON_TRAY_STARTUP", "Размещать RSSOwl в системном лотке при старте");
    translation.put("BUTTON_TRAY_EXIT", "Размещать RSSOwl в системном лотке при выходе");
    translation.put("BUTTON_SHOW_ERRORS", "Отображать ошибки в боковой панели");
    translation.put("BUTTON_MARK_ALL_READ", "Пометить все Избранное как прочитаное");
    translation.put("BUTTON_AGGREGATE_ALL", "Обьединить все Избранное");
    translation.put("BUTTON_RELOAD_ALL", "Перечитать Все Избранное");
    translation.put("BUTTON_SEARCH_ALL", "Искать во всем Избранном");
    translation.put("BUTTON_DISPLAY_TABS", "Отображать новости в закладках");
    translation.put("BUTTON_CREATE_ACCOUNT", "Создать Аккаунт");
    translation.put("BUTTON_UP", "Вверх");
    translation.put("BUTTON_DOWN", "Вниз");
    translation.put("BUTTON_NO_SORT", "Не сортировать новости автоматически");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Автоматически закрывать всплывающие новости");
    translation.put("BUTTON_CACHE_FEEDS", "Автоматически сохранять новости для чтения а оффлайне");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Открыть в браузере");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Показывать кнопку закрытия на закладках");
    translation.put("BUTTON_DELETE_FAVORITE", "При удалении закладки");
    translation.put("BUTTON_DELETE_CATEGORY", "При удалении раздела");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "При удалении Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Никогда не спрашивать");
    translation.put("BUTTON_BLOCK_POPUPS", "блокировать всплывающие окна");
    translation.put("BUTTON_ANIMATE_POPUP", "Анмировать всплывающие окна");
    translation.put("BUTTON_REMOVE", "Удалить");
    translation.put("BUTTON_SMALL_ICONS", "Использовать маленькие иконки");
    translation.put("BUTTON_LINK_TAB", "Создать ссылку на отображеную ленту");
    translation.put("BUTTON_CLEAR", "Очистить");

    /** Header */
    translation.put("HEADER_NEWS", "Заголовок");
    translation.put("HEADER_RSS_FAVORITES", "Избранное");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Открыть сайт");
    translation.put("TOOLTIP_PRINT", "Распечатать новость");
    translation.put("TOOLTIP_RATE", "Оценить новость");
    translation.put("TOOLTIP_GRAB_TITLE", "Получить заголовок новости");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Доступны непрочитаные сообщения");
    translation.put("TOOLTIP_SKIP", "Пропустить");
    translation.put("TOOLTIP_OPEN_TAB", "Открыть новую закладку");
    translation.put("TOOLTIP_QUICKSEARCH", "Быстрый поиск");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Дата публикации");
    translation.put("TABLE_HEADER_AUTHOR", "Автор");
    translation.put("TABLE_HEADER_CATEGORY", "Категория");
    translation.put("TABLE_HEADER_PUBLISHER", "Опубликовал");
    translation.put("TABLE_HEADER_NEWSTITLE", "Заголовок новости");
    translation.put("TABLE_HEADER_FEED", "Источник");
    translation.put("TABLE_HEADER_FEEDURL", "URL источника");
    translation.put("TABLE_HEADER_FEEDTITLE", "Заголовок");
    translation.put("TABLE_HEADER_LINE", "Строка");
    translation.put("TABLE_HEADER_STATUS", "Чтение");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Страница");
    translation.put("CHANNEL_INFO_PUBDATE", "Дата публикации");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Последнее изменение");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Редактор");
    translation.put("CHANNEL_INFO_WEBMASTER", "Вэбмастер");
    translation.put("CHANNEL_INFO_CATEGORY", "Категория");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Время устаревания");
    translation.put("CHANNEL_INFO_RSSVERSION", "Формат");
    translation.put("CHANNEL_INFO_GENERATOR", "Генератор RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Опубликовал");
    translation.put("CHANNEL_INFO_LANGUAGE", "Язык");
    translation.put("CHANNEL_INFO_CREATOR", "Создатель");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Обновление");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "раз");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Источник");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Приложение");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Комментарии");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Внимание");
    translation.put("MESSAGEBOX_FILL_URL", "Введите URL или путь");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Категория с таким именем уже существует");
    translation.put("MESSAGEBOX_SELECT_CAT", "Выберите категорию");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Файл уже существует. Заменить его?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Файл не содержит настроек программы!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Установки импортированы успешно!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Текст новости пуст! Выберите новость.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Добавить закладку");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Добавить категорию");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Введите название");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Введите адрес и название");
    translation.put("BASE_AUTH_TITLE", "Требуется авторизация!");
    translation.put("BASE_AUTH_MESSAGE", "Введите имя пользователя и пароль.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "В указанной папке не найдены RSS файлы!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Подтвердите");
    translation.put("SEARCH_DIALOG_TITLE", "Поиск");
    translation.put("SEARCH_DIALOG_MESSAGE", "Пожалуйста используйте И, ИЛИ и НЕ для ограничения поиска");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Искать");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Только слова целиком");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Чувствительно к регистру");
    translation.put("SEARCH_DIALOG_REGEX", "Использовать регулярные выражения");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Новой версии нет");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "У вас последняя версия программы!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Информация");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Редактировать категорию");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Редактировать закладку");
    translation.put("DIALOG_TITLE_UPDATE", "Доступна новая версия RSSOwl");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Введите путь к файлу");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Невозможно соединиться с http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Вы должны сначала задать ID Пользователя AmphetaRate!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Категория не содержит закладок!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Введите последовательность");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Невозможно открыть браузер!\nУкажите браузер в настройках программы");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Сначала вы должны выбрать блог!");
    translation.put("DIALOG_ID_ATTENTION", "Сначала нужно создать AmphetaRate аккаунт!");
    translation.put("DIALOG_TITLE_CATEGORY", "Выбирайте категорию");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Введите пожалуйста адрес вебсайта");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Редактировать Blogroll");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl не может найти программу для отображення %FORMAT%");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Не могу загрузить внутренний браузер!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Добавить новый Blogroll");
    translation.put("QUESTION_DEL_FAV", "Вы уверены, что хотите удалить закладку \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Вы уверены, что хотите удалить раздел \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Вы уверены, что хотите удалить Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Назад");
    translation.put("BROWSER_FORWARD", "Вперед");
    translation.put("BROWSER_STOP", "Остановить");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Отлично");
    translation.put("RATE_GOOD", "Хорошо");
    translation.put("RATE_MODERATE", "Средне");
    translation.put("RATE_BAD", "Плохо");
    translation.put("RATE_VERY_BAD", "Ужасно");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "нет");
    translation.put("UPDATE_INTERVAL_ONE", "через 1 минуту");
    translation.put("UPDATE_INTERVAL_FIVE", "через 5 минут");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "через 15 минут");
    translation.put("UPDATE_INTERVAL_THIRTY", "через 30 минут");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "через 1 час");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "через 3 часа");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "через 6 часа");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "через 12 часов");
    translation.put("UPDATE_INTERVAL_ONEDAY", "через 24 часа");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Шрифт текста");
    translation.put("FONT_AREA_DIALOG", "Шрифт диалогов");
    translation.put("FONT_AREA_TREE", "Шрифт дерева");
    translation.put("FONT_AREA_TABLE", "Шрифт таблицы");
    translation.put("FONT_AREA_HEADER", "Шрифт шапки");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Шрифт текста используется для новостей, информации о каналах, сообщений и ошибок.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Шрифт диалогов используется во всех диалогах.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Шрифт дерева используется в дереве избранного.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Шрифт таблицы используется в таблице новостей.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Шрифт шапки используется в шапках новостей.");
    translation.put("FONT_STYLE_BOLD", "Жирный");
    translation.put("FONT_STYLE_ITALIC", "Курсив");
    translation.put("FONT_STYLE_NORMAL", "Нормальный");

    /** Groups */
    translation.put("GROUP_COMMAND", "Комманды");
    translation.put("GROUP_SELECTED_FONT", "Выберите шрифт");
    translation.put("GROUP_WINDOW_LAYOUT", "Стили окна");
    translation.put("GROUP_OPEN_MODE", "Режим открытия");
    translation.put("GROUP_ARGUMENTS", "Аргументы");
    translation.put("GROUP_LINK_COLOR", "Цвет ссылок");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Цвет результатов поиска");
    translation.put("GROUP_FONT_AREA", "Просмотр шрифта");
    translation.put("GROUP_TAB_LAYOUT", "Вид вкладок");
    translation.put("GROUP_TRAY", "Системный лоток");
    translation.put("GROUP_EXISTING_ACCOUNT", "Существующий Аккаунт");
    translation.put("GROUP_NEW_ACCOUNT", "Создать Новый Аккаунт");
    translation.put("GROUP_GENERAL", "Общий");
    translation.put("GROUP_NEWS_POPUP", "Всплывающие новости");
    translation.put("GROUP_CONFIRM_DIALOG", "Требовать подтверждения");

    /** Languages */
    translation.put("en", "Английский");
    translation.put("de", "Немецкий");
    translation.put("fr", "Французский");
    translation.put("es", "Испанский");
    translation.put("gl", "Галисийский");
    translation.put("da", "Датский");
    translation.put("it", "Итальянский");
    translation.put("nl", "Голландский");
    translation.put("el", "Греческий");
    translation.put("ru", "Русский");
    translation.put("pt", "Португальский (Бразилия)");
    translation.put("bg", "Болгарский");
    translation.put("no", "Норвежский");
    translation.put("zhcn", "Китайский");
    translation.put("zhtw", "Традиционный Китайский");
    translation.put("ja", "Японский");
    translation.put("ko", "Корейский");
    translation.put("pl", "Польский");
    translation.put("sv", "Шведский");
    translation.put("bn", "Бангладешский(Бенгали)");
    translation.put("fi", "Финский");
    translation.put("uk", "Українська");
    translation.put("cs", "Чешский");
    translation.put("sl", "Словенский");
    translation.put("tr", "Турецкий");
    translation.put("hu", "Венгерский");
    translation.put("th", "Тайська");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Нет описания!");
    translation.put("PRINTED_FROM_RSSOWL", "Напечатано из RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Печать новости из RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Показать RSSOwl");
    translation.put("TAB_WELCOME", "Добро пожаловать");
    translation.put("DOCUMENT_GENERATED_FROM", "Документ создан из RSSOwl");
    translation.put("NO_TITLE", "Заголовка нет");
    translation.put("RSSOWL_TEASER", "RSSOwl - бесплатная программа для чтения RSS и RDF новостей с открытыми исходниками. Возможности программы:\n\n- Экспорт новостей в PDF, HTML, RTF, OPML\n- Импорт избранного из OPML\n- Полнотекстовый поиск с подсветкой синтаксиса результатов\n- Мощнейший поиск в RSS и RDF\n- Просмотр во внутреннем браузере\n- Списки избранных новостей и категории\n- Работает в среде Windows, Solaris, Linux и Mac\n\nПолный список возможностей ищите на сайте: http://www.rssowl.org/overview\n\nСкачать программу можно здесь: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Рекомендовать статьи");
    translation.put("LOAD_FEED", "Загрузка");
    translation.put("SEARCH_FEED", "Поиск");
    translation.put("RELOAD_FEED", "Перезагрузка");
    translation.put("FORMAT_AUTO_DETECT", "Определить автоматически");
    translation.put("MAIL_ERROR_BODY", "Пожалуйста присоедините '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' к этому письму и дайте короткое объяснение почему только что возникла ошибка в RSSOwl.Спасибо!");
    translation.put("NEWSFEED_VALID", "NewsFeed корректный");
    translation.put("OPML_IMPORTED", "Импортированые");
    translation.put("ENTIRE_NEWS", "Все Новости");
    translation.put("SEARCH_AND", "И");
    translation.put("SEARCH_OR", "ИЛИ");
    translation.put("SEARCH_NOT", "НЕ");
  }
}