/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Serbian (Latin) internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Slovenian - by Jure Zemljič and Rok Brnot<br />
 * o Serbian - by Aleksandar Urošević<br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.1.3
 */
public class RSSOwlI18nSH extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nSH(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Datoteka");
    translation.put("MENU_SAVE", "Sačuvaj kao");
    translation.put("MENU_QUICKVIEW", "Brzi pregled");
    translation.put("MENU_TOOLBAR", "Linija alata");
    translation.put("MENU_GENERATE_PDF", "Napravi PDF");
    translation.put("MENU_GENERATE_HTML", "Napravi HTML");
    translation.put("MENU_GENERATE_RTF", "Napravi RTF");
    translation.put("MENU_IMPORT", "Uvoz podešavanja");
    translation.put("MENU_EXPORT", "Izvoz podešavanja");
    translation.put("MENU_EXIT", "Izlaz");
    translation.put("MENU_WINDOW", "Pregled");
    translation.put("MENU_PREFERENCES", "Podešavanja");
    translation.put("MENU_BROWSER", "Preglednik");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Izaberite spoljni preglednik");
    translation.put("MENU_FONT", "Font");
    translation.put("MENU_ENCODING", "Kodiranje teksta");
    translation.put("MENU_LANGUAGE", "Jezik");
    translation.put("MENU_PROXY", "Proksi");
    translation.put("MENU_MISC", "Razno");
    translation.put("MENU_DIRECTOPEN", "Automatski otvori nove naslove u pregledniku");
    translation.put("MENU_DIRECTOPENEACH", "Automatski otvori izabrane naslove u pregledniku");
    translation.put("MENU_SYSTRAY", "Premesti RSSOwl u sistemsku kasetu kada je umanjen");
    translation.put("MENU_CHANNELINFO", "Prikaži podatke o prikupljenim naslovima");
    translation.put("MENU_OPENNEW_BROWSER", "Uvek otvori unutrašnji preglednik na novom listu");
    translation.put("MENU_BROWSER_EXTERN", "Koristi spoljni preglednik");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Prikaži tekst naslova u pregledniku");
    translation.put("MENU_CHECK_UPDATE", "Provera postojanja nove verzije po pokretanju programa");
    translation.put("MENU_INFO", "Pomoć");
    translation.put("MENU_ABOUT", "O programu RSSOwl");
    translation.put("MENU_LICENSE", "Licenca");
    translation.put("MENU_UPDATE", "Provera postojanja nove verzije");
    translation.put("MENU_WELCOME", "Uvodna strana");
    translation.put("MENU_DONATE", "Budite donator");
    translation.put("MENU_TOOLS", "Alati");
    translation.put("MENU_FEEDSEARCH", "Pretraga naslova");
    translation.put("MENU_MINIMIZE_RSSOWL", "Umanji RSSOwl");
    translation.put("MENU_GOTO", "Izbor");
    translation.put("MENU_NEXT_NEWS", "Sledeća vest");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Sledeća nepročitana vest");
    translation.put("MENU_CLOSE", "Zatvori");
    translation.put("MENU_CLOSE_ALL", "Zatvori sve");
    translation.put("MENU_PREVIOUS_TAB", "Prethodni list");
    translation.put("MENU_NEXT_TAB", "Sledeći list");
    translation.put("MENU_HOTKEYS", "Prečica");
    translation.put("MENU_NEWSTIP_MAIL", "Pravljenje NewsTip pisma");
    translation.put("MENU_TELL_FRIENDS", "Podeli sa prijateljima...");
    translation.put("MENU_RELOAD", "Ponovo učitaj");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Napravi PDF od izabranog naslova");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Napravi HTML od izabranog naslova");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Napravi RTF od izabranog naslova");
    translation.put("MENU_MAILING_LIST", "Dopisno društvo");
    translation.put("MENU_TUTORIAL", "Uputstvo");
    translation.put("MENU_COLORS", "Boje");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Opšte");
    translation.put("MENU_IMPORT_OPML", "Uvoz iz OPML");
    translation.put("MENU_VALIDATE", "Validacija");
    translation.put("MENU_FEED_DISCOVERY", "Pregled naslova na prezentaciji");
    translation.put("MENU_DISPLAY_FEED_PDF", "Pregled naslova iz PDF dokumenta");
    translation.put("MENU_DISPLAY_FEED_RTF", "Pregled naslova iz RTF dokumenta");
    translation.put("MENU_DISPLAY_FEED_HTML", "Pregled naslova iz HTML dokumenta");
    translation.put("MENU_NEW_FAVORITE", "Novi zanimljivi izvor");
    translation.put("MENU_EDIT", "Uređivanje");
    translation.put("MENU_EDIT_COPY", "Umnoži");
    translation.put("MENU_EDIT_PASTE", "Prenesi");
    translation.put("MENU_EDIT_SELECT_ALL", "Izaberi sve");
    translation.put("MENU_EDIT_DELETE", "Ukloni");
    translation.put("MENU_EDIT_CUT", "Iseci");
    translation.put("MENU_CONNECTION", "Veza");
    translation.put("MENU_EDIT_RENAME", "Preimenuj");
    translation.put("MENU_WORK_OFFLINE", "Režim van veze");
    translation.put("MENU_WORK_ONLINE", "Režim na vezi");

    /** ToolBar */
    translation.put("TOOL_MARK", "Obeleži");
    translation.put("TOOL_NEXT", "Sledeće");
    translation.put("TOOL_SEPARATOR", "Razdvojnik");
    translation.put("TOOL_ICONS_TEXT", "Ikone i tekst");
    translation.put("TOOL_ICONS", "Ikone");
    translation.put("TOOL_TEXT", "Tekst");
    translation.put("TOOL_RATE", "Ocena");
    translation.put("TOOL_HISTORY", "Istorija");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Novo");
    translation.put("POP_SUB_CATEGORY", "Podkategorija");
    translation.put("POP_UNSUBSCRIBE", "Odjava");
    translation.put("POP_USEPROXY", "Koristi proksi");
    translation.put("POP_AGGREGATE_FAV", "Prikupi zanimljive naslove");
    translation.put("POP_AUTO_UPDATE", "Automatsko osvežavanje");
    translation.put("POP_UPDATE_ONSTARTUP", "pri pokretanju");
    translation.put("POP_IMPORT", "Uvoz");
    translation.put("POP_FROM_OPML", "Iz OPML datoteke");
    translation.put("POP_EXPORT_OPML", "U OPML daoteteku");
    translation.put("POP_COPY", "Umnoži");
    translation.put("POP_OPEN_IN_BROWSER", "Otvori izbor u pregledniku");
    translation.put("POP_MARK_UNREAD", "Označi kao nepročitano");
    translation.put("POP_COPY_NEWS_URL", "Umnoži adresu naslova");
    translation.put("POP_RATE_NEWS", "Ocenjivanje naslova");
    translation.put("POP_MAIL_LINK", "Pošalji NewsTip prijatelju");
    translation.put("POP_OPEN_EXTERN", "Otvori u spoljnom pregledniku");
    translation.put("POP_BLOG_NEWS", "Bloguj naslov");
    translation.put("POP_OPEN_STARTUP", "Otvori pri pokretanju");
    translation.put("POP_KEEP_CURRENT", "Zatvori ostale");
    translation.put("POP_KEEP_NEWSFEEDS", "Zatvori sve osim naslova");
    translation.put("POP_MARK_ALL_READ", "Označi sve kao pročitano");
    translation.put("POP_MARK_CATEGORY_READ", "Označi kategoriju pročitanom");
    translation.put("POP_TAB_POSITION", "pozicija");
    translation.put("POP_TAB_POS_TOP", "Gore");
    translation.put("POP_TAB_POS_BOTTOM", "Dole");
    translation.put("POP_PROPERTIES", "Postavke");
    translation.put("POP_MARK_FAVORITE_READ", "Označi izvor pročitanim");
    translation.put("POP_IMPORT_BLOGROLL", "Sinhronizovani Blogroll");
    translation.put("POP_SYNCHRONIZE", "Sinhronizuj");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Prilagodi liniju alata");
    translation.put("POP_CLEAR_HISTORY", "Očisti istoriju");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Dogodila se neočekivana greška! RSSOwl će biti zatvoren ali su postavke sačuvane.\nZabeležena je greška u '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nŽelite li da pošaljete prijavu greške RSSOwl timu?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Greška");
    translation.put("ERROR_NO_NEWS_FOUND", "Greška: Ne mogu da pronađem nijedan naslov!");
    translation.put("ERROR_CAT_EXISTS", "Kategorija sa tim nazivom već postoji!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Zanimljivi izvor sa tim nazivom već postoji!");
    translation.put("ERROR_FAV_URL_EXISTS", "Zanimljivi izvor sa te URL adrese već postoji!");
    translation.put("ERROR_CONNECTION_FAILED", "Neuspelo povezivanje!");
    translation.put("ERROR_GRABTITLE_FAILED", "Ne mogu da dobavim naslov!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl nije u mogućnosti da prikaže naslove.");
    translation.put("ERROR_FILE_NOT_FOUND", "Ne mogu da pronađem datoteku");
    translation.put("ERROR_AUTH_REQUIRED", "Naslovi su zaštićeni. Neophodna je identifikacija.");
    translation.put("ERROR_REASON", "Razlog");
    translation.put("ERROR_LOADING_FEED", "Greška pri učitavanju naslova „%TITLE%”");
    translation.put("ERROR_HTTP_STATUS", "Status");
    translation.put("ERROR_WORKING_OFFLINE", "Naslovi se ne mogu prikazati u režimu van veze");
    translation.put("ERROR_NOT_A_XML", "Datoteka nije ispravan XML dokument");
    translation.put("ERROR_NOT_A_RSS", "XML dokument nije ispravan RSS, RDF ili Atom naslov");
    translation.put("ERROR_NOT_A_OPML", "XML dokument nije OPML datoteka");
    translation.put("ERROR_SUB_EXISTS", "Već ste prijavljeni na taj Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Putanja");
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_NO_INFOS", "Nema dodatnih informacija!");
    translation.put("LABEL_FAVORITE", "Zanimljivo");
    translation.put("LABEL_TITLE", "Naslov");
    translation.put("LABEL_USE_PROXY", "Koristi proksi");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Proksi zahteva identifikaciju");
    translation.put("LABEL_USERNAME", "Korisničko ime");
    translation.put("LABEL_PASSWORD", "Lozinka");
    translation.put("LABEL_PROXY_HOST", "Proksi host");
    translation.put("LABEL_PROXY_PORT", "Proksi port");
    translation.put("LABEL_CATEGORY", "Kategorija");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Koristi proksi za sve zanimljive izvore");
    translation.put("LABEL_NEWS_RATED", "Naslov je ocenjen");
    translation.put("LABEL_SEARCH_TOPIC", "Odredite pretragu");
    translation.put("LABEL_SEARCH_FINISHED", "Pretraga završena.");
    translation.put("LABEL_SEARCH_RUNNING", "Pretraga u toku...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Intenzivna pretraga");
    translation.put("LABEL_PREFERED_LANGUAGE", "Primarni jezik");
    translation.put("LABEL_DESCRIPTION", "Opis");
    translation.put("LABEL_CREATED", "Napravljeno");
    translation.put("LABEL_LAST_VISIT", "Dobavljeno");
    translation.put("LABEL_USED_BY", "Koristi se za");
    translation.put("LABEL_NAME", "Naziv");
    translation.put("LABEL_KEY_SEQUENCE", "Kombinacija tastera");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Kombinacija tastera nije ispravna!");
    translation.put("LABEL_SIZE", "Veličina");
    translation.put("LABEL_STYLE", "Stil");
    translation.put("LABEL_SELECT_ENCODING", "Izaberite kodiranje");
    translation.put("LABEL_MAIL_SUBJECT", "Tema");
    translation.put("LABEL_MAIL_BODY", "Sadržaj poruke");
    translation.put("LABEL_MAIL_USAGE", "Koristite [TITLE], [LINK] i [DESCRIPTION] kao zamenjive parametre za informacije o naslovu");
    translation.put("LABEL_EMPTY_LINK", "Veza nije određena");
    translation.put("LABEL_USE_SYSTEM_FONT", "Koristi sistemski font");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Pismo u HTML formatu");
    translation.put("LABEL_CURRENT_COLOR", "Trenutna boja");
    translation.put("LABEL_OPTIONS", "Opcije");
    translation.put("LABEL_SEARCH_RESULTS", "Pretraga za „%TERM%” dala je %NUM% rezultata");
    translation.put("LABEL_SEARCH_EMPTY", "Pretraga za „%TERM%” nije dala rezultat.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Izaberite jedan od dva rasporeda prozora");
    translation.put("LABEL_SINGLE_CLICK", "Jedan klik");
    translation.put("LABEL_DOUBLE_CLICK", "Dvoklik");
    translation.put("LABEL_SELECT_BLOGGER", "Izaberite spoljni blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Koristite [NEWSLINK], [FEEDLINK] i [TITLE] kao zamenjive parametre za informacije o naslovu.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Otvori poslednje prikazani naslov po pokretanju");
    translation.put("LABEL_TRADITIONAL_TABS", "Klasični jezičci");
    translation.put("LABEL_CURVED_TABS", "Zaobljeni jezičci");
    translation.put("LABEL_READY", "Spreman");
    translation.put("LABEL_VALIDATION_FINISHED", "Validacija je gotova");
    translation.put("LABEL_VALIDATING", "Validacija u toku");
    translation.put("LABEL_FEED_TYPE", "Vrsta naslova");
    translation.put("LABEL_OVERRIDE_DTD", "Zanemari Doctype definicije");
    translation.put("LABEL_ADDRESS", "Adresa");
    translation.put("LABEL_BROWSER_USAGE", "Koristite [URL] kao zamenjivi parametar za URL.");
    translation.put("LABEL_OLD_ID", "Stari korisnički ID (opciono)");
    translation.put("LABEL_AMPHETARATE_ID", "Korisnički ID");
    translation.put("LABEL_SORT_EXPLANATION", "Prioritet poretka po kome će naslovi automatski biti poređani. RSSOwl prvo pokušava da poređa naslove po sadržajnosti određenih karakteristika. U slučaju da stavka nije sadržana u fiku, RSSOwl nastavlja sa sledećom stavkom iz popisa.");
    translation.put("LABEL_SORT_ORDER", "Poredak naslova");
    translation.put("LABEL_REMEMBER_AUTH", "Upamti korisničko ime i lozinku");
    translation.put("LABEL_NOT_UNSUPPORTED", "Još nije podržano Vašim operativnim sistemom");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Vrednosti koje se ovde mogu podešavati biće uzete kao početne vrednosti za svaki novi zanimljivi izvor.");
    translation.put("LABEL_RESTART", "Promene zahtevaju pokretanje programa iznova");
    translation.put("LABEL_WELCOME_TITLE", "Dobro došli u RSSOwl - Čitač RSS / RDF / Atom naslova");
    translation.put("LABEL_FIRST_STEPS", "Prvi korak");
    translation.put("LABEL_NEWS", "Vesti");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl vesti");
    translation.put("LABEL_SUPPORT", "Podrška");
    translation.put("LABEL_DISCUSSION_FORUM", "Diskusioni forum");
    translation.put("LABEL_PROMOTION", "Promocija");
    translation.put("LABEL_CONTACT", "Kontakt");
    translation.put("LABEL_START", "Početak");
    translation.put("LABEL_DOWNLOAD", "Preuzimanje");
    translation.put("LABEL_MAX_CONNECTIONS", "Maksimalan broj veza");
    translation.put("LABEL_CON_TIMEOUT", "Vreme čekanja veze u sekundama");
    translation.put("LABEL_DELETE_FAVORITE", "Ukloni zanimljivi izvor");
    translation.put("LABEL_DELETE_CATEGORY", "Ukloni kategoriju");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Ukloni Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Registracija je izvršena");
    translation.put("LABEL_SHOW", "Prikaži");
    translation.put("LABEL_SEARCH_IN", "Pretraži u");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Otvori");
    translation.put("BUTTON_RELOAD_CAT", "Ponovo učitaj zanimljive izvore");
    translation.put("BUTTON_ADD", "Dodaj");
    translation.put("BUTTON_FILE", "Otvori datoteku");
    translation.put("BUTTON_SEARCH", "Pretraga");
    translation.put("BUTTON_RELOAD", "Ponovo učitaj naslov");
    translation.put("BUTTON_CANCLE", "Otkaži");
    translation.put("BUTTON_EXPORT", "Izvoz");
    translation.put("BUTTON_STOP_SEARCH", "Zaustavi pretragu");
    translation.put("BUTTON_CLEAR_RESULTS", "Obriši rezultate");
    translation.put("BUTTON_EXPORT_TO_OPML", "Izvoz u OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Dodaj u zanimljive izvore");
    translation.put("BUTTON_ASSIGN", "Potpiši");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Vrati podrazumevano");
    translation.put("BUTTON_APPLY", "Primeni");
    translation.put("BUTTON_CHANGE_FONT", "Promena fonta");
    translation.put("BUTTON_OK", "U redu");
    translation.put("BUTTON_VALIDATE", "Proveri ispravnost");
    translation.put("BUTTON_STOP_VALIDATION", "Zaustavi proveru ispravnosti");
    translation.put("BUTTON_FOCUS_TABS", "Postavi fokus na novi list");
    translation.put("BUTTON_DISPLAY_TABS", "Prikaži naslov na listu");
    translation.put("BUTTON_TRAY_STARTUP", "Postavi RSSOwl u sistemsku kasetu pri pokretanju");
    translation.put("BUTTON_TRAY_EXIT", "Postavi RSSOwl u sistemsku kasetu pri izlasku");
    translation.put("BUTTON_SHOW_ERRORS", "Prikaži grešku na jesičku");
    translation.put("BUTTON_CHANGE", "Promeni");
    translation.put("BUTTON_MARK_ALL_READ", "Obeleži sve kategorije pročitanim");
    translation.put("BUTTON_AGGREGATE_ALL", "Prikupi sve kategorije");
    translation.put("BUTTON_RELOAD_ALL", "Ponovo učitaj sve kategorije");
    translation.put("BUTTON_SEARCH_ALL", "Pretraži u svim kategorijama");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Obeleži sve naslove pročitanim pri umanjivanju");
    translation.put("BUTTON_TRAY_POPUP", "Prikaži oblačić kada ima nepročitanih naslova");
    translation.put("BUTTON_READ_ON_CLOSE", "Obeleži naslov pročitanim pri zatvaranju lista");
    translation.put("BUTTON_UP", "Gore");
    translation.put("BUTTON_DOWN", "Dole");
    translation.put("BUTTON_NO_SORT", "Ne sortiraj naslove automatski");
    translation.put("BUTTON_CREATE_ACCOUNT", "Napravi nalog");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Automatski zatvori oblačiće");
    translation.put("BUTTON_CACHE_FEEDS", "Automatski sačuvaj prikupljene naslove za čitanje u režimu van veze");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Otvori u pregledniku");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Prikaži dugme za zatvaranje na jezičcima");
    translation.put("BUTTON_DELETE_FAVORITE", "Kada se uklanja zanimljivi izvor");
    translation.put("BUTTON_DELETE_CATEGORY", "Kada se uklanja kategorija");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Kada se uklanja Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Nemoj više da pitaš");
    translation.put("BUTTON_BLOCK_POPUPS", "Blokiraj iskačuće prozore");
    translation.put("BUTTON_ANIMATE_POPUP", "Animirani oblačić");
    translation.put("BUTTON_REMOVE", "Ukloni");
    translation.put("BUTTON_SMALL_ICONS", "Koristi male ikone");
    translation.put("BUTTON_LINK_TAB", "Poveži sa prikazanim naslovom");
    translation.put("BUTTON_CLEAR", "Očisti");

    /** Header */
    translation.put("HEADER_NEWS", "Zaglavlje");
    translation.put("HEADER_RSS_FAVORITES", "Zanimljivo");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Kliknite za otvaranje prezentacije!");
    translation.put("TOOLTIP_PRINT", "Štampanje naslova");
    translation.put("TOOLTIP_RATE", "Kliknite za ocenjivanje naslova");
    translation.put("TOOLTIP_GRAB_TITLE", "Koristi naslov iz vesti");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Ima nepročitanih naslova");
    translation.put("TOOLTIP_SKIP", "Preskoči");
    translation.put("TOOLTIP_OPEN_TAB", "Otvori novi list");
    translation.put("TOOLTIP_QUICKSEARCH", "Brza pretraga");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Datum objave");
    translation.put("TABLE_HEADER_AUTHOR", "Autor");
    translation.put("TABLE_HEADER_CATEGORY", "Kategorija");
    translation.put("TABLE_HEADER_PUBLISHER", "Izdavač");
    translation.put("TABLE_HEADER_NEWSTITLE", "Naziv vesti");
    translation.put("TABLE_HEADER_FEED", "Sadržaj");
    translation.put("TABLE_HEADER_FEEDURL", "URL naslova");
    translation.put("TABLE_HEADER_FEEDTITLE", "Naziv naslova");
    translation.put("TABLE_HEADER_LINE", "Linija");
    translation.put("TABLE_HEADER_STATUS", "Status");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Domaća strana");
    translation.put("CHANNEL_INFO_PUBDATE", "Datum objave");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Poslednja izmena kanala");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Uređivač");
    translation.put("CHANNEL_INFO_WEBMASTER", "Vebgazda");
    translation.put("CHANNEL_INFO_CATEGORY", "Kategorija");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Vreme aktivnosti kanala");
    translation.put("CHANNEL_INFO_RSSVERSION", "Verzija");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS generator");
    translation.put("CHANNEL_INFO_PUBLISHER", "Izdavač");
    translation.put("CHANNEL_INFO_LANGUAGE", "Jezik");
    translation.put("CHANNEL_INFO_CREATOR", "Autor");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Ažurirano");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "puta");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Izvor");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Enclosure");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Komentari");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Pažnja");
    translation.put("MESSAGEBOX_FILL_URL", "Unesite URL ili putanju");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Kategorija sa tim nazivom već postoji");
    translation.put("MESSAGEBOX_SELECT_CAT", "Izabor kategorije");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Datoteka postoji. Da pišem preko nje?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Datoteka ne sadrži RSSOwl podešavanja!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Uvoz podešavanja je uspešno obavljen!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Tekst naslova je prazan! Izaberite naslov.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Dodaj novi zanimljivi izvor");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Dodaj novu kategoriju");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Unesite naziv");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Unesite URL / putanju i naziv");
    translation.put("BASE_AUTH_TITLE", "Za zahtevanu prezentaciju je potrebna identifikacija!");
    translation.put("BASE_AUTH_MESSAGE", "Unesite korisničko ime i lozinku.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Nij eizabran ispravan RSS u zanimljivim izvorima!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Potvrdite");
    translation.put("SEARCH_DIALOG_TITLE", "Pretraga");
    translation.put("SEARCH_DIALOG_MESSAGE", "Koristite AND, OR i NOT za definisanje pretrage!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Traži frazu");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Samo reč");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Veličina slova je bitna");
    translation.put("SEARCH_DIALOG_REGEX", "Koristi regularne izraze");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Nema nove verzije");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Već koristite najnoviju verziju programa RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Informacije");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Uređivanje kategorije");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Uređivanje zanimljivog izvora");
    translation.put("DIALOG_TITLE_UPDATE", "Dostupna je nova verzija RSSOwl programa");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Unesite putanju do izvršne datoteke");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Nije moguće povezivanje na http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Prvo morate da postavite vaš AmphetaRate User ID!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Kategorija ne sadrži omiljene izvore!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Unesite kombinaciju tastera");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Neuspešno pokretanje preglednika!\nIzaberite preglednik u „Podešavanjima“");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Prvo morate da izaberete blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Izaberite kategoriju");
    translation.put("DIALOG_ID_ATTENTION", "Prvo morate da napravite AmphetaRate nalog!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Unesite URL do prezentacije");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl ne može da pronađe aplikaciju da prikaže %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Uređivanje Blogroll-a");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Greška pri učitavanju ugrađenog preglednike!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Dodaj novi Blogroll");
    translation.put("QUESTION_DEL_FAV", "Da li ste sigurni da želite da uklonite zanimljivi izvor „%NAME%“?");
    translation.put("QUESTION_DEL_CAT", "Da li ste sigurni da želite da uklonite kategoriju „%NAME%“?");
    translation.put("QUESTION_DEL_SUB", "Da li ste sigurni da želite da uklonite Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Nazad");
    translation.put("BROWSER_FORWARD", "Napred");
    translation.put("BROWSER_STOP", "Zaustavi");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Odlično");
    translation.put("RATE_GOOD", "Dobro");
    translation.put("RATE_MODERATE", "Zadovoljavajuće");
    translation.put("RATE_BAD", "Loše");
    translation.put("RATE_VERY_BAD", "Veoma loše");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "nikada");
    translation.put("UPDATE_INTERVAL_ONE", "na 1 minut");
    translation.put("UPDATE_INTERVAL_FIVE", "nan 5 minuta");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "na 15 minuta");
    translation.put("UPDATE_INTERVAL_THIRTY", "svakih 30 minuta");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "na 1 sat");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "na 3 sata");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "svakih 6 sati");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "na 12 sati");
    translation.put("UPDATE_INTERVAL_ONEDAY", "na 24 sata");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Strelica na gore");
    translation.put("LABEL_KEY_ARROW_DOWN", "Strelica na dole");
    translation.put("LABEL_KEY_ARROW_LEFT", "Strelica u levo");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Strelica u desno");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Razmak");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numerička tastatura");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Font teksta");
    translation.put("FONT_AREA_DIALOG", "Font dijaloga");
    translation.put("FONT_AREA_TREE", "Font stabla");
    translation.put("FONT_AREA_TABLE", "Font tabele");
    translation.put("FONT_AREA_HEADER", "Font zaglavlja");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Font teksta se koristi za tekst naslova, informacije kanala, poruke i greške.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Font dijaloga se koristi u svim dijalozima.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Font stabla se koristi za stablo zanimljivih izvora.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Font tabele se koristi za tabele sa informacijama o vestima.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Font zaglavlja se koristi za deo zaglavlja naslova.");
    translation.put("FONT_STYLE_BOLD", "Podebljano");
    translation.put("FONT_STYLE_ITALIC", "Kurziv");
    translation.put("FONT_STYLE_NORMAL", "Obično");

    /** Groups */
    translation.put("GROUP_COMMAND", "Naredba");
    translation.put("GROUP_SELECTED_FONT", "Izabrani font");
    translation.put("GROUP_FONT_AREA", "Površina fonta");
    translation.put("GROUP_WINDOW_LAYOUT", "Raspored prozora");
    translation.put("GROUP_OPEN_MODE", "Režim otvaranja");
    translation.put("GROUP_ARGUMENTS", "Argumenti");
    translation.put("GROUP_LINK_COLOR", "Boja veze");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Boja rezultata pretrage");
    translation.put("GROUP_TAB_LAYOUT", "Raspored jezičaka");
    translation.put("GROUP_TRAY", "Sistemska kaseta");
    translation.put("GROUP_GENERAL", "Opšte");
    translation.put("GROUP_EXISTING_ACCOUNT", "Postojeći nalog");
    translation.put("GROUP_NEW_ACCOUNT", "Registracija novog naloga");
    translation.put("GROUP_NEWS_POPUP", "Oblačić vesti");
    translation.put("GROUP_CONFIRM_DIALOG", "Prikaži dijalog za potvrdu");

    /** Languages */
    translation.put("de", "Nemački");
    translation.put("da", "Danski");
    translation.put("el", "Grčki");
    translation.put("en", "Engleski");
    translation.put("es", "Španski");
    translation.put("fr", "Francuski");
    translation.put("gl", "Galićanski");
    translation.put("it", "Italijanski");
    translation.put("nl", "Hilandski");
    translation.put("pt", "Portugalski (Brazil)");
    translation.put("ru", "Ruski");
    translation.put("bg", "Bugarski");
    translation.put("zhcn", "Pojednostavljeni Kineski");
    translation.put("zhtw", "Tradicionalni Kineski");
    translation.put("ja", "Japanski");
    translation.put("ko", "Korejski");
    translation.put("pl", "Poljski");
    translation.put("no", "Norveški");
    translation.put("sv", "Švedski");
    translation.put("bn", "Bengalski");
    translation.put("fi", "Finski");
    translation.put("uk", "Ukrainski");
    translation.put("tr", "Turski");
    translation.put("hu", "Mađarski");
    translation.put("sl", "Slovenački");
    translation.put("sr", "Srpski (ćirilica)");
    translation.put("sh", "Srpski (latinica)");
    translation.put("cs", "Češki");
    translation.put("th", "Tai");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Nema opisa!");
    translation.put("LOAD_FEED", "Učitavanje u toku");
    translation.put("SEARCH_FEED", "Pretraga u toku");
    translation.put("RELOAD_FEED", "Osvežavanje u toku");
    translation.put("PRINTED_FROM_RSSOWL", "Štampano iz RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Štampanje vesti iz RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Prikaži RSSOwl");
    translation.put("TAB_WELCOME", "Dobro došli");
    translation.put("DOCUMENT_GENERATED_FROM", "Dokument je napravljen programom RSSOwl");
    translation.put("NO_TITLE", "Bez naslova");
    translation.put("RECOMMENDED_ARTICLES", "Preporučeni naslovi");
    translation.put("RSSOWL_TEASER", "RSSOwl je slobodan, RSS i RDF čitač naslova otvorenog kôda. Posebne mogućnosti su:\n\n- Izvoz vesti u PDF, HTML, RTF, OPML\n- Uvoz omiljenih lokacija iz OPML\n- Pretraga teksta sa naglašavanjem rezultata\n- Moćan RSS i RDF pretraživač\n- Pregled vesti u ugrađenom pregledniku\n- Organizacija omiljenih lokacija po kategorijama\n- Radi na operativnim sistemima Windows, Linux, Solaris i Mac\n\nZa kompletan popis mogućnosti pogledajte: http://www.rssowl.org/features.html\n\nPreuzimanje sa: http://sourceforge.net/project/showfiles.php?group_id=86683");
    translation.put("MAIL_ERROR_BODY", "Molim vas da priložite datoteku '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' uz pismo i ukratko opišete šta ste radili u programu RSSOwl pre nego što je nastala greška. Hvala!");
    translation.put("FORMAT_AUTO_DETECT", "Automatski prepoznaj");
    translation.put("NEWSFEED_VALID", "Naslov je validan");
    translation.put("OPML_IMPORTED", "Uveženo");
    translation.put("ENTIRE_NEWS", "Trenutni naslov");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}