/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Serbian (Cyrillic) internationalization for RSSOwl (i18n) <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Slovenian - by Jure Zemljič and Rok Brnot<br />
 * o Serbian - by Aleksandar Urošević<br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nSR extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nSR(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Датотека");
    translation.put("MENU_SAVE", "Сачувај као");
    translation.put("MENU_QUICKVIEW", "Брзи преглед");
    translation.put("MENU_TOOLBAR", "Линија алата");
    translation.put("MENU_GENERATE_PDF", "Направи PDF");
    translation.put("MENU_GENERATE_HTML", "Направи HTML");
    translation.put("MENU_GENERATE_RTF", "Направи RTF");
    translation.put("MENU_IMPORT", "Увоз подешавања");
    translation.put("MENU_EXPORT", "Извоз подешавања");
    translation.put("MENU_EXIT", "Излаз");
    translation.put("MENU_WINDOW", "Преглед");
    translation.put("MENU_PREFERENCES", "Подешавања");
    translation.put("MENU_BROWSER", "Прегледник");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Изаберите спољни прегледник");
    translation.put("MENU_FONT", "Фонт");
    translation.put("MENU_ENCODING", "Кодирање текста");
    translation.put("MENU_LANGUAGE", "Језик");
    translation.put("MENU_PROXY", "Прокси");
    translation.put("MENU_MISC", "Разно");
    translation.put("MENU_DIRECTOPEN", "Аутоматски отвори нове наслове у прегледнику");
    translation.put("MENU_DIRECTOPENEACH", "Аутоматски отвори изабране наслове у прегледнику");
    translation.put("MENU_SYSTRAY", "Премести RSSOwl у системску касету када је умањен");
    translation.put("MENU_CHANNELINFO", "Прикажи податке о прикупљеним насловима");
    translation.put("MENU_OPENNEW_BROWSER", "Увек отвори унутрашњи прегледник на новом листу");
    translation.put("MENU_BROWSER_EXTERN", "Користи спољни прегледник");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Прикажи текст наслова у прегледнику");
    translation.put("MENU_CHECK_UPDATE", "Провера постојања нове верзије по покретању програма");
    translation.put("MENU_INFO", "Помоћ");
    translation.put("MENU_ABOUT", "О програму RSSOwl");
    translation.put("MENU_LICENSE", "Лиценца");
    translation.put("MENU_UPDATE", "Провера постојања нове верзије");
    translation.put("MENU_WELCOME", "Уводна страна");
    translation.put("MENU_DONATE", "Будите донатор");
    translation.put("MENU_TOOLS", "Алати");
    translation.put("MENU_FEEDSEARCH", "Претрага наслова");
    translation.put("MENU_MINIMIZE_RSSOWL", "Умањи RSSOwl");
    translation.put("MENU_GOTO", "Избор");
    translation.put("MENU_NEXT_NEWS", "Следећа вест");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Следећа непрочитана вест");
    translation.put("MENU_CLOSE", "Затвори");
    translation.put("MENU_CLOSE_ALL", "Затвори све");
    translation.put("MENU_PREVIOUS_TAB", "Претходни лист");
    translation.put("MENU_NEXT_TAB", "Следећи лист");
    translation.put("MENU_HOTKEYS", "Пречица");
    translation.put("MENU_NEWSTIP_MAIL", "Прављење NewsTip писма");
    translation.put("MENU_TELL_FRIENDS", "Подели са пријатељима...");
    translation.put("MENU_RELOAD", "Поново учитај");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Направи PDF од изабраног наслова");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Направи HTML од изабраног наслова");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Направи RTF од изабраног наслова");
    translation.put("MENU_MAILING_LIST", "Дописно друштво");
    translation.put("MENU_TUTORIAL", "Упутство");
    translation.put("MENU_COLORS", "Боје");
    translation.put("MENU_BLOGGER", "Blogger");
    translation.put("MENU_WORKBENCH", "Опште");
    translation.put("MENU_IMPORT_OPML", "Увоз из OPML");
    translation.put("MENU_VALIDATE", "Валидација");
    translation.put("MENU_FEED_DISCOVERY", "Преглед наслова на презентацији");
    translation.put("MENU_DISPLAY_FEED_PDF", "Преглед наслова из PDF документа");
    translation.put("MENU_DISPLAY_FEED_RTF", "Преглед наслова из RTF документа");
    translation.put("MENU_DISPLAY_FEED_HTML", "Преглед наслова из HTML документа");
    translation.put("MENU_NEW_FAVORITE", "Нови занимљиви извор");
    translation.put("MENU_EDIT", "Уређивање");
    translation.put("MENU_EDIT_COPY", "Умножи");
    translation.put("MENU_EDIT_PASTE", "Пренеси");
    translation.put("MENU_EDIT_SELECT_ALL", "Изабери све");
    translation.put("MENU_EDIT_DELETE", "Уклони");
    translation.put("MENU_EDIT_CUT", "Исеци");
    translation.put("MENU_CONNECTION", "Веза");
    translation.put("MENU_EDIT_RENAME", "Преименуј");
    translation.put("MENU_WORK_OFFLINE", "Режим ван везе");
    translation.put("MENU_WORK_ONLINE", "Режим на вези");

    /** ToolBar */
    translation.put("TOOL_MARK", "Обележи");
    translation.put("TOOL_NEXT", "Следеће");
    translation.put("TOOL_SEPARATOR", "Раздвојник");
    translation.put("TOOL_ICONS_TEXT", "Иконе и текст");
    translation.put("TOOL_ICONS", "Иконе");
    translation.put("TOOL_TEXT", "Текст");
    translation.put("TOOL_RATE", "Оцена");
    translation.put("TOOL_HISTORY", "Историја");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Ново");
    translation.put("POP_SUB_CATEGORY", "Подкатегорија");
    translation.put("POP_UNSUBSCRIBE", "Одјава");
    translation.put("POP_USEPROXY", "Користи прокси");
    translation.put("POP_AGGREGATE_FAV", "Прикупи занимљиве наслове");
    translation.put("POP_AUTO_UPDATE", "Аутоматско освежавање");
    translation.put("POP_UPDATE_ONSTARTUP", "при покретању");
    translation.put("POP_IMPORT", "Увоз");
    translation.put("POP_FROM_OPML", "Из OPML датотеке");
    translation.put("POP_EXPORT_OPML", "У OPML даотетеку");
    translation.put("POP_COPY", "Умножи");
    translation.put("POP_OPEN_IN_BROWSER", "Отвори избор у прегледнику");
    translation.put("POP_MARK_UNREAD", "Означи као непрочитано");
    translation.put("POP_COPY_NEWS_URL", "Умножи адресу наслова");
    translation.put("POP_RATE_NEWS", "Оцењивање наслова");
    translation.put("POP_MAIL_LINK", "Пошаљи NewsTip пријатељу");
    translation.put("POP_OPEN_EXTERN", "Отвори у спољном прегледнику");
    translation.put("POP_BLOG_NEWS", "Блогуј наслов");
    translation.put("POP_OPEN_STARTUP", "Отвори при покретању");
    translation.put("POP_KEEP_CURRENT", "Затвори остале");
    translation.put("POP_KEEP_NEWSFEEDS", "Затвори све осим наслова");
    translation.put("POP_MARK_ALL_READ", "Означи све као прочитано");
    translation.put("POP_MARK_CATEGORY_READ", "Означи категорију прочитаном");
    translation.put("POP_TAB_POSITION", "позиција");
    translation.put("POP_TAB_POS_TOP", "Горе");
    translation.put("POP_TAB_POS_BOTTOM", "Доле");
    translation.put("POP_PROPERTIES", "Поставке");
    translation.put("POP_MARK_FAVORITE_READ", "Означи извор прочитаним");
    translation.put("POP_IMPORT_BLOGROLL", "Синхронизовани Blogroll");
    translation.put("POP_SYNCHRONIZE", "Синхронизуј");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Прилагоди линију алата");
    translation.put("POP_CLEAR_HISTORY", "Очисти историју");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Догодила се неочекивана грешка! RSSOwl ће бити затворен али су поставке сачуване.\nЗабележена је грешка у '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nЖелите ли да пошаљете пријаву грешке RSSOwl тиму?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Грешка");
    translation.put("ERROR_NO_NEWS_FOUND", "Грешка: Не могу да пронађем ниједан наслов!");
    translation.put("ERROR_CAT_EXISTS", "Категорија са тим називом већ постоји!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Занимљиви извор са тим називом већ постоји!");
    translation.put("ERROR_FAV_URL_EXISTS", "Занимљиви извор са те УРЛ адресе већ постоји!");
    translation.put("ERROR_CONNECTION_FAILED", "Неуспело повезивање!");
    translation.put("ERROR_GRABTITLE_FAILED", "Не могу да добавим наслов!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl није у могућности да прикаже наслове.");
    translation.put("ERROR_FILE_NOT_FOUND", "Не могу да пронађем датотеку");
    translation.put("ERROR_AUTH_REQUIRED", "Наслови су заштићени. Неопходна је идентификација.");
    translation.put("ERROR_REASON", "Разлог");
    translation.put("ERROR_LOADING_FEED", "Грешка при учитавању наслова „%TITLE%”");
    translation.put("ERROR_HTTP_STATUS", "Статус");
    translation.put("ERROR_WORKING_OFFLINE", "Наслови се не могу приказати у режиму ван везе");
    translation.put("ERROR_NOT_A_XML", "Датотека није исправан XML документ");
    translation.put("ERROR_NOT_A_RSS", "XML документ није исправан RSS, RDF или Atom наслов");
    translation.put("ERROR_NOT_A_OPML", "XML документ није OPML датотека");
    translation.put("ERROR_SUB_EXISTS", "Већ сте пријављени на тај Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "УРЛ / Путања");
    translation.put("LABEL_CATEGORY", "Категорија");
    translation.put("LABEL_NO_INFOS", "Нема додатних информација!");
    translation.put("LABEL_FAVORITE", "Занимљиво");
    translation.put("LABEL_TITLE", "Наслов");
    translation.put("LABEL_USE_PROXY", "Користи прокси");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Прокси захтева идентификацију");
    translation.put("LABEL_USERNAME", "Корисничко име");
    translation.put("LABEL_PASSWORD", "Лозинка");
    translation.put("LABEL_PROXY_HOST", "Прокси хост");
    translation.put("LABEL_PROXY_PORT", "Прокси порт");
    translation.put("LABEL_CATEGORY", "Категорија");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Користи прокси за све занимљиве изворе");
    translation.put("LABEL_NEWS_RATED", "Наслов је оцењен");
    translation.put("LABEL_SEARCH_TOPIC", "Одредите претрагу");
    translation.put("LABEL_SEARCH_FINISHED", "Претрага завршена.");
    translation.put("LABEL_SEARCH_RUNNING", "Претрага у току...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Интензивна претрага");
    translation.put("LABEL_PREFERED_LANGUAGE", "Примарни језик");
    translation.put("LABEL_DESCRIPTION", "Опис");
    translation.put("LABEL_CREATED", "Направљено");
    translation.put("LABEL_LAST_VISIT", "Добављено");
    translation.put("LABEL_USED_BY", "Користи се за");
    translation.put("LABEL_NAME", "Назив");
    translation.put("LABEL_KEY_SEQUENCE", "Комбинација тастера");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Комбинација тастера није исправна!");
    translation.put("LABEL_SIZE", "Величина");
    translation.put("LABEL_STYLE", "Стил");
    translation.put("LABEL_SELECT_ENCODING", "Изаберите кодирање");
    translation.put("LABEL_MAIL_SUBJECT", "Тема");
    translation.put("LABEL_MAIL_BODY", "Садржај поруке");
    translation.put("LABEL_MAIL_USAGE", "Користите [TITLE], [LINK] и [DESCRIPTION] као замењиве параметре за информације о наслову");
    translation.put("LABEL_EMPTY_LINK", "Веза није одређена");
    translation.put("LABEL_USE_SYSTEM_FONT", "Користи системски фонт");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Писмо у HTML формату");
    translation.put("LABEL_CURRENT_COLOR", "Тренутна боја");
    translation.put("LABEL_OPTIONS", "Опције");
    translation.put("LABEL_SEARCH_RESULTS", "Претрага за „%TERM%” дала је %NUM% резултата");
    translation.put("LABEL_SEARCH_EMPTY", "Претрага за „%TERM%” није дала резултат.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Изаберите један од два распореда прозора");
    translation.put("LABEL_SINGLE_CLICK", "Један клик");
    translation.put("LABEL_DOUBLE_CLICK", "Двоклик");
    translation.put("LABEL_SELECT_BLOGGER", "Изаберите спољни blogger");
    translation.put("LABEL_BLOGGER_USAGE", "Користите [NEWSLINK], [FEEDLINK] и [TITLE] као замењиве параметре за информације о наслову.");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Отвори последње приказани наслов по покретању");
    translation.put("LABEL_TRADITIONAL_TABS", "Класични језичци");
    translation.put("LABEL_CURVED_TABS", "Заобљени језичци");
    translation.put("LABEL_READY", "Спреман");
    translation.put("LABEL_VALIDATION_FINISHED", "Валидација је готова");
    translation.put("LABEL_VALIDATING", "Валидација у току");
    translation.put("LABEL_FEED_TYPE", "Врста наслова");
    translation.put("LABEL_OVERRIDE_DTD", "Занемари Doctype дефиниције");
    translation.put("LABEL_ADDRESS", "Адреса");
    translation.put("LABEL_BROWSER_USAGE", "Користите [URL] као замењиви параметар за УРЛ.");
    translation.put("LABEL_OLD_ID", "Стари кориснички ИД (опционо)");
    translation.put("LABEL_AMPHETARATE_ID", "Кориснички ИД");
    translation.put("LABEL_SORT_EXPLANATION", "Приоритет поретка по коме ће наслови аутоматски бити поређани. RSSOwl прво покушава да поређа наслове по садржајности одређених карактеристика. У случају да ставка није садржана у фику, RSSOwl наставља са следећом ставком из пописа.");
    translation.put("LABEL_SORT_ORDER", "Поредак наслова");
    translation.put("LABEL_REMEMBER_AUTH", "Упамти корисничко име и лозинку");
    translation.put("LABEL_NOT_UNSUPPORTED", "Још није подржано Вашим оперативним системом");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Вредности које се овде могу подешавати биће узете као почетне вредности за сваки нови занимљиви извор.");
    translation.put("LABEL_RESTART", "Промене захтевају покретање програма изнова");
    translation.put("LABEL_WELCOME_TITLE", "Добро дошли у RSSOwl - Читач RSS / RDF / Atom наслова");
    translation.put("LABEL_FIRST_STEPS", "Први корак");
    translation.put("LABEL_NEWS", "Вести");
    translation.put("LABEL_RSSOWL_NEWSFEED", "RSSOwl вести");
    translation.put("LABEL_SUPPORT", "Подршка");
    translation.put("LABEL_DISCUSSION_FORUM", "Дискусиони форум");
    translation.put("LABEL_PROMOTION", "Промоција");
    translation.put("LABEL_CONTACT", "Контакт");
    translation.put("LABEL_START", "Почетак");
    translation.put("LABEL_DOWNLOAD", "Преузимање");
    translation.put("LABEL_MAX_CONNECTIONS", "Максималан број веза");
    translation.put("LABEL_CON_TIMEOUT", "Време чекања везе у секундама");
    translation.put("LABEL_DELETE_FAVORITE", "Уклони занимљиви извор");
    translation.put("LABEL_DELETE_CATEGORY", "Уклони категорију");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Уклони Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Регистрација је извршена");
    translation.put("LABEL_SHOW", "Прикажи");
    translation.put("LABEL_SEARCH_IN", "Претражи у");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Отвори");
    translation.put("BUTTON_RELOAD_CAT", "Поново учитај занимљиве изворе");
    translation.put("BUTTON_ADD", "Додај");
    translation.put("BUTTON_FILE", "Отвори датотеку");
    translation.put("BUTTON_SEARCH", "Претрага");
    translation.put("BUTTON_RELOAD", "Поново учитај наслов");
    translation.put("BUTTON_CANCLE", "Откажи");
    translation.put("BUTTON_EXPORT", "Извоз");
    translation.put("BUTTON_STOP_SEARCH", "Заустави претрагу");
    translation.put("BUTTON_CLEAR_RESULTS", "Обриши резултате");
    translation.put("BUTTON_EXPORT_TO_OPML", "Извоз у OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Додај у занимљиве изворе");
    translation.put("BUTTON_ASSIGN", "Потпиши");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Врати подразумевано");
    translation.put("BUTTON_APPLY", "Примени");
    translation.put("BUTTON_CHANGE_FONT", "Промена фонта");
    translation.put("BUTTON_OK", "У реду");
    translation.put("BUTTON_VALIDATE", "Провери исправност");
    translation.put("BUTTON_STOP_VALIDATION", "Заустави проверу исправности");
    translation.put("BUTTON_FOCUS_TABS", "Постави фокус на нови лист");
    translation.put("BUTTON_DISPLAY_TABS", "Прикажи наслов на листу");
    translation.put("BUTTON_TRAY_STARTUP", "Постави RSSOwl у системску касету при покретању");
    translation.put("BUTTON_TRAY_EXIT", "Постави RSSOwl и системску касету при изласку");
    translation.put("BUTTON_SHOW_ERRORS", "Прикажи грешку на јесичку");
    translation.put("BUTTON_CHANGE", "Промени");
    translation.put("BUTTON_MARK_ALL_READ", "Обележи све категорије прочитаним");
    translation.put("BUTTON_AGGREGATE_ALL", "Прикупи све категорије");
    translation.put("BUTTON_RELOAD_ALL", "Поново учитај све категорије");
    translation.put("BUTTON_SEARCH_ALL", "Претражи у свим категоријама");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Обележи све наслове прочитаним при умањивању");
    translation.put("BUTTON_TRAY_POPUP", "Прикажи облачић када има непрочитаних наслова");
    translation.put("BUTTON_READ_ON_CLOSE", "Обележи наслов прочитаним при затварању листа");
    translation.put("BUTTON_UP", "Горе");
    translation.put("BUTTON_DOWN", "Доле");
    translation.put("BUTTON_CREATE_ACCOUNT", "Направи налог");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Аутоматски затвори облачиће");
    translation.put("BUTTON_CACHE_FEEDS", "Аутоматски сачувај прикупљене наслове за читање у режиму ван везе");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Отвори у прегледнику");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Прикажи дугме за затварање на језичцима");
    translation.put("BUTTON_DELETE_FAVORITE", "Када се уклања занимљиви извор");
    translation.put("BUTTON_DELETE_CATEGORY", "Када се уклања категорија");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "Када се уклања Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Немој више да питаш");
    translation.put("BUTTON_BLOCK_POPUPS", "Блокирај искачуће прозоре");
    translation.put("BUTTON_ANIMATE_POPUP", "Анимирани облачић");
    translation.put("BUTTON_REMOVE", "Уклони");
    translation.put("BUTTON_SMALL_ICONS", "Користи мале иконе");
    translation.put("BUTTON_LINK_TAB", "Повежи са приказаним насловом");
    translation.put("BUTTON_CLEAR", "Очисти");
    translation.put("BUTTON_NO_SORT", "Не сортирај наслове аутоматски");

    /** Header */
    translation.put("HEADER_NEWS", "Заглавље");
    translation.put("HEADER_RSS_FAVORITES", "Занимљиво");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Кликните за отварање презентације!");
    translation.put("TOOLTIP_PRINT", "Штампање наслова");
    translation.put("TOOLTIP_RATE", "Кликните за оцењивање наслова");
    translation.put("TOOLTIP_GRAB_TITLE", "Користи наслов из вести");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Има непрочитаних наслова");
    translation.put("TOOLTIP_SKIP", "Прескочи");
    translation.put("TOOLTIP_OPEN_TAB", "Отвори нови лист");
    translation.put("TOOLTIP_QUICKSEARCH", "Брза претрага");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Датум објаве");
    translation.put("TABLE_HEADER_AUTHOR", "Аутор");
    translation.put("TABLE_HEADER_CATEGORY", "Категорија");
    translation.put("TABLE_HEADER_PUBLISHER", "Издавач");
    translation.put("TABLE_HEADER_NEWSTITLE", "Назив вести");
    translation.put("TABLE_HEADER_FEED", "Садржај");
    translation.put("TABLE_HEADER_FEEDURL", "УРЛ наслова");
    translation.put("TABLE_HEADER_FEEDTITLE", "Назив наслова");
    translation.put("TABLE_HEADER_LINE", "Линија");
    translation.put("TABLE_HEADER_STATUS", "Статус");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Домаћа страна");
    translation.put("CHANNEL_INFO_PUBDATE", "Датум објаве");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Последња измена канала");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Уређивач");
    translation.put("CHANNEL_INFO_WEBMASTER", "Вебгазда");
    translation.put("CHANNEL_INFO_CATEGORY", "Категорија");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Време активности канала");
    translation.put("CHANNEL_INFO_RSSVERSION", "Верзија");
    translation.put("CHANNEL_INFO_GENERATOR", "RSS генератор");
    translation.put("CHANNEL_INFO_PUBLISHER", "Издавач");
    translation.put("CHANNEL_INFO_LANGUAGE", "Језик");
    translation.put("CHANNEL_INFO_CREATOR", "Аутор");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Ажурирано");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "пута");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Извор");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Enclosure");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Коментари");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Пажња");
    translation.put("MESSAGEBOX_FILL_URL", "Унесите УРЛ или путању");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Категорија са тим називом већ постоји");
    translation.put("MESSAGEBOX_SELECT_CAT", "Изабор категорије");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Датотека постоји. Да пишем преко ње?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Датотека не садржи RSSOwl подешавања!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Увоз подешавања је успешно обављен!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Текст наслова је празан! Изаберите наслов.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Додај нови занимљиви извор");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Додај нову категорију");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Унесите назив");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Унесите УРЛ / путању и назив");
    translation.put("BASE_AUTH_TITLE", "За захтевану презентацију је потребна идентификација!");
    translation.put("BASE_AUTH_MESSAGE", "Унесите корисничко име и лозинку.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "Ниј еизабран исправан RSS у занимљивим изворима!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Потврдите");
    translation.put("SEARCH_DIALOG_TITLE", "Претрага");
    translation.put("SEARCH_DIALOG_MESSAGE", "Користите AND, OR и NOT за дефинисање претраге!");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Тражи фразу");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Само реч");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Величина слова је битна");
    translation.put("SEARCH_DIALOG_REGEX", "Користи регуларне изразе");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Нема нове верзије");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "Већ користите најновију верзију програма RSSOwl!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Информације");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Уређивање категорије");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Уређивање занимљивог извора");
    translation.put("DIALOG_TITLE_UPDATE", "Доступна је нова верзија RSSOwl програма");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Унесите путању до извршне датотеке");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Није могуће повезивање на http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Прво морате да поставите ваш AmphetaRate User ID!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Категорија не садржи омиљене изворе!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Унесите комбинацију тастера");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Неуспешно покретање прегледника!\nИзаберите прегледник у „Подешавањима“");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Прво морате да изаберете blogger!");
    translation.put("DIALOG_TITLE_CATEGORY", "Изаберите категорију");
    translation.put("DIALOG_ID_ATTENTION", "Прво морате да направите AmphetaRate налог!");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Унесите УРЛ до презентације");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl не може да пронађе апликацију да прикаже %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Уређивање Blogroll-а");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Грешка при учитавању уграђеног прегледнике!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Додај нови Blogroll");
    translation.put("QUESTION_DEL_FAV", "Да ли сте сигурни да желите да уклоните занимљиви извор „%NAME%“?");
    translation.put("QUESTION_DEL_CAT", "Да ли сте сигурни да желите да уклоните категорију „%NAME%“?");
    translation.put("QUESTION_DEL_SUB", "Да ли сте сигурни да желите да уклоните Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Назад");
    translation.put("BROWSER_FORWARD", "Напред");
    translation.put("BROWSER_STOP", "Заустави");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Одлично");
    translation.put("RATE_GOOD", "Добро");
    translation.put("RATE_MODERATE", "Задовољавајуће");
    translation.put("RATE_BAD", "Лоше");
    translation.put("RATE_VERY_BAD", "Веома лоше");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "никада");
    translation.put("UPDATE_INTERVAL_ONE", "на 1 минут");
    translation.put("UPDATE_INTERVAL_FIVE", "нан 5 минута");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "на 15 минута");
    translation.put("UPDATE_INTERVAL_THIRTY", "сваких 30 минута");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "на 1 сат");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "на 3 сата");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "сваких 6 сати");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "на 12 сати");
    translation.put("UPDATE_INTERVAL_ONEDAY", "на 24 сата");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Стрелица на горе");
    translation.put("LABEL_KEY_ARROW_DOWN", "Стрелица на доле");
    translation.put("LABEL_KEY_ARROW_LEFT", "Стрелица у лево");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Стрелица у десно");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Размак");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Нумеричка тастатура");
    translation.put("LABEL_KEY_COMMAND", "Cmd");
    translation.put("LABEL_KEY_DEL", "Del");

    /** Font Settings */
    translation.put("FONT_AREA_TEXT", "Фонт текста");
    translation.put("FONT_AREA_DIALOG", "Фонт дијалога");
    translation.put("FONT_AREA_TREE", "Фонт стабла");
    translation.put("FONT_AREA_TABLE", "Фонт табеле");
    translation.put("FONT_AREA_HEADER", "Фонт заглавља");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Фонт текста се користи за текст наслова, информације канала, поруке и грешке.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Фонт дијалога се користи у свим дијалозима.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Фонт стабла се користи за стабло занимљивих извора.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Фонт табеле се користи за табеле са информацијама о вестима.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Фонт заглавља се користи за део заглавља наслова.");
    translation.put("FONT_STYLE_BOLD", "Подебљано");
    translation.put("FONT_STYLE_ITALIC", "Курзив");
    translation.put("FONT_STYLE_NORMAL", "Обично");

    /** Groups */
    translation.put("GROUP_COMMAND", "Наредба");
    translation.put("GROUP_SELECTED_FONT", "Изабрани фонт");
    translation.put("GROUP_FONT_AREA", "Површина фонта");
    translation.put("GROUP_WINDOW_LAYOUT", "Распоред прозора");
    translation.put("GROUP_OPEN_MODE", "Режим отварања");
    translation.put("GROUP_ARGUMENTS", "Аргументи");
    translation.put("GROUP_LINK_COLOR", "Боја везе");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Боја резултата претраге");
    translation.put("GROUP_TAB_LAYOUT", "Распоред језичака");
    translation.put("GROUP_TRAY", "Системска касета");
    translation.put("GROUP_GENERAL", "Опште");
    translation.put("GROUP_EXISTING_ACCOUNT", "Постојећи налог");
    translation.put("GROUP_NEW_ACCOUNT", "Регистрација новог налога");
    translation.put("GROUP_NEWS_POPUP", "Облачић вести");
    translation.put("GROUP_CONFIRM_DIALOG", "Прикажи дијалог за потврду");

    /** Languages */
    translation.put("de", "Немачки");
    translation.put("da", "Дански");
    translation.put("el", "Грчки");
    translation.put("en", "Енглески");
    translation.put("es", "Шпански");
    translation.put("fr", "Француски");
    translation.put("gl", "Галићански");
    translation.put("it", "Италијански");
    translation.put("nl", "Хиландски");
    translation.put("pt", "Португалски (Бразил)");
    translation.put("ru", "Руски");
    translation.put("bg", "Бугарски");
    translation.put("zhcn", "Поједностављени Кинески");
    translation.put("zhtw", "Традиционални Кинески");
    translation.put("ja", "Јапански");
    translation.put("ko", "Корејски");
    translation.put("pl", "Пољски");
    translation.put("no", "Норвешки");
    translation.put("sv", "Шведски");
    translation.put("bn", "Бенгалски");
    translation.put("fi", "Фински");
    translation.put("uk", "Украински");
    translation.put("tr", "Турски");
    translation.put("hu", "Мађарски");
    translation.put("sl", "Словеначки");
    translation.put("sr", "Српски (ћирилица)");
    translation.put("sh", "Српски (латиница)");
    translation.put("cs", "Чешки");
    translation.put("th", "Таи");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Нема описа!");
    translation.put("LOAD_FEED", "Учитавање у току");
    translation.put("SEARCH_FEED", "Претрага у току");
    translation.put("RELOAD_FEED", "Освежавање у току");
    translation.put("PRINTED_FROM_RSSOWL", "Штампано из RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Штампање вести из RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Прикажи RSSOwl");
    translation.put("TAB_WELCOME", "Добро дошли");
    translation.put("DOCUMENT_GENERATED_FROM", "Документ је направљен програмом RSSOwl");
    translation.put("NO_TITLE", "Без наслова");
    translation.put("RECOMMENDED_ARTICLES", "Препоручени наслови");
    translation.put("RSSOWL_TEASER", "RSSOwl је слободан, RSS и RDF читач наслова отвореног кôда. Посебне могућности су:\n\n- Извоз вести у PDF, HTML, RTF, OPML\n- Увоз омиљених локација из OPML\n- Претрага текста са наглашавањем резултата\n- Моћан RSS и RDF претраживач\n- Преглед вести у уграђеном прегледнику\n- Организација омиљених локација по категоријама\n- Ради на оперативним системима Windows, Linux, Solaris и Mac\n\nЗа комплетан попис могућности погледајте: http://www.rssowl.org/features.html\n\nПреузимање са: http://sourceforge.net/project/showfiles.php?group_id=86683");
    translation.put("MAIL_ERROR_BODY", "Молим вас да приложите датотеку '" + GlobalSettings.WORKING_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' уз писмо и укратко опишете шта сте радили у програму RSSOwl пре него што је настала грешка. Хвала!");
    translation.put("FORMAT_AUTO_DETECT", "Аутоматски препознај");
    translation.put("NEWSFEED_VALID", "Наслов је валидан");
    translation.put("OPML_IMPORTED", "Увежено");
    translation.put("ENTIRE_NEWS", "Тренутни наслов");
    translation.put("SEARCH_AND", "AND");
    translation.put("SEARCH_OR", "OR");
    translation.put("SEARCH_NOT", "NOT");
  }
}