/*   **********************************************************************  **
 **   Copyright notice                                                       **
 **                                                                          **
 **   (c) 2003-2006 RSSOwl Development Team                                  **
 **   http://www.rssowl.org/                                                 **
 **                                                                          **
 **   All rights reserved                                                    **
 **                                                                          **
 **   This program and the accompanying materials are made available under   **
 **   the terms of the Eclipse Public License 1.0 which accompanies this     **
 **   distribution, and is available at:                                     **
 **   http://www.rssowl.org/legal/epl-v10.html                               **
 **                                                                          **
 **   A copy is found in the file epl-v10.html and important notices to the  **
 **   license from the team is found in the textfile LICENSE.txt distributed **
 **   in this package.                                                       **
 **                                                                          **
 **   This copyright notice MUST APPEAR in all copies of the file!           **
 **                                                                          **
 **   Contributors:                                                          **
 **     RSSOwl - initial API and implementation (bpasero@rssowl.org)         **
 **                                                                          **
 **  **********************************************************************  */

package net.sourceforge.rssowl.util.i18n;

import net.sourceforge.rssowl.util.GlobalSettings;

/**
 * Ukrainian internationalization for RSSOwl (i18n). <br />
 * <br />
 * Supported Languages <br />
 * ------------------- <br />
 * <br />
 * o German - by Benjamin P. RSSOwl Administrator/Developer <br />
 * o English - by Benjamin P. RSSOwl Developer and Christian Hochhold <br />
 * o French - by Christophe Dumez RSSOwl Doc Translator (French) <br />
 * o Spanish - by José Domínguez and Ruben <br />
 * o Galician - by José Domínguez <br />
 * o Danish - by Tonny Bredsgaard RSSOwl Doc Translator (Danish) <br />
 * o Italian - by Claudio Fontana <br />
 * o Dutch - by Joris Kluivers and Toon Geens <br />
 * o Greek - by Jacaranda Bill <br />
 * o Russian - by Sergey Rozenblat and Alexandr <br />
 * o Portugues (Brasil) - by Marcelo Fenoll Ramal Tradutor <br />
 * o Bulgarian - by Valeri Damianov <br />
 * o Norwegian (Bokmål) - by Eivind Syverts <br />
 * o Chinese Simplified - by Merlin Ran <br />
 * o Japanese - by Takashi Komatsubara <br />
 * o Korean - by Geon Goo <br />
 * o Polish - by Ryszard Sierotnik <br />
 * o Bangla (Bengali) - by Omi Azad <br />
 * o Swedish - by Patrik Johansson <br />
 * o Chinese Traditional - by Jerry Giant <br />
 * o Finnish - by Samu Reinikainen <br />
 * o Ukrainian - by Alexandr <br />
 * o Czech - by Lukas Petrovicky <br />
 * o Serbian - by Aleksandar Urošević <br />
 * o Slovenian - by Jure Zemljič <br />
 * o Turkish - by Engin Erenturk <br />
 * o Hungarian - by Balázs <br />
 * o Thai - by Patipat Susumpow <br />
 * o Croatian - by Neven Zitek<br />
 * o Slovak - by Vlado Jasaň<br />
 * <br />
 * If you would like to add another language to RSSOwl, feel free to contact me
 * (http://www.rssowl.org).
 * 
 * @author <a href="mailto:bpasero@rssowl.org">Benjamin Pasero </a>
 * @version 1.2.3
 */
public class RSSOwlI18nUK extends Translation {

  /**
   * Instantiate a new translation for a locale
   * 
   * @param language two-letter ISO-639 code
   * @param country two-letter ISO-3166 code
   */
  public RSSOwlI18nUK(String language, String country) {
    super(language, country);
  }

  /** Set up the i18n hashtable */
  protected void initTranslation() {

    /** RSSOwl Top Menu */
    translation.put("MENU_FILE", "Файл");
    translation.put("MENU_SAVE", "Зберегти як");
    translation.put("MENU_TOOLBAR", "Панель інструментів");
    translation.put("MENU_GENERATE_PDF", "Згенерувати PDF");
    translation.put("MENU_GENERATE_HTML", "Згенерувати HTML");
    translation.put("MENU_GENERATE_RTF", "Згенерувати RTF");
    translation.put("MENU_IMPORT", "Імпорт конфігурації");
    translation.put("MENU_EXPORT", "Експорт конфігурації");
    translation.put("MENU_EXIT", "Вихід");
    translation.put("MENU_WINDOW", "Вигляд");
    translation.put("MENU_QUICKVIEW", "Швидкий перегляд");
    translation.put("MENU_PREFERENCES", "Конфігурація");
    translation.put("MENU_BROWSER", "Браузер");
    translation.put("MENU_SELECT_EXTERNAL_BROWSER", "Виберіть зовнішній браузер");
    translation.put("MENU_FONT", "Шрифт");
    translation.put("MENU_ENCODING", "Кодування");
    translation.put("MENU_LANGUAGE", "Мова");
    translation.put("MENU_PROXY", "Проксі");
    translation.put("MENU_MISC", "Інше");
    translation.put("MENU_DIRECTOPEN", "Відкривати порожні новини у браузері");
    translation.put("MENU_DIRECTOPENEACH", "Відкривати кожну новину у браузері");
    translation.put("MENU_SYSTRAY", "Ховати програму у системний лоток");
    translation.put("MENU_CHANNELINFO", "Показувати інформацію про канал");
    translation.put("MENU_OPENNEW_BROWSER", "Завжди відкривати внутрішній баузер у новій закладці");
    translation.put("MENU_BROWSER_EXTERN", "Відкривати зовнішній браузер");
    translation.put("MENU_BROWSER_FOR_NEWSTEXT", "Показувати текст новини у браузері");
    translation.put("MENU_CHECK_UPDATE", "Перевіряти онновлення під час запуску");
    translation.put("MENU_INFO", "Допомога");
    translation.put("MENU_ABOUT", "Про програму");
    translation.put("MENU_LICENSE", "Ліцензія");
    translation.put("MENU_UPDATE", "Перевірити оновлення");
    translation.put("MENU_WELCOME", "Ласкаво просимо");
    translation.put("MENU_DONATE", "Внести пожертвування");
    translation.put("MENU_TOOLS", "Інструменти");
    translation.put("MENU_MINIMIZE_RSSOWL", "Згорнути");
    translation.put("MENU_GOTO", "Перейти");
    translation.put("MENU_NEXT_NEWS", "Наступна новина");
    translation.put("MENU_NEXT_UNREAD_NEWS", "Наступна нова новина");
    translation.put("MENU_CLOSE", "Закрити");
    translation.put("MENU_CLOSE_ALL", "Закрити усе");
    translation.put("MENU_PREVIOUS_TAB", "Попередня закладка");
    translation.put("MENU_NEXT_TAB", "Наступна закладка");
    translation.put("MENU_HOTKEYS", "Гарячі клавіші");
    translation.put("MENU_NEWSTIP_MAIL", "Форматувати пошту NewsTip");
    translation.put("MENU_TELL_FRIENDS", "Розповісти друзям");
    translation.put("MENU_RELOAD", "Оновити");
    translation.put("MENU_GENERATE_PDF_SELECTION", "Згенерувати PDF-файл з вибраних новин");
    translation.put("MENU_GENERATE_HTML_SELECTION", "Згенерувати HTML-файл з вибраних новин");
    translation.put("MENU_GENERATE_RTF_SELECTION", "Згенерувати RTF-файл з вибраних новин");
    translation.put("MENU_MAILING_LIST", "Поштова розсилка");
    translation.put("MENU_TUTORIAL", "Допомога");
    translation.put("MENU_COLORS", "Кольори");
    translation.put("MENU_BLOGGER", "Блоггер");
    translation.put("MENU_WORKBENCH", "Робоче місце");
    translation.put("MENU_FEEDSEARCH", "Пошук джерел");
    translation.put("MENU_IMPORT_OPML", "Імпортувати з OPML");
    translation.put("MENU_FEED_DISCOVERY", "Знайти Стрічку Новин на сайті");
    translation.put("MENU_VALIDATE", "Перевірити джерело новин");
    translation.put("MENU_EDIT", "Редагувати");
    translation.put("MENU_EDIT_COPY", "Копіювати");
    translation.put("MENU_EDIT_PASTE", "Вставити");
    translation.put("MENU_EDIT_SELECT_ALL", "Вибрати Все");
    translation.put("MENU_EDIT_DELETE", "Видалити");
    translation.put("MENU_EDIT_CUT", "Вирізати");
    translation.put("MENU_DISPLAY_FEED_PDF", "Відображати новини у вигляді ПДФ");
    translation.put("MENU_DISPLAY_FEED_RTF", "Відображати новини у вигляді RTF");
    translation.put("MENU_DISPLAY_FEED_HTML", "Відображати новини у вигляді HTML");
    translation.put("MENU_NEW_FAVORITE", "Створити вибране");
    translation.put("MENU_CONNECTION", "З'єднання");
    translation.put("MENU_EDIT_RENAME", "Перейменувати");
    translation.put("MENU_WORK_OFFLINE", "Працювати автономно");
    translation.put("MENU_WORK_ONLINE", "Працювати в мережі");

    /** ToolBar */
    translation.put("TOOL_MARK", "Помітка");
    translation.put("TOOL_NEXT", "Наступна");
    translation.put("TOOL_SEPARATOR", "Роздільник");
    translation.put("TOOL_ICONS_TEXT", "Іконки та текст");
    translation.put("TOOL_ICONS", "Тільки іконки");
    translation.put("TOOL_TEXT", "Тільки текст");
    translation.put("TOOL_RATE", "Рейтинг");
    translation.put("TOOL_HISTORY", "Журнал");
    translation.put("TOOL_NEWSTIP", "NewsTip");

    /** Popup Menu */
    translation.put("POP_NEW", "Додати");
    translation.put("POP_SUB_CATEGORY", "Підрозділ");
    translation.put("POP_UNSUBSCRIBE", "Відписатися");
    translation.put("POP_USEPROXY", "Використовувати проксі");
    translation.put("POP_AGGREGATE_FAV", "Зібрати вибране");
    translation.put("POP_AUTO_UPDATE", "Оновлення");
    translation.put("POP_UPDATE_ONSTARTUP", "при старті");
    translation.put("POP_IMPORT", "Імпорт");
    translation.put("POP_FROM_OPML", "З OPML файлу");
    translation.put("POP_EXPORT_OPML", "У OPML файл");
    translation.put("POP_COPY", "Копіювати");
    translation.put("POP_OPEN_IN_BROWSER", "Відкрити виділене у браузері");
    translation.put("POP_MARK_UNREAD", "Помітити як непрочитане");
    translation.put("POP_COPY_NEWS_URL", "Копіювати посилання");
    translation.put("POP_RATE_NEWS", "Оцінити новину");
    translation.put("POP_MAIL_LINK", "Відіслати NewsTip другу");
    translation.put("POP_OPEN_EXTERN", "Відкрити зовнішній");
    translation.put("POP_BLOG_NEWS", "Новини блога");
    translation.put("POP_OPEN_STARTUP", "Відкривати під час запуску");
    translation.put("POP_KEEP_CURRENT", "Закрити усі, крім поточної");
    translation.put("POP_KEEP_NEWSFEEDS", "Закрити усе, крім новин");
    translation.put("POP_MARK_ALL_READ", "Помітити усе як прочитане");
    translation.put("POP_MARK_CATEGORY_READ", "Помітити Розділ Як Прочитаний");
    translation.put("POP_PROPERTIES", "Конфігурація");
    translation.put("POP_TAB_POSITION", "Позиція");
    translation.put("POP_TAB_POS_TOP", "Згори");
    translation.put("POP_TAB_POS_BOTTOM", "Знизу");
    translation.put("POP_MARK_FAVORITE_READ", "Відмітити закладку прочитаною");
    translation.put("POP_IMPORT_BLOGROLL", "Синхронізований Blogroll");
    translation.put("POP_SYNCHRONIZE", "Синхронізувати");
    translation.put("POP_CUSTOMIZE_TOOLBAR", "Настроїти панель");
    translation.put("POP_CLEAR_HISTORY", "Очистити журнал");

    /** Errors in RSSOwl */
    translation.put("ERROR_UNEXPECTED", "Виникла несподівана помилка! RSSOwl закриється, але усі настройки збережені.\nПовідомлення про помилку у файлі'" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log'.\n\nВи хочете відіслати повідомлення про помилку команді розробників RSSOwl?");
    translation.put("MESSAGE_BOX_TITLE_ERROR", "Помилка");
    translation.put("ERROR_NO_NEWS_FOUND", "Помилка: Неможливо знайти новини!");
    translation.put("ERROR_CAT_EXISTS", "Розділ з такою назвою вже існує!");
    translation.put("ERROR_FAV_TITLE_EXISTS", "Закладка з такою назвою вже існує!");
    translation.put("ERROR_FAV_URL_EXISTS", "Закладка з такою адресою вже існує!");
    translation.put("ERROR_CONNECTION_FAILED", "Зв'язок перервано!");
    translation.put("ERROR_GRABTITLE_FAILED", "Неможливо відобразити назву новини!");
    translation.put("ERROR_NEWSFEED_GENERAL", "RSSOwl не може відобразити новини.");
    translation.put("ERROR_FILE_NOT_FOUND", "Не можу знайти файл");
    translation.put("ERROR_AUTH_REQUIRED", "Новини захищені та вимагають авторизації");
    translation.put("ERROR_REASON", "Причина");
    translation.put("ERROR_LOADING_FEED", "Помилка під час читання новини \"%TITLE%\"");
    translation.put("ERROR_HTTP_STATUS", "Стан");
    translation.put("ERROR_WORKING_OFFLINE", "Новина не може відображена у автономному режимі");
    translation.put("ERROR_NOT_A_XML", "Файл не є коректним документом XML");
    translation.put("ERROR_NOT_A_RSS", "XML документ не є RSS, RDF або Atom newsfeed");
    translation.put("ERROR_NOT_A_OPML", "XML документ не є файлом OPML");
    translation.put("ERROR_SUB_EXISTS", "Ви вже підписані на цей Blogroll!");

    /** Labels */
    translation.put("LABEL_URL_PATH", "URL / Шлях");
    translation.put("LABEL_CATEGORY", "Розділ");
    translation.put("LABEL_NO_INFOS", "Немає додаткової інформації!");
    translation.put("LABEL_FAVORITE", "Вибране");
    translation.put("LABEL_TITLE", "Назва");
    translation.put("LABEL_USE_PROXY", "Використовувати проксі");
    translation.put("LABEL_PROXY_AUTHENTIFICATION", "Проксі вимагає авторизацію");
    translation.put("LABEL_USERNAME", "Логін");
    translation.put("LABEL_PASSWORD", "Пароль");
    translation.put("LABEL_PROXY_HOST", "Хост");
    translation.put("LABEL_PROXY_PORT", "Порт");
    translation.put("LABEL_CATEGORY", "Розділ");
    translation.put("LABEL_USE_PROXY_FOR_ALL", "Використовувати проксі для усіх закладок");
    translation.put("LABEL_NEWS_RATED", "Новина оцінена");
    translation.put("LABEL_SEARCH_TOPIC", "Вкажіть ваш пошук");
    translation.put("LABEL_SEARCH_FINISHED", "Пошук закінчено.");
    translation.put("LABEL_SEARCH_RUNNING", "Відбувається пошук...");
    translation.put("LABEL_INTENSIVE_SEARCH", "Інтенсивний пошук");
    translation.put("LABEL_PREFERED_LANGUAGE", "Переважна мова");
    translation.put("LABEL_DESCRIPTION", "Опис");
    translation.put("LABEL_CREATED", "створено");
    translation.put("LABEL_LAST_VISIT", "Останнє відвідувіння");
    translation.put("LABEL_USED_BY", "використовується");
    translation.put("LABEL_NAME", "Назва");
    translation.put("LABEL_KEY_SEQUENCE", "Послідовність");
    translation.put("LABEL_INVALID_KEYSEQUENCE", "Невірна послідовність!");
    translation.put("LABEL_SIZE", "Розмір");
    translation.put("LABEL_STYLE", "Стиль");
    translation.put("LABEL_SELECT_ENCODING", "Виберіть кодування");
    translation.put("LABEL_MAIL_SUBJECT", "Тема");
    translation.put("LABEL_MAIL_BODY", "Текст");
    translation.put("LABEL_MAIL_USAGE", "Використовуйте [TITLE], [LINK], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] та [DESCRIPTION] для шаблона інформації яка виводиться");
    translation.put("LABEL_EMPTY_LINK", "Посилання не вказане");
    translation.put("LABEL_USE_SYSTEM_FONT", "Використовувати системний шрифт");
    translation.put("LABEL_HTML_FORMAT_MAIL", "Лист у форматі HTML");
    translation.put("LABEL_CURRENT_COLOR", "Поточний колір");
    translation.put("LABEL_OPTIONS", "Настройки");
    translation.put("LABEL_BLOGGER_USAGE", "Використовуйте [NEWSLINK], [FEEDLINK], [DESCRIPTION], [AUTHOR], [CATEGORY], [PUBDATE], [PUBLISHER], [SOURCE] та [TITLE] для шаблона інформації яка виводиться");
    translation.put("LABEL_SEARCH_RESULTS", "По запиту \"%TERM%\" знайдено %NUM% документов");
    translation.put("LABEL_SEARCH_EMPTY", "По запиту \"%TERM%\" нічого не знайдено.");
    translation.put("LABEL_SELECT_WINDOW_LAYOUT", "Виберіть один з двох стилів вікна");
    translation.put("LABEL_SINGLE_CLICK", "Одинарний клік");
    translation.put("LABEL_DOUBLE_CLICK", "Подвійний клік");
    translation.put("LABEL_SELECT_BLOGGER", "Виберітт зовнішній блог");
    translation.put("LABEL_REOPEN_DISPLAYED_FEEDS", "Відкривати останні відкриті новини при старті");
    translation.put("LABEL_TRADITIONAL_TABS", "Традиційні вкладки");
    translation.put("LABEL_CURVED_TABS", "Закруглені вкладки");
    translation.put("LABEL_READY", "Готово");
    translation.put("LABEL_OLD_ID", "Старий ID Користувача(вибірково)");
    translation.put("LABEL_AMPHETARATE_ID", "ID Користувача");
    translation.put("LABEL_FEED_TYPE", "Тип джерела новин");
    translation.put("LABEL_VALIDATION_FINISHED", "Перевірку коректності закінчено");
    translation.put("LABEL_VALIDATING", "Перевірка коректності");
    translation.put("LABEL_OVERRIDE_DTD", "Перевизначити  оголошення Doctype");
    translation.put("LABEL_ADDRESS", "Електронна Адреса");
    translation.put("LABEL_BROWSER_USAGE", "Використовувати [URL] як параметр що замінюєтося для адреси.");
    translation.put("LABEL_SORT_ORDER", "Сортування новин");
    translation.put("LABEL_REMEMBER_AUTH", "Пам'ятати Ім'я Користувача та Пароль");
    translation.put("LABEL_SORT_EXPLANATION", "RSSOwl спочатку спробує сортувати новини першій колонці. У випадку її недосяжності, RSSOwl продовжить з наступної колонки.");
    translation.put("LABEL_NOT_UNSUPPORTED", "Ще не підтримується у Вашій операційній системі");
    translation.put("LABEL_KEY_DEL", "Del");
    translation.put("LABEL_TEMPLATE_EXPLANATION", "Значення встановлені тут, будуть взяті за початкові при створенні вибраного.");
    translation.put("LABEL_RESTART", "Зміни потребують перезавантиження RSSOwl");
    translation.put("LABEL_WELCOME_TITLE", "Ласкаво просимо до програми RSSOwl - Переглядач новин для  RSS / RDF / Atom стрічок новин.");
    translation.put("LABEL_FIRST_STEPS", "Перші кроки");
    translation.put("LABEL_NEWS", "Новини");
    translation.put("LABEL_RSSOWL_NEWSFEED", "Новини RSSOwl");
    translation.put("LABEL_SUPPORT", "Підтримка");
    translation.put("LABEL_DISCUSSION_FORUM", "Обговорення у форумі");
    translation.put("LABEL_PROMOTION", "Розкрутка");
    translation.put("LABEL_CONTACT", "Контакт");
    translation.put("LABEL_START", "Почати");
    translation.put("LABEL_DOWNLOAD", "Завантажити");
    translation.put("LABEL_MAX_CONNECTIONS", "Максимальна кількість з'єднань");
    translation.put("LABEL_CON_TIMEOUT", "Тайм-аут у секундах");
    translation.put("LABEL_DELETE_FAVORITE", "Видалити закладку");
    translation.put("LABEL_DELETE_CATEGORY", "Видалити розділ");
    translation.put("LABEL_DELETE_SUBSCRIPTION", "Видалити Blogroll");
    translation.put("LABEL_REGISTRATION_SUCCESS", "Реєєстрація пройшла успішно");
    translation.put("LABEL_SHOW", "Показувати");
    translation.put("LABEL_SEARCH_IN", "Шукати у");
    translation.put("LABEL_DOMAIN", "Domain");

    /** Buttons */
    translation.put("BUTTON_OPEN", "Відкрити");
    translation.put("BUTTON_RELOAD_CAT", "Оновити вибране");
    translation.put("BUTTON_ADD", "Додати");
    translation.put("BUTTON_FILE", "Огляд...");
    translation.put("BUTTON_SEARCH", "Пошук");
    translation.put("BUTTON_RELOAD", "Оновити новини");
    translation.put("BUTTON_CANCLE", "Відмінити");
    translation.put("BUTTON_EXPORT", "Експорт");
    translation.put("BUTTON_STOP_SEARCH", "Зупинити пошук");
    translation.put("BUTTON_CLEAR_RESULTS", "Очистити результати");
    translation.put("BUTTON_EXPORT_TO_OPML", "Експорт у OPML");
    translation.put("BUTTON_ADDTO_FAVORITS", "Додати до вибраного");
    translation.put("BUTTON_ASSIGN", "Призначити");
    translation.put("BUTTON_RESTORE_DEFAULTS", "Значення по замовчуванню");
    translation.put("BUTTON_APPLY", "Застосувати");
    translation.put("BUTTON_CHANGE_FONT", "Змінити шрифт");
    translation.put("BUTTON_OK", "OK");
    translation.put("BUTTON_READ_ON_MINIMIZE", "Помітити усі новини як прочитані у згорнутому вікні");
    translation.put("BUTTON_TRAY_POPUP", "Показувати вспливаюче повідомлення коли доступні непрочитані новини");
    translation.put("BUTTON_READ_ON_CLOSE", "Помітити повідомлення як прочитані при закритті закладки");
    translation.put("BUTTON_CHANGE", "Змінити");
    translation.put("BUTTON_FOCUS_TABS", "Встановлює фокус на нових закладках");
    translation.put("BUTTON_STOP_VALIDATION", "Зупинити Перевірку коректності");
    translation.put("BUTTON_VALIDATE", "Перевірити коректність");
    translation.put("BUTTON_TRAY_STARTUP", "Розміщати RSSOwl у системному лотку при старті");
    translation.put("BUTTON_TRAY_EXIT", "Розміщати RSSOwl  у системному лотку при виході");
    translation.put("BUTTON_SHOW_ERRORS", "Відображати помилки у бічній панелі");
    translation.put("BUTTON_MARK_ALL_READ", "Помітити Все Вибране як прочитане");
    translation.put("BUTTON_AGGREGATE_ALL", "З'єднати Все Вибране");
    translation.put("BUTTON_RELOAD_ALL", "Перечитати Все Вибране");
    translation.put("BUTTON_SEARCH_ALL", "Шукати в Усьому Вибраному");
    translation.put("BUTTON_DISPLAY_TABS", "Відображати новини у закладках");
    translation.put("BUTTON_CREATE_ACCOUNT", "Створити Акаунт");
    translation.put("BUTTON_UP", "Вгору");
    translation.put("BUTTON_DOWN", "Вниз");
    translation.put("BUTTON_NO_SORT", "Не сортувати новини автоматично");
    translation.put("BUTTON_AUTOCLOSE_POPUP", "Автоматично закривати вспливаючі новини");
    translation.put("BUTTON_CACHE_FEEDS", "Автоматично зберігати новини для читання у оффлайні");
    translation.put("BUTTON_OPEN_IN_BROWSER", "Відкрити у браузері");
    translation.put("BUTTON_SHOW_TAB_CLOSE", "Показувати кнопку закритти на закладках");
    translation.put("BUTTON_DELETE_FAVORITE", "При видаленні закладки");
    translation.put("BUTTON_DELETE_CATEGORY", "При видаленні розділу");
    translation.put("BUTTON_DELETE_SUBSCRIPTION", "При видаленні Blogroll");
    translation.put("BUTTON_NEVER_ASK_AGAIN", "Ніколи не питати");
    translation.put("BUTTON_BLOCK_POPUPS", "блокувати спливаючі вікна");
    translation.put("BUTTON_ANIMATE_POPUP", "Анмувати спливаючі вікна");
    translation.put("BUTTON_REMOVE", "Видалити");
    translation.put("BUTTON_SMALL_ICONS", "Викоритовувати малі іконки");
    translation.put("BUTTON_LINK_TAB", "Зробити посилання на відображену Стрічку");
    translation.put("BUTTON_CLEAR", "Очистити");

    /** Header */
    translation.put("HEADER_NEWS", "Заголовок");
    translation.put("HEADER_RSS_FAVORITES", "Вибране");

    /** Tooltips */
    translation.put("TOOLTIP_URLOPEN", "Натисніть щоб відкирити сайт");
    translation.put("TOOLTIP_PRINT", "Роздрукувати новину");
    translation.put("TOOLTIP_RATE", "Оцінити новину");
    translation.put("TOOLTIP_GRAB_TITLE", "Отримати заголовок новини");
    translation.put("TOOLTIP_UNREAD_AVAILABLE", "Доступні непрочитані повідомлення");
    translation.put("TOOLTIP_SKIP", "Пропустити");
    translation.put("TOOLTIP_OPEN_TAB", "Відкрити нову закладку");
    translation.put("TOOLTIP_QUICKSEARCH", "Швидкий пошук");

    /** Tableheader */
    translation.put("TABLE_HEADER_PUBDATE", "Дата публікації");
    translation.put("TABLE_HEADER_AUTHOR", "Автор");
    translation.put("TABLE_HEADER_CATEGORY", "Розділ");
    translation.put("TABLE_HEADER_PUBLISHER", "Опублікував");
    translation.put("TABLE_HEADER_NEWSTITLE", "Заголовки новин");
    translation.put("TABLE_HEADER_FEED", "Джерело");
    translation.put("TABLE_HEADER_FEEDURL", "URL джерела");
    translation.put("TABLE_HEADER_FEEDTITLE", "Заголовок");
    translation.put("TABLE_HEADER_LINE", "Строка");
    translation.put("TABLE_HEADER_STATUS", "Читання");

    /** Channelinfo / Newsitem info */
    translation.put("CHANNEL_INFO_HOMEPAGE", "Сторінка");
    translation.put("CHANNEL_INFO_PUBDATE", "Дата публикації");
    translation.put("CHANNEL_INFO_LASTBUILDDATE", "Остання зміна");
    translation.put("CHANNEL_INFO_MANAGINGEDITOR", "Редактор");
    translation.put("CHANNEL_INFO_WEBMASTER", "Вебмайстер");
    translation.put("CHANNEL_INFO_CATEGORY", "Розділ");
    translation.put("CHANNEL_INFO_DOCS", "Docs");
    translation.put("CHANNEL_INFO_TTL", "Час старіння");
    translation.put("CHANNEL_INFO_RSSVERSION", "Формат");
    translation.put("CHANNEL_INFO_GENERATOR", "Генератор RSS");
    translation.put("CHANNEL_INFO_PUBLISHER", "Опублікував");
    translation.put("CHANNEL_INFO_LANGUAGE", "Мова");
    translation.put("CHANNEL_INFO_CREATOR", "Творець");
    translation.put("CHANNEL_INFO_UPDATE_PERIOD", "Оновлення");
    translation.put("CHANNEL_INFO_UPDATE_FREQUENCY", "раз(ів)");
    translation.put("NEWS_ITEM_INFO_SOURCE", "Джерело");
    translation.put("NEWS_ITEM_INFO_ENCLOSURE", "Вкладення");
    translation.put("NEWS_ITEM_INFO_COMMENTS", "Коментарі");

    /** Messagebox / Dialogs */
    translation.put("MESSAGEBOX_TITLE_ATTENTION", "Увага");
    translation.put("MESSAGEBOX_FILL_URL", "Введіть URL або шлях");
    translation.put("MESSAGEBOX_CAT_EXISTS", "Розділ з таким ім'ям вже існує");
    translation.put("MESSAGEBOX_SELECT_CAT", "Виберіть розділ");
    translation.put("MESSAGEBOX_FILE_EXISTS", "Файл вже існує. Замінити його?");
    translation.put("MESSAGEBOX_WRONG_IMPORT", "Файл не містить коніфгурацію програми!");
    translation.put("MESSAGEBOX_IMPORT_SUCCESS", "Установки імпортовані вдало!");
    translation.put("MESSAGEBOX_PRINT_EMPTYTEXT", "Текст новини пустий! Выберіть новину.");
    translation.put("DIALOG_ADD_FAVORITE_TITLE", "Додати закладку");
    translation.put("DIALOG_ADD_CATEGORY_TITLE", "Додати розділ");
    translation.put("DIALOG_ADD_CATEGORY_MESSAGE", "Введіть назву");
    translation.put("DIALOG_ADD_SUBSCRIPTION_MESSAGE", "Введіте адресу та назву");
    translation.put("BASE_AUTH_TITLE", "Потрібна авторизація!");
    translation.put("BASE_AUTH_MESSAGE", "Введіть ім'я користувча і пароль.");
    translation.put("MESSAGEBOX_ERROR_SAVE_RSS", "У вказаному каталозі не знайдено файлів RSS!");
    translation.put("MESSAGEBOX_TITLE_CONFIRM_DELETE", "Підтвердіть");
    translation.put("SEARCH_DIALOG_TITLE", "Пошук");
    translation.put("SEARCH_DIALOG_MESSAGE", "Будь ласка використовуйте ТА, АБО чи НЕ для обмеження пошуку");
    translation.put("SEARCH_DIALOG_SEARCH_FOR", "Шукати");
    translation.put("SEARCH_DIALOG_EINTRE_WORDS", "Тільки слова повністю");
    translation.put("SEARCH_DIALOG_CASESENSITIVE", "Чуттєве до рерістру");
    translation.put("SEARCH_DIALOG_REGEX", "Використовувати регулярні вирази");
    translation.put("MESSAGEBOX_TITLE_UPDATE", "Нової версії немає");
    translation.put("MESSAGEBOX_MESSAGE_UPDATE", "У Вас остання версія програми!");
    translation.put("MESSAGEBOX_TITLE_INFORMATION", "Інформация");
    translation.put("DIALOG_EDIT_CATEGORY_TITLE", "Редагувати розділ");
    translation.put("DIALOG_EDIT_FAVORITE_TITLE", "Редагувати закладку");
    translation.put("DIALOG_TITLE_UPDATE", "Доступна нова версія RSSOwl");
    translation.put("DIALOG_SELECT_EXTERNAL_BROWSER", "Введіть шлях до файлу");
    translation.put("MESSAGEBOX_MESSAGE_CON_ERROR", "Неможливо з'єднатися з http://www.rssowl.org");
    translation.put("DIALOG_ID_ATTENTION", "Ви повинні спочатку задати ID Користувча для AmphetaRate!");
    translation.put("DIALOG_MESSAGE_CAT_EMPTY", "Розділ не містить закладок!");
    translation.put("DIALOG_MESSAGE_KEYSEQUENCE", "Введіть послідовність");
    translation.put("DIALOG_BROWSERSTART_FAILED", "Неможливо відкрити браузер!\nВкажіть браузер у конфігурації програми");
    translation.put("DIALOG_BLOGGER_ATTENTION", "Спочатку ви повинні вибрати блог!");
    translation.put("DIALOG_ID_ATTENTION", "Спочатку треба створити Аккаунт AmphetaRate!");
    translation.put("DIALOG_TITLE_CATEGORY", "Виберіть розділ");
    translation.put("DIALOG_MESSAGE_ENTER_URL", "Введіть будь ласка адресу вебсайту");
    translation.put("MESSAGEBOX_LAUNCH_FAILED", "RSSOwl не може знайти программу для відображення %FORMAT%");
    translation.put("DIALOG_EDIT_BLOGROLL_TITLE", "Редагувати Blogroll");
    translation.put("DIALOG_ERROR_INTERNALBROWSER", "Не можу завантажити внутрішній браузер!");
    translation.put("DIALOG_ADD_SUBSCRIPTION_TITLE", "Додати новий Blogroll");
    translation.put("QUESTION_DEL_FAV", "Ви впевнені, що хочете видалити закладку \"%NAME%\"?");
    translation.put("QUESTION_DEL_CAT", "Ви впевнені, що хочете видалити розділ \"%NAME%\"?");
    translation.put("QUESTION_DEL_SUB", "Ви впевнені, що хочете видалити Blogroll?");

    /** Browser */
    translation.put("BROWSER_BACK", "Назад");
    translation.put("BROWSER_FORWARD", "Вперед");
    translation.put("BROWSER_STOP", "Зупинити");

    /** AmphetaRate rating levels */
    translation.put("RATE_FANTASTIC", "Відмінно");
    translation.put("RATE_GOOD", "Добре");
    translation.put("RATE_MODERATE", "Задовільно");
    translation.put("RATE_BAD", "Погано");
    translation.put("RATE_VERY_BAD", "Жахливо");

    /** Update interval */
    translation.put("UPDATE_INTERVAL_NO", "ні");
    translation.put("UPDATE_INTERVAL_ONE", "через 1 хвилину");
    translation.put("UPDATE_INTERVAL_FIVE", "через 5 хвилин");
    translation.put("UPDATE_INTERVAL_FIFTEEN", "через 15 хвилин");
    translation.put("UPDATE_INTERVAL_THIRTY", "через 30 хвилин");
    translation.put("UPDATE_INTERVAL_ONEHOUR", "через 1 годину");
    translation.put("UPDATE_INTERVAL_THREEHOURS", "через 3 години");
    translation.put("UPDATE_INTERVAL_SIXHOURS", "через 6 години");
    translation.put("UPDATE_INTERVAL_TWELVEHOURS", "через 12 годин");
    translation.put("UPDATE_INTERVAL_ONEDAY", "через 24 години");

    /** Keyboard keys */
    translation.put("LABEL_KEY_CONTROL", "Ctrl");
    translation.put("LABEL_KEY_SHIFT", "Shift");
    translation.put("LABEL_KEY_ARROW_UP", "Arrow_Up");
    translation.put("LABEL_KEY_ARROW_DOWN", "Arrow_Down");
    translation.put("LABEL_KEY_ARROW_LEFT", "Arrow_Left");
    translation.put("LABEL_KEY_ARROW_RIGHT", "Arrow_Right");
    translation.put("LABEL_KEY_PAGE_UP", "Page_Up");
    translation.put("LABEL_KEY_PAGE_DOWN", "Page_Down");
    translation.put("LABEL_KEY_SPACE", "Space");
    translation.put("LABEL_KEY_INSERT", "Insert");
    translation.put("LABEL_KEY_PAUSE", "Pause");
    translation.put("LABEL_KEY_NUMPAD", "Numpad");
    translation.put("LABEL_KEY_COMMAND", "Cmd");

    /** Font GlobalSettings */
    translation.put("FONT_AREA_TEXT", "Шрифт тексту");
    translation.put("FONT_AREA_DIALOG", "Шрифт діалогів");
    translation.put("FONT_AREA_TREE", "Шрифт дерева");
    translation.put("FONT_AREA_TABLE", "Шрифт таблиці");
    translation.put("FONT_AREA_HEADER", "Шрифт шапки");
    translation.put("FONT_AREA_TEXT_DESCRIPTION", "Шрифт тексту використовується для новин, інформації про канали, повідомлень та помилок.");
    translation.put("FONT_AREA_DIALOG_DESCRIPTION", "Шрифт діалогів використовується в усіх діалогах.");
    translation.put("FONT_AREA_TREE_DESCRIPTION", "Шрифт дерева  використовується у дереві вибраного.");
    translation.put("FONT_AREA_TABLE_DESCRIPTION", "Шрифт таблиці  використовується у таблиці новин.");
    translation.put("FONT_AREA_HEADER_DESCRIPTION", "Шрифт шапки  використовується у шапках новин.");
    translation.put("FONT_STYLE_BOLD", "Жирний");
    translation.put("FONT_STYLE_ITALIC", "Курсив");
    translation.put("FONT_STYLE_NORMAL", "Нормальний");

    /** Groups */
    translation.put("GROUP_COMMAND", "Команди");
    translation.put("GROUP_SELECTED_FONT", "Виберіть шрифт");
    translation.put("GROUP_WINDOW_LAYOUT", "Стилі вікна");
    translation.put("GROUP_OPEN_MODE", "Режим відкривання");
    translation.put("GROUP_ARGUMENTS", "Аргументи");
    translation.put("GROUP_LINK_COLOR", "Колір посилань");
    translation.put("GROUP_SYNTAXHIGHLIGHT_COLOR", "Колір результатів пошуку");
    translation.put("GROUP_FONT_AREA", "Перегляд шрифту");
    translation.put("GROUP_TAB_LAYOUT", "Вид вкладок");
    translation.put("GROUP_TRAY", "Системний лоток");
    translation.put("GROUP_EXISTING_ACCOUNT", "Існуючий Акаунт");
    translation.put("GROUP_NEW_ACCOUNT", "Створити Новий Акаунт");
    translation.put("GROUP_GENERAL", "Загальний");
    translation.put("GROUP_CONFIRM_DIALOG", "Вимагати підтвердження");
    translation.put("GROUP_NEWS_POPUP", "Вспливаючі новини");

    /** Languages */
    translation.put("en", "Англійска");
    translation.put("de", "Німецька");
    translation.put("fr", "Французька");
    translation.put("es", "Іспанська");
    translation.put("gl", "Галісійська");
    translation.put("da", "Датська");
    translation.put("it", "Італійська");
    translation.put("nl", "Голандська");
    translation.put("el", "Грецька");
    translation.put("ru", "Російська");
    translation.put("pt", "Португальська (Бразилія)");
    translation.put("bg", "Болгарська");
    translation.put("no", "Норвезька");
    translation.put("zhcn", "Китайська");
    translation.put("zhtw", "Традиційна Китайська");
    translation.put("ja", "Японська");
    translation.put("ko", "Корейська");
    translation.put("pl", "Польська");
    translation.put("sv", "Шведська");
    translation.put("bn", "Бангладешська(Бенгалі)");
    translation.put("fi", "Фінська");
    translation.put("uk", "Українська");
    translation.put("cs", "Чеська");
    translation.put("sl", "Словенська");
    translation.put("tr", "Турецька");
    translation.put("hu", "Венгерський");
    translation.put("th", "Тайська");

    /** Misc. */
    translation.put("NEWS_NO_DESCRIPTION", "Немає опису!");
    translation.put("PRINTED_FROM_RSSOWL", "Надруковано з RSSOwl (http://www.rssowl.org)");
    translation.put("PRINTJOB_NAME", "Друк новини з RSSOwl (http://www.rssowl.org)");
    translation.put("SYSTRAY_SHOW", "Показати RSSOwl");
    translation.put("TAB_WELCOME", "Ласкаво просимо");
    translation.put("DOCUMENT_GENERATED_FROM", "Документ створено з RSSOwl");
    translation.put("NO_TITLE", "Немає заголовка");
    translation.put("RSSOWL_TEASER", "RSSOwl - безкоштовна програма для читання RSS та RDF новин з відкритим вихідним текстом. Можливості програми:\n\n- Експорт новин у PDF, HTML, RTF, OPML\n- Імпорт вибраного з OPML\n- Повнотекстовий пошук з підсвіткою синтаксису результатів\n- Потужний пошук у RSS та RDF\n- Перегляд у внутрішньому браузері\n- Списки вибраних новин і розділів\n- Працює у середовищі Windows, Solaris, Linux и Mac\n\nПовний список можливостей щукайте на сайті: http://www.rssowl.org/overview\n\nЗкачати програму можна тут: http://www.rssowl.org/download");
    translation.put("RECOMMENDED_ARTICLES", "Рекомендовані статті");
    translation.put("LOAD_FEED", "Звантаження");
    translation.put("SEARCH_FEED", "Пошук");
    translation.put("RELOAD_FEED", "Перезавантаження");
    translation.put("FORMAT_AUTO_DETECT", "Визначити автоматично");
    translation.put("MAIL_ERROR_BODY", "Будь ласка приєднайте '" + GlobalSettings.LOGS_DIR + GlobalSettings.PATH_SEPARATOR + "rssowllog.log' до цього листа та дайте коротке пояснення чому щойно виникла помилка у RSSOwl.Дякуємо!");
    translation.put("NEWSFEED_VALID", "Джерело новин коректне");
    translation.put("OPML_IMPORTED", "Імпортовані");
    translation.put("ENTIRE_NEWS", "Всі Новини");
    translation.put("SEARCH_AND", "ТА");
    translation.put("SEARCH_OR", "АБО");
    translation.put("SEARCH_NOT", "НЕ");
  }
}