#!/bin/sh

function config() {
	NEW="$1"
	OLD="`dirname $NEW`/`basename $NEW .new`"

	# If there's no config file by that name, mv it over:
	if [ ! -r $OLD ]; then
		echo "--- Renaming $NEW to $OLD"
		mv $NEW $OLD
	elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
		# toss the redundant copy
		echo "--- Deleting $NEW"
		rm $NEW
	else
		# Otherwise, we leave the .new copy for the admin to consider...
		echo "--- Leaving $NEW for you to replace $OLD"
	fi
	

}

FILE=/etc/ipsec.conf.new
if [ -f $FILE ]; then
    config $FILE
fi

( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-gmp.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-gmp.so.0.0.0 libstrongswan-gmp.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-md5.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-md5.so.0.0.0 libstrongswan-md5.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-updown.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-updown.so.0.0.0 libstrongswan-updown.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-x509.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-x509.so.0.0.0 libstrongswan-x509.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-sha2.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-sha2.so.0.0.0 libstrongswan-sha2.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-kernel-netlink.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-kernel-netlink.so.0.0.0 libstrongswan-kernel-netlink.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-kernel-netlink.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-kernel-netlink.so.0.0.0 libstrongswan-kernel-netlink.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-stroke.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-stroke.so.0.0.0 libstrongswan-stroke.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-pubkey.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-pubkey.so.0.0.0 libstrongswan-pubkey.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-fips-prf.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-fips-prf.so.0.0.0 libstrongswan-fips-prf.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-stroke.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-stroke.so.0.0.0 libstrongswan-stroke.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-hmac.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-hmac.so.0.0.0 libstrongswan-hmac.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-xcbc.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-xcbc.so.0.0.0 libstrongswan-xcbc.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-aes.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-aes.so.0.0.0 libstrongswan-aes.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-pubkey.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-pubkey.so.0.0.0 libstrongswan-pubkey.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-ldap.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-ldap.so.0.0.0 libstrongswan-ldap.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-fips-prf.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-fips-prf.so.0.0.0 libstrongswan-fips-prf.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-hmac.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-hmac.so.0.0.0 libstrongswan-hmac.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-sha2.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-sha2.so.0.0.0 libstrongswan-sha2.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-random.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-random.so.0.0.0 libstrongswan-random.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-des.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-des.so.0.0.0 libstrongswan-des.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-updown.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-updown.so.0.0.0 libstrongswan-updown.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-aes.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-aes.so.0.0.0 libstrongswan-aes.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-xcbc.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-xcbc.so.0.0.0 libstrongswan-xcbc.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-x509.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-x509.so.0.0.0 libstrongswan-x509.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-sha1.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-sha1.so.0.0.0 libstrongswan-sha1.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-sha1.so.0 )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-sha1.so.0.0.0 libstrongswan-sha1.so.0 )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-ldap.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-ldap.so.0.0.0 libstrongswan-ldap.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-des.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-des.so.0.0.0 libstrongswan-des.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-md5.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-md5.so.0.0.0 libstrongswan-md5.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-gmp.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-gmp.so.0.0.0 libstrongswan-gmp.so )
( cd usr/libexec/ipsec/plugins ; rm -rf libstrongswan-random.so )
( cd usr/libexec/ipsec/plugins ; ln -sf libstrongswan-random.so.0.0.0 libstrongswan-random.so )
( cd usr/lib ; rm -rf libstrongswan.so )
( cd usr/lib ; ln -sf libstrongswan.so.0.0.0 libstrongswan.so )
( cd usr/lib ; rm -rf libstrongswan.so.0 )
( cd usr/lib ; ln -sf libstrongswan.so.0.0.0 libstrongswan.so.0 )
