/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __BATCH_DIALOG_H
#define __BATCH_DIALOG_H

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _BatchDialog BatchDialog;

struct _BatchDialog {
	GtkWidget* self;

	GtkWidget* entry;
	GtkWidget* radio_button;
	GtkWidget* spin_from;
	GtkWidget* spin_to;
	GtkWidget* spin_width;
	GtkWidget* entry_a;
	GtkWidget* entry_z;
};

enum BATCH_MODE {
	BATCH_MODE_NONE,
	BATCH_MODE_CHAR,
	BATCH_MODE_NUM
};

BatchDialog* batch_dialog_new (GtkWindow* parent);
void batch_dialog_destroy (BatchDialog* bd);

void batch_dialog_init (BatchDialog* bd, GtkWindow* parent);
void batch_dialog_finalize (BatchDialog* bd);
gint batch_dialog_get_mode (BatchDialog* bd);
gint batch_dialog_run (BatchDialog* bd);

const gchar* batch_dialog_get_pattern (BatchDialog* bd);

gchar batch_dialog_get_char_min (BatchDialog* bd);
gchar batch_dialog_get_char_max (BatchDialog* bd);
gint  batch_dialog_get_int_min (BatchDialog* bd);
gint  batch_dialog_get_int_max (BatchDialog* bd);
gint  batch_dialog_get_int_width (BatchDialog* bd);


#ifdef __cplusplus
}
#endif

#endif  // End of __BATCH_DIALOG_H
