/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __BATCH_IMPORTER_H
#define __BATCH_IMPORTER_H

#include "download_importer.h"
#include "batch_dialog.h"
#include "main_app.h"

//
// DownloadDilaog
// |
// `--- DownloadImporter
//      |
//      +--- DownloadApplying
//      |
//      +--- BatchImporter
//      |
//      `--- FilterImporter
//

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _BatchImporter    BatchImporter;

struct _BatchImporter {
	DOWNLOAD_IMPORTER_FIELDS;

	BatchDialog*  batch_dialog;
	int   max_value;
	int   min_value;

	// Example:
	//    pattern_pre
	//    |
	//    V
	//    |--------len_pre-----------|
	//    http://www.xxx.com/path/file*.ext
	//                                 |--| len_post
	//                                 ^
	//                                 |
	//                                 pattern_post
	char* pattern_pre;
	char* pattern_post;
	int   len_pre;
	int   len_post;

	GString* gstr;
	gboolean char_value;
	int      value_width;
	int      n_current;
	int      n_total;
};

BatchImporter* batch_importer_new (GtkWindow* parent, MainApp* app);
#define batch_importer_destroy(o)  download_dialog_destroy(DOWNLOAD_DIALOG (o))

void batch_importer_activate (BatchImporter* bim);

// protected function
void batch_importer_finalize (BatchImporter* bim);

#ifdef __cplusplus
}
#endif

#endif  // End of __BATCH_IMPORTER_H

