/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include "category_chooser.h"
#include "category_tree_view.h"
#include "category_tree_model.h"
#include <urlglib/ug_i18n.h>

static void category_chooser_on_destroy (GObject* obj, gpointer data)
{
	g_free (data);
}

CategoryChooser* category_chooser_new (GtkWindow* parent, RootNode* rnode)
{
	CategoryChooser* ccdlg = g_malloc (sizeof (CategoryChooser));
	GtkTreeModel* model;
	GtkWidget* vbox;
	GtkScrolledWindow* scrolled;

	ccdlg->rnode = rnode;
	ccdlg->self = gtk_dialog_new_with_buttons(_("Choose Category"),
	                                   parent,
	    (GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	                                   GTK_STOCK_CANCEL,
	                                   GTK_RESPONSE_CANCEL,
	                                   GTK_STOCK_OK,
	                                   GTK_RESPONSE_OK,
	                                   NULL);

	vbox = GTK_DIALOG (ccdlg->self)->vbox;

	model = (GtkTreeModel*)category_tree_model_new (rnode);
	ccdlg->category_view = category_tree_view_new ();
	gtk_tree_view_set_model (ccdlg->category_view, model);
	g_object_unref (model);

	scrolled = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_size_request (GTK_WIDGET (scrolled), 120, 250);
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_IN);
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scrolled), GTK_WIDGET (ccdlg->category_view));
	gtk_container_set_border_width (GTK_CONTAINER (scrolled), 4);

	gtk_box_pack_end (GTK_BOX(vbox), (GtkWidget*)scrolled, TRUE, TRUE, 4);

	gtk_widget_show_all (vbox);
	gtk_tree_view_expand_all (ccdlg->category_view);

	// signal
	g_signal_connect (ccdlg->self, "destroy",
	                  G_CALLBACK (category_chooser_on_destroy), ccdlg);

	return ccdlg;
}

void category_chooser_destroy (CategoryChooser* ccdlg)
{
	gtk_widget_destroy (ccdlg->self);
}

void category_chooser_set_hint (CategoryChooser* ccdlg, const gchar* hint)
{
	GtkWidget* label;
	GtkWidget* vbox = GTK_DIALOG (ccdlg->self)->vbox;

	label = gtk_label_new (hint);
	gtk_widget_show (label);
	gtk_box_pack_end (GTK_BOX(vbox), (GtkWidget*)label, FALSE, FALSE, 4);
}

void category_chooser_set_title (CategoryChooser* ccdlg, const gchar* title)
{
	gtk_window_set_title (GTK_WINDOW(ccdlg->self), title);
}

QueueNode* category_chooser_get_selected (CategoryChooser* ccdlg)
{
	GtkTreeModel*     model;
	GtkTreePath*      path;
	GtkTreeIter       iter;
	QueueNode*        qnode;

	model = gtk_tree_view_get_model (ccdlg->category_view);
	gtk_tree_view_get_cursor (ccdlg->category_view, &path, NULL);
	if (path) {
		gtk_tree_model_get_iter (model, &iter, path);
		gtk_tree_path_free (path);
		gtk_tree_model_get (model, &iter, 0, &qnode, -1);
		return qnode;
	}
	return NULL;
}

void       category_chooser_set_selected (CategoryChooser* ccdlg, QueueNode* qnode)
{
	CategoryNode* cnode;
	GtkTreePath*  path;
	int  index;

	path  = gtk_tree_path_new ();
	cnode = queue_node_get_category (qnode);
	index = root_node_category_position (ccdlg->rnode, cnode);
	gtk_tree_path_append_index (path, index);
	index = base_node_child_position (BASE_NODE (cnode), BASE_NODE (qnode));
	if (index)
		gtk_tree_path_append_index (path, index-1);
	gtk_tree_view_set_cursor (ccdlg->category_view, path, NULL, FALSE);
	gtk_tree_path_free (path);
}

