/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef __CATEGORY_CHOOSER_H
#define __CATEGORY_CHOOSER_H

#include <gtk/gtk.h>
#include <urlglib/root_node.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _CategoryChooser    CategoryChooser;

struct _CategoryChooser {
	GtkWidget*    self;
	GtkTreeView*  category_view;   // CategoryTreeView
	RootNode*     rnode;

	gpointer      user_data;
	gpointer      user_data2;
};

CategoryChooser* category_chooser_new (GtkWindow* parent, RootNode* rnode);
void category_chooser_destroy (CategoryChooser* cdialog);

void category_chooser_set_hint (CategoryChooser* dialog, const gchar* hint);
void category_chooser_set_title (CategoryChooser* dialog, const gchar* title);

QueueNode* category_chooser_get_selected (CategoryChooser* dialog);
void       category_chooser_set_selected (CategoryChooser* dialog, QueueNode* qnode);
#define    category_chooser_run(cc)    gtk_dialog_run ((GtkDialog*)(cc)->self)

#ifdef __cplusplus
}
#endif

#endif  /* End of __CATEGORY_CHOOSER_H */
