/*
 *
 *   Copyright (C) 2005 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <gdk/gdkkeysyms.h>
#include "category_dialog.h"
#include <urlglib/ug_i18n.h>

// signal handler ---------------------------------------------------

static gboolean on_key_press_event (GtkWidget* widget,
                                    GdkEventKey *event,
                                    CategoryDialog *dd)
{
	int keyval = event->keyval;

	if (keyval == GDK_Return || keyval == GDK_KP_Enter) {
		gtk_dialog_response (GTK_DIALOG (dd->self), GTK_RESPONSE_OK);
		return TRUE;
	}
	return FALSE;
}

// CategoryDialog functions ------------------------------------------

CategoryDialog* category_dialog_new (GtkWindow* parent)
{
	CategoryDialog* dialog = g_malloc (sizeof (CategoryDialog));
	GtkWidget* vbox;

	dialog->self = gtk_dialog_new_with_buttons(_("Category properties"),
	                                   parent,
	         (GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	                                   GTK_STOCK_CANCEL,
	                                   GTK_RESPONSE_CANCEL,
	                                   GTK_STOCK_OK,
	                                   GTK_RESPONSE_OK,
	                                   NULL);
	vbox = GTK_DIALOG (dialog->self)->vbox;
	category_info_view_init (&dialog->cinfo_view);
	gtk_box_pack_start (GTK_BOX(vbox), (GtkWidget*)dialog->cinfo_view.self,
	                    FALSE, FALSE, 0);

	// signal for CategoryInfoView
	g_signal_connect (dialog->cinfo_view.entry, "key-press-event",
	                  G_CALLBACK (on_key_press_event), dialog);

//	gtk_container_set_focus_child (GTK_CONTAINER (dialog->self),
//	                               dialog->cinfo_view.entry);
	gtk_widget_show (vbox);

	return dialog;
}

void category_dialog_destroy (CategoryDialog* dialog)
{
	gtk_widget_destroy (dialog->self);
	g_free (dialog);
}

void category_dialog_set_title (CategoryDialog* dialog, const gchar* title)
{
	gtk_window_set_title (GTK_WINDOW(dialog->self), title);
}

